/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.constants.WorkOrderConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.model.express.MerchantExpress;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderFlowRecord;
import com.zbkj.common.model.order.OrderInvoice;
import com.zbkj.common.model.order.OrderInvoiceDetail;
import com.zbkj.common.model.order.VerificationRecord;
import com.zbkj.common.model.reservation.ReservationWorkOrder;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.IntegralOrderSearchRequest;
import com.zbkj.common.request.IntegralOrderTabsHeaderRequest;
import com.zbkj.common.request.MerchantOrderDirectRefundDetailRequest;
import com.zbkj.common.request.MerchantOrderDirectRefundRequest;
import com.zbkj.common.request.OrderFrontListRequest;
import com.zbkj.common.request.OrderInvoiceUpdateRequest;
import com.zbkj.common.request.OrderRemarkRequest;
import com.zbkj.common.request.OrderSearchRequest;
import com.zbkj.common.request.OrderSendRequest;
import com.zbkj.common.request.OrderTabsHeaderRequest;
import com.zbkj.common.request.SplitOrderSendDetailRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.response.IntegralOrderPageResponse;
import com.zbkj.common.response.MerchantOrderPageResponse;
import com.zbkj.common.response.OrderAdminDetailResponse;
import com.zbkj.common.response.OrderCountItemResponse;
import com.zbkj.common.response.OrderInfoFrontDataResponse;
import com.zbkj.common.response.OrderInvoiceResponse;
import com.zbkj.common.response.PlatformOrderAdminDetailResponse;
import com.zbkj.common.response.PlatformOrderPageResponse;
import com.zbkj.common.response.onepass.ElectrResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.OrderResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.LogisticsResultVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.OrderFlowRecordVo;
import com.zbkj.service.dao.OrderDao;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.LogisticService;
import com.zbkj.service.service.MerchantExpressService;
import com.zbkj.service.service.MerchantInfoService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantPrintService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderInvoiceDetailService;
import com.zbkj.service.service.OrderInvoiceService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.ReservationWorkOrderService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.VerificationRecordService;
import com.zbkj.service.service.impl.SystemNotificationServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderDao, Order>
implements OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private OrderDao dao;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private SystemAdminService systemAdminService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ExpressService expressService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private LogisticService logisticService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderInvoiceService orderInvoiceService;
    @Autowired
    private OrderInvoiceDetailService orderInvoiceDetailService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private SystemNotificationServiceImpl systemNotificationService;
    @Autowired
    private MerchantPrintService merchantPrintService;
    @Lazy
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private VerificationRecordService verificationRecordService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private ReservationWorkOrderService reservationWorkOrderService;
    @Autowired
    private MerchantInfoService merchantInfoService;
    @Autowired
    private ProductService productService;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;
    @Autowired
    private MerchantExpressService merchantExpressService;

    @Override
    public Order getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        return order;
    }

    @Override
    public Boolean updatePaid(String orderNo) {
        LambdaUpdateWrapper lqw = new LambdaUpdateWrapper();
        lqw.set(Order::getPaid, (Object)true);
        lqw.set(Order::getPayTime, (Object)DateUtil.date());
        lqw.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.eq(Order::getPaid, (Object)false);
        return this.update((Wrapper)lqw);
    }

    @Override
    public Order getByOutTradeNo(String outTradeNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOutTradeNo, (Object)outTradeNo);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        return order;
    }

    @Override
    public PageInfo<Order> getUserOrderList_v1_4(Integer userId, OrderFrontListRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        if (StrUtil.isBlank((CharSequence)request.getKeywords())) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(Order::getUid, (Object)userId);
            if (request.getStatus() >= 0) {
                if (request.getStatus() == 1) {
                    lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
                    lqw.in(Order::getGroupBuyRecordStatus, new Object[]{99, 10});
                } else if (request.getStatus() == 3) {
                    lqw.eq(Order::getStatus, (Object)3);
                    lqw.in(Order::getGroupBuyRecordStatus, new Object[]{99, 10});
                } else {
                    lqw.eq(Order::getStatus, (Object)request.getStatus());
                }
                lqw.lt(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
            }
            lqw.eq(Order::getIsUserDel, (Object)false);
            lqw.eq(Order::getIsMerchantDel, (Object)false);
            lqw.ne(Order::getSecondType, (Object)OrderConstants.ORDER_SECOND_TYPE_VIDEO);
            lqw.eq(Order::getIsDel, (Object)false);
            if (ObjectUtil.isNotNull((Object)request.getSecondType()) && request.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
                lqw.eq(Order::getSecondType, (Object)request.getSecondType());
            }
            lqw.orderByDesc(Order::getId);
            List orderList = this.dao.selectList((Wrapper)lqw);
            return CommonPage.copyPageInfo((Page)page, (List)orderList);
        }
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        String keywords = URLUtil.decode((String)request.getKeywords());
        searchMap.put("keywords", keywords);
        searchMap.put("status", request.getStatus());
        searchMap.put("userId", userId);
        if (ObjectUtil.isNotNull((Object)request.getSecondType()) && request.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
            searchMap.put("secondType", request.getSecondType());
        }
        List<Order> orderList = this.dao.findFrontList(searchMap);
        return CommonPage.copyPageInfo((Page)page, orderList);
    }

    @Override
    public Boolean cancel(String orderNo, Boolean isUser) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getCancelStatus, (Object)(isUser != false ? OrderConstants.ORDER_CANCEL_STATUS_USER : OrderConstants.ORDER_CANCEL_STATUS_SYSTEM));
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_CANCEL);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getPaid, (Object)false);
        wrapper.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<MerchantOrderPageResponse> getMerchantAdminPage(OrderSearchRequest request, SystemAdmin systemAdmin) {
        List<MerchantOrderPageResponse> responseList;
        Page startPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("status", request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        map.put("merId", systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (CollUtil.isEmpty(responseList = this.dao.getMerchantAdminPage(map))) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new MerchantOrderPageResponse[0]));
        }
        responseList.forEach(response -> {
            if (response.getRefundStatus() > 0) {
                response.setUserRefundSign(this.refundOrderService.isOrderContainUserRefund(response.getOrderNo()));
                if (response.getRefundStatus().equals(2)) {
                    response.setRefundNum(this.orderDetailService.getOrderRefundNum(response.getOrderNo()));
                }
            }
            ArrayList infoResponseList = CollUtil.newArrayList((Object[])new OrderInfoFrontDataResponse[0]);
            List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(response.getOrderNo());
            orderDetailList.forEach(od -> {
                OrderInfoFrontDataResponse orderInfoResponse = new OrderInfoFrontDataResponse();
                BeanUtils.copyProperties((Object)od, (Object)orderInfoResponse);
                infoResponseList.add(orderInfoResponse);
            });
            response.setInfoResponseList((List)infoResponseList);
        });
        return CommonPage.copyPageInfo((Page)startPage, responseList);
    }

    @Override
    public OrderCountItemResponse getMerchantOrderStatusNum(OrderTabsHeaderRequest request, SystemAdmin systemAdmin) {
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getCount(request, "all", systemAdmin.getMerId()));
        response.setUnPaid(this.getCount(request, "unPaid", systemAdmin.getMerId()));
        response.setNotShipped(this.getCount(request, "notShipped", systemAdmin.getMerId()));
        response.setSpike(this.getCount(request, "spike", systemAdmin.getMerId()));
        response.setReceiving(this.getCount(request, "receiving", systemAdmin.getMerId()));
        response.setComplete(this.getCount(request, "complete", systemAdmin.getMerId()));
        response.setRefunded(this.getCount(request, "refunded", systemAdmin.getMerId()));
        response.setDeleted(this.getCount(request, "deleted", systemAdmin.getMerId()));
        response.setVerification(this.getCount(request, "awaitVerification", systemAdmin.getMerId()));
        return response;
    }

    @Override
    public OrderAdminDetailResponse adminDetail(String orderNo, SystemAdmin systemAdmin) {
        VerificationRecord verificationRecord;
        Order order = this.getByOrderNo(orderNo);
        if (order.getIsMerchantDel().booleanValue() || !order.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        OrderAdminDetailResponse orderAdminDetailResponse = new OrderAdminDetailResponse();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        BeanUtils.copyProperties((Object)merchantOrder, (Object)orderAdminDetailResponse);
        BeanUtils.copyProperties((Object)order, (Object)orderAdminDetailResponse);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        List orderInfoList = orderDetailList.stream().map(e -> {
            OrderInfoFrontDataResponse dataResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)e, (Object)dataResponse);
            List<ReservationWorkOrder> workOrderList = this.reservationWorkOrderService.findByOrderDetailId(e.getId());
            dataResponse.setWorkOrderList(CollUtil.isEmpty(workOrderList) ? null : workOrderList);
            return dataResponse;
        }).collect(Collectors.toList());
        orderAdminDetailResponse.setOrderDetailList(orderInfoList);
        if (order.getRefundStatus() > 0) {
            orderAdminDetailResponse.setUserRefundSign(this.refundOrderService.isOrderContainUserRefund(order.getOrderNo()));
        }
        User user = (User)this.userService.getById(order.getUid());
        orderAdminDetailResponse.setNickname(user.getNickname());
        orderAdminDetailResponse.setPhone(user.getPhone());
        orderAdminDetailResponse.setIsLogoff(user.getIsLogoff());
        orderAdminDetailResponse.setAvatar(user.getAvatar());
        orderAdminDetailResponse.setUserLevel(user.getLevel());
        orderAdminDetailResponse.setIsPaidMember(user.getIsPaidMember());
        if (merchantOrder.getClerkId() > 0 && ObjectUtil.isNotNull((Object)(verificationRecord = this.verificationRecordService.getByOrderNo(merchantOrder.getOrderNo())))) {
            if (verificationRecord.getVerifyStaffType().equals(1)) {
                SystemAdmin clerkAdmin = (SystemAdmin)this.systemAdminService.getById(merchantOrder.getClerkId());
                orderAdminDetailResponse.setClerkName(clerkAdmin.getRealName());
            } else {
                User clerkUser = (User)this.userService.getById(merchantOrder.getClerkId());
                orderAdminDetailResponse.setClerkName(clerkUser.getNickname());
            }
            orderAdminDetailResponse.setVerifyTime(verificationRecord.getVerifyTime());
        }
        orderAdminDetailResponse.setFlowRecordList(this.getFlowRecordList(orderNo));
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            orderAdminDetailResponse.setPhone(CrmebUtil.maskMobile((String)orderAdminDetailResponse.getPhone()));
            if (StrUtil.isNotBlank((CharSequence)orderAdminDetailResponse.getUserPhone())) {
                orderAdminDetailResponse.setUserPhone(CrmebUtil.maskMobile((String)orderAdminDetailResponse.getUserPhone()));
            }
        }
        return orderAdminDetailResponse;
    }

    private List<OrderFlowRecordVo> getFlowRecordList(String orderNo) {
        List<OrderFlowRecord> orderFlowRecordList = this.orderFlowRecordService.findRecordListByOrderNo(orderNo);
        return orderFlowRecordList.stream().map(flowRecord -> {
            OrderFlowRecordVo vo = new OrderFlowRecordVo();
            BeanUtils.copyProperties((Object)flowRecord, (Object)vo);
            vo.setFlowType(this.getOrderFlowRecordTypeName(flowRecord.getFlowType()));
            if (vo.getOperatorType().equals(0)) {
                vo.setOperatorName("\u7cfb\u7edf");
                return vo;
            }
            if (vo.getOperatorType().equals(4) || vo.getOperatorType().equals(1)) {
                User user = (User)this.userService.getById(vo.getOperatorId());
                vo.setOperatorName(user.getNickname());
                return vo;
            }
            SystemAdmin admin = (SystemAdmin)this.systemAdminService.getById(vo.getOperatorId());
            vo.setOperatorName(admin.getRealName());
            return vo;
        }).collect(Collectors.toList());
    }

    private String getOrderFlowRecordTypeName(String flowType) {
        String flowTypeName = flowType;
        switch (flowType) {
            case "create": {
                flowTypeName = "\u8ba2\u5355\u521b\u5efa";
                break;
            }
            case "paid": {
                flowTypeName = "\u8ba2\u5355\u652f\u4ed8";
                break;
            }
            case "delivery": {
                flowTypeName = "\u8ba2\u5355\u53d1\u8d27";
                break;
            }
            case "receipt": {
                flowTypeName = "\u8ba2\u5355\u6536\u8d27";
                break;
            }
            case "complete": {
                flowTypeName = "\u8ba2\u5355\u5b8c\u6210";
                break;
            }
            case "cancel": {
                flowTypeName = "\u8ba2\u5355\u53d6\u6d88";
                break;
            }
            case "refund": {
                flowTypeName = "\u8ba2\u5355\u5df2\u9000\u6b3e";
            }
        }
        return flowTypeName;
    }

    @Override
    public Boolean send(OrderSendRequest request, SystemAdmin systemAdmin) {
        this.validateOrderSend(request);
        Order order = this.getByOrderNo(request.getOrderNo());
        if (!order.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        if (order.getIsUserDel().booleanValue() || order.getIsMerchantDel().booleanValue()) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_DELETE);
        }
        if (!order.getLevel().equals(OrderConstants.ORDER_LEVEL_MERCHANT)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_LEVEL_ABNORMAL);
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_WAIT_SHIPPING) && !order.getStatus().equals(OrderConstants.ORDER_STATUS_PART_SHIPPING)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_STATUS_ABNORMAL.setMessage("\u8ba2\u5355\u4e0d\u5904\u4e8e\u5f85\u53d1\u8d27\u72b6\u6001"));
        }
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_ALL)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_REFUND_ED);
        }
        if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIRTUALLY) && !request.getDeliveryType().equals("noNeed")) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u865a\u62df\u5546\u54c1\u8ba2\u5355\u53ea\u652f\u6301\u65e0\u9700\u53d1\u8d27\u65b9\u5f0f\u53d1\u8d27");
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(request.getOrderNo());
        if (!merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_SHIPPING_TYPE_PICK_UP);
        }
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_APPLY)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u5904\u7406\u552e\u540e\uff0c\u518d\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c");
        }
        if (!request.getIsSplit().booleanValue()) {
            if (request.getDeliveryType().equals("express")) {
                return this.sendExpress(request, order, merchantOrder, systemAdmin.getId(), systemAdmin.getType());
            }
            if (request.getDeliveryType().equals("merchant")) {
                return this.sendMerchant(request.getDeliveryCarrier(), request.getCarrierPhone(), order, merchantOrder, systemAdmin.getId(), systemAdmin.getType());
            }
            if (request.getDeliveryType().equals("noNeed")) {
                return this.sendNoNeed(StrUtil.isNotBlank((CharSequence)request.getDeliveryMark()) ? request.getDeliveryMark() : "", order, merchantOrder, systemAdmin.getId(), systemAdmin.getType());
            }
        }
        if (CollUtil.isEmpty((Collection)request.getDetailList())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u62c6\u5355\u53d1\u8d27\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List detailRequestList = request.getDetailList();
        List detailIdList = detailRequestList.stream().map(SplitOrderSendDetailRequest::getOrderDetailId).distinct().collect(Collectors.toList());
        if (detailRequestList.size() != detailIdList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6709\u91cd\u590d\u7684\u53d1\u8d27\u5355\u8be6\u60c5");
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(request.getOrderNo());
        detailRequestList.forEach(detailRequest -> {
            if (detailRequest.getNum() < 1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u8be6\u60c5\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
            }
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detailRequest.getOrderDetailId())).findAny().orElse(null);
            if (ObjectUtil.isNull((Object)orderDetail)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u8be6\u60c5ID\u4e0d\u5bf9\u5e94");
            }
            if (orderDetail.getDeliveryNum().equals(0) ? orderDetail.getPayNum() - orderDetail.getRefundNum() - detailRequest.getNum() < 0 : orderDetail.getPayNum() - orderDetail.getDeliveryNum() - detailRequest.getNum() < 0) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d85\u51fa\u53ef\u53d1\u8d27\u6570\u91cf,\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u91cf");
            }
        });
        if (request.getDeliveryType().equals("express")) {
            return this.splitSendExpress(request, order, merchantOrder, orderDetailList, systemAdmin.getId(), systemAdmin.getType());
        }
        if (request.getDeliveryType().equals("merchant")) {
            return this.splitSendMerchant(request, order, merchantOrder, orderDetailList, systemAdmin.getId(), systemAdmin.getType());
        }
        if (request.getDeliveryType().equals("noNeed")) {
            return this.splitSendNoNeed(request, order, merchantOrder, orderDetailList, systemAdmin.getId(), systemAdmin.getType());
        }
        return Boolean.TRUE;
    }

    private Boolean splitSendNoNeed(OrderSendRequest request, Order order, MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, Integer adminId, Integer adminType) {
        List detailRequestList = request.getDetailList();
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        detailRequestList.forEach(detail -> {
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detail.getOrderDetailId())).findAny().orElse(null);
            orderDetail.setDeliveryNum(Integer.valueOf(orderDetail.getDeliveryNum() + detail.getNum()));
            orderDetail.setUpdateTime((Date)DateUtil.date());
            OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
            BeanUtils.copyProperties((Object)orderDetail, (Object)invoiceDetail);
            invoiceDetail.setNum(detail.getNum());
            invoiceDetail.setCreateTime((Date)DateUtil.date());
            invoiceDetail.setUpdateTime((Date)DateUtil.date());
            orderInvoiceDetailList.add(invoiceDetail);
            orderDetailUpdateList.add(orderDetail);
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setDeliveryMark(request.getDeliveryMark());
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        invoice.setDeliveryType("noNeed");
        merchantOrder.setIsSplitDelivery(Boolean.TRUE);
        merchantOrder.setDeliveryType("noNeed");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_PART_SHIPPING);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u62c6\u5355\u53d1\u8d27\uff0c" + StrUtil.format((CharSequence)"\u53d1\u8d27\u5907\u6ce8\uff1a{}", (Object[])new Object[]{request.getDeliveryMark()});
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u65e0\u9700\u53d1\u8d27\u62c6\u5355\u53d1\u8d27\u5931\u8d25\uff01");
        }
        List<OrderDetail> detailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        long count = detailList.stream().filter(e -> e.getPayNum() > e.getDeliveryNum() + e.getRefundNum()).count();
        if (count <= 0L) {
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            order.setUpdateTime((Date)DateUtil.date());
            this.updateById(order);
        }
        return execute;
    }

    private Boolean splitSendMerchant(OrderSendRequest request, Order order, MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, Integer adminId, Integer adminType) {
        List detailRequestList = request.getDetailList();
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        detailRequestList.forEach(detail -> {
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detail.getOrderDetailId())).findAny().orElse(null);
            orderDetail.setDeliveryNum(Integer.valueOf(orderDetail.getDeliveryNum() + detail.getNum()));
            orderDetail.setUpdateTime((Date)DateUtil.date());
            OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
            BeanUtils.copyProperties((Object)orderDetail, (Object)invoiceDetail);
            invoiceDetail.setNum(detail.getNum());
            invoiceDetail.setCreateTime((Date)DateUtil.date());
            invoiceDetail.setUpdateTime((Date)DateUtil.date());
            orderInvoiceDetailList.add(invoiceDetail);
            orderDetailUpdateList.add(orderDetail);
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setDeliveryCarrier(request.getDeliveryCarrier());
        invoice.setCarrierPhone(request.getCarrierPhone());
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        invoice.setDeliveryType("merchant");
        merchantOrder.setIsSplitDelivery(Boolean.TRUE);
        merchantOrder.setDeliveryType("merchant");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_PART_SHIPPING);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u62c6\u5355\u53d1\u8d27\uff0c" + StrUtil.format((CharSequence)"\u914d\u9001\u4eba\u5458\uff1a{}, \u624b\u673a\u53f7\uff1a{}", (Object[])new Object[]{request.getDeliveryCarrier(), request.getCarrierPhone()});
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5546\u5bb6\u914d\u9001\u62c6\u5355\u53d1\u8d27\u5931\u8d25\uff01");
        }
        List<OrderDetail> detailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        long count = detailList.stream().filter(e -> e.getPayNum() > e.getDeliveryNum() + e.getRefundNum()).count();
        if (count <= 0L) {
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            order.setUpdateTime((Date)DateUtil.date());
            this.updateById(order);
        }
        return execute;
    }

    private Boolean sendNoNeed(String deliveryMark, Order order, MerchantOrder merchantOrder, Integer adminId, Integer adminType) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        orderDetailList.forEach(od -> {
            if (od.getPayNum() > od.getDeliveryNum()) {
                OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
                BeanUtils.copyProperties((Object)od, (Object)invoiceDetail);
                invoiceDetail.setNum(Integer.valueOf(od.getPayNum() - od.getDeliveryNum()));
                invoiceDetail.setCreateTime((Date)DateUtil.date());
                invoiceDetail.setUpdateTime((Date)DateUtil.date());
                orderInvoiceDetailList.add(invoiceDetail);
                od.setDeliveryNum(od.getPayNum());
                od.setUpdateTime((Date)DateUtil.date());
                orderDetailUpdateList.add(od);
            }
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setDeliveryMark(deliveryMark);
        invoice.setDeliveryType("noNeed");
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setIsSplitDelivery(Boolean.FALSE);
        merchantOrder.setDeliveryType("noNeed");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u5168\u90e8\u53d1\u8d27\uff0c" + StrUtil.format((CharSequence)"\u53d1\u8d27\u5907\u6ce8\uff1a{}", (Object[])new Object[]{deliveryMark});
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u65e0\u9700\u53d1\u8d27\u53d1\u8d27\u5931\u8d25\uff01");
        }
        return execute;
    }

    private Boolean sendMerchant(String deliveryCarrier, String carrierPhone, Order order, MerchantOrder merchantOrder, Integer adminId, Integer adminType) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        orderDetailList.forEach(od -> {
            if (od.getPayNum() > od.getDeliveryNum()) {
                OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
                BeanUtils.copyProperties((Object)od, (Object)invoiceDetail);
                invoiceDetail.setNum(Integer.valueOf(od.getPayNum() - od.getDeliveryNum()));
                invoiceDetail.setCreateTime((Date)DateUtil.date());
                invoiceDetail.setUpdateTime((Date)DateUtil.date());
                orderInvoiceDetailList.add(invoiceDetail);
                od.setDeliveryNum(od.getPayNum());
                od.setUpdateTime((Date)DateUtil.date());
                orderDetailUpdateList.add(od);
            }
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setDeliveryCarrier(deliveryCarrier);
        invoice.setDeliveryType("merchant");
        invoice.setCarrierPhone(carrierPhone);
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setIsSplitDelivery(Boolean.FALSE);
        merchantOrder.setDeliveryType("merchant");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u5168\u90e8\u53d1\u8d27\uff0c" + StrUtil.format((CharSequence)"\u914d\u9001\u4eba\u5458\uff1a{}, \u624b\u673a\u53f7\uff1a{}", (Object[])new Object[]{deliveryCarrier, carrierPhone});
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5546\u5bb6\u914d\u9001\u53d1\u8d27\u5931\u8d25\uff01");
        }
        return execute;
    }

    @Override
    public void printReceipt(String orderNo, SystemAdmin systemAdmin) {
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        if (!systemAdmin.getMerId().equals(merchantOrder.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        Merchant merchant = this.merchantService.getByIdException(systemAdmin.getMerId());
        if (merchant.getReceiptPrintingSwitch() == 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5c0f\u7968\u6253\u5370\u529f\u80fd\u672a\u5f00\u542f");
        }
        if (merchant.getReceiptPrintingSwitch() == 2) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5c0f\u7968\u6253\u5370\u672a\u5f00\u542f\u624b\u52a8\u6253\u5370");
        }
        this.merchantPrintService.printReceipt(merchantOrder);
    }

    @Override
    public Boolean merchantDeleteByOrderNo(String orderNo, SystemAdmin systemAdmin) {
        Order order = this.getByOrderNoAndMerId(orderNo, systemAdmin.getMerId());
        if (!order.getIsUserDel().booleanValue()) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_USER_NOT_DELETE);
        }
        order.setIsMerchantDel(Boolean.valueOf(true));
        order.setUpdateTime((Date)DateUtil.date());
        return this.updateById(order);
    }

    @Override
    public Boolean merchantMark(OrderRemarkRequest request, SystemAdmin systemAdmin) {
        Order order = this.getByOrderNoAndMerId(request.getOrderNo(), systemAdmin.getMerId());
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
        merchantOrder.setMerchantRemark(request.getRemark());
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        return this.merchantOrderService.updateById(merchantOrder);
    }

    @Override
    public Boolean takeDelivery(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        wrapper.set(Order::getReceivingTime, (Object)DateUtil.date());
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<PlatformOrderPageResponse> getPlatformAdminPage(OrderSearchRequest request) {
        List<PlatformOrderPageResponse> responseList;
        Page startPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("status", request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getSecondType())) {
            map.put("secondType", request.getSecondType());
        }
        if (CollUtil.isEmpty(responseList = this.dao.getPlatformAdminPage(map))) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new PlatformOrderPageResponse[0]));
        }
        List<Integer> merIdList = responseList.stream().map(PlatformOrderPageResponse::getMerId).filter(merId -> merId > 0).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = CollUtil.isNotEmpty(merIdList) ? this.merchantService.getMerIdMapByIdList(merIdList) : null;
        responseList.forEach(response -> {
            if (response.getMerId() > 0) {
                response.setMerName(((Merchant)merchantMap.get(response.getMerId())).getName());
            }
            if (response.getRefundStatus().equals(2)) {
                response.setRefundNum(this.orderDetailService.getOrderRefundNum(response.getOrderNo()));
            }
        });
        return CommonPage.copyPageInfo((Page)startPage, responseList);
    }

    @Override
    public OrderCountItemResponse getPlatformOrderStatusNum(OrderTabsHeaderRequest request) {
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getPlatCount(request, "all"));
        response.setUnPaid(this.getPlatCount(request, "unPaid"));
        response.setNotShipped(this.getPlatCount(request, "notShipped"));
        response.setSpike(this.getPlatCount(request, "spike"));
        response.setComplete(this.getPlatCount(request, "complete"));
        response.setRefunded(this.getPlatCount(request, "refunded"));
        response.setDeleted(this.getPlatCount(request, "deleted"));
        response.setVerification(this.getPlatCount(request, "awaitVerification"));
        response.setReceiving(this.getPlatCount(request, "receiving"));
        response.setCancel(this.getPlatCount(request, "cancel"));
        return response;
    }

    @Override
    public PlatformOrderAdminDetailResponse platformInfo(String orderNo) {
        VerificationRecord verificationRecord;
        Order order = this.getByOrderNo(orderNo);
        PlatformOrderAdminDetailResponse response = new PlatformOrderAdminDetailResponse();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        BeanUtils.copyProperties((Object)merchantOrder, (Object)response);
        BeanUtils.copyProperties((Object)order, (Object)response);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        List orderInfoList = orderDetailList.stream().map(e -> {
            OrderInfoFrontDataResponse dataResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)e, (Object)dataResponse);
            return dataResponse;
        }).collect(Collectors.toList());
        response.setOrderDetailList(orderInfoList);
        User user = (User)this.userService.getById(order.getUid());
        response.setNickname(user.getNickname());
        response.setPhone(user.getPhone());
        response.setIsLogoff(user.getIsLogoff());
        if (merchantOrder.getClerkId() > 0 && ObjectUtil.isNotNull((Object)(verificationRecord = this.verificationRecordService.getByOrderNo(merchantOrder.getOrderNo())))) {
            if (verificationRecord.getVerifyStaffType().equals(1)) {
                SystemAdmin clerkAdmin = (SystemAdmin)this.systemAdminService.getById(merchantOrder.getClerkId());
                response.setClerkName(clerkAdmin.getRealName());
            } else {
                User clerkUser = (User)this.userService.getById(merchantOrder.getClerkId());
                response.setClerkName(clerkUser.getNickname());
            }
            response.setVerifyTime(verificationRecord.getVerifyTime());
        }
        if (order.getMerId() > 0) {
            Merchant merchant = (Merchant)this.merchantService.getById(order.getMerId());
            response.setMerName(merchant.getName());
            response.setMerIsSelf(merchant.getIsSelf());
        }
        response.setFlowRecordList(this.getFlowRecordList(orderNo));
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            response.setPhone(CrmebUtil.maskMobile((String)response.getPhone()));
            if (StrUtil.isNotBlank((CharSequence)response.getUserPhone())) {
                response.setUserPhone(CrmebUtil.maskMobile((String)response.getUserPhone()));
            }
        }
        return response;
    }

    @Override
    public LogisticsResultVo getLogisticsInfoByMerchant(Integer invoiceId, SystemAdmin systemAdmin) {
        OrderInvoice orderInvoice = (OrderInvoice)this.orderInvoiceService.getById(invoiceId);
        if (ObjectUtil.isNull((Object)orderInvoice)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_INVOICE_NOT_EXIST);
        }
        if (!orderInvoice.getDeliveryType().equals("express")) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_INVOICE_LOGISTICS_NOT_EXIST);
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderInvoice.getOrderNo());
        if (ObjectUtil.isNull((Object)merchantOrder) || !systemAdmin.getMerId().equals(merchantOrder.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        return this.logisticService.info(orderInvoice.getTrackingNumber(), null, Optional.ofNullable(orderInvoice.getExpressCode()).orElse(""), merchantOrder.getUserPhone());
    }

    @Override
    public LogisticsResultVo getLogisticsInfo(Integer invoiceId) {
        OrderInvoice orderInvoice = (OrderInvoice)this.orderInvoiceService.getById(invoiceId);
        if (ObjectUtil.isNull((Object)orderInvoice)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_INVOICE_NOT_EXIST);
        }
        if (!orderInvoice.getDeliveryType().equals("express")) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_INVOICE_LOGISTICS_NOT_EXIST);
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderInvoice.getOrderNo());
        return this.logisticService.info(orderInvoice.getTrackingNumber(), null, Optional.ofNullable(orderInvoice.getExpressCode()).orElse(""), merchantOrder.getUserPhone());
    }

    @Override
    public Boolean verificationOrderByCode(String verifyCode, SystemAdmin systemAdmin, String operatingPlatform) {
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByVerifyCode(verifyCode);
        if (ObjectUtil.isNull((Object)merchantOrder)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        Order order = this.getByOrderNo(merchantOrder.getOrderNo());
        if (!systemAdmin.getMerId().equals(order.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_VERIFICATION);
        }
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_APPLY)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u5904\u7406\u552e\u540e\uff0c\u518d\u8fdb\u884c\u6838\u9500\u64cd\u4f5c");
        }
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_ALL)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u5df2\u9000\u6b3e");
        }
        order.setStatus(OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        order.setReceivingTime((Date)DateUtil.date());
        order.setUpdateTime((Date)DateUtil.date());
        merchantOrder.setClerkId(systemAdmin.getId());
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        ArrayList<ReservationWorkOrder> workOrderList = new ArrayList<ReservationWorkOrder>();
        MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(systemAdmin.getMerId());
        if (merchantOrder.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) && merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_TO_STORE) && merchantInfo.getServiceWorkOrderSwitch().equals(Boolean.TRUE)) {
            List<OrderDetail> merOrderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            OrderDetail orderDetail = merOrderDetailList.get(0);
            JSONArray dataArray = new JSONArray();
            if (order.getSystemFormId() > 0) {
                String reservationFormData = orderDetail.getReservationFormData();
                dataArray = JSONArray.parseArray((String)reservationFormData);
            }
            int workNum = orderDetail.getPayNum() - orderDetail.getRefundNum();
            for (int i = 0; i < workNum; ++i) {
                ReservationWorkOrder workOrder = new ReservationWorkOrder();
                workOrder.setWorkOrderNo(CrmebUtil.getOrderNo((String)"GD"));
                workOrder.setMerId(orderDetail.getMerId());
                workOrder.setOrderNo(orderDetail.getOrderNo());
                workOrder.setOrderDetailId(orderDetail.getId());
                workOrder.setReservationDate(orderDetail.getReservationDate());
                workOrder.setReservationTimeSlot(orderDetail.getReservationTimeSlot());
                workOrder.setUserId(order.getUid());
                workOrder.setUserName(merchantOrder.getRealName());
                workOrder.setUserPhone(merchantOrder.getUserPhone());
                workOrder.setUserAddress(merchantOrder.getUserAddress());
                workOrder.setServiceType(WorkOrderConstants.SERVICE_TYPE_TO_STORE);
                workOrder.setReservationFormId(order.getSystemFormId());
                if (order.getSystemFormId() > 0) {
                    JSONArray jsonArray = dataArray.size() > 1 ? dataArray.getJSONArray(i) : dataArray.getJSONArray(0);
                    workOrder.setReservationFormData(jsonArray.toJSONString());
                } else {
                    workOrder.setReservationFormData("");
                }
                workOrderList.add(workOrder);
            }
        }
        VerificationRecord verificationRecord = new VerificationRecord();
        verificationRecord.setOrderNo(order.getOrderNo());
        verificationRecord.setMerId(merchantOrder.getId());
        verificationRecord.setVerifyCode(verifyCode);
        verificationRecord.setVerifyStaffId(systemAdmin.getId());
        if (operatingPlatform.equals("merchant")) {
            verificationRecord.setVerifyStaffType(Integer.valueOf(1));
        } else {
            verificationRecord.setVerifyStaffType(Integer.valueOf(2));
        }
        verificationRecord.setVerifyTime(new Date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(order);
            this.orderDetailService.takeDelivery(order.getOrderNo());
            this.verificationRecordService.save(verificationRecord);
            this.merchantOrderService.updateById(merchantOrder);
            if (CollUtil.isNotEmpty((Collection)workOrderList)) {
                this.reservationWorkOrderService.saveBatch(workOrderList);
            }
            this.orderFlowRecordService.orderReceipt(order.getOrderNo(), systemAdmin.getId(), "verify", systemAdmin.getType().equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            String shippingSwitch;
            this.redisUtil.lPush("alterOrderTakeByUser", (Object)order.getOrderNo());
            if (order.getPayType().equals("weixin") && order.getPayChannel().equals("mini") && StrUtil.isNotBlank((CharSequence)(shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch"))) && shippingSwitch.equals("1")) {
                this.asyncService.verifyOrderWechatSendUploadShipping(merchantOrder.getOrderNo());
            }
        }
        try {
            Merchant merchant = this.merchantService.getByIdException(merchantOrder.getMerId());
            if (merchant.getReceiptPrintingSwitch() == 0) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5c0f\u7968\u6253\u5370\u529f\u80fd\u672a\u5f00\u542f");
            }
            if (merchant.getReceiptPrintingSwitch() < 2) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5c0f\u7968\u6253\u5370\u672a\u5f00\u542f\u81ea\u52a8\u6253\u5370");
            }
            this.merchantPrintService.printReceipt(merchantOrder);
        }
        catch (Exception e2) {
            logger.error(StrUtil.format((CharSequence)"\u5c0f\u7968\u6253\u5370\u5f02\u5e38\uff0cException\uff1a{}", (Object[])new Object[]{e2.getMessage()}), (Throwable)e2);
        }
        return execute;
    }

    @Override
    public MerchantOrderPageResponse getVerificationOrderByCode(String verifyCode, SystemAdmin systemAdmin) {
        MerchantOrder merchantOrder = this.merchantOrderService.getByVerifyCodeForMerchant(verifyCode, systemAdmin.getMerId());
        if (ObjectUtil.isNull((Object)merchantOrder)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        Order order = this.getByOrderNo(merchantOrder.getOrderNo());
        if (!systemAdmin.getMerId().equals(order.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6838\u9500\u7801");
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_VERIFICATION);
        }
        MerchantOrderPageResponse merchantOrderPageResponse = new MerchantOrderPageResponse();
        BeanUtils.copyProperties((Object)merchantOrder, (Object)merchantOrderPageResponse);
        ArrayList infoResponseList = CollUtil.newArrayList((Object[])new OrderInfoFrontDataResponse[0]);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(merchantOrder.getOrderNo());
        orderDetailList.forEach(od -> {
            OrderInfoFrontDataResponse orderInfoResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)od, (Object)orderInfoResponse);
            infoResponseList.add(orderInfoResponse);
        });
        if (order.getRefundStatus() > 0) {
            merchantOrderPageResponse.setUserRefundSign(this.refundOrderService.isOrderContainUserRefund(order.getOrderNo()));
        }
        merchantOrderPageResponse.setInfoResponseList((List)infoResponseList);
        return merchantOrderPageResponse;
    }

    @Override
    public Integer getOrderProductNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(sum(total_num), 0) as total_num"});
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        Order order = (Order)this.dao.selectOne((Wrapper)wrapper);
        return order.getTotalNum();
    }

    @Override
    public Integer getOrderSuccessProductNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(sum(total_num), 0) as total_num"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        Order order = (Order)this.dao.selectOne((Wrapper)wrapper);
        return order.getTotalNum();
    }

    @Override
    public Integer getOrderNumByDate(Integer merId, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        if (merId > 0) {
            wrapper.eq((Object)"mer_id", (Object)merId);
        }
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getPayOrderAmountByDate(Integer merId, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"pay_price"});
        wrapper.eq((Object)"paid", (Object)1);
        if (merId > 0) {
            wrapper.eq((Object)"mer_id", (Object)merId);
        }
        wrapper.eq((Object)"is_del", (Object)false);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        List orderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public List<OrderDetail> getDetailList(String orderNo, SystemAdmin systemAdmin) {
        return this.orderDetailService.getShipmentByOrderNo(orderNo);
    }

    @Override
    public List<OrderInvoiceResponse> getInvoiceListByMerchant(String orderNo, SystemAdmin systemAdmin) {
        this.getByOrderNoAndMerId(orderNo, systemAdmin.getMerId());
        return this.getInvoiceList(orderNo);
    }

    @Override
    public List<OrderInvoiceResponse> getInvoiceList(String orderNo) {
        return this.orderInvoiceService.findByOrderNo(orderNo);
    }

    @Override
    public List<Order> findCanCompleteOrder(Integer autoCompleteDay) {
        DateTime autoCompleteDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-autoCompleteDay.intValue()));
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Order::getId, Order::getUid, Order::getOrderNo});
        lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        lqw.eq(Order::getLevel, (Object)OrderConstants.ORDER_LEVEL_MERCHANT);
        lqw.le(Order::getReceivingTime, (Object)autoCompleteDate);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean batchCompleteByOrderNo(List<String> orderNoList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_COMPLETE);
        wrapper.in(Order::getOrderNo, orderNoList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Integer getCountByStatusAndUid(Integer status, Integer userId) {
        if (status < 0) {
            return 0;
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getUid, (Object)userId);
        lqw.eq(Order::getIsDel, (Object)false);
        if (OrderConstants.ORDER_STATUS_WAIT_SHIPPING.equals(status)) {
            lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
            lqw.in(Order::getGroupBuyRecordStatus, new Object[]{99, 10});
        } else if (OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION.equals(status)) {
            lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            lqw.in(Order::getGroupBuyRecordStatus, new Object[]{99, 10});
        } else {
            lqw.eq(Order::getStatus, (Object)status);
        }
        lqw.eq(Order::getIsUserDel, (Object)false);
        lqw.eq(Order::getIsMerchantDel, (Object)false);
        lqw.ne(Order::getSecondType, (Object)OrderConstants.ORDER_SECOND_TYPE_VIDEO);
        lqw.eq(Order::getIsDel, (Object)false);
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getPayOrderNumByDate(String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getSpreadOrderTotalPriceByOrderList(List<String> orderNoList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Order::getPayPrice});
        lqw.in(Order::getOrderNo, orderNoList);
        List orderList = this.dao.selectList((Wrapper)lqw);
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public Boolean paySplitDelete(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Order::getIsDel, (Object)true);
        wrapper.eq(Order::getOrderNo, (Object)orderNo);
        wrapper.eq(Order::getIsDel, (Object)false);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<Order> getByPlatOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getPlatOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isExistPendingOrderByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Order::getId});
        lqw.eq(Order::getUid, (Object)uid);
        lqw.eq(Order::getIsDel, (Object)0);
        lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING, OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION});
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)order);
    }

    @Override
    public List<Order> findAwaitTakeDeliveryOrderList(String sendTime) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
        lqw.le(Order::getUpdateTime, (Object)sendTime);
        lqw.eq(Order::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getNotShippingNum(Integer merId) {
        return this.getCount("", "notShipped", merId);
    }

    @Override
    public Integer getAwaitVerificationNum(Integer merId) {
        return this.getCount("", "awaitVerification", merId);
    }

    @Override
    public Integer getProductNumCount(Integer uid, Integer proId, Integer marketingType) {
        return this.dao.getProductNumCount(uid, proId, marketingType);
    }

    @Override
    public List<Order> findPayByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Order::getMerId, (Object)merId);
        }
        lqw.eq(Order::getPaid, (Object)1);
        lqw.ne(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
        lqw.eq(Order::getIsDel, (Object)0);
        lqw.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Order> findExportList(OrderSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            lqw.eq(Order::getMerId, (Object)request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            lqw.like(Order::getOrderNo, (Object)URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            lqw.eq(Order::getType, (Object)request.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, request.getDateLimit());
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, request.getStatus());
        lqw.orderByDesc(Order::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isAllSendGoods(String orderNo) {
        List<Order> orderList = this.getByPlatOrderNo(orderNo);
        boolean isAll = true;
        for (Order order : orderList) {
            if (order.getStatus() >= OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION) continue;
            isAll = false;
            break;
        }
        return isAll;
    }

    @Override
    public Boolean virtualShipment(Order order) {
        String shippingSwitch;
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
        merchantOrder.setIsSplitDelivery(Boolean.FALSE);
        merchantOrder.setDeliveryType("fictitious");
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        orderDetailList.forEach(od -> {
            od.setDeliveryNum(od.getPayNum());
            od.setUpdateTime((Date)DateUtil.date());
        });
        order.setUpdateTime((Date)DateUtil.date());
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), "\u865a\u62df\u53d1\u8d27", 0, 0);
            this.takeDelivery(order.getOrderNo());
            this.orderDetailService.takeDelivery(order.getOrderNo());
            this.orderFlowRecordService.orderReceipt(order.getOrderNo(), 0, "auto", null);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("\u865a\u62df\u53d1\u8d27\u5931\u8d25,\u8ba2\u5355\u53f7={}", (Object)order.getOrderNo());
            return execute;
        }
        if (order.getPayType().equals("weixin") && order.getPayChannel().equals("mini") && StrUtil.isNotBlank((CharSequence)(shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch"))) && shippingSwitch.equals("1")) {
            this.asyncService.wechatSendUploadShipping(merchantOrder.getOrderNo());
        }
        this.redisUtil.lPush("alterOrderTakeByUser", (Object)order.getOrderNo());
        return execute;
    }

    @Override
    public Boolean directRefund(MerchantOrderDirectRefundRequest request, SystemAdmin systemAdmin) {
        if (request.getReturnType().equals(2) && CollUtil.isEmpty((Collection)request.getDetailList())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u8981\u9000\u6b3e\u7684\u5546\u54c1");
        }
        Order order = this.getByOrderNoAndMerId(request.getOrderNo(), systemAdmin.getMerId());
        if (order.getRefundStatus().equals(OrderConstants.ORDER_REFUND_STATUS_ALL)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_REFUND_ED);
        }
        boolean isExistWork = false;
        if (request.getReturnType().equals(2) && order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) && (isExistWork = this.reservationWorkOrderService.isExistWorkByOrderNo(request.getOrderNo()).booleanValue()) && CollUtil.isEmpty((Collection)((MerchantOrderDirectRefundDetailRequest)request.getDetailList().get(0)).getWorkOrderIdList())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9884\u7ea6\u8ba2\u5355\u9000\u6b3e\u8bf7\u9009\u62e9\u5de5\u5355");
        }
        if (this.isContainUserRefund(order).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u53d1\u751f\u7528\u6237\u7533\u8bf7\u9000\u6b3e\u7684\u8ba2\u5355\u65e0\u6cd5\u5546\u5bb6\u76f4\u63a5\u9000\u6b3e");
        }
        List<Object> orderDetailList = new ArrayList();
        List<Integer> workOrderIdList = new ArrayList<Integer>();
        if (request.getReturnType().equals(2)) {
            List detailList = request.getDetailList();
            for (MerchantOrderDirectRefundDetailRequest detailRequest : detailList) {
                OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(detailRequest.getOrderDetailId());
                if (ObjectUtil.isNull((Object)orderDetail) || !orderDetail.getOrderNo().equals(order.getOrderNo())) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u5546\u54c1\u8ba2\u5355\u8be6\u60c5\u4e0d\u5b58\u5728,\u8ba2\u5355\u8be6\u60c5ID=" + detailRequest.getOrderDetailId());
                }
                if (orderDetail.getApplyRefundNum() > 0) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u5546\u54c1\u8ba2\u5355\u8be6\u60c5\u5b58\u5728\u9000\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u64cd\u4f5c\u76f4\u63a5\u9000\u6b3e,\u8ba2\u5355\u8be6\u60c5ID=" + detailRequest.getOrderDetailId());
                }
                int canNum = orderDetail.getPayNum() - orderDetail.getRefundNum();
                if (canNum < detailRequest.getNum()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u6570\u91cf\u5927\u4e8e\u53ef\u9000\u6b3e\u6570\u91cf,\u8ba2\u5355\u8be6\u60c5ID=" + detailRequest.getOrderDetailId());
                }
                orderDetail.setApplyRefundNum(detailRequest.getNum());
                if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) && isExistWork) {
                    workOrderIdList = detailRequest.getWorkOrderIdList();
                }
                orderDetailList.add(orderDetail);
            }
        } else {
            orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            int i = 0;
            while (i < orderDetailList.size()) {
                OrderDetail orderDetail = (OrderDetail)orderDetailList.get(i);
                if (orderDetail.getApplyRefundNum() > 0) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u5546\u54c1\u8ba2\u5355\u8be6\u60c5\u5b58\u5728\u9000\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u64cd\u4f5c\u76f4\u63a5\u9000\u6b3e,\u8ba2\u5355\u8be6\u60c5ID=" + orderDetail.getId());
                }
                if (orderDetail.getPayNum() <= orderDetail.getRefundNum()) {
                    orderDetailList.remove(i);
                    continue;
                }
                orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getPayNum() - orderDetail.getRefundNum()));
                isExistWork = this.reservationWorkOrderService.isExistWorkByOrderNo(request.getOrderNo());
                if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) && isExistWork) {
                    workOrderIdList = this.reservationWorkOrderService.findIdByOrderNo(request.getOrderNo());
                }
                ++i;
            }
        }
        return this.refundOrderService.merchantDirectRefund(order, orderDetailList, workOrderIdList);
    }

    @Override
    public Boolean updateInvoice(OrderInvoiceUpdateRequest request, SystemAdmin systemAdmin) {
        OrderInvoice invoice = (OrderInvoice)this.orderInvoiceService.getById(request.getId());
        if (ObjectUtil.isNull((Object)invoice) || !invoice.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_INVOICE_NOT_EXIST);
        }
        this.validateUpdateInvoice(invoice.getDeliveryType(), request);
        if (invoice.getDeliveryType().equals("express")) {
            Express express = this.expressService.getByCode(request.getExpressCode());
            if (ObjectUtil.isNull((Object)express)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5feb\u9012\u516c\u53f8");
            }
            String trackingNumber = request.getExpressNumber();
            invoice.setExpressCode(express.getCode());
            invoice.setExpressName(express.getName());
            invoice.setTrackingNumber(trackingNumber);
        }
        if (invoice.getDeliveryType().equals("merchant")) {
            invoice.setDeliveryCarrier(request.getDeliveryCarrier());
            invoice.setCarrierPhone(request.getCarrierPhone());
        }
        if (invoice.getDeliveryType().equals("noNeed")) {
            invoice.setDeliveryMark(StrUtil.isNotBlank((CharSequence)request.getDeliveryMark()) ? request.getDeliveryMark() : "");
        }
        invoice.setUpdateTime((Date)DateUtil.date());
        return this.orderInvoiceService.updateById(invoice);
    }

    @Override
    public OrderCountItemResponse getIntegralOrderStatusNum(IntegralOrderTabsHeaderRequest request) {
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getIntegralOrderCount(request, "all"));
        response.setUnPaid(this.getIntegralOrderCount(request, "unPaid"));
        response.setNotShipped(this.getIntegralOrderCount(request, "notShipped"));
        response.setSpike(this.getIntegralOrderCount(request, "spike"));
        response.setReceiving(this.getIntegralOrderCount(request, "receiving"));
        response.setComplete(this.getIntegralOrderCount(request, "complete"));
        response.setDeleted(this.getIntegralOrderCount(request, "deleted"));
        response.setCancel(this.getIntegralOrderCount(request, "cancel"));
        return response;
    }

    @Override
    public PageInfo<IntegralOrderPageResponse> findIntegralOrderPageByPlat(IntegralOrderSearchRequest request) {
        List<IntegralOrderPageResponse> responseList;
        Page startPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("status", request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (CollUtil.isEmpty(responseList = this.dao.findIntegralOrderPageByPlat(map))) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new IntegralOrderPageResponse[0]));
        }
        return CommonPage.copyPageInfo((Page)startPage, responseList);
    }

    @Override
    public Boolean integralOrderMark(OrderRemarkRequest request) {
        Order order = this.getByOrderNoAndMerId(request.getOrderNo(), 0);
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
        merchantOrder.setMerchantRemark(request.getRemark());
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        return this.merchantOrderService.updateById(merchantOrder);
    }

    @Override
    public OrderAdminDetailResponse adminIntegralOrderDetail(String orderNo) {
        Order order = this.getByOrderNoAndMerId(orderNo, 0);
        if (order.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        OrderAdminDetailResponse orderAdminDetailResponse = new OrderAdminDetailResponse();
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        BeanUtils.copyProperties((Object)merchantOrder, (Object)orderAdminDetailResponse);
        BeanUtils.copyProperties((Object)order, (Object)orderAdminDetailResponse);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        List orderInfoList = orderDetailList.stream().map(e -> {
            OrderInfoFrontDataResponse dataResponse = new OrderInfoFrontDataResponse();
            BeanUtils.copyProperties((Object)e, (Object)dataResponse);
            return dataResponse;
        }).collect(Collectors.toList());
        orderAdminDetailResponse.setOrderDetailList(orderInfoList);
        if (order.getRefundStatus() > 0) {
            orderAdminDetailResponse.setUserRefundSign(this.refundOrderService.isOrderContainUserRefund(order.getOrderNo()));
        }
        User user = (User)this.userService.getById(order.getUid());
        orderAdminDetailResponse.setNickname(user.getNickname());
        orderAdminDetailResponse.setPhone(user.getPhone());
        orderAdminDetailResponse.setIsLogoff(user.getIsLogoff());
        orderAdminDetailResponse.setAvatar(user.getAvatar());
        orderAdminDetailResponse.setUserLevel(user.getLevel());
        orderAdminDetailResponse.setIsPaidMember(user.getIsPaidMember());
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue() && StrUtil.isNotBlank((CharSequence)orderAdminDetailResponse.getPhone())) {
            orderAdminDetailResponse.setPhone(CrmebUtil.maskMobile((String)orderAdminDetailResponse.getPhone()));
            orderAdminDetailResponse.setUserPhone(CrmebUtil.maskMobile((String)orderAdminDetailResponse.getUserPhone()));
        }
        orderAdminDetailResponse.setFlowRecordList(this.getFlowRecordList(orderNo));
        return orderAdminDetailResponse;
    }

    @Override
    public Order getMerchantOrderNoByPtOrderNoForGroupBuy(String ptOrderNo) {
        Order order = (Order)this.getOne((Wrapper)Wrappers.lambdaQuery(Order.class).eq(Order::getPlatOrderNo, (Object)ptOrderNo));
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u62fc\u56e2\u8ba2\u5355\u66f4\u65b0\u8ba2\u5355\u53f7\u67e5\u8be2\u5931\u8d25\uff01: ptNo:${}", (Object)ptOrderNo);
        }
        return order;
    }

    @Override
    public Integer getOrderNumByMerIds(List<Integer> merIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        wrapper.in((Object)"mer_id", merIds);
        wrapper.eq((Object)"is_del", (Object)0);
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getPayOrderAmountByMerIds(List<Integer> merIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"pay_price"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.in((Object)"mer_id", merIds);
        wrapper.eq((Object)"is_del", (Object)false);
        List orderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public BigDecimal getPayOrderAmountByMerIdsAnDate(List<Integer> merIds, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"pay_price"});
        wrapper.eq((Object)"paid", (Object)1);
        wrapper.in((Object)"mer_id", merIds);
        wrapper.eq((Object)"is_del", (Object)false);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        List orderList = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public Integer getOrderNumByMerIdsAndDate(List<Integer> merIds, String date) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"id"});
        wrapper.in((Object)"mer_id", merIds);
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public Integer getNotShippingNumByMerIds(List<Integer> merIds) {
        return this.getCount("", "notShipped", merIds);
    }

    @Override
    public Integer getAwaitVerificationNumByMerIds(List<Integer> merIds) {
        return this.getCount("", "awaitVerification", merIds);
    }

    @Override
    public PageInfo<PlatformOrderPageResponse> getCircleOrderPage(List<Integer> merIdList, OrderSearchRequest request) {
        List<PlatformOrderPageResponse> responseList;
        Page startPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("status", request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        map.put("merIds", merIds);
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getSecondType())) {
            map.put("secondType", request.getSecondType());
        }
        if (CollUtil.isEmpty(responseList = this.dao.getCircleOrderPage(map))) {
            return CommonPage.copyPageInfo((Page)startPage, (List)CollUtil.newArrayList((Object[])new PlatformOrderPageResponse[0]));
        }
        List<Integer> merchantIdList = responseList.stream().map(PlatformOrderPageResponse::getMerId).filter(merId -> merId > 0).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = CollUtil.isNotEmpty(merchantIdList) ? this.merchantService.getMerIdMapByIdList(merchantIdList) : null;
        responseList.forEach(response -> {
            if (response.getMerId() > 0) {
                response.setMerName(((Merchant)merchantMap.get(response.getMerId())).getName());
            }
            if (response.getRefundStatus().equals(2)) {
                response.setRefundNum(this.orderDetailService.getOrderRefundNum(response.getOrderNo()));
            }
        });
        return CommonPage.copyPageInfo((Page)startPage, responseList);
    }

    @Override
    public OrderCountItemResponse getCircleOrderStatusNum(List<Integer> merIdList, OrderTabsHeaderRequest request) {
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        OrderCountItemResponse response = new OrderCountItemResponse();
        response.setAll(this.getCircleCount(merIds, request, "all"));
        response.setUnPaid(this.getCircleCount(merIds, request, "unPaid"));
        response.setNotShipped(this.getCircleCount(merIds, request, "notShipped"));
        response.setSpike(this.getCircleCount(merIds, request, "spike"));
        response.setComplete(this.getCircleCount(merIds, request, "complete"));
        response.setRefunded(this.getCircleCount(merIds, request, "refunded"));
        response.setDeleted(this.getCircleCount(merIds, request, "deleted"));
        response.setVerification(this.getCircleCount(merIds, request, "awaitVerification"));
        response.setReceiving(this.getCircleCount(merIds, request, "receiving"));
        response.setCancel(this.getCircleCount(merIds, request, "cancel"));
        return response;
    }

    private void validateUpdateInvoice(String deliveryType, OrderInvoiceUpdateRequest request) {
        if (deliveryType.equals("express")) {
            if (StrUtil.isBlank((CharSequence)request.getExpressNumber()) && StrUtil.isNotBlank((CharSequence)request.getExpressRecordType()) && request.getExpressRecordType().equals("1")) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u5feb\u9012\u5355\u53f7");
            }
            if (StrUtil.isBlank((CharSequence)request.getExpressCode())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5feb\u9012\u516c\u53f8");
            }
        }
        if (deliveryType.equals("merchant")) {
            if (StrUtil.isBlank((CharSequence)request.getDeliveryCarrier())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u914d\u9001\u4eba\u5458");
            }
            if (StrUtil.isBlank((CharSequence)request.getCarrierPhone())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u914d\u9001\u4eba\u5458\u624b\u673a\u53f7");
            }
        }
    }

    private Boolean isContainUserRefund(Order order) {
        if (order.getRefundStatus().equals(0)) {
            return Boolean.FALSE;
        }
        return this.refundOrderService.isOrderContainUserRefund(order.getOrderNo());
    }

    private Order getByOrderNoAndMerId(String orderNo, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        lqw.eq(Order::getMerId, (Object)merId);
        lqw.last(" limit 1");
        Order order = (Order)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        return order;
    }

    private Boolean splitSendExpress(OrderSendRequest request, Order order, MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, Integer adminId, Integer adminType) {
        SystemNotification payNotification;
        User user;
        SystemNotification paySplitNotification;
        Express express = this.expressService.getByCode(request.getExpressCode());
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5feb\u9012\u516c\u53f8");
        }
        List detailRequestList = request.getDetailList();
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        detailRequestList.forEach(detail -> {
            OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getId().equals(detail.getOrderDetailId())).findAny().orElse(null);
            orderDetail.setDeliveryNum(Integer.valueOf(orderDetail.getDeliveryNum() + detail.getNum()));
            orderDetail.setUpdateTime((Date)DateUtil.date());
            OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
            BeanUtils.copyProperties((Object)orderDetail, (Object)invoiceDetail);
            invoiceDetail.setNum(detail.getNum());
            invoiceDetail.setCreateTime((Date)DateUtil.date());
            invoiceDetail.setUpdateTime((Date)DateUtil.date());
            orderInvoiceDetailList.add(invoiceDetail);
            orderDetailUpdateList.add(orderDetail);
        });
        ElectrResponse electrResponse = this.expressDump(request, merchantOrder, express);
        logger.info("\u7535\u5b50\u9762\u5355\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)electrResponse));
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setExpressCode(electrResponse.getCode());
        invoice.setExpressName(electrResponse.getLabel());
        invoice.setTrackingNumber(electrResponse.getKuaidinum());
        invoice.setExpressRecordType(request.getExpressRecordType());
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setIsSplitDelivery(Boolean.TRUE);
        merchantOrder.setDeliveryType("express");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_PART_SHIPPING);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u62c6\u5355\u53d1\u8d27\uff0c" + "\u5feb\u9012\u516c\u53f8\uff1a{deliveryName}, \u5feb\u9012\u5355\u53f7\uff1a{deliveryCode}".replace("{deliveryName}", express.getName()).replace("{deliveryCode}", electrResponse.getKuaidinum());
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5feb\u9012\u62c6\u5355\u53d1\u8d27\u5931\u8d25\uff01");
        }
        List<OrderDetail> detailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        long count = detailList.stream().filter(e -> e.getPayNum() > e.getDeliveryNum() + e.getRefundNum()).count();
        if (count <= 0L) {
            String shippingSwitch;
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            order.setUpdateTime((Date)DateUtil.date());
            this.updateById(order);
            if (order.getPayType().equals("weixin") && order.getPayChannel().equals("mini") && StrUtil.isNotBlank((CharSequence)(shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch"))) && shippingSwitch.equals("1")) {
                this.asyncService.wechatSendUploadShipping(order.getOrderNo());
            }
        }
        if ((paySplitNotification = this.systemNotificationService.getByMark("splitDeliverGoods")).getIsSms().equals(1) && StrUtil.isNotBlank((CharSequence)(user = (User)this.userService.getById(order.getUid())).getPhone())) {
            try {
                List productNameList = orderInvoiceDetailList.stream().map(OrderInvoiceDetail::getProductName).collect(Collectors.toList());
                String storeNameAndCarNumString = String.join((CharSequence)",", productNameList);
                this.smsService.sendOrderSplitDeliverNotice(user.getPhone(), storeNameAndCarNumString, order.getOrderNo());
            }
            catch (Exception e2) {
                logger.error("\u62c6\u5206\u53d1\u8d27\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u5f02\u5e38", (Throwable)e2);
            }
        }
        if ((payNotification = this.systemNotificationService.getByMark("deliverGoods")).getIsWechat().equals(1) || payNotification.getIsRoutine().equals(1)) {
            try {
                this.pushMessageOrder(order, payNotification, invoice);
            }
            catch (Exception e3) {
                logger.error("\u62c6\u5206\u53d1\u8d27\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25", (Throwable)e3);
            }
        }
        return execute;
    }

    private Boolean sendExpress(OrderSendRequest request, Order order, MerchantOrder merchantOrder, Integer adminId, Integer adminType) {
        String shippingSwitch;
        User user;
        Express express = this.expressService.getByCode(request.getExpressCode());
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5feb\u9012\u516c\u53f8");
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        ArrayList orderInvoiceDetailList = new ArrayList();
        ArrayList orderDetailUpdateList = new ArrayList();
        orderDetailList.forEach(od -> {
            if (od.getPayNum() > od.getDeliveryNum()) {
                OrderInvoiceDetail invoiceDetail = new OrderInvoiceDetail();
                BeanUtils.copyProperties((Object)od, (Object)invoiceDetail);
                invoiceDetail.setNum(Integer.valueOf(od.getPayNum() - od.getDeliveryNum()));
                invoiceDetail.setCreateTime((Date)DateUtil.date());
                invoiceDetail.setUpdateTime((Date)DateUtil.date());
                orderInvoiceDetailList.add(invoiceDetail);
                od.setDeliveryNum(od.getPayNum());
                od.setUpdateTime((Date)DateUtil.date());
                orderDetailUpdateList.add(od);
            }
        });
        if (CollUtil.isEmpty(orderInvoiceDetailList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        ElectrResponse electrResponse = this.expressDump(request, merchantOrder, express);
        logger.info("\u7535\u5b50\u9762\u5355\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)electrResponse));
        OrderInvoice invoice = new OrderInvoice();
        invoice.setMerId(order.getMerId());
        invoice.setOrderNo(order.getOrderNo());
        invoice.setUid(order.getUid());
        invoice.setExpressCode(electrResponse.getCode());
        invoice.setExpressName(electrResponse.getLabel());
        invoice.setTrackingNumber(electrResponse.getKuaidinum());
        invoice.setExpressRecordType(request.getExpressRecordType());
        invoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(OrderInvoiceDetail::getNum).sum()));
        merchantOrder.setIsSplitDelivery(Boolean.FALSE);
        merchantOrder.setDeliveryType("express");
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        order.setUpdateTime((Date)DateUtil.date());
        String message = "\u5168\u90e8\u53d1\u8d27\uff0c" + "\u5feb\u9012\u516c\u53f8\uff1a{deliveryName}, \u5feb\u9012\u5355\u53f7\uff1a{deliveryCode}".replace("{deliveryName}", express.getName()).replace("{deliveryCode}", electrResponse.getKuaidinum());
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            this.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            this.orderDetailService.updateBatchById(orderDetailUpdateList);
            this.orderInvoiceService.save(invoice);
            orderInvoiceDetailList.forEach(e -> e.setInvoiceId(invoice.getId()));
            this.orderInvoiceDetailService.saveBatch(orderInvoiceDetailList);
            this.orderFlowRecordService.orderDelivery(order.getOrderNo(), message, adminId, adminType.equals(-4) ? 4 : 3);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u5feb\u9012\u53d1\u8d27\u5931\u8d25\uff01");
        }
        SystemNotification payNotification = this.systemNotificationService.getByMark("deliverGoods");
        if (payNotification.getIsSms().equals(1) && StrUtil.isNotBlank((CharSequence)(user = (User)this.userService.getById(order.getUid())).getPhone())) {
            try {
                List productNameList = orderInvoiceDetailList.stream().map(OrderInvoiceDetail::getProductName).collect(Collectors.toList());
                String storeNameAndCarNumString = String.join((CharSequence)",", productNameList);
                this.smsService.sendOrderDeliverNotice(user.getPhone(), user.getNickname(), storeNameAndCarNumString, order.getOrderNo());
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d27\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u5f02\u5e38", (Throwable)e);
            }
        }
        if (payNotification.getIsWechat().equals(1) || payNotification.getIsRoutine().equals(1)) {
            try {
                this.pushMessageOrder(order, payNotification, invoice);
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d27\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25", (Throwable)e);
            }
        }
        if (order.getPayType().equals("weixin") && order.getPayChannel().equals("mini") && StrUtil.isNotBlank((CharSequence)(shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch"))) && shippingSwitch.equals("1")) {
            this.asyncService.wechatSendUploadShipping(merchantOrder.getOrderNo());
        }
        return execute;
    }

    private ElectrResponse expressDump(OrderSendRequest request, MerchantOrder merchantOrder, Express express) {
        ElectrResponse electrResponse = new ElectrResponse();
        if (request.getExpressRecordType().equals("1")) {
            electrResponse.setKuaidinum(request.getExpressNumber());
            electrResponse.setLabel(express.getName());
            electrResponse.setCode(express.getCode());
            return electrResponse;
        }
        MerchantExpress merchantExpress = this.merchantExpressService.getByCode(express.getCode(), merchantOrder.getMerId());
        if (ObjectUtil.isNull((Object)merchantExpress) || !merchantExpress.getIsOpen().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u7269\u6d41\u516c\u53f8\u672a\u5173\u8054\u6216\u672a\u5f00\u542f");
        }
        MyRecord record = new MyRecord();
        record.set("com", (Object)express.getCode());
        record.set("to_name", (Object)merchantOrder.getRealName());
        record.set("to_tel", (Object)merchantOrder.getUserPhone());
        record.set("to_addr", (Object)merchantOrder.getUserAddress());
        record.set("from_name", (Object)request.getToName());
        record.set("from_tel", (Object)request.getToTel());
        record.set("from_addr", (Object)request.getToAddr());
        record.set("temp_id", (Object)request.getExpressTempId());
        record.set("siid", (Object)"");
        record.set("print_type", (Object)"IMAGE");
        record.set("count", (Object)merchantOrder.getTotalNum());
        List<OrderDetail> byOrderNo = this.orderDetailService.getByOrderNo(merchantOrder.getOrderNo());
        ArrayList<String> productNameList = new ArrayList<String>();
        for (OrderDetail orderDetail : byOrderNo) {
            productNameList.add(orderDetail.getProductName());
        }
        record.set("cargo", (Object)String.join((CharSequence)",", productNameList));
        if (express.getPartnerId().booleanValue()) {
            record.set("partner_id", (Object)merchantExpress.getAccount());
        }
        if (express.getPartnerKey().booleanValue()) {
            record.set("partner_key", (Object)merchantExpress.getPassword());
        }
        if (express.getNet().booleanValue()) {
            record.set("net", (Object)merchantExpress.getNetName());
        }
        try {
            MyRecord myRecord = this.onePassService.expressDump(record);
            logger.info("\u7535\u5b50\u9762\u5355\u7684\u8fd4\u56de\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)myRecord));
            electrResponse.setKuaidinum(myRecord.getStr("kuaidinum"));
            electrResponse.setLabel(myRecord.getStr("label"));
            electrResponse.setCode(myRecord.getStr("code"));
        }
        catch (Exception e) {
            logger.error("\u6253\u5370\u7535\u5b50\u9762\u5355\u5931\u8d25 - \u9762\u5355\u7684\u8fd4\u56de\u6570\u636e:{}", (Object)e.getMessage());
            throw new CrmebException("\u4e00\u53f7\u901a-\u7535\u5b50\u9762\u5355\u5931\u8d25\uff1a" + e.getMessage());
        }
        return electrResponse;
    }

    private void validateOrderSend(OrderSendRequest request) {
        if (request.getDeliveryType().equals("express")) {
            if (StrUtil.isBlank((CharSequence)request.getExpressNumber()) && StrUtil.isNotBlank((CharSequence)request.getExpressRecordType()) && request.getExpressRecordType().equals("1")) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u5feb\u9012\u5355\u53f7");
            }
            if (StrUtil.isBlank((CharSequence)request.getExpressCode())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5feb\u9012\u516c\u53f8");
            }
        }
        if (request.getDeliveryType().equals("merchant")) {
            if (StrUtil.isBlank((CharSequence)request.getDeliveryCarrier())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u914d\u9001\u4eba\u5458");
            }
            if (StrUtil.isBlank((CharSequence)request.getCarrierPhone())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u914d\u9001\u4eba\u5458\u624b\u673a\u53f7");
            }
        }
    }

    private Integer getCount(OrderTabsHeaderRequest request, String status, Integer merId) {
        HashMap map = CollUtil.newHashMap();
        map.put("status", status);
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (merId > 0) {
            map.put("merId", merId);
        } else if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        return this.dao.getMerchantAdminPageCount(map);
    }

    private Integer getPlatCount(OrderTabsHeaderRequest request, String status) {
        HashMap map = CollUtil.newHashMap();
        map.put("status", status);
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getSecondType())) {
            map.put("secondType", request.getSecondType());
        }
        return this.dao.getPlatformAdminPageCount(map);
    }

    private Integer getCircleCount(List<Integer> merIdList, OrderTabsHeaderRequest request, String status) {
        HashMap map = CollUtil.newHashMap();
        map.put("status", status);
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        map.put("merIds", merIds);
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getSecondType())) {
            map.put("secondType", request.getSecondType());
        }
        return this.dao.getCircleOrderPageCount(map);
    }

    private Integer getIntegralOrderCount(IntegralOrderTabsHeaderRequest request, String status) {
        HashMap map = CollUtil.newHashMap();
        map.put("status", status);
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        return this.dao.getIntegralOrderCount(map);
    }

    private Integer getCount(String dateLimit, String status, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Order::getMerId, (Object)merId);
            lqw.eq(Order::getIsMerchantDel, (Object)false);
        }
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, dateLimit);
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, status);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private Integer getCount(String dateLimit, String status, List<Integer> merIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Order::getMerId, merIds);
        lqw.eq(Order::getIsMerchantDel, (Object)false);
        if (StrUtil.isNotBlank((CharSequence)dateLimit)) {
            this.getRequestTimeWhere((LambdaQueryWrapper<Order>)lqw, dateLimit);
        }
        this.getMerchantStatusWhere((LambdaQueryWrapper<Order>)lqw, status);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private void getMerchantStatusWhere(LambdaQueryWrapper<Order> lqw, String status) {
        if (StrUtil.isBlank((CharSequence)status)) {
            return;
        }
        switch (status) {
            case "all": {
                break;
            }
            case "unPaid": {
                lqw.eq(Order::getPaid, (Object)false);
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_PAY);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "notShipped": {
                lqw.in(Order::getStatus, new Object[]{OrderConstants.ORDER_STATUS_WAIT_SHIPPING, OrderConstants.ORDER_STATUS_PART_SHIPPING});
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                lqw.in(Order::getGroupBuyRecordStatus, new Object[]{10, 99});
                break;
            }
            case "spike": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "receiving": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "complete": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_COMPLETE);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "awaitVerification": {
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.ne(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                lqw.in(Order::getGroupBuyRecordStatus, new Object[]{10, 99});
                break;
            }
            case "refunded": {
                lqw.eq(Order::getPaid, (Object)true);
                lqw.eq(Order::getCancelStatus, (Object)OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
                lqw.eq(Order::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_REFUND);
                lqw.eq(Order::getIsUserDel, (Object)false);
                break;
            }
            case "deleted": {
                lqw.eq(Order::getIsUserDel, (Object)true);
                break;
            }
            case "cancel": {
                lqw.eq(Order::getPaid, (Object)false);
                lqw.eq(Order::getStatus, (Object)OrderConstants.ORDER_STATUS_CANCEL);
                lqw.in(Order::getCancelStatus, new Object[]{OrderConstants.ORDER_CANCEL_STATUS_SYSTEM, OrderConstants.ORDER_CANCEL_STATUS_USER});
                lqw.eq(Order::getIsUserDel, (Object)false);
            }
        }
        lqw.eq(Order::getIsDel, (Object)false);
    }

    private void getRequestTimeWhere(LambdaQueryWrapper<Order> lqw, String dateLimit) {
        DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)dateLimit);
        lqw.between(Order::getCreateTime, (Object)dateLimitUtilVo.getStartTime(), (Object)dateLimitUtilVo.getEndTime());
    }

    private void pushMessageOrder(Order order, SystemNotification notification, OrderInvoice invoice) {
        if (!order.getPayType().equals("weixin")) {
            return;
        }
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (order.getPayChannel().equals("public") && notification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u8ba2\u5355\u53d1\u8d27\u63d0\u9192");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", invoice.getExpressName());
            temMap.put("keyword3", invoice.getExpressCode());
            temMap.put("remark", "\u6b22\u8fce\u518d\u6b21\u8d2d\u4e70\uff01");
            this.templateMessageService.pushTemplateMessage(notification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (order.getPayChannel().equals("mini") && notification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string7", order.getOrderNo());
            temMap.put("thing1", invoice.getExpressName());
            temMap.put("character_string2", invoice.getExpressCode());
            temMap.put("thing8", "\u60a8\u7684\u8ba2\u5355\u5df2\u53d1\u8d27");
            this.templateMessageService.pushMiniTemplateMessage(notification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    @Override
    public Integer getAPC() {
        return Math.toIntExact(this.productService.count());
    }

    @Override
    public Integer getAMC() {
        return Math.toIntExact(this.merchantService.count());
    }

    @Override
    public Integer getAOC() {
        return Math.toIntExact(this.count());
    }
}

