/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.OrderDetailDao;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderDetailServiceImpl
extends ServiceImpl<OrderDetailDao, OrderDetail>
implements OrderDetailService {
    @Resource
    private OrderDetailDao dao;
    @Autowired
    private OrderService orderService;

    @Override
    public List<OrderDetail> getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<OrderDetail> getReplyList(Integer userId, Boolean isReply, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List<OrderDetail> orderDetailList = this.dao.findReplyList(userId, isReply != false ? 1 : 0);
        return CommonPage.copyPageInfo((Page)page, orderDetailList);
    }

    @Override
    public Boolean takeDelivery(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(OrderDetail::getIsReceipt, (Object)true);
        wrapper.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<OrderDetail> findAfterSaleApplyList(Integer uid, CommonSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        String keywords = StrUtil.isNotBlank((CharSequence)request.getKeywords()) ? URLUtil.decode((String)request.getKeywords()) : "";
        List<OrderDetail> orderDetailList = this.dao.findAfterSaleApplyList(uid, keywords);
        return CommonPage.copyPageInfo((Page)page, orderDetailList);
    }

    @Override
    public Integer getSalesNumByDateAndProductId(String date, Integer proId) {
        return this.dao.getSalesNumByDateAndProductId(date, proId);
    }

    @Override
    public BigDecimal getSalesByDateAndProductId(String date, Integer proId) {
        return this.dao.getSalesByDateAndProductId(date, proId);
    }

    @Override
    public List<OrderDetail> getShipmentByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getId, OrderDetail::getProductName, OrderDetail::getProductType, OrderDetail::getImage, OrderDetail::getSku, OrderDetail::getPayNum, OrderDetail::getDeliveryNum, OrderDetail::getRefundNum, OrderDetail::getPrice, OrderDetail::getPayPrice, OrderDetail::getRefundPrice, OrderDetail::getApplyRefundNum});
        lqw.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitReplyCount(Integer userId) {
        return this.dao.getAwaitReplyCount(userId);
    }

    @Override
    public Boolean isPurchased(Integer proId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getId});
        lqw.eq(OrderDetail::getProductId, (Object)proId);
        lqw.eq(OrderDetail::getUid, (Object)userId);
        lqw.gt(OrderDetail::getMerId, (Object)0);
        lqw.eq(OrderDetail::getIsReceipt, (Object)1);
        lqw.last("limit 1");
        OrderDetail orderDetail = (OrderDetail)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)orderDetail) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public PageInfo<OrderDetail> findPurchasedList(Integer userId, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        QueryWrapper query = Wrappers.query();
        query.select(new String[]{"ANY_VALUE(id) as id", "product_id"});
        query.eq((Object)"uid", (Object)userId);
        query.gt((Object)"mer_id", (Object)0);
        query.eq((Object)"is_receipt", (Object)1);
        query.eq((Object)"product_marketing_type", (Object)0);
        query.in((Object)"product_type", new Object[]{0, 2, 5, 6});
        query.groupBy((Object)"product_id");
        query.orderByDesc((Object)"id");
        List detailList = this.dao.selectList((Wrapper)query);
        return CommonPage.copyPageInfo((Page)page, (List)detailList);
    }

    @Override
    public Map<String, List<OrderDetail>> getMapByOrderNoList(List<String> orderNoList) {
        if (CollUtil.isEmpty(orderNoList)) {
            return new HashMap<String, List<OrderDetail>>();
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(OrderDetail::getOrderNo, orderNoList);
        List detailList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)detailList)) {
            return new HashMap<String, List<OrderDetail>>();
        }
        return detailList.stream().collect(Collectors.groupingBy(OrderDetail::getOrderNo));
    }

    @Override
    public Integer getByGroupBuyActivityId(Integer groupBuyActivityId, Integer productId, Integer uid) {
        Integer waitPayNum = 0;
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderDetail::getGroupBuyActivityId, (Object)groupBuyActivityId);
        lqw.eq(OrderDetail::getProductId, (Object)productId);
        lqw.eq(OrderDetail::getUid, (Object)uid);
        List orderDetailList = this.dao.selectList((Wrapper)lqw);
        if (!orderDetailList.isEmpty()) {
            for (OrderDetail orderDetail : orderDetailList) {
                Order o = this.orderService.getByOrderNo(orderDetail.getOrderNo());
                if (!o.getStatus().equals(OrderConstants.ORDER_STATUS_WAIT_PAY)) continue;
                waitPayNum = waitPayNum + orderDetail.getPayNum();
            }
            return waitPayNum;
        }
        return waitPayNum;
    }

    @Override
    public Integer getOrderRefundNum(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getRefundNum});
        lqw.eq(OrderDetail::getOrderNo, (Object)orderNo);
        List orderDetailList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderDetailList)) {
            return 0;
        }
        return orderDetailList.stream().mapToInt(OrderDetail::getRefundNum).sum();
    }

    @Override
    public Integer getSalesNumCountByReservationIngo(Integer attrValueId, String reservationDate, String timeSlot) {
        return this.dao.getSalesNumCountByReservationIngo(attrValueId, reservationDate, timeSlot);
    }
}

