/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.merchant.MerchantType;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.merchant.MerchantTypeRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.service.dao.MerchantTypeDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.MerchantTypeService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantTypeServiceImpl
extends ServiceImpl<MerchantTypeDao, MerchantType>
implements MerchantTypeService {
    @Resource
    private MerchantTypeDao dao;
    @Autowired
    private MerchantService merchantService;

    @Override
    public PageInfo<MerchantType> getAdminPage(PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantType::getIsDel, (Object)false);
        lqw.orderByDesc(MerchantType::getId);
        List categoryList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)categoryList);
    }

    @Override
    public Boolean add(MerchantTypeRequest request) {
        if (this.checkName(request.getName()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        MerchantType merchantType = new MerchantType();
        BeanUtils.copyProperties((Object)request, (Object)merchantType);
        merchantType.setId(null);
        return this.dao.insert(merchantType) > 0;
    }

    @Override
    public Boolean edit(MerchantTypeRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MerchantType merchantType = this.getByIdException(request.getId());
        if (!merchantType.getName().equals(request.getName()) && this.checkName(request.getName()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        merchantType.setName(request.getName());
        merchantType.setInfo(request.getInfo());
        merchantType.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(merchantType) > 0;
    }

    @Override
    public Boolean delete(Integer id) {
        MerchantType merchantType = this.getByIdException(id);
        if (this.merchantService.isExistType(merchantType.getId()).booleanValue()) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_TYPE_USED);
        }
        merchantType.setIsDel(Boolean.valueOf(true));
        merchantType.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(merchantType) > 0;
    }

    @Override
    public List<MerchantType> allList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantType::getId, MerchantType::getName, MerchantType::getInfo});
        lqw.eq(MerchantType::getIsDel, (Object)false);
        lqw.orderByDesc(MerchantType::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    private Boolean checkName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantType::getId});
        lqw.eq(MerchantType::getName, (Object)name);
        lqw.eq(MerchantType::getIsDel, (Object)false);
        lqw.last(" limit 1");
        MerchantType merchantType = (MerchantType)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantType);
    }

    private MerchantType getByIdException(Integer id) {
        MerchantType merchantType = (MerchantType)this.getById(id);
        if (ObjectUtil.isNull((Object)merchantType) || merchantType.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_TYPE_NOT_EXIST);
        }
        return merchantType;
    }
}

