/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantPrint;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.PrintContentVo;
import com.zbkj.service.dao.MerchantPrintDao;
import com.zbkj.service.service.MerchantPrintService;
import com.zbkj.service.util.PrintUtil;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantPrintServiceImpl
extends ServiceImpl<MerchantPrintDao, MerchantPrint>
implements MerchantPrintService {
    private final Logger logger = LoggerFactory.getLogger(MerchantPrintServiceImpl.class);
    @Resource
    private MerchantPrintDao dao;
    @Autowired
    private PrintUtil printUtil;

    @Override
    public List<MerchantPrint> getList(PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MerchantPrint::getMerId, (Object)systemAdmin.getMerId());
        lambdaQueryWrapper.orderByDesc(MerchantPrint::getUpdateTime);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<MerchantPrint> getByMerIdAndStatusOn(Integer merId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MerchantPrint::getMerId, (Object)merId);
        lambdaQueryWrapper.eq(MerchantPrint::getStatus, (Object)1);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean savePrintConfig(MerchantPrint merchantPrint) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        if (this.isExistNameByMerchant(merchantPrint.getPrintName(), currentUser.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, merchantPrint.getPrintName() + "|\u5f53\u524d\u6253\u5370\u673a\u914d\u7f6e\u5df2\u5b58\u5728");
        }
        merchantPrint.setMerId(currentUser.getMerId());
        int insertCount = this.dao.insert(merchantPrint);
        return insertCount > 0;
    }

    @Override
    public Boolean updatePrintConfig(MerchantPrint merchantPrint) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantPrint oldMerchantPrint = (MerchantPrint)this.getById(merchantPrint.getId());
        if (ObjectUtil.isNull((Object)oldMerchantPrint) || !admin.getMerId().equals(oldMerchantPrint.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        merchantPrint.setMerId(admin.getMerId());
        if (this.isExistNameByMerchant(merchantPrint.getPrintName(), admin.getMerId(), merchantPrint.getId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, merchantPrint.getPrintName() + "|\u5f53\u524d\u6253\u5370\u673a\u914d\u7f6e\u5df2\u5b58\u5728");
        }
        merchantPrint.setUpdateTime((Date)DateUtil.date());
        return this.updateById(merchantPrint);
    }

    @Override
    public Boolean updateStatus(Integer id, Integer status) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.set(MerchantPrint::getStatus, (Object)status);
        updateWrapper.eq(MerchantPrint::getId, (Object)id);
        updateWrapper.eq(MerchantPrint::getMerId, (Object)admin.getMerId());
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public void printReceipt(MerchantOrder merchantOrder) {
        this.printUtil.printTicket(merchantOrder);
    }

    @Override
    public void batchPrintTicket(List<MerchantOrder> merchantOrderList) {
        this.printUtil.batchPrintTicket(merchantOrderList);
    }

    @Override
    public Boolean deleteById(Integer id) {
        MerchantPrint merchantPrint = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(merchantPrint.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        return this.removeById(id);
    }

    @Override
    public MerchantPrint getPrintInfo(Integer id) {
        MerchantPrint merchantPrint = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(merchantPrint.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        return merchantPrint;
    }

    @Override
    public PrintContentVo getPrintContentConfig(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantPrint merchantPrint = this.getByIdException(id);
        if (!admin.getMerId().equals(merchantPrint.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        if (StrUtil.isBlank((CharSequence)merchantPrint.getContent())) {
            return null;
        }
        return (PrintContentVo)JSON.parseObject((String)merchantPrint.getContent(), PrintContentVo.class);
    }

    @Override
    public Boolean savePrintContentConfig(Integer id, PrintContentVo voRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantPrint merchantPrint = this.getByIdException(id);
        if (!admin.getMerId().equals(merchantPrint.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        String content = JSONObject.toJSONString((Object)voRequest);
        merchantPrint.setContent(content);
        merchantPrint.setUpdateTime((Date)DateUtil.date());
        return this.updateById(merchantPrint);
    }

    private MerchantPrint getByIdException(Integer id) {
        MerchantPrint merchantPrint = (MerchantPrint)this.getById(id);
        if (ObjectUtil.isNull((Object)merchantPrint)) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_PRINT_NOT_EXIST);
        }
        return merchantPrint;
    }

    private Boolean isExistNameByMerchant(String printName, Integer merId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MerchantPrint::getPrintName, (Object)printName);
        lambdaQueryWrapper.eq(MerchantPrint::getMerId, (Object)merId);
        lambdaQueryWrapper.last("limit 1");
        MerchantPrint merchantPrint = (MerchantPrint)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
        return ObjectUtil.isNotNull((Object)merchantPrint);
    }

    private Boolean isExistNameByMerchant(String printName, Integer merId, Integer printId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MerchantPrint::getPrintName, (Object)printName);
        lambdaQueryWrapper.eq(MerchantPrint::getMerId, (Object)merId);
        lambdaQueryWrapper.ne(MerchantPrint::getId, (Object)printId);
        lambdaQueryWrapper.last("limit 1");
        MerchantPrint merchantPrint = (MerchantPrint)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
        return ObjectUtil.isNotNull((Object)merchantPrint);
    }
}

