/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.vo.LogisticsResultListVo;
import com.zbkj.common.vo.LogisticsResultVo;
import com.zbkj.common.vo.OnePassLogisticsQueryVo;
import com.zbkj.service.service.LogisticService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsServiceImpl
implements LogisticService {
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OnePassService onePassService;

    @Override
    public LogisticsResultVo info(String expressNo, String type, String com, String phone) {
        LogisticsResultVo resultVo = new LogisticsResultVo();
        String redisKey = "logistics_" + expressNo;
        JSONObject result = this.getCache(redisKey);
        if (ObjectUtil.isNotNull((Object)result)) {
            return (LogisticsResultVo)JSONObject.toJavaObject((JSON)result, LogisticsResultVo.class);
        }
        String logisticsType = this.systemConfigService.getValueByKeyException("logistics_type");
        if (logisticsType.equals("1")) {
            OnePassLogisticsQueryVo queryVo = this.onePassService.exprQuery(expressNo, com, phone);
            if (ObjectUtil.isNull((Object)queryVo)) {
                resultVo.setNumber(expressNo);
                resultVo.setExpName(com);
                return resultVo;
            }
            resultVo = this.queryToResultVo(queryVo);
            String jsonString = JSONObject.toJSONString((Object)resultVo);
            this.saveCache(redisKey, JSONObject.parseObject((String)jsonString));
        }
        if (logisticsType.equals("2")) {
            if (StrUtil.isNotBlank((CharSequence)com) && com.equals("shunfeng")) {
                expressNo = expressNo.concat(":").concat(StrUtil.sub((CharSequence)phone, (int)7, (int)-1));
            }
            String appCode = this.systemConfigService.getValueByKey("system_express_app_code");
            String url = StrUtil.format((CharSequence)"https://wuliu.market.alicloudapi.com/kdi?no={}", (Object[])new Object[]{expressNo});
            if (StringUtils.isNotBlank((CharSequence)type)) {
                url = url.concat(StrUtil.format((CharSequence)"&type={}", (Object[])new Object[]{type}));
            }
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", "APPCODE " + appCode);
            JSONObject data = this.restTemplateUtil.getData(url, header);
            this.checkResult(data);
            result = data.getJSONObject("result");
            this.saveCache(redisKey, result);
            resultVo = (LogisticsResultVo)JSONObject.toJavaObject((JSON)result, LogisticsResultVo.class);
        }
        return resultVo;
    }

    private LogisticsResultVo queryToResultVo(OnePassLogisticsQueryVo queryVo) {
        LogisticsResultVo resultVo = new LogisticsResultVo();
        resultVo.setNumber(queryVo.getNum());
        resultVo.setExpName(queryVo.getCom());
        resultVo.setIsSign(queryVo.getIscheck());
        resultVo.setDeliveryStatus(queryVo.getStatus());
        if (CollUtil.isNotEmpty((Collection)queryVo.getContent())) {
            ArrayList list = CollUtil.newArrayList((Object[])new LogisticsResultListVo[0]);
            queryVo.getContent().forEach(i -> {
                LogisticsResultListVo listVo = new LogisticsResultListVo();
                listVo.setTime(i.getTime());
                listVo.setStatus(i.getStatus());
                list.add(listVo);
            });
            resultVo.setList((List)list);
        }
        return resultVo;
    }

    private JSONObject getCache(String redisKey) {
        Object data = this.redisUtil.get(redisKey);
        if (ObjectUtil.isNotNull((Object)data)) {
            return JSONObject.parseObject((String)data.toString());
        }
        return null;
    }

    private void saveCache(String redisKey, JSONObject data) {
        this.redisUtil.set(redisKey, (Object)data.toJSONString(), Long.valueOf(1800L), TimeUnit.SECONDS);
    }

    private void checkResult(JSONObject data) {
        if (!data.getString("status").equals("0")) {
            throw new CrmebException(data.getString("msg"));
        }
    }
}

