/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.model.merchant.MerchantElect;
import com.zbkj.common.request.ExpressSearchRequest;
import com.zbkj.common.request.ExpressUpdateRequest;
import com.zbkj.common.request.ExpressUpdateShowRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.OnePassApplicationInfoVo;
import com.zbkj.service.dao.ExpressDao;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.MerchantElectService;
import com.zbkj.service.service.MerchantExpressService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.util.OnePassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class ExpressServiceImpl
extends ServiceImpl<ExpressDao, Express>
implements ExpressService {
    @Resource
    private ExpressDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private OnePassUtil onePassUtil;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantExpressService merchantExpressService;
    @Autowired
    private MerchantElectService merchantElectService;

    @Override
    public List<Express> getList(ExpressSearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lqw.like(Express::getCode, (Object)keywords)).or()).like(Express::getName, (Object)keywords);
        }
        lqw.orderByDesc(Express::getSort);
        lqw.orderByAsc(Express::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean updateExpress(ExpressUpdateRequest expressRequest) {
        Express temp = (Express)this.getById(expressRequest.getId());
        if (ObjectUtil.isNull((Object)temp)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.EXPRESS_NOT_EXIST);
        }
        if (StrUtil.isBlank((CharSequence)expressRequest.getAccount()) && temp.getPartnerId().equals(true)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6708\u7ed3\u8d26\u53f7");
        }
        if (StrUtil.isBlank((CharSequence)expressRequest.getPassword()) && temp.getPartnerKey().equals(true)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u6708\u7ed3\u5bc6\u7801");
        }
        if (StrUtil.isBlank((CharSequence)expressRequest.getNetName()) && temp.getNet().equals(true)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u8f93\u5165\u53d6\u4ef6\u7f51\u70b9");
        }
        boolean status = true;
        if (!expressRequest.getStatus().booleanValue() && temp.getStatus().booleanValue()) {
            status = false;
        }
        Express express = new Express();
        BeanUtils.copyProperties((Object)expressRequest, (Object)express);
        if (status) {
            return this.updateById(express);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(express);
            if (!express.getStatus().booleanValue()) {
                this.merchantExpressService.deleteByExpressId(express.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateExpressShow(ExpressUpdateShowRequest expressRequest) {
        Express temp = (Express)this.getById(expressRequest.getId());
        if (ObjectUtil.isNull((Object)temp)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.EXPRESS_NOT_EXIST);
        }
        if (temp.getIsShow().equals(expressRequest.getIsShow())) {
            return Boolean.TRUE;
        }
        Express express = new Express();
        BeanUtils.copyProperties((Object)expressRequest, (Object)express);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(express);
            if (!express.getIsShow().booleanValue()) {
                this.merchantExpressService.deleteByExpressId(express.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean syncExpress() {
        if (this.redisUtil.exists("sync_express").booleanValue()) {
            return Boolean.TRUE;
        }
        this.getExpressList();
        this.redisUtil.set("sync_express", (Object)1, Long.valueOf(3600L), TimeUnit.SECONDS);
        return Boolean.TRUE;
    }

    @Override
    public List<Express> findAll(String type) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Express::getIsShow, (Object)true);
        if (type.equals("elec")) {
            lqw.eq(Express::getStatus, (Object)true);
        }
        lqw.orderByDesc(Express::getSort);
        lqw.orderByAsc(Express::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public JSONObject template(String com) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantElect merchantElect = this.merchantElectService.getMerchantElect(admin);
        if (ObjectUtil.isNull((Object)merchantElect) || merchantElect.getId() <= 0) {
            throw new CrmebException("\u8bf7\u5148\u914d\u7f6e\u7535\u5b50\u9762\u5355\u6253\u5370\u914d\u7f6e");
        }
        if (merchantElect.getOp().equals(1) && ObjectUtil.isNull((Object)merchantElect.getCloudPrintNo())) {
            throw new CrmebException("\u4e91\u6253\u5370\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer isShipment = merchantElect.getCloudPrintNo().isEmpty() ? 1 : 0;
        OnePassApplicationInfoVo infoVo = this.onePassService.getApplicationInfoException();
        String token = this.onePassUtil.getToken(infoVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"com", (Object)com);
        param.add((Object)"is_shipment", (Object)isShipment);
        return this.onePassUtil.getFrom("https://sms.crmeb.net/api/v2/expr_dump/temp", (MultiValueMap<String, Object>)param, header);
    }

    @Override
    public Express getByCode(String code) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Express::getCode, (Object)code);
        return (Express)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Express getInfo(Integer id) {
        Express express = (Express)this.getById(id);
        if (ObjectUtil.isNull((Object)express)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.EXPRESS_NOT_EXIST);
        }
        return express;
    }

    private void getExpressList() {
        boolean saveBatch;
        OnePassApplicationInfoVo infoVo = this.onePassService.getApplicationInfoException();
        String token = this.onePassUtil.getToken(infoVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"page", (Object)0);
        param.add((Object)"limit", (Object)9999);
        JSONObject post = this.onePassUtil.getFrom("https://sms.crmeb.net/api/v2/expr/express", (MultiValueMap<String, Object>)param, header);
        System.out.println("OnePass Express ALL post = " + post);
        JSONObject jsonObject = post.getJSONObject("data");
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        if (CollUtil.isEmpty((Collection)jsonArray)) {
            return;
        }
        ArrayList expressList = CollUtil.newArrayList((Object[])new Express[0]);
        List<String> codeList = this.getAllCode();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            if (!StrUtil.isNotBlank((CharSequence)object.getString("code")) || codeList.contains(object.getString("code"))) continue;
            Express express = new Express();
            express.setName(Optional.ofNullable(object.getString("name")).orElse(""));
            express.setCode(Optional.ofNullable(object.getString("code")).orElse(""));
            express.setPartnerId(Boolean.valueOf(false));
            express.setPartnerKey(Boolean.valueOf(false));
            express.setNet(Boolean.valueOf(false));
            if (ObjectUtil.isNotNull((Object)object.getInteger("partner_id"))) {
                express.setPartnerId(Boolean.valueOf(object.getInteger("partner_id") == 1));
            }
            if (ObjectUtil.isNotNull((Object)object.getInteger("partner_key"))) {
                express.setPartnerKey(Boolean.valueOf(object.getInteger("partner_key") == 1));
            }
            if (ObjectUtil.isNotNull((Object)object.getInteger("net"))) {
                express.setNet(Boolean.valueOf(object.getInteger("net") == 1));
            }
            express.setIsShow(Boolean.valueOf(true));
            express.setStatus(Boolean.valueOf(false));
            if (!(express.getPartnerId().booleanValue() || express.getPartnerKey().booleanValue() || express.getNet().booleanValue())) {
                express.setStatus(Boolean.valueOf(true));
            }
            expressList.add(express);
        }
        if (CollUtil.isNotEmpty((Collection)expressList) && !(saveBatch = this.saveBatch(expressList))) {
            throw new CrmebException("\u540c\u6b65\u7269\u6d41\u516c\u53f8\u5931\u8d25");
        }
    }

    private List<String> getAllCode() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Express::getCode});
        List expressList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)expressList)) {
            return CollUtil.newArrayList((Object[])new String[0]);
        }
        return expressList.stream().map(Express::getCode).collect(Collectors.toList());
    }
}

