/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.CommunityConstants;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.community.CommunityReply;
import com.zbkj.common.model.community.CommunityReplyLike;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonAuditRequest;
import com.zbkj.common.request.CommunityReplyAddRequest;
import com.zbkj.common.request.CommunityReplySearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.response.CommunityCommentReplyResponse;
import com.zbkj.common.response.CommunityReplyPageDateResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.CommunityResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.community.CommunityReplyDao;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.CommunityReplyLikeService;
import com.zbkj.service.service.CommunityReplyService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CommunityReplyServiceImpl
extends ServiceImpl<CommunityReplyDao, CommunityReply>
implements CommunityReplyService {
    @Resource
    private CommunityReplyDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserService userService;
    @Autowired
    private CommunityReplyLikeService communityReplyLikeService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AsyncService asyncService;

    @Override
    public Integer getCountByNid(Integer nid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.eq(CommunityReply::getAuditStatus, (Object)CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS);
        lqw.eq(CommunityReply::getNoteId, (Object)nid);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<CommunityReplyPageDateResponse> findPageList(CommunityReplySearchRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getTitle())) {
            map.put("title", URLUtil.decode((String)request.getTitle()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            map.put("keywordsContent", URLUtil.decode((String)request.getKeywords()));
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            map.put("auditStatus", request.getAuditStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            map.put("startTime", dateLimitVo.getStartTime());
            map.put("endTime", dateLimitVo.getEndTime());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<CommunityReplyPageDateResponse> list = this.dao.findPageList(map);
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public void audit(CommonAuditRequest request) {
        if (request.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_ERROR) && StrUtil.isBlank((CharSequence)request.getRefusalReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u8bf7\u586b\u5199\u5ba1\u6838\u62d2\u7edd\u539f\u56e0"));
        }
        CommunityReply reply = this.getByIdException(request.getId());
        if (!reply.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_AWAIT)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_REPLY_AUDIT_STATUS_EXCEPTION);
        }
        reply.setAuditStatus(request.getAuditStatus());
        if (request.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_ERROR) && StrUtil.isNotBlank((CharSequence)request.getRefusalReason())) {
            reply.setRefusal(request.getRefusalReason());
        }
        reply.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(reply);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u793e\u533a\u8bc4\u8bba\u5ba1\u6838\u5931\u8d25"));
        }
        if (reply.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS)) {
            this.asyncService.noteAddReplyAfter(reply.getNoteId(), reply.getParentId(), reply.getId());
        }
    }

    @Override
    public void delete(Integer id) {
        CommunityReply reply = this.getByIdException(id);
        reply.setIsDel(Constants.COMMON_IS_FILED_ONE);
        reply.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(reply);
            if (reply.getType().equals(CommunityConstants.COMMUNITY_REPLY_TYPE_COMMENT)) {
                this.deleteReplyByParentId(reply.getId());
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u793e\u533a\u8bc4\u8bba\u5220\u9664\u5931\u8d25"));
        }
        this.asyncService.communityReplyDeleteAfter(reply.getNoteId(), reply.getParentId(), reply.getId(), reply.getCountReply());
    }

    @Override
    public PageInfo<CommunityCommentReplyResponse> findNotePageList(Integer noteId, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityReply::getNoteId, (Object)noteId);
        lqw.eq(CommunityReply::getType, (Object)CommunityConstants.COMMUNITY_REPLY_TYPE_COMMENT);
        lqw.eq(CommunityReply::getAuditStatus, (Object)CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS);
        lqw.eq(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc(CommunityReply::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List<CommunityCommentReplyResponse> responseList = list.stream().map(r -> {
            CommunityCommentReplyResponse replyResponse = new CommunityCommentReplyResponse();
            BeanUtils.copyProperties((Object)r, (Object)replyResponse);
            replyResponse.setAuditStatus(null);
            List<CommunityReply> replyList = this.findReplyByParentId(r.getId());
            if (CollUtil.isNotEmpty(replyList)) {
                List childReplyList = replyList.stream().map(reply -> {
                    CommunityCommentReplyResponse childReply = new CommunityCommentReplyResponse();
                    BeanUtils.copyProperties((Object)reply, (Object)childReply);
                    return childReply;
                }).collect(Collectors.toList());
                replyResponse.setReplyList(childReplyList);
            }
            return replyResponse;
        }).collect(Collectors.toList());
        this.responseSetUserName(responseList);
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public void likeReply(Integer replyId, Integer userId) {
        CommunityReply reply = this.getByIdException(replyId);
        if (!reply.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_REPLY_AUDIT_STATUS_EXCEPTION);
        }
        CommunityReplyLike replyLike = this.communityReplyLikeService.getDetail(replyId, userId);
        if (ObjectUtil.isNotNull((Object)replyLike)) {
            boolean remove = this.communityReplyLikeService.removeById((Serializable)replyLike);
            if (!remove) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8bc4\u8bba\u53d6\u6d88\u70b9\u8d5e\u5931\u8d25"));
            }
            this.asyncService.communityReplyLikeOrClean(replyId, "sub");
            return;
        }
        replyLike = new CommunityReplyLike();
        replyLike.setNoteId(reply.getNoteId());
        replyLike.setReplyId(reply.getId());
        replyLike.setUid(userId);
        boolean save = this.communityReplyLikeService.save(replyLike);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8bc4\u8bba\u70b9\u8d5e\u5931\u8d25"));
        }
        this.asyncService.communityReplyLikeOrClean(replyId, "add");
    }

    @Override
    public CommunityCommentReplyResponse create(CommunityReplyAddRequest request) {
        boolean save;
        String replyAuditSwitch;
        CommunityReply reply = new CommunityReply();
        reply.setType(CommunityConstants.COMMUNITY_REPLY_TYPE_COMMENT);
        reply.setUid(request.getUserId());
        reply.setContent(request.getContent());
        reply.setAuditStatus(CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS);
        reply.setParentId(Integer.valueOf(0));
        reply.setNoteId(request.getNoteId());
        if (request.getReplyId() > 0) {
            reply.setType(CommunityConstants.COMMUNITY_REPLY_TYPE_REPLY);
            CommunityReply tempReply = this.getByIdException(request.getReplyId());
            if (tempReply.getType().equals(CommunityConstants.COMMUNITY_REPLY_TYPE_COMMENT)) {
                reply.setParentId(tempReply.getId());
                reply.setParentUid(tempReply.getUid());
            } else {
                reply.setParentId(tempReply.getParentId());
                reply.setParentUid(tempReply.getParentUid());
                reply.setReviewId(tempReply.getId());
                reply.setReviewUid(tempReply.getUid());
            }
        }
        if ((replyAuditSwitch = this.systemConfigService.getValueByKeyException("communityReplyAuditSwitch")).equals("1")) {
            reply.setAuditStatus(CommunityConstants.COMMUNITY_REPLY_AUDIT_AWAIT);
        }
        if (!(save = this.save(reply))) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7b14\u8bb0\u8bc4\u8bba\u5931\u8d25"));
        }
        if (reply.getAuditStatus().equals(CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS)) {
            this.asyncService.noteAddReplyAfter(reply.getNoteId(), reply.getParentId(), reply.getId());
        }
        CommunityCommentReplyResponse response = new CommunityCommentReplyResponse();
        BeanUtils.copyProperties((Object)reply, (Object)response);
        User user = this.userService.getInfo();
        response.setNickname(user.getNickname());
        response.setAvatar(user.getAvatar());
        response.setCreateTime((Date)DateUtil.date());
        if (ObjectUtil.isNotNull((Object)reply.getReviewUid()) && reply.getReviewUid() > 0) {
            User reviewUser = (User)this.userService.getById(reply.getReviewUid());
            response.setReviewUserNickname(reviewUser.getNickname());
            response.setCountStart(Integer.valueOf(0));
            response.setCreateTime((Date)DateUtil.date());
        }
        return response;
    }

    @Override
    public void deleteByNoteId(Integer noteId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ONE);
        wrapper.eq(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        wrapper.eq(CommunityReply::getNoteId, (Object)noteId);
        this.update((Wrapper)wrapper);
    }

    @Override
    public void operationLike(Integer replyId, String operationType) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (operationType.equals("add")) {
            wrapper.setSql("count_start = count_start + 1");
        } else {
            wrapper.setSql("count_start = count_start - 1");
        }
        wrapper.eq(CommunityReply::getId, (Object)replyId);
        this.update((Wrapper)wrapper);
    }

    @Override
    public void operationReplyNum(Integer replyId, Integer num, String operationType) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (operationType.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"count_reply = count_reply + {}", (Object[])new Object[]{num}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"count_reply = count_reply - {}", (Object[])new Object[]{num}));
        }
        wrapper.eq(CommunityReply::getId, (Object)replyId);
        this.update((Wrapper)wrapper);
    }

    private void responseSetUserName(List<CommunityCommentReplyResponse> responseList) {
        ArrayList<Integer> uidList = new ArrayList<Integer>();
        responseList.forEach(r -> {
            if (!uidList.contains(r.getUid())) {
                uidList.add(r.getUid());
            }
            if (CollUtil.isNotEmpty((Collection)r.getReplyList())) {
                r.getReplyList().forEach(rc -> {
                    if (!uidList.contains(rc.getUid())) {
                        uidList.add(rc.getUid());
                    }
                    if (rc.getReviewUid() > 0 && !uidList.contains(rc.getReviewUid())) {
                        uidList.add(rc.getReviewUid());
                    }
                });
            }
        });
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        responseList.forEach(r -> {
            r.setNickname(((User)userMap.get(r.getUid())).getNickname());
            r.setAvatar(((User)userMap.get(r.getUid())).getAvatar());
            if (CollUtil.isNotEmpty((Collection)r.getReplyList())) {
                r.getReplyList().forEach(rc -> {
                    rc.setNickname(((User)userMap.get(rc.getUid())).getNickname());
                    rc.setAvatar(((User)userMap.get(rc.getUid())).getAvatar());
                    if (rc.getReviewUid() > 0) {
                        rc.setReviewUserNickname(((User)userMap.get(rc.getReviewUid())).getNickname());
                    }
                });
            }
        });
    }

    private List<CommunityReply> findReplyByParentId(Integer replyId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityReply::getParentId, (Object)replyId);
        lqw.eq(CommunityReply::getType, (Object)CommunityConstants.COMMUNITY_REPLY_TYPE_REPLY);
        lqw.eq(CommunityReply::getAuditStatus, (Object)CommunityConstants.COMMUNITY_REPLY_AUDIT_SUCCESS);
        lqw.eq(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc(CommunityReply::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    private void deleteReplyByParentId(Integer replyId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ONE);
        wrapper.eq(CommunityReply::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        wrapper.eq(CommunityReply::getParentId, (Object)replyId);
        this.update((Wrapper)wrapper);
    }

    private CommunityReply getByIdException(Integer id) {
        CommunityReply reply = (CommunityReply)this.getById(id);
        if (ObjectUtil.isNull((Object)reply) && reply.getIsDel().equals(Constants.COMMON_IS_FILED_ONE)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_REPLY_NOT_EXIST);
        }
        return reply;
    }
}

