/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.CommunityConstants;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.CommunityNotePageDateDto;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.community.CommunityNotes;
import com.zbkj.common.model.community.CommunityNotesProduct;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonAuditRequest;
import com.zbkj.common.request.CommonForcedDownRequest;
import com.zbkj.common.request.CommonStarUpdateRequest;
import com.zbkj.common.request.CommunityNoteCategoryBatchUpdateRequest;
import com.zbkj.common.request.CommunityNoteFrontDiscoverRequest;
import com.zbkj.common.request.CommunityNoteFrontSearchRequest;
import com.zbkj.common.request.CommunityNoteSaveRequest;
import com.zbkj.common.request.CommunityNoteSearchRequest;
import com.zbkj.common.request.CommunityNoteTopicSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.response.CommunityNoteDetailResponse;
import com.zbkj.common.response.CommunityNotePageDateResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.CommunityResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.service.dao.community.CommunityNotesDao;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.CommunityAuthorConcernedService;
import com.zbkj.service.service.CommunityCategoryService;
import com.zbkj.service.service.CommunityNotesProductService;
import com.zbkj.service.service.CommunityNotesRelationService;
import com.zbkj.service.service.CommunityNotesService;
import com.zbkj.service.service.CommunityReplyService;
import com.zbkj.service.service.CommunityTopicService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CommunityNotesServiceImpl
extends ServiceImpl<CommunityNotesDao, CommunityNotes>
implements CommunityNotesService {
    private static final Logger log = LoggerFactory.getLogger(CommunityNotesServiceImpl.class);
    @Resource
    private CommunityNotesDao dao;
    @Autowired
    private CommunityCategoryService categoryService;
    @Autowired
    private CommunityTopicService topicService;
    @Autowired
    private CommunityReplyService replyService;
    @Autowired
    private UserService userService;
    @Autowired
    private CommunityNotesProductService notesProductService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CommunityAuthorConcernedService communityAuthorConcernedService;
    @Autowired
    private CommunityNotesProductService communityNotesProductService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private CommunityNotesRelationService communityNotesRelationService;

    @Override
    public Boolean isUseCategory(Integer cateId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotes::getId});
        lqw.eq(CommunityNotes::getCategoryId, (Object)cateId);
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.last("limit 1");
        CommunityNotes communityNotes = (CommunityNotes)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)communityNotes);
    }

    @Override
    public List<CommunityNotes> findAllByTopic(Integer topicId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.apply("FIND_IN_SET({0}, topic_ids)", new Object[]{topicId});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public void updateTopicIds(Integer id, String topicIds) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CommunityNotes::getTopicIds, (Object)topicIds);
        wrapper.eq(CommunityNotes::getId, (Object)id);
        boolean update = this.update((Wrapper)wrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u7b14\u8bb0\u5173\u8054\u8bdd\u9898\u5931\u8d25");
        }
    }

    @Override
    public PageInfo<CommunityNotePageDateResponse> findPageList(CommunityNoteSearchRequest request) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getTitle())) {
            map.put("title", URLUtil.decode((String)request.getTitle()));
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            map.put("type", request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getTopicId())) {
            map.put("topicId", request.getTopicId());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            map.put("auditStatus", request.getAuditStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<CommunityNotePageDateDto> dtoList = this.dao.findPageList(map);
        if (CollUtil.isEmpty(dtoList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        ArrayList cateIdList = CollUtil.newArrayList((Object[])new Integer[0]);
        ArrayList topicIdList = CollUtil.newArrayList((Object[])new Integer[0]);
        dtoList.forEach(e -> {
            cateIdList.add(e.getCategoryId());
            if (StrUtil.isNotBlank((CharSequence)e.getTopicIds())) {
                topicIdList.addAll(CrmebUtil.stringToArray((String)e.getTopicIds()));
            }
        });
        Map<Integer, String> categoryMap = this.categoryService.getMapInIdList(cateIdList);
        Map<Integer, String> topicMap = this.topicService.getNameMapInIdList(topicIdList);
        List responseList = dtoList.stream().map(dto -> {
            CommunityNotePageDateResponse response = new CommunityNotePageDateResponse();
            BeanUtils.copyProperties((Object)dto, (Object)response);
            response.setCategoryName((String)categoryMap.get(dto.getCategoryId()));
            if (StrUtil.isNotBlank((CharSequence)dto.getTopicIds())) {
                List topicList = Arrays.stream(dto.getTopicIds().split(",")).map(e -> (String)topicMap.get(Integer.valueOf(e))).collect(Collectors.toList());
                response.setTopicList(topicList);
            }
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public CommunityNoteDetailResponse detail(Integer id) {
        CommunityNotes note = this.getByIdException(id);
        CommunityNoteDetailResponse response = new CommunityNoteDetailResponse();
        BeanUtils.copyProperties((Object)note, (Object)response);
        User user = (User)this.userService.getById(note.getUid());
        response.setAuthorId(note.getUid());
        response.setAuthorName(user.getNickname());
        response.setProductList(this.notesProductService.findListByNoteId(id));
        return response;
    }

    @Override
    public void audit(CommonAuditRequest request) {
        if (request.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_ERROR) && StrUtil.isBlank((CharSequence)request.getRefusalReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u8bf7\u586b\u5199\u5ba1\u6838\u62d2\u7edd\u539f\u56e0"));
        }
        CommunityNotes notes = this.getByIdException(request.getId());
        if (!notes.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_NOTE_AUDIT_STATUS_EXCEPTION);
        }
        notes.setAuditStatus(request.getAuditStatus());
        if (request.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_ERROR) && StrUtil.isNotBlank((CharSequence)request.getRefusalReason())) {
            notes.setRefusal(request.getRefusalReason());
        }
        notes.setOperateTime((Date)DateUtil.date());
        notes.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(notes);
        if (!update) {
            throw new CrmebException("\u793e\u533a\u7b14\u8bb0\u5ba1\u6838\u5931\u8d25");
        }
        if (notes.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS)) {
            this.asyncService.noteUpExp(notes.getUid(), notes.getId());
        }
    }

    @Override
    public void forcedDown(CommonForcedDownRequest request) {
        CommunityNotes notes = this.getByIdException(request.getId());
        if (!notes.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_NOTE_AUDIT_STATUS_EXCEPTION);
        }
        notes.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_CLOSE);
        notes.setOperateTime((Date)DateUtil.date());
        notes.setRefusal(request.getReason());
        notes.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(notes);
        if (!update) {
            throw new CrmebException("\u793e\u533a\u7b14\u8bb0\u5f3a\u5236\u4e0b\u67b6\u5931\u8d25");
        }
    }

    @Override
    public void delete(Integer id) {
        CommunityNotes notes = this.getByIdException(id);
        notes.setIsDel(Constants.COMMON_IS_FILED_ONE);
        notes.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(notes);
            this.notesProductService.deleteByNoteId(id);
            this.replyService.deleteByNoteId(id);
            this.communityNotesRelationService.deleteByNoteId(id);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u793e\u533a\u7b14\u8bb0\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void categoryBatchUpdate(CommunityNoteCategoryBatchUpdateRequest request) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CommunityNotes::getCategoryId, (Object)request.getCategoryId());
        wrapper.in(CommunityNotes::getId, (Collection)request.getNoteIdList());
        this.update((Wrapper)wrapper);
    }

    @Override
    public void updateStar(CommonStarUpdateRequest request) {
        CommunityNotes notes = this.getByIdException(request.getId());
        if (!notes.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_NOTE_AUDIT_STATUS_EXCEPTION);
        }
        if (notes.getStar().equals(request.getStar())) {
            return;
        }
        notes.setStar(request.getStar());
        notes.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(notes);
        if (!update) {
            throw new CrmebException("\u793e\u533a\u7b14\u8bb0\u63a8\u8350\u661f\u7ea7\u7f16\u8f91\u5931\u8d25");
        }
    }

    @Override
    public void replyForceOffSwitch(Integer id) {
        CommunityNotes notes;
        notes.setReplyStatus((notes = this.getByIdException(id)).getReplyStatus().equals(CommunityConstants.COMMUNITY_NOTE_IS_REPLY_FORCE_OFF) ? CommunityConstants.COMMUNITY_NOTE_IS_REPLY_CLOSE : CommunityConstants.COMMUNITY_NOTE_IS_REPLY_FORCE_OFF);
        notes.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(notes);
        if (!update) {
            throw new CrmebException("\u4fee\u6539\u793e\u533a\u7b14\u8bb0\u8bc4\u8bba\u5f00\u5173\u72b6\u6001\u5931\u8d25");
        }
    }

    private PageInfo<CommunityNotes> findFrontSearchList(CommunityNoteFrontSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotes::getId, CommunityNotes::getTitle, CommunityNotes::getCover, CommunityNotes::getUid, CommunityNotes::getType, CommunityNotes::getLikeNum, CommunityNotes::getAuditStatus});
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            lqw.eq(CommunityNotes::getCategoryId, (Object)request.getCategoryId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTitle())) {
            lqw.like(CommunityNotes::getTitle, (Object)request.getTitle());
        }
        if (ObjectUtil.isNotNull((Object)request.getUid())) {
            lqw.eq(CommunityNotes::getUid, (Object)request.getUid());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            lqw.eq(CommunityNotes::getAuditStatus, (Object)request.getAuditStatus());
        }
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        if (ObjectUtil.isNotNull((Object)request.getTopicId())) {
            lqw.apply("FIND_IN_SET({0}, topic_ids)", new Object[]{request.getTopicId()});
        }
        switch (request.getCollation()) {
            case "star": {
                lqw.orderByDesc((Object[])new SFunction[]{CommunityNotes::getStar, CommunityNotes::getId});
                break;
            }
            case "hot": {
                lqw.orderByDesc((Object[])new SFunction[]{CommunityNotes::getLikeNum, CommunityNotes::getId});
                break;
            }
            default: {
                lqw.orderByDesc(CommunityNotes::getId);
            }
        }
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public PageInfo<CommunityNotes> findDiscoverNoteList(CommunityNoteFrontDiscoverRequest request) {
        CommunityNoteFrontSearchRequest searchRequest = new CommunityNoteFrontSearchRequest();
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            searchRequest.setCategoryId(request.getCategoryId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTitle())) {
            searchRequest.setTitle(URLUtil.decode((String)request.getTitle()));
        }
        searchRequest.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        searchRequest.setCollation("star");
        searchRequest.setPage(request.getPage());
        searchRequest.setLimit(request.getLimit());
        return this.findFrontSearchList(searchRequest);
    }

    @Override
    public PageInfo<CommunityNotes> findFollowNoteList(PageParamRequest request, Integer userId) {
        List<Integer> authorIdList = this.communityAuthorConcernedService.findAuthorIdList(userId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        if (CollUtil.isEmpty(authorIdList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotes::getId, CommunityNotes::getTitle, CommunityNotes::getCover, CommunityNotes::getContent, CommunityNotes::getVideo, CommunityNotes::getTopicIds, CommunityNotes::getUid, CommunityNotes::getType, CommunityNotes::getCreateTime, CommunityNotes::getLikeNum, CommunityNotes::getImage, CommunityNotes::getReplyNum});
        lqw.in(CommunityNotes::getUid, authorIdList);
        lqw.eq(CommunityNotes::getAuditStatus, (Object)CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc(CommunityNotes::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Integer getCountByTopic(Integer topicId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.apply("FIND_IN_SET({0}, topic_ids)", new Object[]{topicId});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getFrontCountByTopic(Integer topicId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.eq(CommunityNotes::getAuditStatus, (Object)CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        lqw.apply("FIND_IN_SET({0}, topic_ids)", new Object[]{topicId});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<CommunityNotes> findAuthorNoteList(Integer authorId, PageParamRequest request) {
        CommunityNoteFrontSearchRequest searchRequest = new CommunityNoteFrontSearchRequest();
        searchRequest.setUid(authorId);
        searchRequest.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        searchRequest.setPage(request.getPage());
        searchRequest.setLimit(request.getLimit());
        return this.findFrontSearchList(searchRequest);
    }

    @Override
    public CommunityNotes getByIdException(Integer id) {
        CommunityNotes notes = (CommunityNotes)this.getById(id);
        if (ObjectUtil.isNull((Object)notes) || notes.getIsDel().equals(Constants.COMMON_IS_FILED_ONE)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_NOTE_NOT_EXIST);
        }
        return notes;
    }

    @Override
    public PageInfo<CommunityNotes> findTopicNoteList(CommunityNoteTopicSearchRequest request) {
        CommunityNoteFrontSearchRequest searchRequest = new CommunityNoteFrontSearchRequest();
        searchRequest.setTopicId(request.getTopicId());
        searchRequest.setCollation(request.getType());
        searchRequest.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        searchRequest.setPage(request.getPage());
        searchRequest.setLimit(request.getLimit());
        return this.findFrontSearchList(searchRequest);
    }

    @Override
    public void create(CommunityNoteSaveRequest request) {
        Boolean execute;
        String videoAuditSwitch;
        String textAuditSwitch;
        this.validatorNoteParam(request);
        Integer userId = this.userService.getUserIdException();
        CommunityNotes note = new CommunityNotes();
        BeanUtils.copyProperties((Object)request, (Object)note, (String[])new String[]{"id"});
        note.setUid(userId);
        note.setCover(this.systemAttachmentService.clearPrefix(request.getCover()));
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_IMAGE_CONTENT.equals(request.getType())) {
            note.setImage(this.systemAttachmentService.clearPrefix(request.getImage()));
        }
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_SHORT_VIDEO.equals(request.getType())) {
            note.setVideo(this.systemAttachmentService.clearPrefix(request.getVideo()));
        }
        ArrayList notesProductList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)request.getProIds())) {
            List proIdList = CrmebUtil.stringToArray((String)request.getProIds());
            proIdList.forEach(pid -> {
                CommunityNotesProduct notesProduct = new CommunityNotesProduct();
                notesProduct.setProductId(pid);
                notesProduct.setIsPay(Integer.valueOf(this.orderDetailService.isPurchased((Integer)pid, userId) != false ? 1 : 0));
                notesProductList.add(notesProduct);
            });
        }
        note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_IMAGE_CONTENT.equals(request.getType()) && "1".equals(textAuditSwitch = this.systemConfigService.getValueByKeyException("communityImageTextAuditSwitch"))) {
            note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT);
        }
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_SHORT_VIDEO.equals(request.getType()) && "1".equals(videoAuditSwitch = this.systemConfigService.getValueByKeyException("communityShortVideoAuditSwitch"))) {
            note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT);
        }
        if (!(execute = (Boolean)this.transactionTemplate.execute(e -> {
            int insert = this.dao.insert(note);
            if (insert < 1) {
                e.setRollbackOnly();
                log.error("\u6dfb\u52a0\u793e\u533a\u7b14\u8bb0\u5931\u8d25\uff0crequest = {}", (Object)request);
                return Boolean.FALSE;
            }
            if (CollUtil.isNotEmpty((Collection)notesProductList)) {
                notesProductList.forEach(p -> p.setNoteId(note.getId()));
                this.communityNotesProductService.saveBatch(notesProductList);
            }
            return Boolean.TRUE;
        })).booleanValue()) {
            throw new CrmebException("\u521b\u5efa\u793e\u533a\u7b14\u8bb0\u5931\u8d25");
        }
        if (note.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS)) {
            this.asyncService.noteUpExp(userId, note.getId());
        }
    }

    @Override
    public void updateNote(CommunityNoteSaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u8bf7\u5148\u62e9\u7b14\u8bb0"));
        }
        this.validatorNoteParam(request);
        Integer userId = this.userService.getUserIdException();
        CommunityNotes note = this.getByIdException(request.getId());
        if (!note.getUid().equals(userId)) {
            throw new CrmebException("\u4e0d\u80fd\u64cd\u4f5c\u522b\u4eba\u7684\u6570\u636e");
        }
        note.setTitle(StrUtil.isNotBlank((CharSequence)request.getTitle()) ? request.getTitle() : "");
        note.setCover(this.systemAttachmentService.clearPrefix(request.getCover()));
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_IMAGE_CONTENT.equals(request.getType())) {
            note.setImage(this.systemAttachmentService.clearPrefix(request.getImage()));
        }
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_SHORT_VIDEO.equals(request.getType())) {
            note.setVideo(this.systemAttachmentService.clearPrefix(request.getVideo()));
        }
        note.setContent(StrUtil.isNotBlank((CharSequence)request.getContent()) ? request.getContent() : "");
        note.setCategoryId(request.getCategoryId());
        note.setType(request.getType());
        note.setTopicIds(StrUtil.isNotBlank((CharSequence)request.getTopicIds()) ? request.getTopicIds() : "");
        if (!note.getReplyStatus().equals(CommunityConstants.COMMUNITY_NOTE_IS_REPLY_FORCE_OFF)) {
            note.setReplyStatus(request.getReplyStatus());
        }
        if (note.getAuditStatus().equals(CommunityConstants.COMMUNITY_NOTE_AUDIT_CLOSE)) {
            note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT);
        } else if (CommunityConstants.COMMUNITY_NOTE_TYPE_IMAGE_CONTENT.equals(request.getType())) {
            String textAuditSwitch = this.systemConfigService.getValueByKeyException("communityImageTextAuditSwitch");
            if ("1".equals(textAuditSwitch)) {
                note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT);
            }
        } else if (CommunityConstants.COMMUNITY_NOTE_TYPE_SHORT_VIDEO.equals(request.getType())) {
            String videoAuditSwitch = this.systemConfigService.getValueByKeyException("communityShortVideoAuditSwitch");
            if ("1".equals(videoAuditSwitch)) {
                note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_AWAIT);
            }
        } else {
            note.setAuditStatus(CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        }
        ArrayList notesProductList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)request.getProIds())) {
            List proIdList = CrmebUtil.stringToArray((String)request.getProIds());
            proIdList.forEach(pid -> {
                CommunityNotesProduct notesProduct = new CommunityNotesProduct();
                notesProduct.setProductId(pid);
                notesProduct.setNoteId(note.getId());
                notesProduct.setIsPay(Integer.valueOf(this.orderDetailService.isPurchased((Integer)pid, userId) != false ? 1 : 0));
                notesProductList.add(notesProduct);
            });
        }
        note.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateById(note);
            if (!update) {
                e.setRollbackOnly();
                log.error("\u7f16\u8f91\u793e\u533a\u7b14\u8bb0\u5931\u8d25\uff0crequest = {}", (Object)request);
                return Boolean.FALSE;
            }
            this.communityNotesProductService.deleteByNoteId(note.getId());
            if (CollUtil.isNotEmpty((Collection)notesProductList)) {
                notesProductList.forEach(p -> p.setNoteId(note.getId()));
                this.communityNotesProductService.saveBatch(notesProductList);
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u7f16\u8f91\u793e\u533a\u7b14\u8bb0\u5931\u8d25");
        }
    }

    @Override
    public PageInfo<CommunityNotes> findMyNoteList(Integer userId, PageParamRequest request) {
        CommunityNoteFrontSearchRequest searchRequest = new CommunityNoteFrontSearchRequest();
        searchRequest.setUid(userId);
        searchRequest.setPage(request.getPage());
        searchRequest.setLimit(request.getLimit());
        return this.findFrontSearchList(searchRequest);
    }

    @Override
    public PageInfo<Integer> findAuthorPageTimeDesc(Integer userId, PageParamRequest request) {
        List<Integer> authorConcernedList = this.communityAuthorConcernedService.findAuthorIdList(userId);
        authorConcernedList.add(userId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        QueryWrapper query = Wrappers.query();
        query.select(new String[]{"uid", "MAX(create_time) as create_time"});
        query.notIn((Object)"uid", authorConcernedList);
        query.eq((Object)"audit_status", (Object)CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        query.eq((Object)"is_del", (Object)Constants.COMMON_IS_FILED_ZERO);
        query.groupBy((Object)"uid");
        query.orderByDesc((Object)"create_time");
        List list = this.dao.selectList((Wrapper)query);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List authorIdList = list.stream().map(CommunityNotes::getUid).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, authorIdList);
    }

    @Override
    public List<CommunityNotes> findNewNoteByAuthorId(Integer authorId, Integer num) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotes::getId, CommunityNotes::getCover, CommunityNotes::getType});
        lqw.eq(CommunityNotes::getUid, (Object)authorId);
        lqw.eq(CommunityNotes::getAuditStatus, (Object)CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc(CommunityNotes::getId);
        lqw.last(" limit " + num);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public void operationLike(Integer noteId, String operationType) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (operationType.equals("add")) {
            wrapper.setSql("like_num = like_num + 1");
        } else {
            wrapper.setSql("like_num = like_num - 1");
        }
        wrapper.eq(CommunityNotes::getId, (Object)noteId);
        this.update((Wrapper)wrapper);
    }

    @Override
    public void operationReplyNum(Integer noteId, Integer num, String operationType) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (operationType.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"reply_num = reply_num + {}", (Object[])new Object[]{num}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"reply_num = reply_num - {}", (Object[])new Object[]{num}));
        }
        wrapper.eq(CommunityNotes::getId, (Object)noteId);
        this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<CommunityNotes> findDiscoverNoteRecommendList(Integer noteId, PageParamRequest request) {
        CommunityNotes note = this.getByIdException(noteId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.lt(CommunityNotes::getId, (Object)noteId);
        lqw.eq(CommunityNotes::getType, (Object)note.getType());
        lqw.eq(CommunityNotes::getAuditStatus, (Object)CommunityConstants.COMMUNITY_NOTE_AUDIT_SUCCESS);
        lqw.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc((Object[])new SFunction[]{CommunityNotes::getLikeNum, CommunityNotes::getId});
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isNotEmpty((Collection)list)) {
            Collections.shuffle(list);
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Map<Integer, CommunityNotes> getMapByIdList(List<Integer> noteIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotes::getId, CommunityNotes::getTitle, CommunityNotes::getCover, CommunityNotes::getUid, CommunityNotes::getType, CommunityNotes::getLikeNum});
        lqw.in(CommunityNotes::getId, noteIdList);
        List list = this.dao.selectList((Wrapper)lqw);
        HashMap<Integer, CommunityNotes> map = new HashMap<Integer, CommunityNotes>();
        list.forEach(e -> map.put(e.getId(), (CommunityNotes)e));
        return map;
    }

    @Override
    public Boolean deleteByUid(Integer userId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ONE);
        wrapper.eq(CommunityNotes::getUid, (Object)userId);
        wrapper.eq(CommunityNotes::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        return this.update((Wrapper)wrapper);
    }

    private void validatorNoteParam(CommunityNoteSaveRequest request) {
        String[] proSplit;
        String[] topicSplit;
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_IMAGE_CONTENT.equals(request.getType())) {
            if (StrUtil.isBlank((CharSequence)request.getImage())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u8bf7\u5148\u4e0a\u4f20\u56fe\u7247"));
            }
            String[] split = request.getImage().split(",");
            if (split.length > 9) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u6700\u591a\u53ea\u80fd\u4e0a\u4f209\u5f20\u56fe\u7247"));
            }
            if (StrUtil.isNotBlank((CharSequence)request.getContent()) && request.getContent().length() > 600) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u6b63\u6587\u4e0d\u80fd\u8d85\u8fc7600\u4e2a\u5b57\u7b26"));
            }
        }
        if (CommunityConstants.COMMUNITY_NOTE_TYPE_SHORT_VIDEO.equals(request.getType())) {
            if (StrUtil.isBlank((CharSequence)request.getVideo())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u8bf7\u5148\u4e0a\u4f20\u89c6\u9891"));
            }
            if (StrUtil.isNotBlank((CharSequence)request.getContent()) && request.getContent().length() > 200) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u89c6\u9891\u6b63\u6587\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26"));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTopicIds()) && (topicSplit = request.getTopicIds().split(",")).length > 5) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u6700\u591a\u53ea\u80fd\u5173\u80545\u4e2a\u8bdd\u9898"));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProIds()) && (proSplit = request.getProIds().split(",")).length > 5) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED.setMessage("\u6700\u591a\u53ea\u80fd\u5173\u80545\u4e2a\u5546\u54c1"));
        }
    }
}

