/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.constants.CategoryConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.category.Category;
import com.zbkj.common.request.CategoryRequest;
import com.zbkj.common.request.CategorySearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.vo.CategoryTreeVo;
import com.zbkj.service.dao.CategoryDao;
import com.zbkj.service.service.CategoryService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CategoryServiceImpl
extends ServiceImpl<CategoryDao, Category>
implements CategoryService {
    @Resource
    private CategoryDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemRoleService systemRoleService;

    @Override
    public List<Category> getList(CategorySearchRequest request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (ObjectUtil.isNotNull((Object)request.getPid())) {
            lqw.eq(Category::getPid, (Object)request.getPid());
        }
        if (ObjectUtil.isNotNull((Object)request.getType())) {
            lqw.eq(Category::getType, (Object)request.getType());
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus()) && request.getStatus() >= 0) {
            lqw.eq(Category::getStatus, (Object)request.getStatus().equals(CategoryConstants.CATEGORY_STATUS_NORMAL));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String decode = URLUtil.decode((String)request.getName());
            lqw.like(Category::getName, (Object)decode);
        }
        lqw.eq(Category::getOwner, (Object)this.systemRoleService.getOwnerByCurrentAdmin());
        ((LambdaQueryWrapper)lqw.orderByDesc(Category::getSort)).orderByDesc(Category::getId);
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Category> getByIds(List<Integer> idList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(Category::getId, idList);
        lambdaQueryWrapper.in(Category::getOwner, new Object[]{this.systemRoleService.getOwnerByCurrentAdmin()});
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean update(CategoryRequest request, Integer id) {
        if (id <= 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "id \u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Category oldCategory = (Category)this.getById(id);
        if (ObjectUtil.isNull((Object)oldCategory)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        if (oldCategory.getId().equals(request.getPid())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u7684\u7236\u7ea7\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        if (!oldCategory.getOwner().equals(ownerId)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        if (!oldCategory.getName().equals(request.getName()) && this.checkName(request.getName(), request.getType(), ownerId, oldCategory.getId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        Category category = new Category();
        BeanUtils.copyProperties((Object)request, (Object)category);
        category.setId(id);
        category.setPath(this.getPathByPId(category.getPid()));
        if (StrUtil.isNotBlank((CharSequence)request.getExtra())) {
            category.setExtra(this.systemAttachmentService.clearPrefix(request.getExtra()));
        }
        category.setOwner(ownerId);
        category.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(category);
            if (!request.getStatus().booleanValue()) {
                this.updateStatusByPid(id, false);
            } else {
                this.updatePidStatusById(id);
            }
            return Boolean.TRUE;
        });
    }

    private Boolean updatePidStatusById(Integer id) {
        Category category = (Category)this.getById(id);
        if (StrUtil.isBlank((CharSequence)category.getPath())) {
            return Boolean.TRUE;
        }
        List categoryIdList = CrmebUtil.stringToArrayByRegex((String)category.getPath(), (String)"/");
        categoryIdList.removeIf(i -> i.equals(0));
        if (CollUtil.isEmpty((Collection)categoryIdList)) {
            return Boolean.FALSE;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Category::getStatus, (Object)true);
        wrapper.in(Category::getId, (Collection)categoryIdList);
        return this.update((Wrapper)wrapper);
    }

    private int getChildCountByPid(Integer pid) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.like((Object)"path", (Object)("/" + pid + "/"));
        return this.dao.selectCount((Wrapper)objectQueryWrapper);
    }

    private Boolean updateStatusByPid(Integer pid, Boolean status) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Category::getStatus, (Object)status);
        wrapper.like(Category::getPath, (Object)("/" + pid + "/"));
        return this.update((Wrapper)wrapper);
    }

    private String getPathByPId(Integer pid) {
        Category category = (Category)this.getById(pid);
        if (ObjectUtil.isNotNull((Object)category)) {
            return category.getPath() + pid + "/";
        }
        return "";
    }

    @Override
    public List<CategoryTreeVo> getListTree(Integer type, Integer status, String name) {
        name = URLUtil.decode((String)name);
        return this.getTree(type, status, name, null);
    }

    private List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList) {
        ArrayList<CategoryTreeVo> treeList = new ArrayList<CategoryTreeVo>();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Category::getType, (Object)type);
        if (CollUtil.isNotEmpty(categoryIdList)) {
            lqw.in(Category::getId, categoryIdList);
        }
        if (status >= 0) {
            lqw.eq(Category::getStatus, (Object)status);
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            lqw.like(Category::getName, (Object)name);
        }
        lqw.eq(Category::getOwner, (Object)this.systemRoleService.getOwnerByCurrentAdmin());
        lqw.orderByDesc(Category::getSort);
        lqw.orderByAsc(Category::getId);
        List allTree = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)allTree)) {
            return CollUtil.newArrayList((Object[])new CategoryTreeVo[0]);
        }
        if (StrUtil.isNotBlank((CharSequence)name) && CollUtil.isNotEmpty((Collection)allTree)) {
            ArrayList searchCategory = new ArrayList();
            List categoryIds = allTree.stream().map(Category::getId).collect(Collectors.toList());
            List<Integer> pidList = allTree.stream().filter(c -> c.getPid() > 0 && !categoryIds.contains(c.getPid())).map(Category::getPid).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(pidList)) {
                pidList.forEach(pid -> searchCategory.add(this.dao.selectById((Serializable)pid)));
            }
            allTree.addAll(searchCategory);
        }
        for (Object category : allTree) {
            CategoryTreeVo categoryTreeVo = new CategoryTreeVo();
            BeanUtils.copyProperties((Object)category, (Object)categoryTreeVo);
            treeList.add(categoryTreeVo);
        }
        HashMap<Integer, CategoryTreeVo> map = new HashMap<Integer, CategoryTreeVo>();
        for (CategoryTreeVo categoryTreeVo1 : treeList) {
            map.put(categoryTreeVo1.getId(), categoryTreeVo1);
        }
        ArrayList<CategoryTreeVo> list = new ArrayList<CategoryTreeVo>();
        for (CategoryTreeVo tree : treeList) {
            CategoryTreeVo tree1 = (CategoryTreeVo)map.get(tree.getPid());
            if (ObjectUtil.isNotNull((Object)tree1)) {
                tree1.getChild().add(tree);
                continue;
            }
            list.add(tree);
        }
        System.out.println("\u65e0\u9650\u6781\u5206\u7c7b : getTree:" + JSON.toJSONString(list));
        return list;
    }

    @Override
    public int delete(Integer id) {
        if (this.getChildCountByPid(id) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u5206\u7c7b\u4e0b\u6709\u5b50\u7c7b\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7c7b\uff01");
        }
        Category category = this.getByIdException(id);
        Integer owner = this.systemRoleService.getOwnerByCurrentAdmin();
        if (!owner.equals(category.getOwner())) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        return this.dao.deleteById(id);
    }

    private Boolean checkName(String name, Integer type, Integer owner, Integer id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(Category::getName, (Object)name);
        lambdaQueryWrapper.eq(Category::getOwner, (Object)owner);
        if (ObjectUtil.isNotNull((Object)type)) {
            lambdaQueryWrapper.eq(Category::getType, (Object)type);
        }
        if (id > 0) {
            lambdaQueryWrapper.ne(Category::getId, (Object)id);
        }
        return this.dao.selectCount((Wrapper)lambdaQueryWrapper) > 0;
    }

    @Override
    public Boolean updateStatus(Integer id) {
        Category category = (Category)this.getById(id);
        Integer owner = this.systemRoleService.getOwnerByCurrentAdmin();
        if (!owner.equals(category.getOwner())) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        category.setStatus(Boolean.valueOf(category.getStatus() == false));
        category.setUpdateTime((Date)DateUtil.date());
        return this.updateById(category);
    }

    @Override
    public Boolean create(CategoryRequest categoryRequest) {
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        if (this.checkName(categoryRequest.getName(), categoryRequest.getType(), ownerId, 0).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6b64\u5206\u7c7b\u5df2\u5b58\u5728");
        }
        Category category = new Category();
        BeanUtils.copyProperties((Object)categoryRequest, (Object)category);
        category.setPath(this.getPathByPId(category.getPid()));
        category.setExtra(this.systemAttachmentService.clearPrefix(category.getExtra()));
        category.setOwner(ownerId);
        return this.save(category);
    }

    @Override
    public Category getByIdException(Integer id) {
        Category category = (Category)this.getById(id);
        if (ObjectUtil.isNull((Object)category)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        return category;
    }

    @Override
    public Category getBaseCategoryInfo(Integer id) {
        Category category = this.getByIdException(id);
        Integer owner = this.systemRoleService.getOwnerByCurrentAdmin();
        if (!owner.equals(category.getOwner())) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CATEGORY_NOT_EXIST);
        }
        return category;
    }
}

