/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.binarywang.wxpay.bean.notify.SignatureHeader;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyV3Result;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyV3Result;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderV3Request;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryV3Result;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundV3Result;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderV3Result;
import com.github.binarywang.wxpay.bean.result.enums.TradeTypeEnum;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.WechatExceptions;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.wxjava.WxPayServiceFactory;
import com.zbkj.service.service.WechatExceptionsService;
import com.zbkj.service.service.WechatPayInfoService;
import com.zbkj.service.service.WechatPayService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatPayServiceImpl
implements WechatPayService {
    private final Logger LOGGER = LoggerFactory.getLogger(WechatPayServiceImpl.class);
    @Autowired
    private WechatExceptionsService wechatExceptionsService;
    @Autowired
    private WxPayServiceFactory wxPayServiceFactory;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;

    @Override
    public MyRecord createOrder(WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest, String openid, String channel, String paySource, String apiDomain) {
        this.setTradeAndOpenid(wxPayUnifiedOrderRequest, channel, openid);
        WechatPayInfo wechatPayInfo = this.createWechatPayInfo(wxPayUnifiedOrderRequest);
        MyRecord record = new MyRecord();
        switch (channel) {
            case "mini": 
            case "video": {
                try {
                    wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                    WxPayMpOrderResult payResult = (WxPayMpOrderResult)this.wxPayServiceFactory.getService("ma").createOrder(wxPayUnifiedOrderRequest);
                    record.set("appId", (Object)payResult.getAppId());
                    record.set("nonceStr", (Object)payResult.getNonceStr());
                    record.set("package", (Object)payResult.getPackageValue());
                    record.set("signType", (Object)payResult.getSignType());
                    record.set("paySign", (Object)payResult.getPaySign());
                    record.set("timeStamp", (Object)payResult.getTimeStamp());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V2\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V2\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "public": {
                try {
                    wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    WxPayMpOrderResult payResult = (WxPayMpOrderResult)this.wxPayServiceFactory.getService("mp").createOrder(wxPayUnifiedOrderRequest);
                    record.set("appId", (Object)payResult.getAppId());
                    record.set("nonceStr", (Object)payResult.getNonceStr());
                    record.set("package", (Object)payResult.getPackageValue());
                    record.set("signType", (Object)payResult.getSignType());
                    record.set("paySign", (Object)payResult.getPaySign());
                    record.set("timeStamp", (Object)payResult.getTimeStamp());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V2\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V2\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "h5": {
                WxPayMwebOrderResult mwebOrderResult;
                if (paySource.equals("mini")) {
                    try {
                        wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                        mwebOrderResult = (WxPayMwebOrderResult)this.wxPayServiceFactory.getService("ma").createOrder(wxPayUnifiedOrderRequest);
                        record.set("mwebUrl", (Object)mwebOrderResult.getMwebUrl());
                    }
                    catch (WxPayException payException) {
                        this.LOGGER.error("\u5fae\u4fe1V2H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                        wechatPayInfo.setErrCode(payException.getErrCode());
                        this.wechatPayInfoService.save(wechatPayInfo);
                        throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.LOGGER.error("\u5fae\u4fe1V2H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                }
                if (!paySource.equals("public")) break;
                try {
                    wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    mwebOrderResult = (WxPayMwebOrderResult)this.wxPayServiceFactory.getService("mp").createOrder(wxPayUnifiedOrderRequest);
                    record.set("mwebUrl", (Object)mwebOrderResult.getMwebUrl());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V2H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V2H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "native": {
                WxPayNativeOrderResult nativeOrderResult;
                if (paySource.equals("mini")) {
                    try {
                        wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                        nativeOrderResult = (WxPayNativeOrderResult)this.wxPayServiceFactory.getService("ma").createOrder(wxPayUnifiedOrderRequest);
                        record.set("codeUrl", (Object)nativeOrderResult.getCodeUrl());
                    }
                    catch (WxPayException payException) {
                        this.LOGGER.error("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                        wechatPayInfo.setErrCode(payException.getErrCode());
                        this.wechatPayInfoService.save(wechatPayInfo);
                        throw new CrmebException("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.LOGGER.error("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new CrmebException("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                }
                if (!paySource.equals("public")) break;
                try {
                    wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    nativeOrderResult = (WxPayNativeOrderResult)this.wxPayServiceFactory.getService("mp").createOrder(wxPayUnifiedOrderRequest);
                    record.set("codeUrl", (Object)nativeOrderResult.getCodeUrl());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1V2Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "wechatIos": 
            case "wechatAndroid": {
                try {
                    wxPayUnifiedOrderRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/app");
                    WxPayAppOrderResult appOrderResult = (WxPayAppOrderResult)this.wxPayServiceFactory.getService("app").createOrder(wxPayUnifiedOrderRequest);
                    record.set("appId", (Object)appOrderResult.getAppId());
                    record.set("partnerId", (Object)appOrderResult.getPartnerId());
                    record.set("prepayId", (Object)appOrderResult.getPrepayId());
                    record.set("package", (Object)appOrderResult.getPackageValue());
                    record.set("nonceStr", (Object)appOrderResult.getNonceStr());
                    record.set("timeStamp", (Object)appOrderResult.getTimeStamp());
                    record.set("sign", (Object)appOrderResult.getSign());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V2APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1V2APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V2APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1V2APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
        }
        wechatPayInfo.setErrCode("200");
        this.wechatPayInfoService.save(wechatPayInfo);
        return record;
    }

    private WechatPayInfo createWechatPayInfo(WxPayUnifiedOrderV3Request v3Request) {
        WechatPayInfo payInfo = new WechatPayInfo();
        payInfo.setAppId(v3Request.getAppid());
        payInfo.setAttach(v3Request.getAttach());
        payInfo.setOutTradeNo(v3Request.getOutTradeNo());
        return payInfo;
    }

    private WechatPayInfo createWechatPayInfo(WxPayUnifiedOrderRequest unifiedOrderRequest) {
        WechatPayInfo payInfo = new WechatPayInfo();
        payInfo.setAppId(unifiedOrderRequest.getAppid());
        payInfo.setMchId(unifiedOrderRequest.getMchId());
        payInfo.setDeviceInfo(unifiedOrderRequest.getDeviceInfo());
        payInfo.setOpenId(unifiedOrderRequest.getOpenid());
        payInfo.setNonceStr(unifiedOrderRequest.getNonceStr());
        payInfo.setSign(unifiedOrderRequest.getSign());
        payInfo.setSignType(unifiedOrderRequest.getSignType());
        payInfo.setBody(unifiedOrderRequest.getBody());
        payInfo.setDetail(unifiedOrderRequest.getDetail());
        payInfo.setAttach(unifiedOrderRequest.getAttach());
        payInfo.setOutTradeNo(unifiedOrderRequest.getOutTradeNo());
        payInfo.setFeeType(unifiedOrderRequest.getFeeType());
        payInfo.setTotalFee(unifiedOrderRequest.getTotalFee());
        payInfo.setSpbillCreateIp(unifiedOrderRequest.getSpbillCreateIp());
        payInfo.setTimeStart(unifiedOrderRequest.getTimeStart());
        payInfo.setTimeExpire(unifiedOrderRequest.getTimeExpire());
        payInfo.setNotifyUrl(unifiedOrderRequest.getNotifyUrl());
        payInfo.setTradeType(unifiedOrderRequest.getTradeType());
        payInfo.setProductId(unifiedOrderRequest.getProductId());
        payInfo.setSceneInfo(unifiedOrderRequest.getSceneInfo());
        return payInfo;
    }

    private void setTradeAndOpenid(WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest, String channel, String openid) {
        switch (channel) {
            case "h5": {
                wxPayUnifiedOrderRequest.setTradeType("MWEB");
                wxPayUnifiedOrderRequest.setOpenid(null);
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                wxPayUnifiedOrderRequest.setTradeType("APP");
                wxPayUnifiedOrderRequest.setOpenid(null);
                break;
            }
            case "native": {
                wxPayUnifiedOrderRequest.setTradeType("NATIVE");
                wxPayUnifiedOrderRequest.setOpenid(null);
                break;
            }
            default: {
                wxPayUnifiedOrderRequest.setTradeType("JSAPI");
                wxPayUnifiedOrderRequest.setOpenid(openid);
            }
        }
    }

    @Override
    public WxPayOrderNotifyResult parseOrderNotifyResult(String notifyData, String serviceKey) {
        WxPayOrderNotifyResult wxPayOrderNotifyResult;
        try {
            wxPayOrderNotifyResult = this.wxPayServiceFactory.getService(serviceKey).parseOrderNotifyResult(notifyData);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u89e3\u6790\u8ba2\u5355\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u89e3\u6790\u8ba2\u5355\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
        }
        return wxPayOrderNotifyResult;
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String outTradeNo, String paySource) {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        WxPayOrderQueryResult queryResult = new WxPayOrderQueryResult();
        try {
            switch (paySource) {
                case "public": {
                    queryResult = this.wxPayServiceFactory.getService("mp").queryOrder(request);
                    break;
                }
                case "mini": 
                case "video": {
                    queryResult = this.wxPayServiceFactory.getService("ma").queryOrder(request);
                    break;
                }
                case "wechatIos": 
                case "wechatAndroid": {
                    queryResult = this.wxPayServiceFactory.getService("app").queryOrder(request);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u5931\u8d25\uff0coutTradeNo = " + outTradeNo);
        }
        this.checkQueryResult(queryResult);
        return queryResult;
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest wxPayRefundRequest, String paySource, String apiDomain) {
        WxPayRefundResult refundResult = new WxPayRefundResult();
        try {
            switch (paySource) {
                case "public": {
                    wxPayRefundRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/mp");
                    refundResult = this.wxPayServiceFactory.getService("mp").refundV2(wxPayRefundRequest);
                    break;
                }
                case "mini": 
                case "video": {
                    wxPayRefundRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/ma");
                    refundResult = this.wxPayServiceFactory.getService("ma").refundV2(wxPayRefundRequest);
                    break;
                }
                case "wechatIos": 
                case "wechatAndroid": {
                    wxPayRefundRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/app");
                    refundResult = this.wxPayServiceFactory.getService("app").refundV2(wxPayRefundRequest);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1V2\u9000\u6b3e\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1V2\u9000\u6b3e\u5931\u8d25\uff0coutTradeNo = " + wxPayRefundRequest.getOutTradeNo());
        }
        this.checkRefundResult(refundResult);
        return refundResult;
    }

    @Override
    public WxPayRefundNotifyResult parseRefundNotifyResult(String notifyData, String serviceKey) {
        WxPayRefundNotifyResult wxPayRefundNotifyResult;
        try {
            wxPayRefundNotifyResult = this.wxPayServiceFactory.getService(serviceKey).parseRefundNotifyResult(notifyData);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u89e3\u6790\u8ba2\u5355\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u89e3\u6790\u9000\u6b3e\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
        }
        return wxPayRefundNotifyResult;
    }

    private void checkRefundResult(WxPayRefundResult refundResult) {
        if (refundResult.getReturnCode().equalsIgnoreCase("FAIL")) {
            this.wxPayRefundExceptionDispose(refundResult, "\u5fae\u4fe1\u9000\u6b3e\u901a\u4fe1\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d251\uff01" + refundResult.getReturnMsg());
        }
        if (refundResult.getResultCode().equalsIgnoreCase("FAIL")) {
            this.wxPayRefundExceptionDispose(refundResult, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d252\uff01" + refundResult.getErrCode() + refundResult.getErrCodeDes());
        }
    }

    private void checkQueryResult(WxPayOrderQueryResult queryResult) {
        if (queryResult.getReturnCode().equalsIgnoreCase("FAIL")) {
            this.wxPayQueryExceptionDispose(queryResult, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u901a\u4fe1\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d251\uff01" + queryResult.getReturnMsg());
        }
        if (queryResult.getResultCode().equalsIgnoreCase("FAIL")) {
            this.wxPayQueryExceptionDispose(queryResult, "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d252\uff01" + queryResult.getErrCode() + queryResult.getErrCodeDes());
        }
    }

    private void wxPayQueryExceptionDispose(WxPayOrderQueryResult queryResult, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        if (queryResult.getReturnCode().equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode("-200");
            wechatExceptions.setErrmsg(queryResult.getReturnMsg());
        } else if (queryResult.getResultCode().equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode(queryResult.getErrCode());
            wechatExceptions.setErrmsg(queryResult.getErrCodeDes());
        } else if (!queryResult.getTradeState().equalsIgnoreCase("SUCCESS")) {
            wechatExceptions.setErrcode("-201");
            wechatExceptions.setErrmsg(queryResult.getTradeState());
        }
        wechatExceptions.setData(JSONObject.toJSONString((Object)queryResult));
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    private void wxPayRefundExceptionDispose(WxPayRefundResult refundResult, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        if (refundResult.getReturnCode().equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode("-100");
            wechatExceptions.setErrmsg(refundResult.getReturnMsg());
        } else if (refundResult.getResultCode().equalsIgnoreCase("FAIL")) {
            wechatExceptions.setErrcode(refundResult.getErrCode());
            wechatExceptions.setErrmsg(refundResult.getErrCodeDes());
        }
        wechatExceptions.setData(JSONObject.toJSONString((Object)refundResult));
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    @Override
    public MyRecord createV3Order(WxPayUnifiedOrderV3Request wxPayUnifiedOrderV3Request, String openid, String channel, String paySource, String apiDomain) {
        WxPayUnifiedOrderV3Request.Payer payer = new WxPayUnifiedOrderV3Request.Payer();
        payer.setOpenid(openid);
        wxPayUnifiedOrderV3Request.setPayer(payer);
        WechatPayInfo wechatPayInfo = this.createWechatPayInfo(wxPayUnifiedOrderV3Request);
        MyRecord record = new MyRecord();
        switch (channel) {
            case "mini": 
            case "video": {
                try {
                    wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                    WxPayUnifiedOrderV3Result.JsapiResult jsapiResult = (WxPayUnifiedOrderV3Result.JsapiResult)this.wxPayServiceFactory.getService("ma").createOrderV3(TradeTypeEnum.JSAPI, wxPayUnifiedOrderV3Request);
                    record.set("appId", (Object)jsapiResult.getAppId());
                    record.set("nonceStr", (Object)jsapiResult.getNonceStr());
                    record.set("package", (Object)jsapiResult.getPackageValue());
                    record.set("signType", (Object)jsapiResult.getSignType());
                    record.set("paySign", (Object)jsapiResult.getPaySign());
                    record.set("timeStamp", (Object)jsapiResult.getTimeStamp());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V3\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V3\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "public": {
                try {
                    wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    WxPayUnifiedOrderV3Result.JsapiResult jsapiResult = (WxPayUnifiedOrderV3Result.JsapiResult)this.wxPayServiceFactory.getService("mp").createOrderV3(TradeTypeEnum.JSAPI, wxPayUnifiedOrderV3Request);
                    record.set("appId", (Object)jsapiResult.getAppId());
                    record.set("nonceStr", (Object)jsapiResult.getNonceStr());
                    record.set("package", (Object)jsapiResult.getPackageValue());
                    record.set("signType", (Object)jsapiResult.getSignType());
                    record.set("paySign", (Object)jsapiResult.getPaySign());
                    record.set("timeStamp", (Object)jsapiResult.getTimeStamp());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V3\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V3\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "h5": {
                String h5Url;
                WxPayUnifiedOrderV3Request.SceneInfo sceneInfo = new WxPayUnifiedOrderV3Request.SceneInfo();
                sceneInfo.setPayerClientIp(RequestUtil.getClientIp());
                WxPayUnifiedOrderV3Request.H5Info h5Info = new WxPayUnifiedOrderV3Request.H5Info();
                h5Info.setType("Wap");
                sceneInfo.setH5Info(h5Info);
                wxPayUnifiedOrderV3Request.setSceneInfo(sceneInfo);
                if (paySource.equals("mini")) {
                    try {
                        wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                        h5Url = (String)this.wxPayServiceFactory.getService("ma").createOrderV3(TradeTypeEnum.H5, wxPayUnifiedOrderV3Request);
                        record.set("mwebUrl", (Object)h5Url);
                    }
                    catch (WxPayException payException) {
                        this.LOGGER.error("\u5fae\u4fe1V3H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                        wechatPayInfo.setErrCode(payException.getErrCode());
                        this.wechatPayInfoService.save(wechatPayInfo);
                        throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.LOGGER.error("\u5fae\u4fe1V3H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                }
                if (!paySource.equals("public")) break;
                try {
                    wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    h5Url = (String)this.wxPayServiceFactory.getService("mp").createOrderV3(TradeTypeEnum.H5, wxPayUnifiedOrderV3Request);
                    record.set("mwebUrl", (Object)h5Url);
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V3H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V3H5\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1H5\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "native": {
                String codeUrl;
                wxPayUnifiedOrderV3Request.setPayer(null);
                if (paySource.equals("mini")) {
                    try {
                        wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/ma");
                        codeUrl = (String)this.wxPayServiceFactory.getService("ma").createOrderV3(TradeTypeEnum.NATIVE, wxPayUnifiedOrderV3Request);
                        record.set("codeUrl", (Object)codeUrl);
                    }
                    catch (WxPayException payException) {
                        this.LOGGER.error("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                        wechatPayInfo.setErrCode(payException.getErrCode());
                        this.wechatPayInfoService.save(wechatPayInfo);
                        throw new CrmebException("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.LOGGER.error("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u5c0f\u7a0b\u5e8f\uff01");
                        this.LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new CrmebException("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    }
                }
                if (!paySource.equals("public")) break;
                try {
                    wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/mp");
                    codeUrl = (String)this.wxPayServiceFactory.getService("mp").createOrderV3(TradeTypeEnum.NATIVE, wxPayUnifiedOrderV3Request);
                    record.set("codeUrl", (Object)codeUrl);
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01\u652f\u4ed8\u6e20\u9053\u516c\u4f17\u53f7\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1V3Native\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
            case "wechatIos": 
            case "wechatAndroid": {
                wxPayUnifiedOrderV3Request.setPayer(null);
                try {
                    wxPayUnifiedOrderV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/app");
                    WxPayUnifiedOrderV3Result.AppResult appResult = (WxPayUnifiedOrderV3Result.AppResult)this.wxPayServiceFactory.getService("app").createOrderV3(TradeTypeEnum.APP, wxPayUnifiedOrderV3Request);
                    record.set("appId", (Object)appResult.getAppid());
                    record.set("partnerId", (Object)appResult.getPartnerId());
                    record.set("prepayId", (Object)appResult.getPrepayId());
                    record.set("package", (Object)appResult.getPackageValue());
                    record.set("nonceStr", (Object)appResult.getNoncestr());
                    record.set("timeStamp", (Object)appResult.getTimestamp());
                    record.set("sign", (Object)appResult.getSign());
                    break;
                }
                catch (WxPayException payException) {
                    this.LOGGER.error("\u5fae\u4fe1V3APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(payException.getMessage(), (Throwable)payException);
                    wechatPayInfo.setErrCode(payException.getErrCode());
                    this.wechatPayInfoService.save(wechatPayInfo);
                    throw new CrmebException("\u5fae\u4fe1V3APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5fae\u4fe1V3APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new CrmebException("\u5fae\u4fe1V3APP\u9884\u4e0b\u5355\u5931\u8d25\uff01");
                }
            }
        }
        wechatPayInfo.setErrCode("200");
        this.wechatPayInfoService.save(wechatPayInfo);
        return record;
    }

    @Override
    public WxPayOrderQueryV3Result queryOrderV3(String outTradeNo, String paySource) {
        WxPayOrderQueryV3Request queryV3Request = new WxPayOrderQueryV3Request();
        queryV3Request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        WxPayOrderQueryV3Result queryV3Result = new WxPayOrderQueryV3Result();
        try {
            switch (paySource) {
                case "public": {
                    queryV3Result = this.wxPayServiceFactory.getService("mp").queryOrderV3(queryV3Request);
                    break;
                }
                case "mini": 
                case "video": {
                    queryV3Result = this.wxPayServiceFactory.getService("ma").queryOrderV3(queryV3Request);
                    break;
                }
                case "wechatIos": 
                case "wechatAndroid": {
                    queryV3Result = this.wxPayServiceFactory.getService("app").queryOrderV3(queryV3Request);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u67e5\u8be2\u5fae\u4fe1\u8ba2\u5355\u5931\u8d25\uff0coutTradeNo = " + outTradeNo);
        }
        return queryV3Result;
    }

    @Override
    public WxPayRefundV3Result refundV3(WxPayRefundV3Request wxPayRefundV3Request, String paySource, String apiDomain) {
        WxPayRefundV3Result refundV3Result = new WxPayRefundV3Result();
        try {
            switch (paySource) {
                case "public": {
                    wxPayRefundV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/mp");
                    refundV3Result = this.wxPayServiceFactory.getService("mp").refundV3(wxPayRefundV3Request);
                    break;
                }
                case "mini": 
                case "video": {
                    wxPayRefundV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/ma");
                    refundV3Result = this.wxPayServiceFactory.getService("ma").refundV3(wxPayRefundV3Request);
                    break;
                }
                case "wechatIos": 
                case "wechatAndroid": {
                    wxPayRefundV3Request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/wechat/refund/app");
                    refundV3Result = this.wxPayServiceFactory.getService("app").refundV3(wxPayRefundV3Request);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1V3\u9000\u6b3e\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1V3\u9000\u6b3e\u5931\u8d25\uff0coutTradeNo = " + wxPayRefundV3Request.getOutTradeNo());
        }
        return refundV3Result;
    }

    @Override
    public WxPayNotifyV3Result parseOrderNotifyV3Result(String notifyData, SignatureHeader header, String serviceKey) {
        try {
            return this.wxPayServiceFactory.getService(serviceKey).parseOrderNotifyV3Result(notifyData, header);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1\u89e3\u6790\u652f\u4ed8\u901a\u77e5\u7ed3\u679cV3\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u89e3\u6790\u8ba2\u5355\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
        }
    }

    @Override
    public WxPayRefundNotifyV3Result parseRefundNotifyV3Result(String notifyData, SignatureHeader header, String serviceKey) {
        try {
            return this.wxPayServiceFactory.getService(serviceKey).parseRefundNotifyV3Result(notifyData, header);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5fae\u4fe1\u89e3\u6790\u9000\u6b3e\u901a\u77e5\u7ed3\u679cV3\u5931\u8d25");
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u89e3\u6790\u8ba2\u5355\u901a\u77e5\u7ed3\u679c\u5931\u8d25");
        }
    }
}

