/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.service.service.WechatMediaService;
import com.zbkj.service.service.WechatService;
import java.io.File;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WechatMediaServiceImpl
implements WechatMediaService {
    private static final Logger logger = LoggerFactory.getLogger(WechatMediaService.class);
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public WxMediaUploadResult uploadMedia(String type, MultipartFile multipart) {
        WxMediaUploadResult wxMediaUploadResult;
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)multipart.getOriginalFilename()).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        try {
            File file = UploadUtil.createFile((String)destPath);
            multipart.transferTo(file);
            wxMediaUploadResult = this.wxMaService.getMediaService().uploadMedia(type, file);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object)e.getMessage());
            throw new CrmebException(StrUtil.format((CharSequence)"\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object[])new Object[]{e.getMessage()}));
        }
        return wxMediaUploadResult;
    }

    @Override
    public WxMediaUploadResult uploadMediaByLocal(String type, String imagePath) {
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "/crmebimage/public/wechat/";
        String newFileName = UploadUtil.fileName((String)FilenameUtils.getExtension((String)imagePath).toLowerCase());
        String webPath = modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = new File(destPath);
        HttpUtil.downloadFile((String)imagePath, (File)file);
        try {
            WxMediaUploadResult wxMediaUploadResult = this.wxMaService.getMediaService().uploadMedia(type, file);
            return wxMediaUploadResult;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object)e.getMessage());
            throw new CrmebException(StrUtil.format((CharSequence)"\u4e0a\u4f20\u5fae\u4fe1\u7d20\u6750\u51fa\u9519:{}", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public File getFileByMediaId(String mediaId) throws WxErrorException {
        return this.wxMaService.getMediaService().getMedia(mediaId);
    }
}

