/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.wechat.live.WechatLiveAssistant;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.wxmplive.assistant.WechatLiveAssistantAddRequest;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.wechat.live.WechatLiveAssistantDao;
import com.zbkj.service.service.WechatLiveAssistantService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WechatLiveAssistantServiceImpl
extends ServiceImpl<WechatLiveAssistantDao, WechatLiveAssistant>
implements WechatLiveAssistantService {
    private static final Logger logger = LoggerFactory.getLogger(WechatLiveAssistantServiceImpl.class);
    @Resource
    private WechatLiveAssistantDao wechatLiveAssistantDao;

    @Override
    public List<WechatLiveAssistant> getList(String keywords, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LoginUserVo currentUser = SecurityUtil.getLoginUserVo();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)keywords)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.like(WechatLiveAssistant::getWechat, (Object)URLUtil.decode((String)keywords))).or()).like(WechatLiveAssistant::getWechatNickname, (Object)URLUtil.decode((String)keywords));
        }
        lambdaQueryWrapper.eq(WechatLiveAssistant::getMerId, (Object)currentUser.getUser().getMerId());
        lambdaQueryWrapper.orderByDesc(WechatLiveAssistant::getCreateTime);
        return this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean saveUnique(WechatLiveAssistant wechatLiveAssistant) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(WechatLiveAssistant::getWechat, (Object)wechatLiveAssistant.getWechat());
        List wechatLiveAssistants = this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
        if (wechatLiveAssistants.size() > 0) {
            throw new CrmebException("\u5fae\u4fe1\u76f4\u64ad\u5c0f\u52a9\u624b\u5df2\u7ecf\u5b58\u5728:" + wechatLiveAssistant.getWechat());
        }
        wechatLiveAssistant.setMerId(SecurityUtil.getLoginUserVo().getUser().getMerId());
        return this.wechatLiveAssistantDao.insert(wechatLiveAssistant) > 0;
    }

    @Override
    public List<WechatLiveAssistant> syncAssListUnique(List<WechatLiveAssistant> wechatLiveAssistant) {
        ArrayList<WechatLiveAssistant> resultList = new ArrayList<WechatLiveAssistant>();
        List currentAssWechatList = wechatLiveAssistant.stream().map(WechatLiveAssistant::getWechat).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.in(WechatLiveAssistant::getWechat, new Object[]{Joiner.on((String)",").join(currentAssWechatList)});
        List currentExitAssList = this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
        for (WechatLiveAssistant assistant : currentExitAssList) {
            List existAss = wechatLiveAssistant.stream().filter(ass -> ass.getWechat().equals(assistant.getWechat())).collect(Collectors.toList());
            if (existAss.size() == 0) {
                logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u76f4\u64ad\u95f4 - \u540c\u6b65\u5c0f\u52a9\u624b \u66f4\u65b0\u65f6\u5b58\u5728\u6f0f\u7f51\u4e4b\u9c7c:{}:\u672c\u5730\u6ca1\u6709\u627e\u5230", (Object)JSON.toJSONString((Object)assistant));
                break;
            }
            WechatLiveAssistant currentAssForUpdate = (WechatLiveAssistant)existAss.get(0);
            BeanUtils.copyProperties((Object)currentAssForUpdate, (Object)assistant);
            assistant.setId(currentAssForUpdate.getId());
            assistant.setUpdateTime((Date)DateUtil.date());
        }
        boolean assBatchUpdateResult = this.updateBatchById(currentExitAssList);
        resultList.addAll(currentExitAssList);
        ArrayList<WechatLiveAssistant> wechatLiveAssistantListForInsert = new ArrayList<WechatLiveAssistant>();
        for (WechatLiveAssistant assistant : wechatLiveAssistant) {
            List notExistAss = currentExitAssList.stream().filter(ass -> !ass.getWechat().equals(assistant.getWechat())).collect(Collectors.toList());
            if (notExistAss.size() <= 0) continue;
            WechatLiveAssistant currentASS = (WechatLiveAssistant)notExistAss.get(0);
            wechatLiveAssistantListForInsert.add(currentASS);
        }
        resultList.addAll(wechatLiveAssistantListForInsert);
        return resultList;
    }

    @Override
    public Boolean deleteById(Integer id) {
        this.getAssistantInfo(id);
        return this.removeById(id);
    }

    @Override
    public Boolean edit(WechatLiveAssistantAddRequest wechatLiveAssistant) {
        this.getAssistantInfo(wechatLiveAssistant.getId());
        WechatLiveAssistant assistant = new WechatLiveAssistant();
        BeanUtils.copyProperties((Object)wechatLiveAssistant, (Object)assistant);
        assistant.setUpdateTime((Date)DateUtil.date());
        return this.updateById(assistant);
    }

    @Override
    public WechatLiveAssistant getAssistantInfo(Integer id) {
        WechatLiveAssistant liveAssistant = (WechatLiveAssistant)this.getById(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (ObjectUtil.isNull((Object)liveAssistant) || !admin.getMerId().equals(liveAssistant.getMerId())) {
            throw new CrmebException("\u76f4\u64ad\u52a9\u624b\u4e0d\u5b58\u5728");
        }
        return liveAssistant;
    }
}

