/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.wechat.WechatCallback;
import com.zbkj.service.dao.WechatCallbackDao;
import com.zbkj.service.service.WechatCallbackService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WechatCallbackServiceImpl
extends ServiceImpl<WechatCallbackDao, WechatCallback>
implements WechatCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(WechatCallbackServiceImpl.class);
    @Resource
    private WechatCallbackDao dao;

    @Override
    public String callback(String request) {
        JSONObject jsonObject = JSONObject.parseObject((String)request);
        WechatCallback wechatCallback = new WechatCallback();
        wechatCallback.setToUserName(jsonObject.getString("ToUserName"));
        wechatCallback.setFromUserName(jsonObject.getString("FromUserName"));
        wechatCallback.setCreateTime(jsonObject.getLong("CreateTime"));
        wechatCallback.setMsgType(jsonObject.getString("MsgType"));
        wechatCallback.setEvent(jsonObject.getString("Event"));
        wechatCallback.setAddTime((Date)DateUtil.date());
        wechatCallback.setContent(request);
        this.save(wechatCallback);
        if (wechatCallback.getMsgType().equals("text")) {
            return "success";
        }
        switch (wechatCallback.getEvent()) {
            case "open_product_account_register": {
                break;
            }
            case "![CDATA[open_product_scene_group_audit]]": {
                break;
            }
            case "open_product_category_audit": {
                break;
            }
            case "open_product_spu_status_update": {
                break;
            }
            case "open_product_order_pay": {
                break;
            }
            case "miniprogram_sharer_bind_status_change": {
                break;
            }
            case "open_product_receive_coupon": {
                break;
            }
            case "open_product_spu_audit": {
                break;
            }
            case "open_product_brand_audit": {
                break;
            }
            default: {
                logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u56de\u8c03\u65b9\u5f0f\u672a\u77e5 {}", (Object)JSONObject.parseObject((String)request));
            }
        }
        return "success";
    }
}

