/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.user.UserMerchantCollect;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CancelCollectRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.MerchantCollectResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.UserMerchantCollectDao;
import com.zbkj.service.service.MerchantEmployeeService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMerchantCollectServiceImpl
extends ServiceImpl<UserMerchantCollectDao, UserMerchantCollect>
implements UserMerchantCollectService {
    @Resource
    private UserMerchantCollectDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private MerchantEmployeeService merchantEmployeeService;

    @Override
    public Boolean isCollect(Integer userId, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserMerchantCollect::getUid, (Object)userId);
        lqw.eq(UserMerchantCollect::getMerId, (Object)merId);
        lqw.last(" limit 1");
        UserMerchantCollect collect = (UserMerchantCollect)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)collect);
    }

    @Override
    public Integer getCountByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserMerchantCollect::getMerId, (Object)merId);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private Boolean delete(Integer uid, Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(UserMerchantCollect::getUid, (Object)uid);
        wrapper.eq(UserMerchantCollect::getMerId, (Object)merId);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public Boolean userCollect(Integer merId) {
        Integer uid = this.userService.getUserIdException();
        if (this.isCollect(uid, merId).booleanValue()) {
            return Boolean.TRUE;
        }
        UserMerchantCollect userMerchantCollect = new UserMerchantCollect();
        userMerchantCollect.setUid(uid);
        userMerchantCollect.setMerId(merId);
        return this.save(userMerchantCollect);
    }

    @Override
    public Boolean userCancelCollect(Integer merId) {
        Integer uid = this.userService.getUserIdException();
        if (!this.isCollect(uid, merId).booleanValue()) {
            return Boolean.TRUE;
        }
        if (this.merchantEmployeeService.isExist(merId, uid).booleanValue()) {
            throw new CrmebException("\u5e97\u94fa\u7ba1\u7406\u5458\u4e0d\u53ef\u53d6\u5173\u5e97\u94fa");
        }
        return this.delete(uid, merId);
    }

    @Override
    public PageInfo<MerchantCollectResponse> findList(PageParamRequest pageParamRequest) {
        Integer uid = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserMerchantCollect::getUid, (Object)uid);
        lqw.orderByDesc(UserMerchantCollect::getCreateTime);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List collectList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)collectList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantCollectResponse[0]));
        }
        List responseList = collectList.stream().map(collect -> {
            MerchantCollectResponse response = new MerchantCollectResponse();
            BeanUtils.copyProperties((Object)collect, (Object)response);
            Merchant merchant = (Merchant)this.merchantService.getById(collect.getMerId());
            response.setMerName(merchant.getName());
            response.setMerAvatar(merchant.getAvatar());
            response.setIsSelf(merchant.getIsSelf());
            response.setCollectNum(this.getCountByMerId(merchant.getId()));
            response.setPcGoodStoreCoverImage(merchant.getPcGoodStoreCoverImage());
            response.setPcLogo(merchant.getPcLogo());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean deleteByUid(Integer uid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(UserMerchantCollect::getUid, (Object)uid);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public Boolean userBatchCancelCollect(CancelCollectRequest request) {
        Integer userId = this.userService.getUserIdException();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(UserMerchantCollect::getUid, (Object)userId);
        wrapper.eq(UserMerchantCollect::getMerId, (Object)CrmebUtil.stringToArray((String)request.getIds()));
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public Integer getCollectNumByMerIds(List<Integer> merIds) {
        List<Integer> userIds = this.getUserIdsByMerIds(merIds);
        return CollUtil.isEmpty(userIds) ? 0 : userIds.size();
    }

    @Override
    public Integer getCollectNumByMerIdsAndDate(List<Integer> merIds, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(UserMerchantCollect::getMerId, merIds);
        lqw.apply("DATE_FORMAT(create_time,'%Y-%m-%d') = {0}", new Object[]{date});
        Set collect = this.dao.selectList((Wrapper)lqw).stream().map(UserMerchantCollect::getUid).collect(Collectors.toSet());
        return CollUtil.isEmpty(collect) ? 0 : collect.size();
    }

    @Override
    public List<Integer> getUserIdsByMerIds(List<Integer> merIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(UserMerchantCollect::getMerId, merIds);
        Set collect = this.dao.selectList((Wrapper)lqw).stream().map(UserMerchantCollect::getUid).collect(Collectors.toSet());
        return CollUtil.isEmpty(collect) ? CollUtil.newArrayList((Object[])new Integer[0]) : new ArrayList<Integer>(collect);
    }
}

