/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ExperienceRecordConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sgin.SignConfig;
import com.zbkj.common.model.sgin.UserSignRecord;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserExperienceRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SignConfigRequest;
import com.zbkj.common.request.SignRecordSearchRequest;
import com.zbkj.common.response.SignConfigResponse;
import com.zbkj.common.response.SignPageInfoResponse;
import com.zbkj.common.response.UserSignRecordResponse;
import com.zbkj.common.vo.PaidMemberBenefitsVo;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.PaidMemberService;
import com.zbkj.service.service.SignConfigService;
import com.zbkj.service.service.SignService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserExperienceRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserSignRecordService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SignServiceImpl
implements SignService {
    @Autowired
    private SignConfigService signConfigService;
    @Autowired
    private UserSignRecordService userSignRecordService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private UserExperienceRecordService userExperienceRecordService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private PaidMemberService paidMemberService;

    @Override
    public SignConfigResponse getConfig() {
        String signRule = this.systemConfigService.getValueByKey("sign_rule_description ");
        SignConfigResponse response = new SignConfigResponse();
        response.setSignRuleDescription(signRule);
        List<SignConfig> configList = this.signConfigService.findList();
        if (CollUtil.isEmpty(configList)) {
            response.setBaseSignConfig(this.getInitBaseConfig());
            return response;
        }
        for (int i = 0; i < configList.size(); ++i) {
            SignConfig signConfig = configList.get(i);
            if (!signConfig.getDay().equals(0)) continue;
            response.setBaseSignConfig(signConfig);
            configList.remove(i);
            break;
        }
        if (ObjectUtil.isNull((Object)response.getBaseSignConfig())) {
            response.setBaseSignConfig(this.getInitBaseConfig());
        }
        response.setSignConfigList(configList);
        return response;
    }

    @Override
    public Boolean addConfig(SignConfigRequest request) {
        request.setId(null);
        return this.signConfigService.add(request);
    }

    @Override
    public Boolean delete(Integer id) {
        return this.signConfigService.delete(id);
    }

    @Override
    public Boolean editBaseConfig(SignConfigRequest request) {
        if (StrUtil.isBlank((CharSequence)request.getSignRuleDescription())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u7b7e\u5230\u89c4\u5219\u8bf4\u660e");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.signConfigService.editBaseConfig(request);
            this.systemConfigService.updateOrSaveValueByName("sign_rule_description ", request.getSignRuleDescription());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean editAwardConfig(SignConfigRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u7b7e\u5230\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.signConfigService.editAwardConfig(request);
    }

    @Override
    public PageInfo<UserSignRecordResponse> getSignRecordList(SignRecordSearchRequest request) {
        return this.userSignRecordService.pageRecordList(request);
    }

    @Override
    public SignPageInfoResponse getPageInfo(String month) {
        String lastMonthStr;
        User user = this.userService.getInfo();
        DateTime date = DateUtil.date();
        String todayStr = date.toString("yyyy-MM-dd");
        boolean isTip = false;
        UserSignRecord lastSignRecord = this.userSignRecordService.getLastByUid(user.getId());
        if (ObjectUtil.isNull((Object)lastSignRecord) || !lastSignRecord.getDate().equals(todayStr)) {
            lastSignRecord = this.sign(todayStr, user, lastSignRecord);
            isTip = true;
        }
        String nowMonth = date.toString("yyyy-MM");
        if (StrUtil.isNotBlank((CharSequence)month) && !nowMonth.equals(month) && !(lastMonthStr = DateUtil.offsetMonth((Date)DateUtil.beginOfMonth((Date)date), (int)-1).toString("yyyy-MM")).equals(month)) {
            throw new CrmebException("\u53ea\u80fd\u67e5\u770b\u5f53\u524d\u6708\u53ca\u4e0a\u6708\u7684\u7b7e\u5230\u65e5\u5386");
        }
        if (StrUtil.isBlank((CharSequence)month)) {
            month = nowMonth;
        }
        List<UserSignRecord> signRecordList = this.userSignRecordService.findByMonth(user.getId(), month);
        List signDateStrList = signRecordList.stream().map(UserSignRecord::getDate).collect(Collectors.toList());
        SignPageInfoResponse response = new SignPageInfoResponse();
        response.setSignDateList(signDateStrList);
        response.setSignDayNum(lastSignRecord.getDay());
        response.setIntegral(Integer.valueOf(lastSignRecord.getIntegral() + lastSignRecord.getAwardIntegral()));
        response.setExperience(Integer.valueOf(lastSignRecord.getExperience() + lastSignRecord.getAwardExperience()));
        String signRule = this.systemConfigService.getValueByKey("sign_rule_description ");
        response.setSignRule(signRule);
        response.setIsTip(Boolean.valueOf(isTip));
        return response;
    }

    @Override
    public PageInfo<UserSignRecord> findFrontSignRecordList(PageParamRequest pageParamRequest) {
        Integer uid = this.userService.getUserIdException();
        return this.userSignRecordService.findPageByUid(uid, pageParamRequest);
    }

    private UserSignRecord sign(String todayStr, User user, UserSignRecord lastSignRecord) {
        List signConfigList;
        SignConfig signConfig;
        SignConfigResponse config = this.getConfig();
        SignConfig baseSignConfig = config.getBaseSignConfig();
        if (user.getSignNum() > 0) {
            String yesterdayStr = DateUtil.yesterday().toString("yyyy-MM-dd");
            if (ObjectUtil.isNull((Object)lastSignRecord) || !lastSignRecord.getDate().equals(yesterdayStr)) {
                user.setSignNum(Integer.valueOf(0));
            }
        }
        int integral = 0;
        int experience = 0;
        UserSignRecord userSignRecord = new UserSignRecord();
        userSignRecord.setUid(user.getId());
        userSignRecord.setDate(todayStr);
        userSignRecord.setDay(Integer.valueOf(user.getSignNum() + 1));
        userSignRecord.setIntegral(Integer.valueOf(0));
        userSignRecord.setExperience(Integer.valueOf(0));
        userSignRecord.setAwardIntegral(Integer.valueOf(0));
        userSignRecord.setAwardExperience(Integer.valueOf(0));
        if (baseSignConfig.getIsIntegral().booleanValue()) {
            userSignRecord.setIntegral(baseSignConfig.getIntegral());
            integral += baseSignConfig.getIntegral().intValue();
        }
        if (baseSignConfig.getIsExperience().booleanValue()) {
            userSignRecord.setExperience(baseSignConfig.getExperience());
            experience += baseSignConfig.getExperience().intValue();
        }
        if (ObjectUtil.isNotNull((Object)(signConfig = (SignConfig)(signConfigList = config.getSignConfigList()).stream().filter(e -> e.getDay().equals(user.getSignNum() + 1)).findAny().orElse(null)))) {
            if (signConfig.getIsIntegral().booleanValue()) {
                userSignRecord.setAwardIntegral(signConfig.getIntegral());
                integral += signConfig.getIntegral().intValue();
            }
            if (signConfig.getIsExperience().booleanValue()) {
                userSignRecord.setAwardExperience(signConfig.getExperience());
                experience += signConfig.getExperience().intValue();
            }
        } else if (user.getSignNum() > 0 && CollUtil.isNotEmpty((Collection)signConfigList)) {
            SignConfig signConfigMax = signConfigList.stream().max(Comparator.comparing(SignConfig::getDay)).get();
            if (signConfigMax.getIsIntegral().booleanValue()) {
                userSignRecord.setAwardIntegral(signConfigMax.getIntegral());
                integral += signConfigMax.getIntegral().intValue();
            }
            if (signConfigMax.getIsExperience().booleanValue()) {
                userSignRecord.setAwardExperience(signConfigMax.getExperience());
                experience += signConfigMax.getExperience().intValue();
            }
        }
        if (user.getIsPaidMember().booleanValue()) {
            List<PaidMemberBenefitsVo> benefitsList = this.paidMemberService.getBenefitsList();
            for (PaidMemberBenefitsVo b : benefitsList) {
                if (!b.getStatus().booleanValue()) continue;
                if (b.getName().equals("integralDoubling") && b.getMultiple() > 1 && b.getChannelStr().contains("1")) {
                    integral *= b.getMultiple().intValue();
                    userSignRecord.setIntegral(Integer.valueOf(userSignRecord.getIntegral() * b.getMultiple()));
                    userSignRecord.setAwardIntegral(Integer.valueOf(userSignRecord.getAwardIntegral() * b.getMultiple()));
                }
                if (!b.getName().equals("experienceDoubling") || b.getMultiple() <= 1 || !b.getChannelStr().contains("1")) continue;
                experience *= b.getMultiple().intValue();
                userSignRecord.setExperience(Integer.valueOf(userSignRecord.getExperience() * b.getMultiple()));
                userSignRecord.setAwardExperience(Integer.valueOf(userSignRecord.getAwardExperience() * b.getMultiple()));
            }
        }
        StringBuilder mark = new StringBuilder("\u7b7e\u5230\u5956\u52b1");
        if (baseSignConfig.getIsIntegral().booleanValue() || ObjectUtil.isNotNull((Object)signConfig) && signConfig.getIsIntegral().booleanValue()) {
            mark.append(integral).append("\u79ef\u5206");
        }
        if (baseSignConfig.getIsExperience().booleanValue() || ObjectUtil.isNotNull((Object)signConfig) && signConfig.getIsExperience().booleanValue()) {
            mark.append(experience).append("\u7ecf\u9a8c");
        }
        userSignRecord.setMark(mark.toString());
        int finalIntegral = integral;
        int finalExperience = experience;
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userService.updateSignNumByUid(userSignRecord.getDay(), user.getId());
            this.userSignRecordService.save(userSignRecord);
            if (finalIntegral > 0) {
                this.userService.updateIntegral(user.getId(), finalIntegral, "add");
                UserIntegralRecord integralRecord = new UserIntegralRecord();
                integralRecord.setUid(user.getId());
                integralRecord.setLinkId("0");
                integralRecord.setLinkType("sign");
                integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
                integralRecord.setTitle("\u7b7e\u5230\u79ef\u5206\u5956\u52b1");
                integralRecord.setMark(StrUtil.format((CharSequence)"\u7b7e\u5230\u5956\u52b1{}\u79ef\u5206", (Object[])new Object[]{finalIntegral}));
                integralRecord.setIntegral(Integer.valueOf(finalIntegral));
                integralRecord.setBalance(Integer.valueOf(finalIntegral + user.getIntegral()));
                integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
                this.userIntegralRecordService.save(integralRecord);
            }
            if (finalExperience > 0) {
                this.userService.updateExperience(user.getId(), finalExperience, "add");
                UserExperienceRecord experienceRecord = new UserExperienceRecord();
                experienceRecord.setUid(user.getId());
                experienceRecord.setLinkId("0");
                experienceRecord.setLinkType("sign");
                experienceRecord.setType(ExperienceRecordConstants.EXPERIENCE_RECORD_TYPE_ADD);
                experienceRecord.setTitle("\u7b7e\u5230\u7ecf\u9a8c\u5956\u52b1");
                experienceRecord.setMark(StrUtil.format((CharSequence)"\u7b7e\u5230\u5956\u52b1{}\u7ecf\u9a8c", (Object[])new Object[]{finalExperience}));
                experienceRecord.setExperience(Integer.valueOf(finalExperience));
                experienceRecord.setBalance(Integer.valueOf(finalExperience + user.getExperience()));
                experienceRecord.setStatus(ExperienceRecordConstants.EXPERIENCE_RECORD_STATUS_CREATE);
                this.userExperienceRecordService.save(experienceRecord);
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u7b7e\u5230\u5931\u8d25");
        }
        if (finalExperience > 0) {
            this.asyncService.userLevelUp(user.getId(), user.getLevel(), user.getExperience() + finalExperience);
        }
        return userSignRecord;
    }

    private SignConfig getInitBaseConfig() {
        SignConfig signConfig = new SignConfig();
        signConfig.setDay(Integer.valueOf(0));
        signConfig.setIsIntegral(Boolean.valueOf(false));
        signConfig.setIsExperience(Boolean.valueOf(false));
        signConfig.setIntegral(Integer.valueOf(0));
        signConfig.setExperience(Integer.valueOf(0));
        this.signConfigService.save(signConfig);
        return signConfig;
    }
}

