/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sgin.SignConfig;
import com.zbkj.common.request.SignConfigRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.service.dao.SignConfigDao;
import com.zbkj.service.service.SignConfigService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SignConfigServiceImpl
extends ServiceImpl<SignConfigDao, SignConfig>
implements SignConfigService {
    @Resource
    private SignConfigDao dao;

    @Override
    public List<SignConfig> findList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SignConfig::getIsDel, (Object)false);
        lqw.orderByDesc(SignConfig::getDay);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean add(SignConfigRequest request) {
        if (this.isExistDay(request.getDay(), null).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5b58\u5728\u76f8\u540c\u7684\u8fde\u7eed\u7b7e\u5230\u5929\u6570");
        }
        SignConfig signConfig = new SignConfig();
        BeanUtils.copyProperties((Object)request, (Object)signConfig);
        signConfig.setMark(this.getMark(signConfig));
        return this.save(signConfig);
    }

    private String getMark(SignConfig signConfig) {
        String mark = "";
        if (signConfig.getIsIntegral().booleanValue() && signConfig.getIsExperience().booleanValue()) {
            mark = StrUtil.format((CharSequence)"\u8d60\u9001{}\u79ef\u5206\uff0c\u8d60\u9001{}\u7ecf\u9a8c", (Object[])new Object[]{signConfig.getIntegral(), signConfig.getExperience()});
        } else if (signConfig.getIsIntegral().booleanValue()) {
            mark = StrUtil.format((CharSequence)"\u8d60\u9001{}\u79ef\u5206", (Object[])new Object[]{signConfig.getIntegral()});
        } else if (signConfig.getIsExperience().booleanValue()) {
            mark = StrUtil.format((CharSequence)"\u8d60\u9001{}\u7ecf\u9a8c", (Object[])new Object[]{signConfig.getExperience()});
        }
        return mark;
    }

    @Override
    public Boolean delete(Integer id) {
        SignConfig config = (SignConfig)this.getById(id);
        if (ObjectUtil.isNull((Object)config) || config.getIsDel().booleanValue()) {
            return true;
        }
        if (config.getDay().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u80fd\u5220\u9664\u57fa\u7840\u7b7e\u5230\u914d\u7f6e");
        }
        config.setIsDel(Boolean.valueOf(true));
        return this.updateById(config);
    }

    @Override
    public Boolean editBaseConfig(SignConfigRequest request) {
        SignConfig signConfig = this.getByDay(0);
        signConfig.setIsIntegral(request.getIsIntegral());
        signConfig.setIntegral(request.getIntegral());
        signConfig.setIsExperience(request.getIsExperience());
        signConfig.setExperience(request.getExperience());
        return this.updateById(signConfig);
    }

    @Override
    public Boolean editAwardConfig(SignConfigRequest request) {
        SignConfig signConfig = this.getByIdException(request.getId());
        if (!signConfig.getDay().equals(request.getDay()) && this.isExistDay(request.getDay(), null).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5b58\u5728\u76f8\u540c\u7684\u8fde\u7eed\u7b7e\u5230\u5929\u6570");
        }
        BeanUtils.copyProperties((Object)request, (Object)signConfig);
        signConfig.setMark(this.getMark(signConfig));
        return this.updateById(signConfig);
    }

    private SignConfig getByIdException(Integer id) {
        SignConfig signConfig = (SignConfig)this.getById(id);
        if (ObjectUtil.isNull((Object)signConfig) || signConfig.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.SIGN_COFNIG_NOT_EXIST);
        }
        return signConfig;
    }

    private SignConfig getByDay(Integer day) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SignConfig::getDay, (Object)day);
        lqw.eq(SignConfig::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (SignConfig)this.dao.selectOne((Wrapper)lqw);
    }

    private Boolean isExistDay(Integer day, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SignConfig::getDay, (Object)day);
        if (ObjectUtil.isNotNull((Object)id)) {
            lqw.ne(SignConfig::getId, (Object)id);
        }
        lqw.eq(SignConfig::getIsDel, (Object)false);
        lqw.last(" limit 1");
        SignConfig signConfig = (SignConfig)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)signConfig);
    }
}

