/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.WorkOrderConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.reservation.MerchantServiceStaff;
import com.zbkj.common.model.reservation.ReservationWorkOrder;
import com.zbkj.common.model.system.SystemForm;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.request.WorkOrderPageRequest;
import com.zbkj.common.request.reservation.ForceFinishWorkOrderRequest;
import com.zbkj.common.request.reservation.ReservationWorkOrderAssignRequest;
import com.zbkj.common.request.reservation.ServiceStaffWorkOrderSearchRequest;
import com.zbkj.common.request.reservation.UpdateAgreementRequest;
import com.zbkj.common.request.reservation.WorkOrderRemarkRequest;
import com.zbkj.common.request.reservation.WorkOrderSearchRequest;
import com.zbkj.common.request.reservation.WorkOrderTabsHeaderRequest;
import com.zbkj.common.response.reservation.ReservationWorkOrderDetailResponse;
import com.zbkj.common.response.reservation.ReservationWorkOrderPageResponse;
import com.zbkj.common.response.reservation.WorkOrderCountItemResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.reservation.ReservationWorkOrderDao;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.MerchantInfoService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantServiceStaffService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ReservationWorkOrderService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemFormService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ReservationWorkOrderServiceImpl
extends ServiceImpl<ReservationWorkOrderDao, ReservationWorkOrder>
implements ReservationWorkOrderService {
    @Resource
    private ReservationWorkOrderDao dao;
    @Autowired
    private MerchantServiceStaffService merchantServiceStaffService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private MerchantInfoService merchantInfoService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemFormService systemFormService;
    @Autowired
    private OrderService orderService;

    @Override
    public List<ReservationWorkOrder> findByOrderDetailId(Integer orderDetailId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getOrderDetailId, (Object)orderDetailId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitCountByStaffId(Integer staffId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getServiceStaffId, (Object)staffId);
        lqw.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE);
        lqw.lt(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_REFUND);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getWorkingCountByStaffId(Integer staffId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getServiceStaffId, (Object)staffId);
        lqw.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_SERVICING);
        lqw.lt(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_REFUND);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getWorkedCountByStaffId(Integer staffId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getServiceStaffId, (Object)staffId);
        lqw.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_END);
        lqw.lt(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_REFUND);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<ReservationWorkOrder> findFrontPage(WorkOrderPageRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", request.getStatus());
        map.put("staffId", request.getStaffId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            map.put("keywords", URLUtil.decode((String)request.getKeywords()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            List dateStrList = CrmebUtil.stringToArrayStr((String)request.getDateLimit());
            String startDate = (String)dateStrList.get(0);
            String endDate = (String)dateStrList.get(1);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<ReservationWorkOrder> workOrderList = this.dao.findFrontList(map);
        return CommonPage.copyPageInfo((Page)page, workOrderList);
    }

    @Override
    public ReservationWorkOrder getByWorkOrderNo(String workOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        lqw.last(" limit 1");
        return (ReservationWorkOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageInfo<ReservationWorkOrder> findAwaitReceivePage(Integer merId, String keywords, Integer page, Integer limit) {
        Page orderPage = PageHelper.startPage((int)page, (int)limit);
        List<ReservationWorkOrder> workOrderList = this.dao.findAwaitReceiveList(merId, keywords);
        return CommonPage.copyPageInfo((Page)orderPage, workOrderList);
    }

    @Override
    public Boolean receiveWorkOrder(Integer staffId, String workOrderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE);
        wrapper.set(ReservationWorkOrder::getServiceStaffId, (Object)staffId);
        wrapper.set(ReservationWorkOrder::getAllocateType, (Object)WorkOrderConstants.ALLOCATE_TYPE_WREST);
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        wrapper.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public void autoClockIn(String workOrderNo) {
        ReservationWorkOrder workOrder = this.getByWorkOrderNo(workOrderNo);
        if (!workOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE)) {
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_SERVICING);
        wrapper.set(ReservationWorkOrder::getClockInStatus, (Object)WorkOrderConstants.CLOCK_IN_STATUS_AUTO);
        wrapper.set(ReservationWorkOrder::getServiceStartTime, (Object)new Date());
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        wrapper.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE);
        this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean clockIn(String workOrderNo, String clockInPhoto, String clockInRemark) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_SERVICING);
        wrapper.set(ReservationWorkOrder::getClockInStatus, (Object)WorkOrderConstants.CLOCK_IN_STATUS_MANUAL);
        if (StrUtil.isNotBlank((CharSequence)clockInPhoto)) {
            wrapper.set(ReservationWorkOrder::getClockInPhoto, (Object)this.systemAttachmentService.clearPrefix(clockInPhoto));
        }
        if (StrUtil.isNotBlank((CharSequence)clockInRemark)) {
            wrapper.set(ReservationWorkOrder::getClockInRemark, (Object)clockInRemark);
        }
        wrapper.set(ReservationWorkOrder::getServiceStartTime, (Object)new Date());
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        wrapper.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean serviceEvidence(String workOrderNo, String serviceEvidenceForm, Integer serviceEvidenceFormId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getServiceEvidenceFormId, (Object)serviceEvidenceFormId);
        wrapper.set(ReservationWorkOrder::getServiceEvidenceForm, (Object)this.systemAttachmentService.clearPrefix(serviceEvidenceForm));
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        wrapper.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_SERVICING);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean serviceEnd(String workOrderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_END);
        wrapper.set(ReservationWorkOrder::getServiceEndTime, (Object)new Date());
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        wrapper.eq(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_SERVICING);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<ReservationWorkOrderPageResponse> getWorkOrderListPage(WorkOrderSearchRequest request, SystemAdmin systemAdmin) {
        HashMap map = CollUtil.newHashMap();
        map.put("merId", systemAdmin.getMerId());
        map.put("status", request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getWorkOrderNo())) {
            map.put("workOrderNo", URLUtil.decode((String)request.getWorkOrderNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getServiceType())) {
            map.put("serviceType", request.getServiceType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                String startTime = LocalDateTime.parse(dateLimit.getStartTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                String endTime = LocalDateTime.parse(dateLimit.getEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                map.put("startTime", startTime);
                map.put("endTime", endTime);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("UserKeywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<ReservationWorkOrder> list = this.dao.getWorkOrderListPage(map);
        if (CollectionUtil.isEmpty(list)) {
            return CommonPage.copyPageInfo((Page)page, Collections.emptyList());
        }
        List workOrderResponseList = list.stream().map(workOrder -> {
            OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(workOrder.getOrderDetailId());
            ReservationWorkOrderPageResponse reservationWorkOrderResponse = new ReservationWorkOrderPageResponse();
            BeanUtils.copyProperties((Object)workOrder, (Object)reservationWorkOrderResponse);
            reservationWorkOrderResponse.setProductId(orderDetail.getProductId());
            reservationWorkOrderResponse.setProductName(orderDetail.getProductName());
            reservationWorkOrderResponse.setImage(orderDetail.getImage());
            reservationWorkOrderResponse.setSku(orderDetail.getSku());
            return reservationWorkOrderResponse;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, workOrderResponseList);
    }

    @Override
    public WorkOrderCountItemResponse getWorkOrderStatusNum(WorkOrderTabsHeaderRequest request, SystemAdmin systemAdmin) {
        Integer merId = systemAdmin.getMerId();
        WorkOrderCountItemResponse countItemResponse = new WorkOrderCountItemResponse();
        countItemResponse.setAll(this.getWorkOrderCount(request, 0, merId));
        countItemResponse.setUnReceive(this.getWorkOrderCount(request, 1, merId));
        countItemResponse.setReceived(this.getWorkOrderCount(request, 2, merId));
        countItemResponse.setInService(this.getWorkOrderCount(request, 3, merId));
        countItemResponse.setEndService(this.getWorkOrderCount(request, 4, merId));
        countItemResponse.setRefunded(this.getWorkOrderCount(request, 9, merId));
        return countItemResponse;
    }

    @Override
    public ReservationWorkOrderDetailResponse getInfo(String workOrderNo, SystemAdmin systemAdmin) {
        ReservationWorkOrder reservationWorkOrder = this.getByWorkOrderNo(workOrderNo);
        ReservationWorkOrderDetailResponse reservationWorkOrderDetailResponse = new ReservationWorkOrderDetailResponse();
        BeanUtils.copyProperties((Object)reservationWorkOrder, (Object)reservationWorkOrderDetailResponse);
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(reservationWorkOrder.getOrderNo());
        if (ObjectUtil.isNotNull((Object)merchantOrder)) {
            reservationWorkOrderDetailResponse.setUserRemark(merchantOrder.getUserRemark());
        }
        reservationWorkOrderDetailResponse.setOrderDetail((OrderDetail)this.orderDetailService.getById(reservationWorkOrder.getOrderDetailId()));
        reservationWorkOrderDetailResponse.setServiceStaff((MerchantServiceStaff)this.merchantServiceStaffService.getById(reservationWorkOrder.getServiceStaffId()));
        if (reservationWorkOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_END)) {
            long serviceDuration = DateUtil.between((Date)reservationWorkOrder.getServiceStartTime(), (Date)reservationWorkOrder.getServiceEndTime(), (DateUnit)DateUnit.MINUTE, (boolean)true);
            String duration = CrmebDateUtil.minutesToHoursMinutes((long)serviceDuration);
            reservationWorkOrderDetailResponse.setServiceDuration(duration);
        }
        if (reservationWorkOrder.getServiceEvidenceFormId() > 0) {
            SystemForm systemForm = (SystemForm)this.systemFormService.getById(reservationWorkOrder.getServiceEvidenceFormId());
            reservationWorkOrderDetailResponse.setServiceEvidenceFormValue(systemForm.getFormValue());
        }
        if (reservationWorkOrder.getReservationFormId() > 0) {
            SystemForm systemForm = (SystemForm)this.systemFormService.getById(reservationWorkOrder.getReservationFormId());
            reservationWorkOrderDetailResponse.setReservationFormValue(systemForm.getFormValue());
        }
        if (StringUtils.isNotBlank((CharSequence)reservationWorkOrder.getCollaboratorIds())) {
            String[] ids = reservationWorkOrder.getCollaboratorIds().split(",");
            List collaboratorStaffs = this.merchantServiceStaffService.listByIds(Arrays.asList(ids));
            reservationWorkOrderDetailResponse.setCollaboratorStaffs(collaboratorStaffs);
        }
        return reservationWorkOrderDetailResponse;
    }

    @Override
    public Boolean assign(ReservationWorkOrderAssignRequest request, SystemAdmin systemAdmin) {
        MerchantInfo merchantInfo;
        List workOrderNoList = request.getWorkOrderNoList();
        Integer serviceStaffId = request.getServiceStaffId();
        this.validateWorkOrderAndStaff(workOrderNoList, serviceStaffId, systemAdmin);
        ArrayList updateWorkOrderNoList = new ArrayList();
        workOrderNoList.forEach(workOrderNo -> {
            ReservationWorkOrder workOrder = this.getByWorkOrderNo((String)workOrderNo);
            if (workOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_AWAIT) && !workOrder.getRefundStatus().equals(WorkOrderConstants.REFUND_STATUS_REFUND)) {
                updateWorkOrderNoList.add(workOrderNo);
            }
        });
        if (CollUtil.isEmpty(updateWorkOrderNoList)) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(ReservationWorkOrder::getWorkOrderNo, updateWorkOrderNoList);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE)).set(ReservationWorkOrder::getServiceStaffId, (Object)serviceStaffId)).set(ReservationWorkOrder::getAllocateType, (Object)WorkOrderConstants.ALLOCATE_TYPE_APPOINT);
        boolean update = this.update((Wrapper)updateWrapper);
        if (update && (merchantInfo = this.merchantInfoService.getByMerId(systemAdmin.getMerId())).getClockInType().equals(1)) {
            workOrderNoList.forEach(s -> this.asyncService.workOrderAutoClockIn((String)s));
        }
        return update;
    }

    @Override
    public Boolean reassign(ReservationWorkOrderAssignRequest request, SystemAdmin systemAdmin) {
        List workOrderNoList = request.getWorkOrderNoList();
        Integer serviceStaffId = request.getServiceStaffId();
        ArrayList updateWorkOrderNoList = new ArrayList();
        this.validateWorkOrderAndStaff(workOrderNoList, serviceStaffId, systemAdmin);
        workOrderNoList.forEach(workOrderNo -> {
            ReservationWorkOrder workOrder = this.getByWorkOrderNo((String)workOrderNo);
            if (ObjectUtil.isNotNull((Object)workOrder) && !Objects.equals(workOrder.getServiceStaffId(), serviceStaffId) && (workOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_SERVICING) || workOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_AWAIT_SERVICE)) && !workOrder.getRefundStatus().equals(WorkOrderConstants.REFUND_STATUS_REFUND)) {
                updateWorkOrderNoList.add(workOrderNo);
            }
        });
        if (CollUtil.isEmpty(updateWorkOrderNoList)) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(ReservationWorkOrder::getWorkOrderNo, updateWorkOrderNoList);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getServiceStaffId, (Object)serviceStaffId)).set(ReservationWorkOrder::getCollaboratorIds, null)).set(ReservationWorkOrder::getIsEditAllocate, (Object)Boolean.TRUE);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean updateAgreement(UpdateAgreementRequest request, SystemAdmin systemAdmin) {
        List workOrderNoList = request.getWorkOrderNoList();
        String fullDateTimeStr = request.getReservationDate() + " " + request.getReservationTimeSlot().split("-")[0] + ":00";
        DateTime reservationDateTime = DateUtil.parseDateTime((String)fullDateTimeStr);
        if (reservationDateTime.before(new Date())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9884\u7ea6\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        ArrayList updateHomeWorkOrderNoList = new ArrayList();
        ArrayList updateStoreWorkOrderNoList = new ArrayList();
        workOrderNoList.forEach(workOrderNo -> {
            ReservationWorkOrder workOrder = this.getByWorkOrderNo((String)workOrderNo);
            if (ObjectUtil.isNotNull((Object)workOrder) && Objects.equals(workOrder.getMerId(), systemAdmin.getMerId()) && !workOrder.getServiceStatus().equals(WorkOrderConstants.SERVICE_STATUS_END) && !workOrder.getRefundStatus().equals(WorkOrderConstants.REFUND_STATUS_REFUND)) {
                if (workOrder.getServiceType().equals(WorkOrderConstants.SERVICE_TYPE_HOME_SERVICE)) {
                    updateHomeWorkOrderNoList.add(workOrderNo);
                } else {
                    updateStoreWorkOrderNoList.add(workOrderNo);
                }
            }
        });
        if (CollUtil.isNotEmpty(updateHomeWorkOrderNoList) && StrUtil.isEmpty((CharSequence)request.getUserAddress())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u542b\u6709\u4e0a\u95e8\u670d\u52a1\u5de5\u5355\u5fc5\u987b\u586b\u5199\u7528\u6237\u5730\u5740");
        }
        LambdaUpdateWrapper updateHomeWrapper = null;
        LambdaUpdateWrapper updateStoreWrapper = null;
        if (CollUtil.isNotEmpty(updateHomeWorkOrderNoList)) {
            updateHomeWrapper = new LambdaUpdateWrapper();
            updateHomeWrapper.in(ReservationWorkOrder::getWorkOrderNo, updateHomeWorkOrderNoList);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateHomeWrapper.set(ReservationWorkOrder::getReservationDate, (Object)request.getReservationDate())).set(ReservationWorkOrder::getReservationTimeSlot, (Object)request.getReservationTimeSlot())).set(ReservationWorkOrder::getUserName, (Object)request.getUserName())).set(ReservationWorkOrder::getUserPhone, (Object)request.getUserPhone())).set(ReservationWorkOrder::getUserAddress, (Object)request.getUserAddress())).set(ReservationWorkOrder::getIsEditReservation, (Object)Boolean.TRUE);
        }
        if (CollUtil.isNotEmpty(updateStoreWorkOrderNoList)) {
            updateStoreWrapper = new LambdaUpdateWrapper();
            updateStoreWrapper.in(ReservationWorkOrder::getWorkOrderNo, updateStoreWorkOrderNoList);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateStoreWrapper.set(ReservationWorkOrder::getReservationDate, (Object)request.getReservationDate())).set(ReservationWorkOrder::getReservationTimeSlot, (Object)request.getReservationTimeSlot())).set(ReservationWorkOrder::getUserName, (Object)request.getUserName())).set(ReservationWorkOrder::getUserPhone, (Object)request.getUserPhone())).set(ReservationWorkOrder::getIsEditReservation, (Object)Boolean.TRUE);
        }
        LambdaUpdateWrapper finalUpdateHomeWrapper = updateHomeWrapper;
        LambdaUpdateWrapper finalUpdateStoreWrapper = updateStoreWrapper;
        return (Boolean)this.transactionTemplate.execute(status -> {
            boolean homeUpdateResult = true;
            boolean storeUpdateResult = true;
            if (ObjectUtil.isNotNull((Object)finalUpdateHomeWrapper)) {
                homeUpdateResult = this.update((Wrapper)finalUpdateHomeWrapper);
            }
            if (ObjectUtil.isNotNull((Object)finalUpdateStoreWrapper)) {
                storeUpdateResult = this.update((Wrapper)finalUpdateStoreWrapper);
            }
            return homeUpdateResult && storeUpdateResult;
        });
    }

    @Override
    public Boolean updateAgreementByStore(String workOrderNo, String reservationDate, String reservationTimeSlot, String userName, String userPhone) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getReservationDate, (Object)reservationDate)).set(ReservationWorkOrder::getReservationTimeSlot, (Object)reservationTimeSlot)).set(ReservationWorkOrder::getUserName, (Object)userName)).set(ReservationWorkOrder::getUserPhone, (Object)userPhone)).set(ReservationWorkOrder::getIsEditReservation, (Object)Boolean.TRUE);
        updateWrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean updateAgreementByHome(String workOrderNo, String reservationDate, String reservationTimeSlot, String userName, String userPhone, String userAddress, String longitude, String latitude) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getReservationDate, (Object)reservationDate)).set(ReservationWorkOrder::getReservationTimeSlot, (Object)reservationTimeSlot)).set(ReservationWorkOrder::getUserName, (Object)userName)).set(ReservationWorkOrder::getUserPhone, (Object)userPhone)).set(ReservationWorkOrder::getUserAddress, (Object)userAddress)).set(ReservationWorkOrder::getLongitude, (Object)longitude)).set(ReservationWorkOrder::getLatitude, (Object)latitude)).set(ReservationWorkOrder::getIsEditReservation, (Object)Boolean.TRUE);
        updateWrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean batchUpdateAgreement(List<String> workOrderNoList, String reservationDate, String reservationTimeSlot) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getReservationDate, (Object)reservationDate)).set(ReservationWorkOrder::getReservationTimeSlot, (Object)reservationTimeSlot)).set(ReservationWorkOrder::getIsEditReservation, (Object)Boolean.TRUE);
        updateWrapper.in(ReservationWorkOrder::getWorkOrderNo, workOrderNoList);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean forceFinish(ForceFinishWorkOrderRequest request, SystemAdmin systemAdmin) {
        ArrayList updateWorkOrderNoList = new ArrayList();
        ArrayList orderNoList = new ArrayList();
        request.getWorkOrderNoList().forEach(workOrderNo -> {
            ReservationWorkOrder workOrder = this.getByWorkOrderNo((String)workOrderNo);
            if (ObjectUtil.isNotNull((Object)workOrder) && Objects.equals(workOrder.getMerId(), systemAdmin.getMerId()) && !workOrder.getRefundStatus().equals(WorkOrderConstants.REFUND_STATUS_REFUND)) {
                updateWorkOrderNoList.add(workOrderNo);
                orderNoList.add(workOrder.getOrderNo());
            }
        });
        if (CollUtil.isEmpty(updateWorkOrderNoList)) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(ReservationWorkOrder::getWorkOrderNo, updateWorkOrderNoList);
        ((LambdaUpdateWrapper)updateWrapper.set(ReservationWorkOrder::getServiceStatus, (Object)WorkOrderConstants.SERVICE_STATUS_END)).set(ReservationWorkOrder::getServiceEndTime, (Object)new Date());
        Boolean update = this.update((Wrapper)updateWrapper);
        if (update.booleanValue()) {
            orderNoList.stream().distinct().forEach(this::workOrderEndOrderFlow);
        }
        return update;
    }

    private void workOrderEndOrderFlow(String orderNo) {
        boolean isEnd = true;
        List<ReservationWorkOrder> workOrderList = this.findByOrderNo(orderNo);
        for (ReservationWorkOrder workOrder : workOrderList) {
            if (workOrder.getRefundStatus().equals(WorkOrderConstants.REFUND_STATUS_REFUND) || workOrder.getServiceStatus() >= WorkOrderConstants.SERVICE_STATUS_END) continue;
            isEnd = false;
            break;
        }
        if (!isEnd) {
            return;
        }
        Order order = this.orderService.getByOrderNo(orderNo);
        if (order.getStatus().equals(OrderConstants.ORDER_STATUS_TAKE_DELIVERY)) {
            return;
        }
        order.setStatus(OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
        order.setReceivingTime((Date)DateUtil.date());
        order.setUpdateTime((Date)DateUtil.date());
        this.orderService.updateById(order);
        this.orderDetailService.takeDelivery(order.getOrderNo());
    }

    @Override
    public List<ReservationWorkOrder> getOverViewData(Map<String, Object> map) {
        return this.dao.getOverViewData(map);
    }

    @Override
    public List<ReservationWorkOrder> findByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getOrderNo, (Object)orderNo);
        lqw.orderByDesc(ReservationWorkOrder::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ReservationWorkOrder> findNoRefundByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getOrderNo, (Object)orderNo);
        lqw.eq(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_NO);
        lqw.orderByDesc(ReservationWorkOrder::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean batchRefundByIdList(List<Integer> workOrderIdList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_REFUND);
        wrapper.set(ReservationWorkOrder::getUpdateTime, (Object)new Date());
        wrapper.in(ReservationWorkOrder::getId, workOrderIdList);
        wrapper.eq(ReservationWorkOrder::getRefundStatus, (Object)WorkOrderConstants.REFUND_STATUS_NO);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Integer getCountByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ReservationWorkOrder::getOrderNo, (Object)orderNo);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean isExistWorkByOrderNo(String orderNo) {
        return this.getCountByOrderNo(orderNo) > 0;
    }

    @Override
    public List<Integer> findIdByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ReservationWorkOrder::getId});
        lqw.eq(ReservationWorkOrder::getOrderNo, (Object)orderNo);
        List workOrderList = this.dao.selectList((Wrapper)lqw);
        return workOrderList.stream().map(ReservationWorkOrder::getId).collect(Collectors.toList());
    }

    @Override
    public Boolean merchantMark(WorkOrderRemarkRequest request, SystemAdmin systemAdmin) {
        ReservationWorkOrder workOrder = this.getByWorkOrderNo(request.getWorkOrderNo());
        if (ObjectUtil.isNull((Object)workOrder) || !ObjectUtil.equal((Object)workOrder.getMerId(), (Object)systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5de5\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u6237");
        }
        return this.workRemark(request.getWorkOrderNo(), request.getRemark());
    }

    @Override
    public Boolean workRemark(String workOrderNo, String remark) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ReservationWorkOrder::getRemark, (Object)remark);
        wrapper.eq(ReservationWorkOrder::getWorkOrderNo, (Object)workOrderNo);
        return this.update((Wrapper)wrapper);
    }

    private ReservationWorkOrder validateWorkOrder(String workOrderNo, Integer serviceStaffId, SystemAdmin systemAdmin) {
        MerchantServiceStaff staff = (MerchantServiceStaff)this.merchantServiceStaffService.getById(serviceStaffId);
        if (ObjectUtil.isNull((Object)staff) || !Objects.equals(staff.getMerId(), systemAdmin.getMerId()) || staff.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u670d\u52a1\u5458\u5de5\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u6237");
        }
        if (staff.getStatus() != 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8be5\u670d\u52a1\u5458\u5de5\u72b6\u6001\u672a\u5f00\u542f");
        }
        ReservationWorkOrder workOrder = this.getByWorkOrderNo(workOrderNo);
        if (ObjectUtil.isNull((Object)workOrder) || !Objects.equals(workOrder.getMerId(), systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5de5\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u6237");
        }
        return workOrder;
    }

    private void validateWorkOrderAndStaff(List<String> workOrderNoList, Integer serviceStaffId, SystemAdmin systemAdmin) {
        MerchantServiceStaff staff = (MerchantServiceStaff)this.merchantServiceStaffService.getById(serviceStaffId);
        if (ObjectUtil.isNull((Object)staff) || !Objects.equals(staff.getMerId(), systemAdmin.getMerId()) || staff.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u670d\u52a1\u5458\u5de5\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u6237");
        }
        if (staff.getStatus() != 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8be5\u670d\u52a1\u5458\u5de5\u72b6\u6001\u672a\u5f00\u542f");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ReservationWorkOrder::getWorkOrderNo, workOrderNoList);
        lqw.eq(ReservationWorkOrder::getMerId, (Object)systemAdmin.getMerId());
        int count = this.dao.selectCount((Wrapper)lqw);
        if (count != workOrderNoList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5b58\u5728\u5de5\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u6237");
        }
    }

    private Map<String, Object> buildBaseMap(Integer merId, ServiceStaffWorkOrderSearchRequest request) {
        String keywords;
        HashMap map = CollUtil.newHashMap();
        map.put("merId", merId);
        if (ObjectUtil.isNotEmpty((Object)request.getReservationKeyword())) {
            keywords = URLUtil.decode((String)request.getReservationKeyword());
            map.put("reservationKeywords", keywords);
        }
        if (ObjectUtil.isNotNull((Object)request.getServiceType()) && request.getServiceType() > 0) {
            map.put("serviceType", request.getServiceType());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getReservationDate())) {
            map.put("reservationDate", request.getReservationDate());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getServiceStatus())) {
            Set statusSet = Arrays.stream(request.getServiceStatus().split(",")).collect(Collectors.toCollection(LinkedHashSet::new));
            if (statusSet.contains("2")) {
                statusSet.add("1");
            }
            map.put("serviceStatus", statusSet);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("UserKeywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        return map;
    }

    private Integer getWorkOrderCount(WorkOrderTabsHeaderRequest request, int status, Integer merId) {
        HashMap map = CollUtil.newHashMap();
        map.put("merId", merId);
        map.put("status", status);
        if (StrUtil.isNotBlank((CharSequence)request.getWorkOrderNo())) {
            map.put("workOrderNo", URLUtil.decode((String)request.getWorkOrderNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (ObjectUtil.isNotNull((Object)request.getServiceType())) {
            map.put("serviceType", request.getServiceType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("UserKeywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        return this.dao.getWorkOrderCount(map);
    }
}

