/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderV3Request;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.GroupDataConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.RechargeOrderSearchRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.request.UserRechargeRequest;
import com.zbkj.common.response.OrderPayResultResponse;
import com.zbkj.common.response.RechargePackageResponse;
import com.zbkj.common.response.UserRechargeItemResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoDetailVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoVo;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.WxPayJsResultVo;
import com.zbkj.service.dao.RechargeOrderDao;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemGroupDataService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.WechatPayService;
import com.zbkj.service.service.WechatService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RechargeOrderServiceImpl
extends ServiceImpl<RechargeOrderDao, RechargeOrder>
implements RechargeOrderService {
    @Resource
    private RechargeOrderDao dao;
    private static final Logger logger = LoggerFactory.getLogger(RechargeOrderServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemGroupDataService systemGroupDataService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private BillService billService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private WechatPayService wechatPayService;

    @Override
    public PageInfo<RechargeOrder> getAdminPage(RechargeOrderSearchRequest request) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String orderNo = URLUtil.decode((String)request.getKeywords());
            map.put("orderNo", orderNo);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<RechargeOrder> rechargeOrderList = this.dao.getAdminPage(map);
        return CommonPage.copyPageInfo((Page)page, rechargeOrderList);
    }

    @Override
    public RechargePackageResponse getRechargePackage() {
        RechargePackageResponse userRechargeResponse = new RechargePackageResponse();
        userRechargeResponse.setPackageList(this.systemGroupDataService.getListByGid(GroupDataConstants.GROUP_DATA_ID_RECHARGE_PACKAGE, UserRechargeItemResponse.class));
        String rechargeAttention = this.systemConfigService.getValueByKey("recharge_attention");
        List rechargeAttentionList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)rechargeAttention)) {
            rechargeAttentionList = CrmebUtil.stringToArrayStrRegex((String)rechargeAttention, (String)"\n");
        }
        userRechargeResponse.setNoticeList(rechargeAttentionList);
        return userRechargeResponse;
    }

    @Override
    public OrderPayResultResponse userRechargeOrderCreate(UserRechargeRequest request) {
        BigDecimal rechargeMinAmount;
        User user = this.userService.getInfo();
        if (ObjectUtil.isNull((Object)request.getPrice()) && ObjectUtil.isNull((Object)request.getGroupDataId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5145\u503c\u5957\u9910\u6216\u586b\u5199\u81ea\u5b9a\u4e49\u5145\u503c\u91d1\u989d");
        }
        BigDecimal rechargePrice = BigDecimal.ZERO;
        BigDecimal gainPrice = BigDecimal.ZERO;
        String rechargeMinAmountStr = this.systemConfigService.getValueByKey("store_user_min_recharge");
        BigDecimal bigDecimal = rechargeMinAmount = StrUtil.isBlank((CharSequence)rechargeMinAmountStr) ? BigDecimal.ZERO : new BigDecimal(rechargeMinAmountStr);
        if (ObjectUtil.isNotNull((Object)request.getPrice())) {
            if (request.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5145\u503c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            rechargePrice = request.getPrice();
        } else {
            UserRechargeItemResponse rechargePackage = this.systemGroupDataService.getNormalInfo(request.getGroupDataId(), UserRechargeItemResponse.class);
            if (ObjectUtil.isNull((Object)rechargePackage)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u60a8\u9009\u62e9\u7684\u5145\u503c\u65b9\u5f0f\u5df2\u4e0b\u67b6");
            }
            rechargePrice = new BigDecimal(rechargePackage.getPrice());
            gainPrice = new BigDecimal(rechargePackage.getGiveMoney());
        }
        if (rechargePrice.compareTo(rechargeMinAmount) < 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5145\u503c\u91d1\u989d\u5c0f\u4e8e\u6700\u4f4e\u5145\u503c\u91d1\u989d");
        }
        String rechargeNo = CrmebUtil.getOrderNo((String)"CZ");
        OrderPayResultResponse response = new OrderPayResultResponse();
        RechargeOrder rechargeOrder = new RechargeOrder();
        if (request.getPayType().equals("weixin")) {
            MyRecord record = this.wechatPayment(rechargePrice, request.getPayChannel(), user.getId());
            WxPayJsResultVo vo = (WxPayJsResultVo)record.get("vo");
            String outTradeNo = record.getStr("outTradeNo");
            response.setJsConfig(vo);
            rechargeOrder.setOutTradeNo(outTradeNo);
        }
        if (request.getPayType().equals("alipay")) {
            String result = this.aliPayService.pay(rechargeNo, rechargePrice, "recharge", request.getPayChannel(), "");
            response.setAlipayRequest(result);
            rechargeOrder.setOutTradeNo(rechargeNo);
        }
        rechargeOrder.setUid(user.getId());
        rechargeOrder.setOrderNo(rechargeNo);
        rechargeOrder.setPrice(rechargePrice);
        rechargeOrder.setGivePrice(gainPrice);
        rechargeOrder.setPayType(request.getPayType());
        rechargeOrder.setPayChannel(request.getPayChannel());
        boolean save = this.save(rechargeOrder);
        if (!save) {
            throw new CrmebException("\u751f\u6210\u5145\u503c\u8ba2\u5355\u5931\u8d25!");
        }
        return response;
    }

    private MyRecord wechatPayment(BigDecimal rechargePrice, String payChannel, Integer uid) {
        WxPayJsResultVo vo = this.wechatUnifiedorder(rechargePrice, payChannel, uid);
        MyRecord record = new MyRecord();
        record.set("outTradeNo", (Object)vo.getOutTradeNo());
        vo.setOutTradeNo(null);
        record.set("vo", (Object)vo);
        return record;
    }

    private WxPayJsResultVo wechatUnifiedorder(BigDecimal rechargePrice, String payChannel, Integer uid) {
        MyRecord myRecord;
        String outTradeNo;
        String paySource;
        UserToken userToken = new UserToken();
        userToken.setToken("");
        if (payChannel.equals("public")) {
            userToken = this.userTokenService.getTokenByUserId(uid, UserConstants.USER_TOKEN_TYPE_WECHAT);
        }
        if (payChannel.equals("mini")) {
            userToken = this.userTokenService.getTokenByUserId(uid, UserConstants.USER_TOKEN_TYPE_ROUTINE);
        }
        if ((paySource = payChannel).equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayUnifiedOrderRequest unifiedOrderRequest = this.buildWxPayUnifiedOrderRequest(rechargePrice, uid);
            outTradeNo = unifiedOrderRequest.getOutTradeNo();
            myRecord = this.wechatPayService.createOrder(unifiedOrderRequest, userToken.getToken(), payChannel, paySource, apiDomain);
        } else {
            WxPayUnifiedOrderV3Request v3Request = this.buildWxPayUnifiedOrderV3Request(rechargePrice, uid);
            outTradeNo = v3Request.getOutTradeNo();
            myRecord = this.wechatPayService.createV3Order(v3Request, userToken.getToken(), payChannel, paySource, apiDomain);
        }
        WxPayJsResultVo vo = new WxPayJsResultVo();
        vo.setOutTradeNo(outTradeNo);
        switch (payChannel) {
            case "mini": 
            case "video": 
            case "public": {
                vo.setAppId(myRecord.getStr("appId"));
                vo.setNonceStr(myRecord.getStr("nonceStr"));
                vo.setPackages(myRecord.getStr("package"));
                vo.setSignType(myRecord.getStr("signType"));
                vo.setPaySign(myRecord.getStr("paySign"));
                vo.setTimeStamp(myRecord.getStr("timeStamp"));
                break;
            }
            case "h5": {
                vo.setMwebUrl(myRecord.getStr("mwebUrl"));
                break;
            }
            case "native": {
                vo.setMwebUrl(myRecord.getStr("codeUrl"));
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                vo.setAppId(myRecord.getStr("appId"));
                vo.setPartnerid(myRecord.getStr("partnerId"));
                vo.setPrepayid(myRecord.getStr("prepayId"));
                vo.setPackages(myRecord.getStr("package"));
                vo.setNonceStr(myRecord.getStr("nonceStr"));
                vo.setTimeStamp(myRecord.getStr("timeStamp"));
                vo.setPaySign(myRecord.getStr("sign"));
            }
        }
        return vo;
    }

    private WxPayUnifiedOrderRequest buildWxPayUnifiedOrderRequest(BigDecimal rechargePrice, Integer uid) {
        WxPayUnifiedOrderRequest orderRequest = new WxPayUnifiedOrderRequest();
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        orderRequest.setBody(siteName);
        AttachVo attachVo = new AttachVo("recharge", uid);
        orderRequest.setAttach(JSONObject.toJSONString((Object)attachVo));
        orderRequest.setOutTradeNo(CrmebUtil.getOrderNo((String)"WX"));
        orderRequest.setTotalFee(Integer.valueOf(rechargePrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
        orderRequest.setSpbillCreateIp(RequestUtil.getClientIp());
        String domain = this.systemConfigService.getValueByKeyException("site_url");
        CreateOrderH5SceneInfoVo createOrderH5SceneInfoVo = new CreateOrderH5SceneInfoVo(new CreateOrderH5SceneInfoDetailVo(domain, this.systemConfigService.getValueByKeyException("site_name")));
        orderRequest.setSceneInfo(JSONObject.toJSONString((Object)createOrderH5SceneInfoVo));
        return orderRequest;
    }

    private WxPayUnifiedOrderV3Request buildWxPayUnifiedOrderV3Request(BigDecimal rechargePrice, Integer uid) {
        WxPayUnifiedOrderV3Request orderRequest = new WxPayUnifiedOrderV3Request();
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        orderRequest.setDescription(siteName);
        orderRequest.setOutTradeNo(CrmebUtil.getOrderNo((String)"WX"));
        AttachVo attachVo = new AttachVo("recharge", uid);
        orderRequest.setAttach(JSONObject.toJSONString((Object)attachVo));
        WxPayUnifiedOrderV3Request.Amount amount = new WxPayUnifiedOrderV3Request.Amount();
        amount.setTotal(Integer.valueOf(rechargePrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
        orderRequest.setAmount(amount);
        return orderRequest;
    }

    @Override
    public RechargeOrder getByOutTradeNo(String outTradeNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getOutTradeNo, (Object)outTradeNo);
        lqw.last(" limit 1");
        return (RechargeOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean paySuccessAfter(RechargeOrder rechargeOrder) {
        User user = (User)this.userService.getById(rechargeOrder.getUid());
        BigDecimal addPrice = rechargeOrder.getPrice().add(rechargeOrder.getGivePrice());
        BigDecimal balance = user.getNowMoney().add(addPrice);
        UserBalanceRecord record = new UserBalanceRecord();
        record.setUid(rechargeOrder.getUid());
        record.setLinkId(rechargeOrder.getOrderNo());
        record.setLinkType("recharge");
        record.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        record.setAmount(addPrice);
        record.setBalance(balance);
        record.setRemark(StrUtil.format((CharSequence)"\u5145\u503c\u6210\u529f\uff0c\u4f59\u989d\u589e\u52a0{}\u5143", (Object[])new Object[]{addPrice}));
        Bill bill = new Bill();
        bill.setOrderNo(rechargeOrder.getOrderNo());
        bill.setUid(rechargeOrder.getUid());
        bill.setPm(BillConstants.BILL_PM_ADD);
        bill.setAmount(rechargeOrder.getPrice());
        bill.setType("recharge_user");
        bill.setMark(StrUtil.format((CharSequence)"\u5145\u503c\u8ba2\u5355\uff0c\u7528\u6237\u5145\u503c\u91d1\u989d{}\u5143", (Object[])new Object[]{rechargeOrder.getPrice()}));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            boolean updatePaid = this.updatePaid(rechargeOrder.getId(), rechargeOrder.getOrderNo());
            if (!updatePaid) {
                logger.error("\u5145\u503c\u8ba2\u5355\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0corderNo = {}", (Object)rechargeOrder.getOrderNo());
                e.setRollbackOnly();
                return false;
            }
            this.userService.updateNowMoney(user.getId(), addPrice, "add");
            this.userBalanceRecordService.save(record);
            this.billService.save(bill);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.asyncService.sendRechargeSuccessNotification(rechargeOrder, user);
        }
        return execute;
    }

    private boolean updatePaid(Integer id, String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(RechargeOrder::getPaid, (Object)true);
        wrapper.set(RechargeOrder::getPayTime, (Object)CrmebDateUtil.nowDateTime());
        wrapper.eq(RechargeOrder::getId, (Object)id);
        wrapper.eq(RechargeOrder::getOrderNo, (Object)orderNo);
        wrapper.eq(RechargeOrder::getPaid, (Object)false);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<RechargeOrder> findByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getPaid, (Object)true);
        lqw.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public RechargeOrder getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        return (RechargeOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<RechargeOrder> findAwaitUploadWechatList() {
        DateTime date = DateUtil.date();
        DateTime offsetMinute = DateUtil.offsetMinute((Date)date, (int)-10);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getPaid, (Object)1);
        lqw.eq(RechargeOrder::getIsWechatShipping, (Object)0);
        lqw.eq(RechargeOrder::getPayType, (Object)"weixin");
        lqw.eq(RechargeOrder::getPayChannel, (Object)"mini");
        lqw.le(RechargeOrder::getPayTime, (Object)offsetMinute);
        return this.dao.selectList((Wrapper)lqw);
    }
}

