/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.service.service.QiNiuService;
import com.zbkj.service.service.SystemConfigService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiNiuServiceImpl
implements QiNiuService {
    private static final Logger logger = LoggerFactory.getLogger(QiNiuServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public void uploadFile(String webPth, String localFile, File file) {
        if (!file.exists()) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
            throw new CrmebException("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
        }
        UploadManager uploadManager = this.getUploadManager();
        String uploadToken = this.getUploadToken();
        try {
            Response put = uploadManager.put(file, webPth, uploadToken);
            put.close();
        }
        catch (QiniuException ex) {
            logger.error("\u4e03\u725b\u4e91\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)ex);
            throw new CrmebException(ex.getMessage());
        }
    }

    private String getUploadToken() {
        String accessKey = this.systemConfigService.getValueByKeyException("qnAccessKey");
        String secretKey = this.systemConfigService.getValueByKeyException("qnSecretKey");
        String bucketName = this.systemConfigService.getValueByKeyException("qnStorageName");
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        return auth.uploadToken(bucketName);
    }

    private UploadManager getUploadManager() {
        Configuration cfg = new Configuration(Region.autoRegion());
        return new UploadManager(cfg);
    }
}

