/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.product.ProductRule;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductRuleRequest;
import com.zbkj.common.request.ProductRuleSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.ProductRuleDao;
import com.zbkj.service.service.ProductRuleService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ProductRuleServiceImpl
extends ServiceImpl<ProductRuleDao, ProductRule>
implements ProductRuleService {
    @Resource
    private ProductRuleDao dao;

    @Override
    public PageInfo<ProductRule> getList(ProductRuleSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ProductRule::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lambdaQueryWrapper.like(ProductRule::getRuleName, (Object)keywords);
        }
        lambdaQueryWrapper.orderByDesc(ProductRule::getId);
        List list = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public boolean save(ProductRuleRequest productRuleRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (this.existRuleName(productRuleRequest.getRuleName(), systemAdmin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RULE_EXIST);
        }
        ProductRule productRule = new ProductRule();
        BeanUtils.copyProperties((Object)productRuleRequest, (Object)productRule);
        productRule.setMerId(systemAdmin.getMerId());
        return this.save(productRule);
    }

    private Boolean existRuleName(String ruleName, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductRule::getId});
        lqw.eq(ProductRule::getRuleName, (Object)ruleName);
        lqw.eq(ProductRule::getMerId, (Object)merId);
        lqw.last(" limit 1");
        ProductRule productRule = (ProductRule)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)productRule);
    }

    @Override
    public Boolean updateRule(ProductRuleRequest productRuleRequest) {
        if (ObjectUtil.isNull((Object)productRuleRequest.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u9009\u62e9\u89c4\u683c");
        }
        this.getRuleInfo(productRuleRequest.getId());
        ProductRule newProductRule = new ProductRule();
        BeanUtils.copyProperties((Object)productRuleRequest, (Object)newProductRule);
        return this.updateById(newProductRule);
    }

    @Override
    public Boolean deleteById(Integer id) {
        this.getRuleInfo(id);
        return this.removeById(id);
    }

    @Override
    public ProductRule getRuleInfo(Integer id) {
        ProductRule productRule = (ProductRule)this.getById(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (ObjectUtil.isNull((Object)productRule) || !admin.getMerId().equals(productRule.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RULE_NOT_EXIST);
        }
        return productRule;
    }
}

