/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.product.MerchantProductGuaranteeGroup;
import com.zbkj.common.model.product.ProductGuaranteeGroup;
import com.zbkj.common.request.ProductGuaranteeGroupAddRequest;
import com.zbkj.common.response.ProductGuaranteeGroupListResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.ProductGuaranteeGroupDao;
import com.zbkj.service.service.MerchantProductGuaranteeGroupService;
import com.zbkj.service.service.ProductGuaranteeGroupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductGuaranteeGroupServiceImpl
extends ServiceImpl<ProductGuaranteeGroupDao, ProductGuaranteeGroup>
implements ProductGuaranteeGroupService {
    @Resource
    private ProductGuaranteeGroupDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantProductGuaranteeGroupService merchantProductGuaranteeGroupService;

    @Override
    public Boolean add(ProductGuaranteeGroupAddRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        String gids = request.getGids();
        List gidList = CrmebUtil.stringToArray((String)gids);
        ProductGuaranteeGroup productGuaranteeGroup = new ProductGuaranteeGroup();
        productGuaranteeGroup.setMerId(systemAdmin.getMerId());
        productGuaranteeGroup.setName(request.getName());
        productGuaranteeGroup.setIsDel(Boolean.valueOf(false));
        List mpGroupList = gidList.stream().map(gid -> {
            MerchantProductGuaranteeGroup group = new MerchantProductGuaranteeGroup();
            group.setGid(gid);
            group.setIsShow(Boolean.valueOf(true));
            return group;
        }).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.save(productGuaranteeGroup);
            mpGroupList.forEach(mp -> mp.setGroupId(productGuaranteeGroup.getId()));
            this.merchantProductGuaranteeGroupService.saveBatch(mpGroupList);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean delete(Integer id) {
        ProductGuaranteeGroup group = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(group.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_GUARANTEE_GROUP_NOT_EXIST);
        }
        group.setIsDel(Boolean.valueOf(true));
        group.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(group);
            this.merchantProductGuaranteeGroupService.deleteByGroupId(group.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean edit(ProductGuaranteeGroupAddRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7ec4\u5408ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        ProductGuaranteeGroup guaranteeGroup = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(guaranteeGroup.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_GUARANTEE_GROUP_NOT_EXIST);
        }
        List gidList = CrmebUtil.stringToArray((String)request.getGids());
        List mpGroupList = gidList.stream().map(gid -> {
            MerchantProductGuaranteeGroup group = new MerchantProductGuaranteeGroup();
            group.setGroupId(guaranteeGroup.getId());
            group.setGid(gid);
            group.setIsShow(Boolean.valueOf(true));
            return group;
        }).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (!guaranteeGroup.getName().equals(request.getName())) {
                guaranteeGroup.setName(request.getName());
                guaranteeGroup.setUpdateTime((Date)DateUtil.date());
                this.updateById(guaranteeGroup);
            }
            this.merchantProductGuaranteeGroupService.deleteByGroupId(guaranteeGroup.getId());
            this.merchantProductGuaranteeGroupService.saveBatch(mpGroupList);
            return Boolean.TRUE;
        });
    }

    @Override
    public List<ProductGuaranteeGroupListResponse> findList() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductGuaranteeGroup::getMerId, (Object)systemAdmin.getMerId());
        lqw.eq(ProductGuaranteeGroup::getIsDel, (Object)false);
        lqw.orderByDesc(ProductGuaranteeGroup::getId);
        List groupList = this.dao.selectList((Wrapper)lqw);
        ArrayList responseList = CollUtil.newArrayList((Object[])new ProductGuaranteeGroupListResponse[0]);
        if (CollUtil.isEmpty((Collection)groupList)) {
            return responseList;
        }
        groupList.forEach(group -> {
            ProductGuaranteeGroupListResponse response = new ProductGuaranteeGroupListResponse();
            BeanUtils.copyProperties((Object)group, (Object)response);
            ArrayList mpList = this.merchantProductGuaranteeGroupService.findByGroupId(group.getId());
            response.setGuaranteeList(CollUtil.isNotEmpty(mpList) ? mpList : CollUtil.newArrayList((Object[])new MerchantProductGuaranteeGroup[0]));
            responseList.add(response);
        });
        return responseList;
    }

    private ProductGuaranteeGroup getByIdException(Integer id) {
        ProductGuaranteeGroup group = (ProductGuaranteeGroup)this.getById(id);
        if (ObjectUtil.isNull((Object)group) || group.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_GUARANTEE_GROUP_NOT_EXIST);
        }
        return group;
    }
}

