/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.service.dao.ProductAttrValueDao;
import com.zbkj.service.service.ProductAttrValueService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductAttrValueServiceImpl
extends ServiceImpl<ProductAttrValueDao, ProductAttrValue>
implements ProductAttrValueService {
    @Resource
    private ProductAttrValueDao dao;

    @Override
    public ProductAttrValue getByProductIdAndAttrId(Integer productId, Integer attrId, Integer type, Integer marketingType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        lqw.eq(ProductAttrValue::getId, (Object)attrId);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (ProductAttrValue)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public ProductAttrValue getByIdAndProductIdAndType(Integer id, Integer productId, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getId, (Object)id);
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (ProductAttrValue)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public ProductAttrValue getByIdAndProductIdAndType(Integer id, Integer productId, Integer type, Integer marketingType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getId, (Object)id);
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (ProductAttrValue)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String operationType, Integer type, Integer version) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (operationType.equals("quick")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
        }
        if (operationType.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
        }
        if (operationType.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        if (operationType.equals("create")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        if (operationType.equals("delete")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.setSql("version = version + 1");
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.eq((Object)"type", (Object)type);
        updateWrapper.eq((Object)"version", (Object)version);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5546\u54c1attrValue\u5931\u8d25\uff0cattrValueId = " + id);
        }
        return update;
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String operationType, Integer type, Integer marketingType, Integer version) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (operationType.equals("quick")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            if (type > 0 && type < 5) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
            if (marketingType > 0) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            if (marketingType > 0) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota - {}", (Object[])new Object[]{num}));
                updateWrapper.last(StrUtil.format((CharSequence)"and (quota - {} >= 0)", (Object[])new Object[]{num}));
            } else {
                updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("create")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        if (operationType.equals("delete")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.setSql("version = version + 1");
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.eq((Object)"type", (Object)type);
        updateWrapper.eq((Object)"marketing_type", (Object)marketingType);
        updateWrapper.eq((Object)"version", (Object)version);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5546\u54c1attrValue\u5931\u8d25\uff0cattrValueId = " + id);
        }
        return update;
    }

    @Override
    public Boolean operationSales(Integer id, Integer num, String operationType) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (operationType.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
        }
        if (operationType.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5546\u54c1attrValue\u9500\u91cf\u5931\u8d25\uff0cattrValueId = " + id);
        }
        return update;
    }

    @Override
    public Boolean deleteByProductIdAndType(Integer productId, Integer type, Integer marketingType) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(ProductAttrValue::getIsDel, (Object)true);
        luw.eq(ProductAttrValue::getProductId, (Object)productId);
        luw.eq(ProductAttrValue::getType, (Object)type);
        luw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        return this.update((Wrapper)luw);
    }

    @Override
    public Boolean batchDeleteByProductIdAndMarketingType(List<Integer> productIds, Integer marketingType) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(ProductAttrValue::getIsDel, (Object)true);
        luw.in(ProductAttrValue::getProductId, productIds);
        luw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        return this.update((Wrapper)luw);
    }

    @Override
    public List<ProductAttrValue> getListByProductIdAndType(Integer productId, Integer type, Integer marketingType, Boolean showSwitch) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        if (showSwitch.booleanValue()) {
            lqw.eq(ProductAttrValue::getIsShow, (Object)1);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ProductAttrValue> getByProductIdAndAttrIdList(Integer productId, List<Integer> attrIdList, Integer type, Integer marketingType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        lqw.in(ProductAttrValue::getId, attrIdList);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean updateBrokerageByProductId(Integer proId, Integer type, Integer marketingType, Integer brokerage, Integer brokerageTwo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ProductAttrValue::getBrokerage, (Object)brokerage);
        wrapper.set(ProductAttrValue::getBrokerageTwo, (Object)brokerageTwo);
        wrapper.eq(ProductAttrValue::getProductId, (Object)proId);
        wrapper.eq(ProductAttrValue::getType, (Object)type);
        wrapper.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean deleteByMasterIdListAndMarktingType(List<Integer> skuIdList, Integer marketingType) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(ProductAttrValue::getIsDel, (Object)true);
        luw.in(ProductAttrValue::getMasterId, skuIdList);
        luw.eq(ProductAttrValue::getMarketingType, (Object)marketingType);
        return this.update((Wrapper)luw);
    }
}

