/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.constants.GroupConfigConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.GroupConfig;
import com.zbkj.common.request.PaidMemberBenefitsStatementRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.PaidMemberBenefitsVo;
import com.zbkj.common.vo.PaidMemberConfigVo;
import com.zbkj.service.service.GroupConfigService;
import com.zbkj.service.service.PaidMemberService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PaidMemberServiceImpl
implements PaidMemberService {
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private GroupConfigService groupConfigService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private UserService userService;

    @Override
    public PaidMemberConfigVo getBaseConfig() {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("paid_member_paid_entrance");
        keyList.add("paid_member_price_display");
        keyList.add("paid_member_product_switch");
        MyRecord myRecord = this.systemConfigService.getValuesByKeyList(keyList);
        PaidMemberConfigVo vo = new PaidMemberConfigVo();
        vo.setPaidMemberPaidEntrance(myRecord.getStr("paid_member_paid_entrance"));
        vo.setPaidMemberPriceDisplay(myRecord.getStr("paid_member_price_display"));
        vo.setPaidMemberProductSwitch(myRecord.getStr("paid_member_product_switch"));
        return vo;
    }

    @Override
    public Boolean editBaseConfig(PaidMemberConfigVo voRequest) {
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemConfigService.updateOrSaveValueByName("paid_member_paid_entrance", voRequest.getPaidMemberPaidEntrance());
            this.systemConfigService.updateOrSaveValueByName("paid_member_price_display", voRequest.getPaidMemberPriceDisplay());
            this.systemConfigService.updateOrSaveValueByName("paid_member_product_switch", voRequest.getPaidMemberProductSwitch());
            return Boolean.TRUE;
        });
    }

    @Override
    public List<PaidMemberBenefitsVo> getBenefitsList() {
        List<GroupConfig> configList = this.groupConfigService.findByTag(GroupConfigConstants.TAG_PAID_MEMBER_BENEFITS, "desc", null);
        if (CollUtil.isEmpty(configList)) {
            return new ArrayList<PaidMemberBenefitsVo>();
        }
        Iterator<GroupConfig> iterator = configList.iterator();
        ArrayList<PaidMemberBenefitsVo> voList = new ArrayList<PaidMemberBenefitsVo>();
        while (iterator.hasNext()) {
            GroupConfig config = iterator.next();
            PaidMemberBenefitsVo vo = new PaidMemberBenefitsVo();
            BeanUtils.copyProperties((Object)config, (Object)vo);
            int multiple = 1;
            String channelStr = "";
            if (StrUtil.isNotBlank((CharSequence)config.getLinkUrl())) {
                StrUtil.split((CharSequence)config.getLinkUrl(), (CharSequence)":");
                String[] split = config.getLinkUrl().split(":");
                String multipleStr = split[0];
                multiple = Integer.parseInt(multipleStr);
                channelStr = split[1];
                if (channelStr.equals("0")) {
                    channelStr = "";
                }
            }
            vo.setMultiple(Integer.valueOf(multiple));
            vo.setChannelStr(channelStr);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public Boolean editBenefits(PaidMemberBenefitsVo voRequest) {
        GroupConfig groupConfig = this.getBenefitsGroupConfigById(voRequest.getId());
        if (groupConfig.getName().equals("integralDoubling") || groupConfig.getName().equals("experienceDoubling")) {
            if (ObjectUtil.isNull((Object)voRequest.getMultiple()) || voRequest.getMultiple() < 1 || voRequest.getMultiple() > 99) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u500d\u6570\u8303\u56f4\u4e3a\uff1a1~99");
            }
            String channelStr = StrUtil.isBlank((CharSequence)voRequest.getChannelStr()) ? "0" : voRequest.getChannelStr();
            String linkUrl = voRequest.getMultiple() + ":" + channelStr;
            groupConfig.setLinkUrl(linkUrl);
        }
        groupConfig.setImageUrl(this.systemAttachmentService.clearPrefix(voRequest.getImageUrl()));
        groupConfig.setValue(voRequest.getValue());
        groupConfig.setMessage(voRequest.getMessage());
        groupConfig.setStatus(voRequest.getStatus());
        groupConfig.setSort(voRequest.getSort());
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.groupConfigService.updateById(groupConfig);
    }

    @Override
    public Boolean editBenefitsSwitch(Integer id) {
        GroupConfig groupConfig;
        groupConfig.setStatus(Boolean.valueOf((groupConfig = this.getBenefitsGroupConfigById(id)).getStatus() == false));
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.groupConfigService.updateById(groupConfig);
    }

    @Override
    public Boolean editBenefitsStatement(PaidMemberBenefitsStatementRequest request) {
        GroupConfig groupConfig = this.getBenefitsGroupConfigById(request.getId());
        String expand = StrUtil.isNotBlank((CharSequence)request.getExpand()) ? request.getExpand() : "";
        groupConfig.setExpand(this.systemAttachmentService.clearPrefix(expand));
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.groupConfigService.updateById(groupConfig);
    }

    private GroupConfig getBenefitsGroupConfigById(Integer id) {
        GroupConfig groupConfig = this.groupConfigService.getByIdException(id);
        if (!groupConfig.getTag().equals(GroupConfigConstants.TAG_PAID_MEMBER_BENEFITS)) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!(groupConfig.getName().equals("memberExclusivePrice") || groupConfig.getName().equals("integralDoubling") || groupConfig.getName().equals("experienceDoubling") || groupConfig.getName().equals("exclusiveCustomer"))) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return groupConfig;
    }

    @Override
    public void memberExpirationProcessing() {
        Boolean update = this.userService.memberExpirationProcessing();
        if (!update.booleanValue()) {
            throw new CrmebException("\u4f1a\u5458\u8fc7\u671f\u5904\u7406\u5931\u8d25");
        }
    }
}

