/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.member.PaidMemberCard;
import com.zbkj.common.request.PaidMemberCardSaveRequest;
import com.zbkj.common.request.PaidMemberCardSearchRequest;
import com.zbkj.common.response.PaidMemberCardResponse;
import com.zbkj.common.response.SvipCardResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MemberResultCode;
import com.zbkj.service.dao.PaidMemberCardDao;
import com.zbkj.service.service.PaidMemberCardService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PaidMemberCardServiceImpl
extends ServiceImpl<PaidMemberCardDao, PaidMemberCard>
implements PaidMemberCardService {
    @Resource
    private PaidMemberCardDao dao;

    @Override
    public Boolean add(PaidMemberCardSaveRequest request) {
        if (request.getType() <= 1 && (ObjectUtil.isNull((Object)request.getDeadlineDay()) || request.getDeadlineDay() < 1 || request.getDeadlineDay() > 9999)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u671f\u9650\u5929\u6570\u8303\u56f4\u4e3a\uff1a1~9999");
        }
        PaidMemberCard card = new PaidMemberCard();
        card.setName(request.getName());
        if (StrUtil.isNotBlank((CharSequence)request.getLabel())) {
            card.setLabel(request.getLabel());
        }
        card.setType(request.getType());
        card.setDeadlineDay(Integer.valueOf(request.getType() > 1 ? 0 : request.getDeadlineDay()));
        card.setOriginalPrice(request.getOriginalPrice());
        card.setPrice(request.getPrice());
        card.setIsFirstChargeGive(request.getIsFirstChargeGive());
        card.setGiftBalance(request.getGiftBalance());
        card.setSort(request.getSort());
        card.setStatus(request.getStatus());
        return this.save(card);
    }

    @Override
    public Boolean edit(PaidMemberCardSaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4f1a\u5458\u5361ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PaidMemberCard card = this.getByIdException(request.getId());
        if (card.getType() <= 1 && (ObjectUtil.isNull((Object)request.getDeadlineDay()) || request.getDeadlineDay() < 1 || request.getDeadlineDay() > 9999)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u671f\u9650\u5929\u6570\u8303\u56f4\u4e3a\uff1a1~9999");
        }
        card.setName(request.getName());
        card.setLabel(StrUtil.isNotBlank((CharSequence)request.getLabel()) ? request.getLabel() : "");
        card.setDeadlineDay(Integer.valueOf(card.getType() > 1 ? 0 : request.getDeadlineDay()));
        card.setOriginalPrice(request.getOriginalPrice());
        card.setPrice(request.getPrice());
        card.setIsFirstChargeGive(request.getIsFirstChargeGive());
        card.setGiftBalance(request.getGiftBalance());
        card.setSort(request.getSort());
        card.setStatus(request.getStatus());
        card.setUpdateTime((Date)DateUtil.date());
        return this.updateById(card);
    }

    @Override
    public Boolean editSwitch(Integer id) {
        PaidMemberCard card = this.getByIdException(id);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(PaidMemberCard::getStatus, (Object)(card.getStatus() == false ? 1 : 0));
        wrapper.eq(PaidMemberCard::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean deleteCard(Integer id) {
        PaidMemberCard card = this.getByIdException(id);
        card.setIsDelete(Boolean.valueOf(true));
        card.setUpdateTime((Date)DateUtil.date());
        return this.updateById(card);
    }

    @Override
    public List<PaidMemberCardResponse> findPlatList(PaidMemberCardSearchRequest request) {
        String name = "";
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            name = URLUtil.decode((String)request.getName());
        }
        List<PaidMemberCard> list = this.findList(name, ObjectUtil.isNotNull((Object)request.getType()) ? request.getType() : null, ObjectUtil.isNotNull((Object)request.getStatus()) ? request.getStatus() : null);
        ArrayList<PaidMemberCardResponse> responseList = new ArrayList<PaidMemberCardResponse>();
        for (PaidMemberCard card : list) {
            PaidMemberCardResponse response = new PaidMemberCardResponse();
            BeanUtils.copyProperties((Object)card, (Object)response);
            responseList.add(response);
        }
        return responseList;
    }

    private List<PaidMemberCard> findList(String name, Integer type, Boolean status) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberCard::getIsDelete, (Object)0);
        if (StrUtil.isNotBlank((CharSequence)name)) {
            lqw.like(PaidMemberCard::getName, (Object)name);
        }
        if (ObjectUtil.isNotNull((Object)type)) {
            lqw.eq(PaidMemberCard::getType, (Object)type);
        }
        if (ObjectUtil.isNotNull((Object)status)) {
            lqw.eq(PaidMemberCard::getStatus, (Object)status);
        }
        lqw.orderByDesc((Object[])new SFunction[]{PaidMemberCard::getSort, PaidMemberCard::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PaidMemberCard getByIdException(Integer id) {
        PaidMemberCard paidMemberCard = (PaidMemberCard)this.getById(id);
        if (ObjectUtil.isNull((Object)paidMemberCard) || paidMemberCard.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_CARD_NOT_EXIST);
        }
        return paidMemberCard;
    }

    @Override
    public List<SvipCardResponse> findFrontList(Boolean isPayTrial) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberCard::getIsDelete, (Object)0);
        if (isPayTrial.booleanValue()) {
            lqw.in(PaidMemberCard::getType, new Object[]{1, 2});
        }
        lqw.eq(PaidMemberCard::getStatus, (Object)1);
        lqw.orderByDesc((Object[])new SFunction[]{PaidMemberCard::getSort, PaidMemberCard::getId});
        List list = this.dao.selectList((Wrapper)lqw);
        ArrayList<SvipCardResponse> responseList = new ArrayList<SvipCardResponse>();
        for (PaidMemberCard card : list) {
            SvipCardResponse response = new SvipCardResponse();
            BeanUtils.copyProperties((Object)card, (Object)response);
            responseList.add(response);
        }
        return responseList;
    }
}

