/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.circle.Circle;
import com.zbkj.common.model.page.PageDiy;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonSearchRequest;
import com.zbkj.common.request.FrontPageDiyRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.page.PageDiyEditNameRequest;
import com.zbkj.common.request.page.PageDiyRequest;
import com.zbkj.common.response.page.PageDiyDefaultResponse;
import com.zbkj.common.response.page.PageDiyResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.page.PageDiyDao;
import com.zbkj.service.service.CircleService;
import com.zbkj.service.service.PageDiyService;
import com.zbkj.service.service.SystemConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PageDiyServiceImpl
extends ServiceImpl<PageDiyDao, PageDiy>
implements PageDiyService {
    private static final Logger logger = LoggerFactory.getLogger(PageDiyServiceImpl.class);
    @Resource
    private PageDiyDao dao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CircleService circleService;

    @Override
    public PageInfo<PageDiy> findPlatPage(String name, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<PageDiy> pageDiyList = this.findList(name, 0);
        if (CollUtil.isNotEmpty(pageDiyList)) {
            List<Integer> diyIdList = pageDiyList.stream().map(PageDiy::getId).collect(Collectors.toList());
            Map<Integer, String> map = this.circleService.getCircleNameMapByDiyIdList(diyIdList);
            pageDiyList.forEach(e -> {
                if (StrUtil.isNotBlank((CharSequence)((CharSequence)map.get(e.getId())))) {
                    e.setCircleNames((String)map.get(e.getId()));
                } else {
                    e.setCircleNames("-");
                }
            });
        }
        return CommonPage.copyPageInfo((Page)page, pageDiyList);
    }

    @Override
    public PageInfo<PageDiy> findMerchantPage(CommonSearchRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<PageDiy> pageDiyList = this.findList(request.getKeywords(), systemAdmin.getMerId());
        return CommonPage.copyPageInfo((Page)page, pageDiyList);
    }

    private List<PageDiy> findList(String keywords, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(PageDiy.class, i -> !i.getColumn().equals("value"));
        if (StrUtil.isNotBlank((CharSequence)keywords)) {
            lqw.like(PageDiy::getName, (Object)URLUtil.decode((String)keywords));
        }
        lqw.eq(PageDiy::getMerId, (Object)merId);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        lqw.orderByDesc((Object[])new SFunction[]{PageDiy::getIsDefault, PageDiy::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageDiy addPageDiy(PageDiyRequest request) {
        this.checkPageDiyNameUnique(request.getName(), 0, 0);
        PageDiy pageDiy = new PageDiy();
        BeanUtils.copyProperties((Object)request, (Object)pageDiy);
        pageDiy.setName(URLUtil.decode((String)request.getName()));
        pageDiy.setId(null);
        pageDiy.setMerId(Integer.valueOf(0));
        pageDiy.setValue(PageDiyServiceImpl.sortWithSerializerFeature(request.getValue()).toJSONString());
        boolean save = this.save(pageDiy);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR, "DIY\u6a21\u677f\u4fdd\u5b58\u5931\u8d25");
        }
        return pageDiy;
    }

    private static JSONObject sortWithSerializerFeature(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return new JSONObject();
        }
        LinkedHashMap map = new LinkedHashMap();
        jsonObject.keySet().stream().sorted(Comparator.comparingLong(Long::parseLong)).forEach(key -> map.put(key, jsonObject.get(key)));
        return new JSONObject(map);
    }

    @Override
    public Boolean editPageDiy(PageDiyRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9DIY\u6a21\u677f");
        }
        PageDiy oldPageDiy = this.getByIdException(request.getId());
        if (!oldPageDiy.getMerId().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        String name = URLUtil.decode((String)request.getName());
        if (!oldPageDiy.getName().equals(name)) {
            this.checkPageDiyNameUnique(request.getName(), request.getId(), 0);
        }
        PageDiy pageDiy = new PageDiy();
        BeanUtils.copyProperties((Object)request, (Object)pageDiy);
        pageDiy.setName(name);
        pageDiy.setValue(PageDiyServiceImpl.sortWithSerializerFeature(request.getValue()).toJSONString());
        pageDiy.setMerId(Integer.valueOf(0));
        pageDiy.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(pageDiy) > 0;
    }

    @Override
    public Boolean editPageDiyName(PageDiyEditNameRequest pageDiyEditNameRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        PageDiy pageDiy = this.getByIdException(pageDiyEditNameRequest.getId());
        if (!pageDiy.getMerId().equals(admin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        String name = URLUtil.decode((String)pageDiyEditNameRequest.getName());
        if (!pageDiy.getName().equals(name)) {
            this.checkPageDiyNameUnique(name, pageDiyEditNameRequest.getId(), admin.getMerId());
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(PageDiy::getName, (Object)name);
        wrapper.eq(PageDiy::getId, (Object)pageDiyEditNameRequest.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean setDiyDefault(Integer diyId) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        PageDiy pageDiy = this.getByIdException(diyId);
        if (!admin.getMerId().equals(pageDiy.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.clearDiyDefault(admin.getMerId());
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            wrapper.set(PageDiy::getIsDefault, (Object)1);
            wrapper.eq(PageDiy::getMerId, (Object)admin.getMerId());
            wrapper.eq(PageDiy::getId, (Object)diyId);
            this.update((Wrapper)wrapper);
            return Boolean.TRUE;
        });
    }

    private void clearDiyDefault(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(PageDiy::getIsDefault, (Object)0);
        wrapper.eq(PageDiy::getMerId, (Object)merId);
        wrapper.eq(PageDiy::getIsDefault, (Object)1);
        this.update((Wrapper)wrapper);
    }

    private PageDiy getByIdException(Integer id) {
        PageDiy pageDiy = (PageDiy)this.getById(id);
        if (ObjectUtil.isNull((Object)pageDiy) || pageDiy.getIsDel() > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        return pageDiy;
    }

    @Override
    public PageDiyResponse getDiyPageByPageIdForAdmin(Integer id) {
        PageDiy pageDiy;
        if (0 == id) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(PageDiy::getIsDefault, (Object)1);
            lqw.eq(PageDiy::getMerId, (Object)0);
            pageDiy = (PageDiy)this.getOne((Wrapper)lqw);
        } else {
            pageDiy = this.getByIdException(id);
        }
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.PAGE_DIY_NOT_EXIST);
        }
        PageDiyResponse response = new PageDiyResponse();
        BeanUtils.copyProperties((Object)pageDiy, (Object)response);
        response.setValue(JSON.parseObject((String)pageDiy.getValue()));
        return response;
    }

    @Override
    public Integer getDefaultId() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{PageDiy::getId});
        lqw.eq(PageDiy::getMerId, (Object)admin.getMerId());
        lqw.eq(PageDiy::getIsDefault, (Object)1);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        lqw.last(" limit 1");
        PageDiy pageDiy = (PageDiy)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)pageDiy) ? pageDiy.getId() : 0;
    }

    @Override
    public PageDiy saveMerchantPageDiy(PageDiyRequest request) {
        String adminApiPath = this.systemConfigService.getValueByKey("api_url");
        if (StrUtil.isBlank((CharSequence)adminApiPath)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5e94\u7528\u8bbe\u7f6e\u4e2d \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6570\u636e\u914d\u7f6e \u6216\u8005 \u652f\u4ed8\u56de\u8c03\u5730\u5740\u4ee5\u53ca\u7f51\u7ad9\u5730\u5740 \u914d\u7f6e\u4e0d\u5168");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        this.checkPageDiyNameUnique(request.getName(), 0, admin.getMerId());
        PageDiy pageDiy = new PageDiy();
        BeanUtils.copyProperties((Object)request, (Object)pageDiy);
        pageDiy.setId(null);
        pageDiy.setValue(JSON.toJSONString((Object)request.getValue()));
        pageDiy.setMerId(admin.getMerId());
        pageDiy.setIsDefault(Integer.valueOf(ObjectUtil.isNotNull((Object)request.getIsDefault()) && request.getIsDefault() > 0 ? 1 : 0));
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@ == '" + adminApiPath + "')]", new Predicate[0]);
        pageDiy.setValue(jsonContext.jsonString());
        boolean save = this.save(pageDiy);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR, "\u4fdd\u5b58diy\u6a21\u677f\u5931\u8d25");
        }
        return pageDiy;
    }

    @Override
    public Boolean editMerchantPageDiy(PageDiyRequest request) {
        String adminApiPath = this.systemConfigService.getValueByKey("api_url");
        if (StrUtil.isBlank((CharSequence)adminApiPath)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5e94\u7528\u8bbe\u7f6e\u4e2d \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6570\u636e\u914d\u7f6e \u6216\u8005 \u652f\u4ed8\u56de\u8c03\u5730\u5740\u4ee5\u53ca\u7f51\u7ad9\u5730\u5740 \u914d\u7f6e\u4e0d\u5168");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        PageDiy tempPageDiy = this.getByIdException(request.getId());
        if (!tempPageDiy.getMerId().equals(admin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        this.checkPageDiyNameUnique(request.getName(), tempPageDiy.getId(), admin.getMerId());
        PageDiy pageDiy = new PageDiy();
        BeanUtils.copyProperties((Object)request, (Object)pageDiy);
        pageDiy.setValue(JSON.toJSONString((Object)request.getValue()));
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@ == '" + adminApiPath + "')]", new Predicate[0]);
        pageDiy.setValue(jsonContext.jsonString());
        pageDiy.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(pageDiy) > 0;
    }

    @Override
    public Boolean deletePageDiy(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        PageDiy pageDiy = this.getByIdException(id);
        if (!pageDiy.getMerId().equals(admin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        return this.removeById(id);
    }

    @Override
    public PageDiyResponse getMerchantPageDiyInfo(Integer id) {
        PageDiy pageDiy;
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (0 == id) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(PageDiy::getIsDefault, (Object)1);
            lqw.eq(PageDiy::getMerId, (Object)admin.getMerId());
            pageDiy = (PageDiy)this.getOne((Wrapper)lqw);
        } else {
            pageDiy = this.getByIdException(id);
        }
        if (ObjectUtil.isNull((Object)pageDiy) || !pageDiy.getMerId().equals(admin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        String modifiedJsonString = this.getModifiedJsonString(pageDiy.getValue());
        pageDiy.setValue(modifiedJsonString);
        PageDiyResponse response = new PageDiyResponse();
        BeanUtils.copyProperties((Object)pageDiy, (Object)response);
        response.setValue(JSON.parseObject((String)pageDiy.getValue()));
        return response;
    }

    @Override
    public PageDiyResponse getMerchantPageDiyInfoByFront(Integer merId, Integer id) {
        PageDiy pageDiy = ObjectUtil.isNotNull((Object)id) && id > 0 ? this.getDetailByMerId(id, merId) : this.getDefaultByMerId(merId);
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.PAGE_DIY_NOT_EXIST);
        }
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@.name == 'goodList')].itemStyle.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].tabConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].typeConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsSort.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsList.list[*].attrValue", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].activeValueBrand", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].goodsList", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].selectConfig", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].productList..*.goods[*].attrValue", new Predicate[0]);
        PageDiyResponse response = new PageDiyResponse();
        BeanUtils.copyProperties((Object)pageDiy, (Object)response);
        response.setValue(JSON.parseObject((String)jsonContext.jsonString()));
        return response;
    }

    @Override
    public PageDiy getMerchantDefDiy() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PageDiy::getMerId, (Object)-9);
        lqw.last(" limit 1");
        return (PageDiy)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageDiyDefaultResponse getDefault() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{PageDiy::getId});
        lqw.eq(PageDiy::getMerId, (Object)admin.getMerId());
        lqw.eq(PageDiy::getIsDefault, (Object)1);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        lqw.last(" limit 1");
        PageDiy pageDiy = (PageDiy)this.dao.selectOne((Wrapper)lqw);
        PageDiyDefaultResponse response = new PageDiyDefaultResponse();
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException("\u5f53\u524d\u5546\u57ce\u9996\u9875\u672a\u8bbe\u7f6e\u6216\u6570\u636e\u6709\u8bef");
        }
        response.setId(pageDiy.getId());
        response.setType("homePage");
        return response;
    }

    @Override
    public Map<Integer, String> getNameMapByIdList(List<Integer> diyIdList) {
        if (CollUtil.isEmpty(diyIdList)) {
            return new HashMap<Integer, String>();
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(PageDiy::getId, diyIdList);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        List diyList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)diyList)) {
            return new HashMap<Integer, String>();
        }
        return diyList.stream().collect(Collectors.toMap(PageDiy::getId, PageDiy::getName));
    }

    private PageDiy getDetailByMerId(Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PageDiy::getId, (Object)id);
        lqw.eq(PageDiy::getMerId, (Object)merId);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        return (PageDiy)this.dao.selectOne((Wrapper)lqw);
    }

    private PageDiy getDefaultByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PageDiy::getMerId, (Object)merId);
        lqw.eq(PageDiy::getIsDefault, (Object)1);
        lqw.eq(PageDiy::getIsDel, (Object)0);
        return (PageDiy)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageDiyResponse getDiyPageByFront(FrontPageDiyRequest request) {
        LambdaQueryWrapper getHomeDefault;
        PageDiy pageDiy;
        List circleIdList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)request.getCircleIds())) {
            circleIdList = CrmebUtil.stringToArray((String)request.getCircleIds());
        }
        if (ObjectUtil.isNull((Object)request.getId())) {
            request.setId(Integer.valueOf(0));
        }
        if (StrUtil.isBlank((CharSequence)request.getCircleIds()) || request.getCircleIds().equals("0") || circleIdList.size() > 1) {
            if (request.getId() > 0) {
                pageDiy = this.getByIdException(request.getId());
            } else {
                getHomeDefault = Wrappers.lambdaQuery();
                getHomeDefault.eq(PageDiy::getMerId, (Object)0);
                getHomeDefault.eq(PageDiy::getIsDefault, (Object)1);
                pageDiy = (PageDiy)this.getOne((Wrapper)getHomeDefault);
            }
        } else if (request.getId() > 0) {
            pageDiy = this.getByIdException(request.getId());
        } else {
            Circle circle;
            PageDiy circleDiy;
            JSONObject searObject;
            Integer tabVal;
            JSONObject jsonObject;
            String templeName;
            getHomeDefault = Wrappers.lambdaQuery();
            getHomeDefault.eq(PageDiy::getMerId, (Object)0);
            getHomeDefault.eq(PageDiy::getIsDefault, (Object)1);
            PageDiy defaultDiy = (PageDiy)this.getOne((Wrapper)getHomeDefault);
            JSONObject defaultJsonObject = JSONObject.parseObject((String)defaultDiy.getValue(), (Feature[])new Feature[]{Feature.OrderedField});
            pageDiy = defaultJsonObject.isEmpty() ? defaultDiy : (!(templeName = (jsonObject = this.getFirstJSONObject(defaultJsonObject)).getString("name")).equals("homeComb") && !templeName.equals("headerSerch") ? defaultDiy : ((tabVal = (searObject = jsonObject.getJSONObject("searConfig")).getInteger("tabVal")) < 2 ? defaultDiy : (ObjectUtil.isNotNull((Object)(circleDiy = (PageDiy)this.getById((circle = (Circle)this.circleService.getById((Serializable)circleIdList.get(0))).getDiyId()))) ? circleDiy : defaultDiy)));
        }
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.PAGE_DIY_NOT_EXIST);
        }
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@.name == 'goodList')].itemStyle.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].tabConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].typeConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsSort.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsList.list[*].attrValue", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].activeValueBrand", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].goodsList", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].selectConfig", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].productList..*.goods[*].attrValue", new Predicate[0]);
        PageDiyResponse response = new PageDiyResponse();
        BeanUtils.copyProperties((Object)pageDiy, (Object)response);
        response.setValue(JSON.parseObject((String)jsonContext.jsonString()));
        return response;
    }

    private JSONObject getFirstJSONObject(JSONObject defaultJsonObject) {
        for (String key : defaultJsonObject.keySet()) {
            Object value = defaultJsonObject.get((Object)key);
            if (!(value instanceof JSONObject)) continue;
            return (JSONObject)value;
        }
        return defaultJsonObject;
    }

    private void checkPageDiyNameUnique(String pageDiyName, Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PageDiy::getName, (Object)pageDiyName);
        if (id > 0) {
            lqw.ne(PageDiy::getId, (Object)id);
        }
        lqw.eq(PageDiy::getMerId, (Object)merId);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        if (count > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u6a21\u7248\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\uff01");
        }
    }

    private String getModifiedJsonString(String diyValue) {
        Gson gson = new Gson();
        JsonElement jsonElement = (JsonElement)gson.fromJson(diyValue, JsonElement.class);
        String adminApiPath = "crmebimage";
        String newPrefix = this.systemConfigService.getValueByKey("localUploadUrl");
        JsonElement modifiedJsonElement = this.replaceJsonValue(jsonElement, adminApiPath, newPrefix);
        return gson.toJson(modifiedJsonElement);
    }

    private JsonElement replaceJsonValue(JsonElement jsonElement, String keyword, String newValue) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject newJsonObject = new JsonObject();
            for (String key : jsonObject.keySet()) {
                JsonElement value = jsonObject.get(key);
                if (value.isJsonPrimitive() && value.getAsString().startsWith(keyword)) {
                    newJsonObject.addProperty(key, newValue + "/" + value.getAsString());
                    continue;
                }
                newJsonObject.add(key, this.replaceJsonValue(value, keyword, newValue));
            }
            return newJsonObject;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            JsonArray newJsonArray = new JsonArray();
            for (JsonElement element : jsonArray) {
                newJsonArray.add(this.replaceJsonValue(element, keyword, newValue));
            }
            return newJsonArray;
        }
        return jsonElement;
    }
}

