/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.OnePassResultCode;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.OnePassApplicationInfoVo;
import com.zbkj.common.vo.OnePassLogisticsQueryVo;
import com.zbkj.common.vo.OnePassUserInfoVo;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.impl.OnePassSmsServiceImpl;
import com.zbkj.service.util.OnePassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class OnePassServiceImpl
implements OnePassService {
    private static final Logger logger = LoggerFactory.getLogger(OnePassSmsServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OnePassUtil onePassUtil;

    @Override
    public OnePassUserInfoVo info() {
        return this.getInfo();
    }

    private OnePassUserInfoVo getInfo() {
        OnePassApplicationInfoVo infoVo = this.getApplicationInfoException();
        String accessToken = this.onePassUtil.getToken(infoVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(accessToken);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/v2/user/info", null, header);
        OnePassUserInfoVo userInfoVo = (OnePassUserInfoVo)jsonObject.getObject("data", OnePassUserInfoVo.class);
        userInfoVo.setAccount(userInfoVo.getAccount());
        return userInfoVo;
    }

    @Override
    public JSONObject copyGoods(String url) {
        OnePassApplicationInfoVo infoVo = this.getApplicationInfoException();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(infoVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"url", (Object)url);
        JSONObject jsonObject = this.onePassUtil.postFrom("https://sms.crmeb.net/api/v2/copy/goods", (MultiValueMap<String, Object>)params, header);
        return jsonObject.getJSONObject("data");
    }

    @Override
    public MyRecord expressDump(MyRecord record) {
        OnePassApplicationInfoVo infoVo = this.getApplicationInfoException();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(infoVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Map columns = record.getColumns();
        Object siid = columns.get("siid");
        if (ObjectUtil.isEmpty(siid)) {
            columns.put("print_type", "IMAGE");
            header.put("version", "v1.1");
        }
        columns.forEach((arg_0, arg_1) -> ((MultiValueMap)params).add(arg_0, arg_1));
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/v2/expr/dump", (MultiValueMap<String, Object>)params, header);
        MyRecord myRecord = new MyRecord();
        JSONObject jsonObject = post.getJSONObject("data");
        return myRecord.setColums(jsonObject);
    }

    @Override
    public OnePassLogisticsQueryVo exprQuery(String expressNo, String com, String phone) {
        OnePassApplicationInfoVo infoVo = this.getApplicationInfoException();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(this.onePassUtil.getToken(infoVo));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"com", (Object)com);
        params.add((Object)"num", (Object)expressNo);
        params.add((Object)"phone", (Object)phone);
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/v2/expr/query", (MultiValueMap<String, Object>)params, header);
        String dataStr = post.getString("data");
        if (StrUtil.isBlank((CharSequence)dataStr) || dataStr.equals("[]")) {
            return null;
        }
        JSONObject jsonObject = post.getJSONObject("data");
        return (OnePassLogisticsQueryVo)JSONObject.toJavaObject((JSON)jsonObject, OnePassLogisticsQueryVo.class);
    }

    private void setApplicationInfo(String accessKey, String secretKey) {
        boolean accountResult = this.systemConfigService.updateOrSaveValueByName("one_pass_access_key", accessKey);
        boolean tokenResult = this.systemConfigService.updateOrSaveValueByName("one_pass_secret_key", secretKey);
        if (!accountResult || !tokenResult) {
            throw new CrmebException("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    @Override
    public Boolean saveApplicationInfo(OnePassApplicationInfoVo request) {
        this.setApplicationInfo(request.getAccessKey(), request.getSecretKey());
        return Boolean.TRUE;
    }

    @Override
    public OnePassApplicationInfoVo getApplicationInfo() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one_pass_access_key");
        list.add("one_pass_secret_key");
        MyRecord myRecord = this.systemConfigService.getValuesByKeyList(list);
        OnePassApplicationInfoVo onePassApplicationInfoVo = new OnePassApplicationInfoVo();
        onePassApplicationInfoVo.setAccessKey(myRecord.getStr("one_pass_access_key"));
        onePassApplicationInfoVo.setSecretKey(myRecord.getStr("one_pass_secret_key"));
        return onePassApplicationInfoVo;
    }

    @Override
    public OnePassApplicationInfoVo getApplicationInfoException() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one_pass_access_key");
        list.add("one_pass_secret_key");
        MyRecord myRecord = this.systemConfigService.getValuesByKeyList(list);
        String accessKey = myRecord.getStr("one_pass_access_key");
        if (StrUtil.isBlank((CharSequence)accessKey)) {
            throw new CrmebException((IResultEnum)OnePassResultCode.ACCESS_KEY_NOT_CONFIG);
        }
        String secretKey = myRecord.getStr("one_pass_secret_key");
        if (StrUtil.isBlank((CharSequence)secretKey)) {
            throw new CrmebException((IResultEnum)OnePassResultCode.SECRET_KEY_NOT_CONFIG);
        }
        return new OnePassApplicationInfoVo(accessKey, secretKey);
    }
}

