/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.request.reservation.MerchantReservationToHomeRequest;
import com.zbkj.common.request.reservation.MerchantReservationToStoreRequest;
import com.zbkj.common.response.reservation.MerchantReservationToHomeResponse;
import com.zbkj.common.response.reservation.MerchantReservationToStoreResponse;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.MerchantInfoDao;
import com.zbkj.service.service.MerchantInfoService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MerchantInfoServiceImpl
extends ServiceImpl<MerchantInfoDao, MerchantInfo>
implements MerchantInfoService {
    @Resource
    private MerchantInfoDao dao;

    @Override
    public MerchantInfo getByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantInfo::getMerId, (Object)merId);
        lqw.last(" limit 1");
        return (MerchantInfo)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public MerchantReservationToHomeResponse getReservationConfigInfo() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        MerchantInfo merchantInfo = this.getByMerId(systemAdmin.getMerId());
        MerchantReservationToHomeResponse reservationResponse = new MerchantReservationToHomeResponse();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)reservationResponse);
        return reservationResponse;
    }

    @Override
    public Boolean editReservationConfig(MerchantReservationToHomeRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        MerchantInfo merchantInfo = this.getByMerId(systemAdmin.getMerId());
        BeanUtils.copyProperties((Object)request, (Object)merchantInfo);
        if (ObjectUtil.isNull((Object)merchantInfo.getServiceEvidenceFormId()) || ObjectUtil.isEmpty((Object)merchantInfo.getServiceEvidenceFormId())) {
            merchantInfo.setServiceEvidenceFormId(Integer.valueOf(0));
        }
        merchantInfo.setUpdateTime(new Date());
        return this.updateById(merchantInfo);
    }

    @Override
    public MerchantReservationToStoreResponse getReservationConfigToStoreInfo() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        MerchantInfo merchantInfo = this.getByMerId(systemAdmin.getMerId());
        MerchantReservationToStoreResponse response = new MerchantReservationToStoreResponse();
        response.setServiceWorkOrderSwitch(merchantInfo.getServiceWorkOrderSwitch());
        return response;
    }

    @Override
    public Boolean editToStoreReservationConfig(MerchantReservationToStoreRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Integer merId = systemAdmin.getMerId();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(MerchantInfo::getMerId, (Object)merId);
        wrapper.set(MerchantInfo::getServiceWorkOrderSwitch, (Object)request.getServiceWorkOrderSwitch());
        return this.update((Wrapper)wrapper);
    }
}

