/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantDeliveryPersonnel;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.MerchantDeliveryPersonnelSaveRequest;
import com.zbkj.common.request.MerchantDeliveryPersonnelSearchRequest;
import com.zbkj.common.response.MerchantDeliveryPersonnelPageResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.MerchantDeliveryPersonnelDao;
import com.zbkj.service.service.MerchantDeliveryPersonnelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MerchantDeliveryPersonnelServiceImpl
extends ServiceImpl<MerchantDeliveryPersonnelDao, MerchantDeliveryPersonnel>
implements MerchantDeliveryPersonnelService {
    @Resource
    private MerchantDeliveryPersonnelDao dao;

    @Override
    public PageInfo<MerchantDeliveryPersonnelPageResponse> findPage(MerchantDeliveryPersonnelSearchRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDeliveryPersonnel::getMerId, (Object)admin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getPersonnelName())) {
            lqw.like(MerchantDeliveryPersonnel::getPersonnelName, (Object)URLUtil.decode((String)request.getPersonnelName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getPersonnelPhone())) {
            lqw.like(MerchantDeliveryPersonnel::getPersonnelPhone, (Object)request.getPersonnelPhone());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(MerchantDeliveryPersonnel::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.eq(MerchantDeliveryPersonnel::getIsDelete, (Object)0);
        lqw.eq(MerchantDeliveryPersonnel::getStatus, (Object)1);
        lqw.orderByDesc((Object[])new SFunction[]{MerchantDeliveryPersonnel::getSort, MerchantDeliveryPersonnel::getId});
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List responseList = list.stream().map(mdp -> {
            MerchantDeliveryPersonnelPageResponse response = new MerchantDeliveryPersonnelPageResponse();
            BeanUtils.copyProperties((Object)mdp, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<MerchantDeliveryPersonnelPageResponse> findPageByEmployee(MerchantDeliveryPersonnelSearchRequest request, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDeliveryPersonnel::getMerId, (Object)merId);
        if (StrUtil.isNotBlank((CharSequence)request.getPersonnelName())) {
            lqw.like(MerchantDeliveryPersonnel::getPersonnelName, (Object)URLUtil.decode((String)request.getPersonnelName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getPersonnelPhone())) {
            lqw.like(MerchantDeliveryPersonnel::getPersonnelPhone, (Object)request.getPersonnelPhone());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(MerchantDeliveryPersonnel::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.eq(MerchantDeliveryPersonnel::getIsDelete, (Object)0);
        lqw.eq(MerchantDeliveryPersonnel::getStatus, (Object)1);
        lqw.orderByDesc((Object[])new SFunction[]{MerchantDeliveryPersonnel::getSort, MerchantDeliveryPersonnel::getId});
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List responseList = list.stream().map(mdp -> {
            MerchantDeliveryPersonnelPageResponse response = new MerchantDeliveryPersonnelPageResponse();
            BeanUtils.copyProperties((Object)mdp, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean add(MerchantDeliveryPersonnelSaveRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (this.isExistName(request.getPersonnelName(), 0, admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u540d\u79f0\u91cd\u590d");
        }
        if (this.isExistPhone(request.getPersonnelPhone(), 0, admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u624b\u673a\u53f7\u91cd\u590d");
        }
        MerchantDeliveryPersonnel personnel = new MerchantDeliveryPersonnel();
        BeanUtils.copyProperties((Object)request, (Object)personnel);
        personnel.setId(null);
        personnel.setMerId(admin.getMerId());
        return this.save(personnel);
    }

    @Override
    public Boolean delete(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        this.getByIdException(id, admin.getMerId());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantDeliveryPersonnel::getIsDelete, (Object)1);
        wrapper.eq(MerchantDeliveryPersonnel::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean edit(MerchantDeliveryPersonnelSaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u914d\u9001\u4eba\u5458");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        this.getByIdException(request.getId(), admin.getMerId());
        if (this.isExistName(request.getPersonnelName(), request.getId(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u540d\u79f0\u91cd\u590d");
        }
        if (this.isExistPhone(request.getPersonnelPhone(), request.getId(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u624b\u673a\u53f7\u91cd\u590d");
        }
        MerchantDeliveryPersonnel personnel = new MerchantDeliveryPersonnel();
        personnel.setId(request.getId());
        personnel.setPersonnelName(request.getPersonnelName());
        personnel.setPersonnelPhone(request.getPersonnelPhone());
        personnel.setSort(request.getSort());
        personnel.setUpdateTime(new Date());
        return this.updateById(personnel);
    }

    private MerchantDeliveryPersonnel getByIdException(Integer id, Integer merId) {
        MerchantDeliveryPersonnel personnel = (MerchantDeliveryPersonnel)this.getById(id);
        if (ObjectUtil.isNull((Object)personnel) || personnel.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        if (!personnel.getMerId().equals(merId)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        return personnel;
    }

    private MerchantDeliveryPersonnel getByIdException(Integer id) {
        MerchantDeliveryPersonnel personnel = (MerchantDeliveryPersonnel)this.getById(id);
        if (ObjectUtil.isNull((Object)personnel) || personnel.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u914d\u9001\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        return personnel;
    }

    private Boolean isExistPhone(String personnelPhone, Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDeliveryPersonnel::getPersonnelPhone, (Object)personnelPhone);
        if (id > 0) {
            lqw.ne(MerchantDeliveryPersonnel::getId, (Object)id);
        }
        lqw.eq(MerchantDeliveryPersonnel::getMerId, (Object)merId);
        lqw.eq(MerchantDeliveryPersonnel::getIsDelete, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }

    private Boolean isExistName(String personnelName, Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDeliveryPersonnel::getPersonnelName, (Object)personnelName);
        if (id > 0) {
            lqw.ne(MerchantDeliveryPersonnel::getId, (Object)id);
        }
        lqw.eq(MerchantDeliveryPersonnel::getMerId, (Object)merId);
        lqw.eq(MerchantDeliveryPersonnel::getIsDelete, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }
}

