/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantAddress;
import com.zbkj.common.request.merchant.MerchantAddressSaveRequest;
import com.zbkj.common.request.merchant.MerchantAddressSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.service.dao.MerchantAddressDao;
import com.zbkj.service.service.MerchantAddressService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantAddressServiceImpl
extends ServiceImpl<MerchantAddressDao, MerchantAddress>
implements MerchantAddressService {
    @Resource
    private MerchantAddressDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<MerchantAddress> findList(MerchantAddressSearchRequest request, SystemAdmin admin) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantAddress::getMerId, (Object)admin.getMerId());
        lqw.eq(MerchantAddress::getIsDel, (Object)0);
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            lqw.eq(MerchantAddress::getIsShow, (Object)request.getIsShow());
        }
        lqw.orderByDesc((Object[])new SFunction[]{MerchantAddress::getIsDefault, MerchantAddress::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean add(MerchantAddressSaveRequest request, SystemAdmin admin) {
        MerchantAddress address = new MerchantAddress();
        address.setReceiverName(request.getReceiverName());
        address.setReceiverPhone(request.getReceiverPhone());
        address.setDetail(request.getDetail());
        address.setIsShow(request.getIsShow());
        address.setIsDefault(request.getIsDefault());
        address.setMerId(admin.getMerId());
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (address.getIsDefault().booleanValue()) {
                this.clearDefaultByMerId(admin.getMerId());
            }
            this.save(address);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateAddress(MerchantAddressSaveRequest request, SystemAdmin admin) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5546\u6237\u5730\u5740");
        }
        MerchantAddress address = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(address.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_ADDRESS_NOT_EXIST);
        }
        boolean isDefault = address.getIsDefault();
        address.setReceiverName(request.getReceiverName());
        address.setReceiverPhone(request.getReceiverPhone());
        address.setDetail(request.getDetail());
        address.setIsShow(request.getIsShow());
        address.setIsDefault(request.getIsDefault());
        address.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (address.getIsDefault().booleanValue() && !isDefault) {
                this.clearDefaultByMerId(admin.getMerId());
            }
            this.updateById(address);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean delete(Integer id, SystemAdmin admin) {
        MerchantAddress address = this.getByIdException(id);
        if (!admin.getMerId().equals(address.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_ADDRESS_NOT_EXIST);
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantAddress::getIsDel, (Object)1);
        wrapper.eq(MerchantAddress::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean setDefault(Integer id, SystemAdmin admin) {
        MerchantAddress address = this.getByIdException(id);
        if (!admin.getMerId().equals(address.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_ADDRESS_NOT_EXIST);
        }
        if (address.getIsDefault().booleanValue()) {
            return Boolean.TRUE;
        }
        address.setIsDefault(Boolean.valueOf(true));
        address.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.clearDefaultByMerId(admin.getMerId());
            this.updateById(address);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateShow(Integer id, SystemAdmin admin) {
        MerchantAddress address = this.getByIdException(id);
        if (!admin.getMerId().equals(address.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_ADDRESS_NOT_EXIST);
        }
        address.setIsShow(Boolean.valueOf(address.getIsShow() == false));
        address.setUpdateTime((Date)DateUtil.date());
        return this.updateById(address);
    }

    @Override
    public MerchantAddress getByIdException(Integer id) {
        MerchantAddress merchantAddress = (MerchantAddress)this.getById(id);
        if (ObjectUtil.isNull((Object)merchantAddress) || merchantAddress.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_ADDRESS_NOT_EXIST);
        }
        return merchantAddress;
    }

    private void clearDefaultByMerId(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantAddress::getIsDefault, (Object)0);
        wrapper.eq(MerchantAddress::getMerId, (Object)merId);
        wrapper.eq(MerchantAddress::getIsDefault, (Object)1);
        this.update((Wrapper)wrapper);
    }
}

