/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.PutObjectRequest;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.service.service.HuaWeiObsService;
import com.zbkj.service.service.SystemConfigService;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HuaWeiObsServiceImpl
implements HuaWeiObsService {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiObsServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public void uploadFile(String fileName, String localFilePath, File file) {
        if (!file.exists()) {
            log.error("\u534e\u4e3a\u4e91\u5b58\u50a8\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u5b58\u5728\uff0cfileName = {}\uff0c localFilePath = {}", (Object)fileName, (Object)localFilePath);
            return;
        }
        String bucketName = this.systemConfigService.getValueByKeyException("hwObsBucketName");
        ObsClient obsClient = this.getObsClient();
        try {
            PutObjectRequest request = new PutObjectRequest();
            request.setBucketName(bucketName);
            request.setObjectKey(fileName);
            request.setFile(file);
            obsClient.putObject(request);
            log.info("putObject successfully");
        }
        catch (ObsException e) {
            log.error("upload huaweiObs putObject failed");
            log.error("HTTP Code:" + e.getResponseCode());
            log.error("Error Code:" + e.getErrorCode());
            log.error("Error Message:" + e.getErrorMessage());
            log.error("Request ID:" + e.getErrorRequestId());
            log.error("Host ID:" + e.getErrorHostId());
            throw new CrmebException(e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("upload huaweiObs putObject failed", (Throwable)e);
            throw new CrmebException("upload huaweiObs putObject failed");
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error("upload huaweiObs close failed", (Throwable)e);
            }
        }
    }

    private ObsClient getObsClient() {
        String endPoint = this.systemConfigService.getValueByKeyException("hwObsEndpoint");
        String ak = this.systemConfigService.getValueByKeyException("hwObsAccessKey");
        String sk = this.systemConfigService.getValueByKeyException("hwObsSecretKey");
        ObsClient obsClient = new ObsClient(ak, sk, endPoint);
        return obsClient;
    }
}

