/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.enums.RegionTypeEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.city.CityRegion;
import com.zbkj.common.request.CityRegionEditRequest;
import com.zbkj.common.request.CityRegionRequest;
import com.zbkj.common.request.CitySearchRequest;
import com.zbkj.common.response.CityResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.CityTree;
import com.zbkj.common.vo.CityVo;
import com.zbkj.service.dao.CityRegionDao;
import com.zbkj.service.service.CityRegionService;
import com.zbkj.service.service.impl.ShippingTemplatesFreeServiceImpl;
import com.zbkj.service.service.impl.ShippingTemplatesRegionServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CityRegionServiceImpl
extends ServiceImpl<CityRegionDao, CityRegion>
implements CityRegionService {
    @Resource
    private CityRegionDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ShippingTemplatesFreeServiceImpl shippingTemplatesFreeService;
    @Autowired
    private ShippingTemplatesRegionServiceImpl shippingTemplatesRegionService;

    @Override
    public List<CityVo> getCityListTree() {
        List cityList = (List)this.redisUtil.get("city_list_tree");
        if (CollUtil.isEmpty((Collection)cityList)) {
            ArrayList<CityVo> treeList = new ArrayList<CityVo>();
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.select(new SFunction[]{CityRegion::getRegionId, CityRegion::getParentId, CityRegion::getRegionName, CityRegion::getRegionType});
            lambdaQueryWrapper.lt(CityRegion::getRegionType, (Object)RegionTypeEnum.STREET.getValue());
            List allTree = this.dao.selectList((Wrapper)lambdaQueryWrapper);
            if (CollUtil.isEmpty((Collection)allTree)) {
                return treeList;
            }
            for (CityRegion cityRegion : allTree) {
                CityVo cityVo = new CityVo();
                BeanUtils.copyProperties((Object)cityRegion, (Object)cityVo);
                treeList.add(cityVo);
            }
            CityTree cityTree = new CityTree(treeList);
            cityList = cityTree.buildTree();
            this.redisUtil.set("city_list_tree", (Object)cityList);
        }
        return (List)this.redisUtil.get("city_list_tree");
    }

    @Override
    public List<CityVo> getRegionListTree() {
        List cityList = (List)this.redisUtil.get("city_region_list_tree");
        if (CollUtil.isEmpty((Collection)cityList)) {
            ArrayList<CityVo> treeList = new ArrayList<CityVo>();
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.select(new SFunction[]{CityRegion::getRegionId, CityRegion::getParentId, CityRegion::getRegionName, CityRegion::getRegionType});
            List allTree = this.dao.selectList((Wrapper)lambdaQueryWrapper);
            if (CollUtil.isEmpty((Collection)allTree)) {
                return treeList;
            }
            for (CityRegion cityRegion : allTree) {
                CityVo cityVo = new CityVo();
                BeanUtils.copyProperties((Object)cityRegion, (Object)cityVo);
                treeList.add(cityVo);
            }
            CityTree cityTree = new CityTree(treeList);
            cityList = cityTree.buildTree();
            this.redisUtil.set("city_region_list_tree", (Object)cityList);
        }
        return cityList;
    }

    @Override
    public Boolean add(CityRegionRequest request) {
        CityRegion region = this.getByRegionId(request.getRegionId());
        if (ObjectUtil.isNotNull((Object)region)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u57ce\u5e02\u533a\u57dfID\u4e0d\u80fd\u76f8\u540c");
        }
        CityRegion cityRegion = new CityRegion();
        BeanUtils.copyProperties((Object)request, (Object)cityRegion);
        return this.save(cityRegion);
    }

    @Override
    public Boolean edit(CityRegionEditRequest request) {
        CityRegion region = this.getByRegionId(request.getOldRegionId());
        if (ObjectUtil.isNull((Object)region)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CITY_REGION_NOT_EXIST);
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CityRegion::getRegionId, (Object)request.getRegionId());
        wrapper.set(CityRegion::getRegionName, (Object)request.getRegionName());
        wrapper.eq(CityRegion::getRegionId, (Object)request.getOldRegionId());
        boolean update = this.update((Wrapper)wrapper);
        if (update) {
            if (!region.getRegionType().equals(RegionTypeEnum.STREET.getValue())) {
                this.redisUtil.delete(new String[]{"city_list_tree"});
            }
            this.redisUtil.delete(new String[]{"city_region_list_tree"});
        }
        return update;
    }

    @Override
    public Boolean delete(Integer regionId) {
        CityRegion region = this.getByRegionId(regionId);
        if (ObjectUtil.isNull((Object)region)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.CITY_REGION_NOT_EXIST);
        }
        if (!region.getRegionType().equals(RegionTypeEnum.STREET.getValue()) && this.countByParentId(region.getParentId()) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u57ce\u5e02\u533a\u57df\u4e0b\u6709\u5b50\u7ea7\u533a\u57df\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u533a\u57df");
        }
        if (region.getRegionType().equals(RegionTypeEnum.AREA.getValue())) {
            if (this.shippingTemplatesRegionService.existCityId(region.getRegionId()).booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u57ce\u5e02\u533a\u57df\u6709\u8fd0\u8d39\u6a21\u677f\u4f7f\u7528\uff0c\u8bf7\u5148\u4fee\u6539\u8fd0\u8d39\u6a21\u677f\u540e\u518d\u5220\u9664");
            }
            if (this.shippingTemplatesFreeService.existCityId(region.getRegionId()).booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u57ce\u5e02\u533a\u57df\u6709\u8fd0\u8d39\u6a21\u677f\u4f7f\u7528\uff0c\u8bf7\u5148\u4fee\u6539\u8fd0\u8d39\u6a21\u677f\u540e\u518d\u5220\u9664");
            }
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(CityRegion::getRegionId, (Object)regionId);
        int delete = this.dao.delete((Wrapper)wrapper);
        if (delete > 0) {
            if (!region.getRegionType().equals(RegionTypeEnum.STREET.getValue())) {
                this.redisUtil.delete(new String[]{"city_list_tree"});
            }
            this.redisUtil.delete(new String[]{"city_region_list_tree"});
        }
        return delete > 0;
    }

    @Override
    public List<CityResponse> getCityRegionList(CitySearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CityRegion::getParentId, (Object)request.getParentId());
        lqw.eq(CityRegion::getRegionType, (Object)request.getRegionType());
        List cityList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)cityList)) {
            return CollUtil.newArrayList((Object[])new CityResponse[0]);
        }
        return cityList.stream().map(e -> {
            CityResponse cityResponse = new CityResponse();
            BeanUtils.copyProperties((Object)e, (Object)cityResponse);
            if (e.getRegionType().equals(3)) {
                cityResponse.setIsChild(this.isExistChild(e.getRegionId()));
            }
            if (e.getRegionType().equals(4)) {
                cityResponse.setIsChild(Boolean.valueOf(false));
            }
            return cityResponse;
        }).collect(Collectors.toList());
    }

    private Boolean isExistChild(Integer parentId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CityRegion::getRegionId});
        lqw.eq(CityRegion::getParentId, (Object)parentId);
        lqw.last(" limit 1");
        CityRegion cityRegion = (CityRegion)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)cityRegion);
    }

    private Integer countByParentId(Integer parentId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CityRegion::getParentId, (Object)parentId);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public CityRegion getByRegionId(Integer regionId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CityRegion::getRegionId, (Object)regionId);
        lqw.last(" limit 1");
        return (CityRegion)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public CityRegion getByRegionName(String regionName, Integer parentId, Integer regionType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CityRegion::getRegionName, (Object)regionName);
        lqw.eq(CityRegion::getRegionType, (Object)regionType);
        lqw.eq(CityRegion::getParentId, (Object)parentId);
        lqw.last(" limit 1");
        CityRegion cityRegion = (CityRegion)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)cityRegion)) {
            return cityRegion;
        }
        lqw.clear();
        lqw.likeRight(CityRegion::getRegionName, (Object)StrUtil.subPre((CharSequence)regionName, (int)2));
        lqw.eq(CityRegion::getRegionType, (Object)regionType);
        lqw.eq(CityRegion::getParentId, (Object)parentId);
        lqw.last(" limit 1");
        return (CityRegion)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<CityRegion> findProvinceList() {
        return this.findByRegionType(1, 0);
    }

    @Override
    public List<CityRegion> findCityList(Integer provinceId) {
        return this.findByRegionType(2, provinceId);
    }

    @Override
    public List<CityRegion> findDistrictList(Integer cityId) {
        return this.findByRegionType(3, cityId);
    }

    @Override
    public List<CityRegion> findStreetList(Integer districtId) {
        return this.findByRegionType(4, districtId);
    }

    private List<CityRegion> findByRegionType(Integer regionType, Integer parentId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CityRegion::getRegionType, (Object)regionType);
        if (parentId > 0) {
            lqw.eq(CityRegion::getParentId, (Object)parentId);
        }
        return this.dao.selectList((Wrapper)lqw);
    }
}

