/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.circle.CircleAdmin;
import com.zbkj.common.model.circle.CircleMenu;
import com.zbkj.common.model.circle.CircleRole;
import com.zbkj.common.model.circle.CircleRoleMenu;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemRoleRequest;
import com.zbkj.common.request.SystemRoleSearchRequest;
import com.zbkj.common.request.SystemRoleStatusRequest;
import com.zbkj.common.response.RoleInfoResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.MenuCheckTree;
import com.zbkj.common.vo.MenuCheckVo;
import com.zbkj.service.dao.circle.CircleRoleDao;
import com.zbkj.service.service.CircleAdminService;
import com.zbkj.service.service.CircleMenuService;
import com.zbkj.service.service.CircleRoleMenuService;
import com.zbkj.service.service.CircleRoleService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CircleRoleServiceImpl
extends ServiceImpl<CircleRoleDao, CircleRole>
implements CircleRoleService {
    @Resource
    private CircleRoleDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CircleRoleMenuService circleRoleMenuService;
    @Autowired
    private CircleAdminService circleAdminService;
    @Autowired
    private CircleMenuService circleMenuService;

    @Override
    public List<CircleRole> getPlaCircleRoleList(SystemRoleSearchRequest request, PageParamRequest pageParamRequest) {
        return this.getList(request, pageParamRequest, RoleEnum.CIRCLE_SUPER.getValue());
    }

    private List<CircleRole> getList(SystemRoleSearchRequest request, PageParamRequest pageParamRequest, Integer type) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CircleRole::getId, CircleRole::getRoleName, CircleRole::getStatus, CircleRole::getCreateTime, CircleRole::getUpdateTime});
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(CircleRole::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRoleName())) {
            String decode = URLUtil.decode((String)request.getRoleName());
            lqw.like(CircleRole::getRoleName, (Object)decode);
        }
        lqw.eq(CircleRole::getType, (Object)type);
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue())) {
            SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
            lqw.eq(CircleRole::getCircleId, (Object)currentAdmin.getCircleId());
        }
        lqw.orderByAsc(CircleRole::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean addPlaCircleRole(SystemRoleRequest request) {
        if (this.existName(request.getRoleName(), 0, RoleEnum.CIRCLE_SUPER.getValue()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        return this.addRole(request, RoleEnum.CIRCLE_SUPER.getValue());
    }

    private Boolean addRole(SystemRoleRequest request, Integer type) {
        CircleRole circleRole = new CircleRole();
        BeanUtils.copyProperties((Object)request, (Object)circleRole);
        List ruleList = Stream.of(request.getRules().split(",")).map(Integer::valueOf).distinct().collect(Collectors.toList());
        circleRole.setId(null);
        circleRole.setRules("");
        circleRole.setType(type);
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue())) {
            SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
            circleRole.setCircleId(currentAdmin.getCircleId());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean save = this.save(circleRole);
            if (!save) {
                return Boolean.FALSE;
            }
            List roleMenuList = ruleList.stream().map(rule -> {
                CircleRoleMenu roleMenu = new CircleRoleMenu();
                roleMenu.setRid(circleRole.getId());
                roleMenu.setMenuId(rule);
                return roleMenu;
            }).collect(Collectors.toList());
            this.circleRoleMenuService.saveBatch(roleMenuList, 100);
            return Boolean.TRUE;
        });
    }

    private Boolean existName(String roleName, Integer id, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleRole::getRoleName, (Object)roleName);
        lqw.ne(id > 0, CircleRole::getId, (Object)id);
        lqw.eq(CircleRole::getType, (Object)type);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public Boolean deletePlaCircleRole(Integer id) {
        return this.deleteRole(id, RoleEnum.CIRCLE_SUPER.getValue());
    }

    private Boolean deleteRole(Integer id, Integer type) {
        CircleRole circleRole = (CircleRole)this.getById(id);
        if (ObjectUtil.isNull((Object)circleRole)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.ROLE_DELETE);
        }
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue()) && circleRole.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException("\u666e\u901a\u89d2\u8272\u4e0d\u5141\u8bb8\u5220\u9664\u8d85\u7ba1\u89d2\u8272");
        }
        if (this.circleAdminService.isExistRole(id).booleanValue()) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.ROLE_USED);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.deleteById(id);
            this.circleRoleMenuService.deleteByRid(id);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean editPlaCircleRole(SystemRoleRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.existName(request.getRoleName(), request.getId(), RoleEnum.CIRCLE_SUPER.getValue()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        return this.editRole(request, RoleEnum.CIRCLE_SUPER.getValue());
    }

    private Boolean editRole(SystemRoleRequest request, Integer type) {
        CircleRole role = (CircleRole)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)role)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.ROLE_NOT_EXIST);
        }
        List ruleList = Stream.of(request.getRules().split(",")).map(Integer::valueOf).distinct().collect(Collectors.toList());
        List roleMenuList = ruleList.stream().map(rule -> {
            CircleRoleMenu roleMenu = new CircleRoleMenu();
            roleMenu.setRid(request.getId());
            roleMenu.setMenuId(rule);
            return roleMenu;
        }).collect(Collectors.toList());
        CircleRole circleRole = new CircleRole();
        BeanUtils.copyProperties((Object)request, (Object)circleRole);
        circleRole.setRules("");
        circleRole.setType(type);
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue())) {
            SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
            circleRole.setCircleId(currentAdmin.getCircleId());
        }
        circleRole.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(circleRole);
            this.circleRoleMenuService.deleteByRid(circleRole.getId());
            this.circleRoleMenuService.saveBatch(roleMenuList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public RoleInfoResponse getInfo(Integer id) {
        List<CircleMenu> menuList;
        CircleRole circleRole = (CircleRole)this.getById(id);
        if (ObjectUtil.isNull((Object)circleRole)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.ROLE_NOT_EXIST);
        }
        List<Integer> menuIdList = this.circleRoleMenuService.getMenuListByRid(id);
        Integer circleId = circleRole.getCircleId();
        if (circleId == 0) {
            menuList = this.circleMenuService.getList();
        } else {
            CircleAdmin circleAdmin = this.circleAdminService.getByCircleId(circleId);
            menuList = this.circleMenuService.findPermissionByUserId(circleAdmin.getId());
        }
        List menuCheckVoList = menuList.stream().map(menu -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)menu, (Object)menuCheckVo);
            menuCheckVo.setChecked(Boolean.valueOf(menuIdList.contains(menu.getId())));
            return menuCheckVo;
        }).collect(Collectors.toList());
        RoleInfoResponse response = new RoleInfoResponse();
        BeanUtils.copyProperties((Object)circleRole, (Object)response);
        response.setMenuList(new MenuCheckTree(menuCheckVoList).buildTree());
        return response;
    }

    @Override
    public Boolean updateStatus(SystemRoleStatusRequest request) {
        CircleRole role = (CircleRole)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)role)) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.ROLE_NOT_EXIST);
        }
        if (role.getStatus().equals(request.getStatus())) {
            return true;
        }
        role.setStatus(request.getStatus());
        role.setUpdateTime((Date)DateUtil.date());
        return this.updateById(role);
    }

    @Override
    public List<CircleRole> getListByCircleId(Integer circleId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleRole::getCircleId, (Object)circleId);
        lqw.ne(CircleRole::getType, (Object)RoleEnum.CIRCLE_SUPER.getValue());
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<CircleRole> getCircleRoleList(SystemRoleSearchRequest request, PageParamRequest pageParamRequest) {
        return this.getList(request, pageParamRequest, RoleEnum.CIRCLE_ADMIN.getValue());
    }

    @Override
    public Boolean addCircleRole(SystemRoleRequest request) {
        return this.addRole(request, RoleEnum.CIRCLE_ADMIN.getValue());
    }

    @Override
    public Boolean deleteCircleRole(Integer id) {
        return this.deleteRole(id, RoleEnum.CIRCLE_ADMIN.getValue());
    }

    @Override
    public Boolean editCircleRole(SystemRoleRequest request) {
        return this.editRole(request, RoleEnum.CIRCLE_ADMIN.getValue());
    }
}

