/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.circle.CircleMerchant;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.circle.CircleMerchantDao;
import com.zbkj.service.service.CircleMerchantService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CircleMerchantServiceImpl
extends ServiceImpl<CircleMerchantDao, CircleMerchant>
implements CircleMerchantService {
    @Resource
    private CircleMerchantDao dao;

    @Override
    public List<Integer> getMerIdListByCirCleIds(List<Integer> circleIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{CircleMerchant::getMerId});
        wrapper.in(CircleMerchant::getCircleId, circleIdList);
        List list = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new Integer[0]);
        }
        return list.stream().map(CircleMerchant::getMerId).distinct().collect(Collectors.toList());
    }

    @Override
    public Integer getMerchantNumByMerIdsAndDate(List<Integer> merIds, String date) {
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        Integer circleId = loginUserVo.getUser().getCircleId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(CircleMerchant::getMerId, merIds);
        wrapper.eq(CircleMerchant::getCircleId, (Object)circleId);
        wrapper.apply("DATE_FORMAT(create_time,'%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)wrapper);
    }

    @Override
    public List<Integer> getMerIdsByCircleId(Integer circleId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CircleMerchant::getCircleId, (Object)circleId);
        List list = this.dao.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new Integer[0]);
        }
        return list.stream().map(CircleMerchant::getMerId).collect(Collectors.toList());
    }

    @Override
    public Boolean removeMer(List<Integer> circleIds, List<Integer> merchantIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(CircleMerchant::getCircleId, circleIds);
        wrapper.in(CircleMerchant::getMerId, merchantIds);
        this.remove((Wrapper)wrapper);
        return Boolean.TRUE;
    }

    @Override
    public List<CircleMerchant> getByCircleIds(List<Integer> circleIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(CircleMerchant::getCircleId, circleIds);
        return this.dao.selectList((Wrapper)wrapper);
    }
}

