/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.cdkey.CdkeyLibrary;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CdkeyLibrarySaveRequest;
import com.zbkj.common.request.CdkeyLibrarySearchRequest;
import com.zbkj.common.response.CdkeyLibraryPageResponse;
import com.zbkj.common.response.CdkeyLibrarySimpleResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.CdkeyLibraryDao;
import com.zbkj.service.service.CardSecretService;
import com.zbkj.service.service.CdkeyLibraryService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CdkeyLibraryServiceImpl
extends ServiceImpl<CdkeyLibraryDao, CdkeyLibrary>
implements CdkeyLibraryService {
    @Resource
    private CdkeyLibraryDao dao;
    @Autowired
    private CardSecretService cardSecretService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private static final Logger logger = LoggerFactory.getLogger(CdkeyLibraryServiceImpl.class);

    @Override
    public PageInfo<CdkeyLibraryPageResponse> findPageList(CdkeyLibrarySearchRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String kerwords = URLUtil.decode((String)request.getName());
            lqw.like(CdkeyLibrary::getName, (Object)kerwords);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProductName())) {
            String productName = URLUtil.decode((String)request.getProductName());
            List<Product> products = this.productService.likeProductName(productName, admin.getMerId());
            if (CollUtil.isEmpty(products)) {
                Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
                return CommonPage.copyPageInfo((Page)page, new ArrayList());
            }
            List productIdList = products.stream().map(Product::getId).collect(Collectors.toList());
            lqw.in(CdkeyLibrary::getProductId, productIdList);
        }
        lqw.eq(CdkeyLibrary::getMerId, (Object)admin.getMerId());
        lqw.eq(CdkeyLibrary::getIsDel, (Object)0);
        lqw.orderByDesc(CdkeyLibrary::getId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List libraryList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)libraryList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List<Integer> proIdList = libraryList.stream().map(CdkeyLibrary::getProductId).filter(productId -> productId > 0).distinct().collect(Collectors.toList());
        Map<Integer, Product> productMap = this.productService.getMapByIdList(proIdList);
        ArrayList<CdkeyLibraryPageResponse> responseList = new ArrayList<CdkeyLibraryPageResponse>();
        for (CdkeyLibrary cdkeyLibrary : libraryList) {
            CdkeyLibraryPageResponse response = new CdkeyLibraryPageResponse();
            response.setId(cdkeyLibrary.getId());
            response.setName(cdkeyLibrary.getName());
            response.setRemark(cdkeyLibrary.getRemark());
            response.setUsedNum(cdkeyLibrary.getUsedNum());
            response.setTotalNum(cdkeyLibrary.getTotalNum());
            response.setCreateTime(cdkeyLibrary.getCreateTime());
            if (cdkeyLibrary.getProductId() > 0) {
                response.setProductName(productMap.get(cdkeyLibrary.getProductId()).getName());
                ProductAttrValue attrValue = (ProductAttrValue)this.productAttrValueService.getById(cdkeyLibrary.getProductAttrValueId());
                response.setProductAttrValueName(attrValue.getSku());
            } else {
                response.setProductName("");
                response.setProductAttrValueName("");
            }
            responseList.add(response);
        }
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean add(CdkeyLibrarySaveRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (this.isExistName(request.getName(), 0, admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u5bc6\u5e93\u540d\u79f0\u5df2\u5b58\u5728");
        }
        CdkeyLibrary cdkeyLibrary = new CdkeyLibrary();
        cdkeyLibrary.setName(request.getName());
        cdkeyLibrary.setRemark(StrUtil.isNotBlank((CharSequence)request.getRemark()) ? request.getRemark() : "");
        cdkeyLibrary.setMerId(admin.getMerId());
        return this.save(cdkeyLibrary);
    }

    @Override
    public Boolean delete(Integer id) {
        CdkeyLibrary cdkeyLibrary = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        cdkeyLibrary.setIsDel(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateById(cdkeyLibrary);
            if (!update) {
                logger.error("\u5220\u9664\u5361\u5bc6\u5e93\u5931\u8d25\uff0c\u5361\u5bc6\u5e93id={}", (Object)id);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.cardSecretService.deleteByLibraryId(cdkeyLibrary.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateLibrary(CdkeyLibrarySaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u5361\u5bc6\u5e93");
        }
        CdkeyLibrary cdkeyLibrary = this.getByIdException(request.getId());
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        if (!cdkeyLibrary.getName().equals(request.getName())) {
            if (this.isExistName(request.getName(), cdkeyLibrary.getId(), cdkeyLibrary.getMerId()).booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u5bc6\u5e93\u540d\u79f0\u5df2\u5b58\u5728");
            }
            cdkeyLibrary.setName(request.getName());
        }
        cdkeyLibrary.setRemark(StrUtil.isNotBlank((CharSequence)request.getRemark()) ? request.getRemark() : "");
        return this.updateById(cdkeyLibrary);
    }

    @Override
    public List<CdkeyLibrarySimpleResponse> findUnrelatedList() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CdkeyLibrary::getId, CdkeyLibrary::getName, CdkeyLibrary::getTotalNum, CdkeyLibrary::getUsedNum});
        lqw.eq(CdkeyLibrary::getProductId, (Object)0);
        lqw.eq(CdkeyLibrary::getMerId, (Object)admin.getMerId());
        lqw.eq(CdkeyLibrary::getIsDel, (Object)0);
        lqw.orderByDesc(CdkeyLibrary::getId);
        List libraryList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)libraryList)) {
            return new ArrayList<CdkeyLibrarySimpleResponse>();
        }
        return libraryList.stream().map(library -> {
            CdkeyLibrarySimpleResponse response = new CdkeyLibrarySimpleResponse();
            response.setId(library.getId());
            response.setName(library.getName());
            response.setStock(Integer.valueOf(library.getTotalNum() - library.getUsedNum()));
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public CdkeyLibrary getByIdException(Integer id) {
        CdkeyLibrary cdkeyLibrary = (CdkeyLibrary)this.getById(id);
        if (ObjectUtil.isNull((Object)cdkeyLibrary) || cdkeyLibrary.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        return cdkeyLibrary;
    }

    @Override
    public Boolean operationTotalNum(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"total_num = total_num + {}", (Object[])new Object[]{num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"total_num = total_num - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (total_num - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5361\u5bc6\u5e93\u5e93\u5b58\u5931\u8d25,\u5361\u5bc6\u5e93id = " + id);
        }
        return update;
    }

    @Override
    public Boolean clearAssociationProduct(Integer proId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CdkeyLibrary::getProductId, (Object)0);
        wrapper.set(CdkeyLibrary::getProductAttrValueId, (Object)0);
        wrapper.eq(CdkeyLibrary::getProductId, (Object)proId);
        wrapper.eq(CdkeyLibrary::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean clearAssociationByIds(List<Integer> idList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CdkeyLibrary::getProductId, (Object)0);
        wrapper.set(CdkeyLibrary::getProductAttrValueId, (Object)0);
        wrapper.in(CdkeyLibrary::getId, idList);
        wrapper.eq(CdkeyLibrary::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<CdkeyLibrary> findByIdList(List<Integer> cdkIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(CdkeyLibrary::getId, cdkIdList);
        lqw.eq(CdkeyLibrary::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean operationUseNum(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"used_num = used_num + {}", (Object[])new Object[]{num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"used_num = used_num - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (used_num - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5361\u5bc6\u5e93\u4f7f\u7528\u6570\u91cf\u5931\u8d25,\u5361\u5bc6\u5e93id = " + id);
        }
        return update;
    }

    private Boolean isExistName(String name, Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CdkeyLibrary::getName, (Object)name);
        if (ObjectUtil.isNotNull((Object)id) && id > 0) {
            lqw.ne(CdkeyLibrary::getId, (Object)id);
        }
        lqw.eq(CdkeyLibrary::getMerId, (Object)merId);
        lqw.eq(CdkeyLibrary::getIsDel, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count >= 1;
    }
}

