/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.cdkey.CardSecret;
import com.zbkj.common.model.cdkey.CdkeyLibrary;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BatchOperationCommonRequest;
import com.zbkj.common.request.CardSecretAddRequest;
import com.zbkj.common.request.CardSecretSaveRequest;
import com.zbkj.common.request.CardSecretSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.CardSecretSimpleVo;
import com.zbkj.service.dao.CardSecretDao;
import com.zbkj.service.service.CardSecretService;
import com.zbkj.service.service.CdkeyLibraryService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CardSecretServiceImpl
extends ServiceImpl<CardSecretDao, CardSecret>
implements CardSecretService {
    @Resource
    private CardSecretDao dao;
    @Autowired
    private CdkeyLibraryService cdkeyLibraryService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    private static final Logger logger = LoggerFactory.getLogger(CardSecretServiceImpl.class);

    @Override
    public PageInfo<CardSecret> findPageList(CardSecretSearchRequest request) {
        CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(request.getLibraryId());
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CardSecret::getLibraryId, (Object)cdkeyLibrary.getId());
        lqw.eq(CardSecret::getIsDel, (Object)0);
        lqw.orderByAsc(CardSecret::getIsUse);
        lqw.orderByDesc(CardSecret::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Boolean deleteByLibraryId(Integer libraryId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CardSecret::getIsDel, (Object)1);
        wrapper.eq(CardSecret::getLibraryId, (Object)libraryId);
        wrapper.eq(CardSecret::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean add(CardSecretAddRequest request) {
        CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(request.getLibraryId());
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        List csList = request.getCsList();
        List<String> cardList = csList.stream().map(CardSecretSimpleVo::getCardNumber).collect(Collectors.toList());
        this.validateCardOnly(cardList, cdkeyLibrary.getId());
        List cardSecretList = csList.stream().map(cs -> {
            CardSecret cardSecret = new CardSecret();
            cardSecret.setCardNumber(cs.getCardNumber());
            cardSecret.setSecretNum(cs.getSecretNum());
            cardSecret.setMerId(cdkeyLibrary.getMerId());
            cardSecret.setLibraryId(cdkeyLibrary.getId());
            cardSecret.setIsUse(Boolean.valueOf(false));
            return cardSecret;
        }).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.saveBatch(cardSecretList);
            if (!update) {
                logger.error("\u65b0\u589e\u5361\u5bc6\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)request.getLibraryId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.cdkeyLibraryService.operationTotalNum(cdkeyLibrary.getId(), cardSecretList.size(), "add");
            if (!update) {
                logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)request.getLibraryId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (cdkeyLibrary.getProductId() > 0) {
                ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(cdkeyLibrary.getProductAttrValueId(), cdkeyLibrary.getProductId(), ProductConstants.PRODUCT_TYPE_CDKEY);
                update = this.productAttrValueService.operationStock(cdkeyLibrary.getProductAttrValueId(), cardSecretList.size(), "quick", ProductConstants.PRODUCT_TYPE_CDKEY, attrValue.getVersion());
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5e93\u5b58\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)request.getLibraryId());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                update = this.productService.operationStock(cdkeyLibrary.getProductId(), cardSecretList.size(), "quick");
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)request.getLibraryId());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean delete(Integer id) {
        CardSecret cardSecret = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cardSecret.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_NOT_EXIST);
        }
        if (cardSecret.getIsUse().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_USED);
        }
        CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(cardSecret.getLibraryId());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CardSecret::getIsDel, (Object)1);
        wrapper.eq(CardSecret::getId, (Object)id);
        wrapper.eq(CardSecret::getIsDel, (Object)0);
        wrapper.eq(CardSecret::getIsUse, (Object)0);
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.update((Wrapper)wrapper);
            if (!update) {
                logger.error("\u5220\u9664\u5361\u5bc6\u5931\u8d25\uff0c\u5361\u5bc6ID={}", (Object)id);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.cdkeyLibraryService.operationTotalNum(cardSecret.getLibraryId(), 1, "sub");
            if (!update) {
                logger.error("\u5220\u9664\u5361\u5bc6,\u66f4\u65b0\u5361\u5bc6\u5e93\u5e93\u5b58\u5931\u8d25\uff0c\u5361\u5bc6ID={}", (Object)id);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (cdkeyLibrary.getProductId() > 0) {
                ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(cdkeyLibrary.getProductAttrValueId(), cdkeyLibrary.getProductId(), ProductConstants.PRODUCT_TYPE_CDKEY);
                update = this.productAttrValueService.operationStock(cdkeyLibrary.getProductAttrValueId(), 1, "delete", ProductConstants.PRODUCT_TYPE_CDKEY, attrValue.getVersion());
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5e93\u5b58\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6ID = {}", (Object)id);
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                update = this.productService.operationStock(cdkeyLibrary.getProductId(), 1, "delete");
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6ID = {}", (Object)id);
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean edit(CardSecretSaveRequest request) {
        CardSecret cardSecret = this.getByIdException(request.getId());
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cardSecret.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_NOT_EXIST);
        }
        if (cardSecret.getIsUse().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_USED);
        }
        if (cardSecret.getCardNumber().equals(request.getCardNumber()) && cardSecret.getSecretNum().equals(request.getSecretNum())) {
            return Boolean.TRUE;
        }
        if (!cardSecret.getCardNumber().equals(request.getCardNumber())) {
            this.validateCardOnly(request.getCardNumber(), cardSecret.getLibraryId());
            cardSecret.setCardNumber(request.getCardNumber());
        }
        cardSecret.setSecretNum(request.getSecretNum());
        return this.updateById(cardSecret);
    }

    @Override
    public Boolean addImportExcel(MultipartFile file, Integer libraryId) {
        CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(libraryId);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
        }
        String type = FileUtil.extName((String)file.getOriginalFilename());
        if (!"xlsx".equals(type) && !"xls".equals(type)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u63d0\u4ea4\u6b63\u786e\u7684excel\u6587\u4ef6");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e2) {
            logger.error("\u5bfc\u5165\u5361\u5bc6\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e2);
            throw new CrmebException("\u5bfc\u5165\u5361\u5bc6\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25");
        }
        ExcelReader excelReader = ExcelUtil.getReader((InputStream)inputStream);
        excelReader.addHeaderAlias("\u5361\u53f7", "cardNumber");
        excelReader.addHeaderAlias("\u5bc6\u7801", "secretNum");
        List cardSecretList = excelReader.readAll(CardSecret.class);
        if (CollUtil.isEmpty((Collection)cardSecretList)) {
            return Boolean.TRUE;
        }
        for (CardSecret cardSecret : cardSecretList) {
            if (!StrUtil.isBlank((CharSequence)cardSecret.getCardNumber()) && !StrUtil.isBlank((CharSequence)cardSecret.getSecretNum())) continue;
            throw new CrmebException("\u5bfc\u5165\u5361\u5bc6\u6587\u4ef6\u6570\u636e\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        List collect = cardSecretList.stream().map(CardSecret::getCardNumber).distinct().collect(Collectors.toList());
        if (cardSecretList.size() != collect.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5bfc\u5165\u6570\u636e\u4e2d\u5305\u542b\u91cd\u590d\u5361\u53f7");
        }
        for (CardSecret cardSecret : cardSecretList) {
            this.validateCardOnly(cardSecret.getCardNumber(), libraryId);
            cardSecret.setMerId(cdkeyLibrary.getMerId());
            cardSecret.setLibraryId(cdkeyLibrary.getId());
            cardSecret.setIsUse(Boolean.valueOf(false));
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.saveBatch(cardSecretList);
            if (!update) {
                logger.error("\u5bfc\u5165\u5361\u5bc6\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)libraryId);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.cdkeyLibraryService.operationTotalNum(cdkeyLibrary.getId(), cardSecretList.size(), "add");
            if (!update) {
                logger.error("\u5bfc\u5165\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)libraryId);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (cdkeyLibrary.getProductId() > 0) {
                ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(cdkeyLibrary.getProductAttrValueId(), cdkeyLibrary.getProductId(), ProductConstants.PRODUCT_TYPE_CDKEY);
                update = this.productAttrValueService.operationStock(cdkeyLibrary.getProductAttrValueId(), cardSecretList.size(), "quick", ProductConstants.PRODUCT_TYPE_CDKEY, attrValue.getVersion());
                if (!update) {
                    logger.error("\u5bfc\u5165\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5e93\u5b58\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)libraryId);
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                update = this.productService.operationStock(cdkeyLibrary.getProductId(), cardSecretList.size(), "quick");
                if (!update) {
                    logger.error("\u5bfc\u5165\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6\u5e93ID = {}", (Object)libraryId);
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchDelete(BatchOperationCommonRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        List integers = CrmebUtil.stringToArray((String)request.getIds());
        if (CollUtil.isEmpty((Collection)integers)) {
            return true;
        }
        List<CardSecret> cardSecretList = this.findByIdS(integers);
        if (CollUtil.isEmpty(cardSecretList)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_NOT_EXIST);
        }
        if (integers.size() != cardSecretList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6570\u636e\u6761\u76ee\u65e0\u6cd5\u5bf9\u5e94\uff0c\u8bf7\u5237\u8bf7\u540e\u64cd\u4f5c");
        }
        cardSecretList.forEach(cs -> {
            if (!admin.getMerId().equals(cs.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_NOT_EXIST);
            }
            if (cs.getIsUse().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_USED);
            }
            if (cs.getIsDel().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_DELETE);
            }
            cs.setIsDel(Boolean.valueOf(true));
        });
        CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(cardSecretList.get(0).getLibraryId());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateBatchById(cardSecretList);
            if (!update) {
                logger.error("\u6279\u91cf\u5220\u9664\u5361\u5bc6\u5931\u8d25\uff0c\u5361\u5bc6IDS={}", (Object)request.getIds());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.cdkeyLibraryService.operationTotalNum(cdkeyLibrary.getId(), cardSecretList.size(), "sub");
            if (!update) {
                logger.error("\u6279\u91cf\u5220\u9664\u5361\u5bc6,\u66f4\u65b0\u5361\u5bc6\u5e93\u5e93\u5b58\u5931\u8d25\uff0c\u5361\u5bc6IDS={}", (Object)request.getIds());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (cdkeyLibrary.getProductId() > 0) {
                ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(cdkeyLibrary.getProductAttrValueId(), cdkeyLibrary.getProductId(), ProductConstants.PRODUCT_TYPE_CDKEY);
                update = this.productAttrValueService.operationStock(cdkeyLibrary.getProductAttrValueId(), cardSecretList.size(), "delete", ProductConstants.PRODUCT_TYPE_CDKEY, attrValue.getVersion());
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5e93\u5b58\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6IDS={}", (Object)request.getIds());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                update = this.productService.operationStock(cdkeyLibrary.getProductId(), cardSecretList.size(), "delete");
                if (!update) {
                    logger.error("\u65b0\u589e\u5361\u5bc6\u66f4\u65b0\u5361\u5bc6\u5e93\u5173\u8054\u5546\u54c1\u6570\u91cf\u5931\u8d25\uff0c\u5361\u5bc6IDS={}", (Object)request.getIds());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public CardSecret consume(Integer libraryId) {
        CardSecret cardSecret = this.getByNotUsed(libraryId);
        if (ObjectUtil.isNull((Object)cardSecret)) {
            return null;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CardSecret::getIsUse, (Object)1);
        wrapper.eq(CardSecret::getIsUse, (Object)0);
        wrapper.eq(CardSecret::getIsDel, (Object)0);
        wrapper.eq(CardSecret::getId, (Object)cardSecret.getId());
        boolean update = this.update((Wrapper)wrapper);
        if (!update) {
            return null;
        }
        return cardSecret;
    }

    @Override
    public Boolean cancelConsume(List<Integer> cardSecretIdList) {
        Integer cardSecretId = cardSecretIdList.get(0);
        CardSecret cardSecret = (CardSecret)this.getById(cardSecretId);
        return (Boolean)this.transactionTemplate.execute(e -> {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            wrapper.set(CardSecret::getIsUse, (Object)0);
            wrapper.eq(CardSecret::getIsUse, (Object)1);
            wrapper.in(CardSecret::getId, (Collection)cardSecretIdList);
            this.update((Wrapper)wrapper);
            this.cdkeyLibraryService.operationUseNum(cardSecret.getLibraryId(), cardSecretIdList.size(), "sub");
            return Boolean.TRUE;
        });
    }

    @Override
    public List<CardSecret> findByIds(List<Integer> cardSecretIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(CardSecret::getId, cardSecretIdList);
        return this.dao.selectList((Wrapper)lqw);
    }

    private CardSecret getByNotUsed(Integer libraryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CardSecret::getLibraryId, (Object)libraryId);
        lqw.eq(CardSecret::getIsUse, (Object)0);
        lqw.eq(CardSecret::getIsDel, (Object)0);
        lqw.orderByAsc(CardSecret::getId);
        lqw.last(" limit 1");
        return (CardSecret)this.dao.selectOne((Wrapper)lqw);
    }

    private List<CardSecret> findByIdS(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(CardSecret::getId, idList);
        return this.dao.selectList((Wrapper)lqw);
    }

    private CardSecret getByIdException(Integer id) {
        CardSecret cardSecret = (CardSecret)this.getById(id);
        if (ObjectUtil.isNull((Object)cardSecret) || cardSecret.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CARD_SECRET_NOT_EXIST);
        }
        return cardSecret;
    }

    private void validateCardOnly(String cardNumber, Integer libraryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CardSecret::getCardNumber, (Object)cardNumber);
        lqw.eq(CardSecret::getLibraryId, (Object)libraryId);
        lqw.eq(CardSecret::getIsDel, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        if (count > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u53f7\u91cd\u590d");
        }
    }

    private void validateCardOnly(List<String> cardNumberList, Integer libraryId) {
        List collect = cardNumberList.stream().distinct().collect(Collectors.toList());
        if (cardNumberList.size() != collect.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6dfb\u52a0\u6570\u636e\u4e2d\u6709\u91cd\u590d\u5361\u53f7");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(CardSecret::getCardNumber, cardNumberList);
        lqw.eq(CardSecret::getLibraryId, (Object)libraryId);
        lqw.eq(CardSecret::getIsDel, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        if (count > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u53f7\u91cd\u590d");
        }
    }
}

