/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.groupbuy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.ShippingTemplatesConstants;
import com.zbkj.common.enums.GroupBuyRecordEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.cdkey.CardSecret;
import com.zbkj.common.model.express.ShippingTemplates;
import com.zbkj.common.model.express.ShippingTemplatesFree;
import com.zbkj.common.model.express.ShippingTemplatesRegion;
import com.zbkj.common.model.groupbuy.GroupBuyActivity;
import com.zbkj.common.model.groupbuy.GroupBuyActivitySku;
import com.zbkj.common.model.groupbuy.GroupBuyRecord;
import com.zbkj.common.model.groupbuy.GroupBuyUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.system.SystemForm;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserAddress;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CreateOrderRequest;
import com.zbkj.common.request.GroupBuyRecordPageNumRequest;
import com.zbkj.common.request.OrderMerchantRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.PreOrderDetailRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.request.groupbuy.GroupBuyRecordForCache;
import com.zbkj.common.request.groupbuy.GroupBuyRecordSearchRequest;
import com.zbkj.common.response.OrderNoResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityRecordAdminListResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityRecordListHeaderCount;
import com.zbkj.common.response.groupbuy.GroupBuyActivityResponse;
import com.zbkj.common.response.groupbuy.GroupBuyRecordDetailMemberResponse;
import com.zbkj.common.response.groupbuy.GroupBuyRecordDetailResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.PreMerchantOrderVo;
import com.zbkj.common.vo.PreOrderInfoDetailVo;
import com.zbkj.common.vo.PreOrderInfoVo;
import com.zbkj.service.dao.groupby.GroupBuyRecordDao;
import com.zbkj.service.service.CardSecretService;
import com.zbkj.service.service.CdkeyLibraryService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.ShippingTemplatesFreeService;
import com.zbkj.service.service.ShippingTemplatesRegionService;
import com.zbkj.service.service.ShippingTemplatesService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemFormService;
import com.zbkj.service.service.UserAddressService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.groupbuy.GroupBuyActivityService;
import com.zbkj.service.service.groupbuy.GroupBuyActivitySkuService;
import com.zbkj.service.service.groupbuy.GroupBuyRecordService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class GroupBuyRecordServiceImpl
extends ServiceImpl<GroupBuyRecordDao, GroupBuyRecord>
implements GroupBuyRecordService {
    private final Logger logger = LoggerFactory.getLogger(GroupBuyRecordServiceImpl.class);
    @Resource
    private GroupBuyRecordDao dao;
    @Autowired
    private GroupBuyActivityService groupBuyActivityService;
    @Autowired
    private GroupBuyActivitySkuService groupBuyActivitySkuService;
    @Autowired
    private GroupBuyUserService groupBuyUserService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserAddressService userAddressService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ShippingTemplatesService shippingTemplatesService;
    @Autowired
    private ShippingTemplatesFreeService shippingTemplatesFreeService;
    @Autowired
    private ShippingTemplatesRegionService shippingTemplatesRegionService;
    @Autowired
    private CdkeyLibraryService cdkeyLibraryService;
    @Autowired
    private CardSecretService cardSecretService;
    @Autowired
    private SystemFormService systemFormService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    public PageInfo<GroupBuyActivityRecordAdminListResponse> getList(GroupBuyRecordSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recordStatus", request.getRecordStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getGroupActivityName())) {
            map.put("groupActivityName", URLUtil.decode((String)request.getGroupActivityName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProductName())) {
            map.put("productName", URLUtil.decode((String)request.getProductName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getStartTime())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)(request.getStartTime() + "," + request.getEndTime()));
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (admin.getMerId() > 0) {
            map.put("merId", admin.getMerId());
        } else if (StrUtil.isNotBlank((CharSequence)request.getMerName())) {
            map.put("merName", URLUtil.decode((String)request.getMerName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        Page groupBuyRecordsPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<GroupBuyActivityRecordAdminListResponse> responseList = this.dao.findAdminList(map);
        return CommonPage.copyPageInfo((Page)groupBuyRecordsPage, responseList);
    }

    @Override
    public GroupBuyActivityRecordListHeaderCount getListHeaderCount(GroupBuyRecordPageNumRequest request, SystemAdmin systemAdmin) {
        GroupBuyActivityRecordListHeaderCount headerCount = new GroupBuyActivityRecordListHeaderCount();
        headerCount.setIngNum(this.getListHeaderCountNum(request, 0, systemAdmin.getMerId()));
        headerCount.setSuccessNum(this.getListHeaderCountNum(request, 10, systemAdmin.getMerId()));
        headerCount.setFailNum(this.getListHeaderCountNum(request, -1, systemAdmin.getMerId()));
        return headerCount;
    }

    @Override
    public GroupBuyRecordDetailResponse getByAdminDetail(Integer id) {
        GroupBuyRecordDetailResponse response = new GroupBuyRecordDetailResponse();
        GroupBuyRecord groupBuyRecord = this.getByIdException(id);
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (admin.getMerId() > 0 && !groupBuyRecord.getMerId().equals(admin.getMerId())) {
            throw new CrmebException("\u62fc\u56e2\u5f00\u56e2\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        response.setGroupBuyingId(groupBuyRecord.getGroupBuyingId());
        response.setRecordStatus(groupBuyRecord.getRecordStatus());
        response.setBuyingCountNum(groupBuyRecord.getBuyingCountNum());
        response.setYetBuyingNum(groupBuyRecord.getYetBuyingNum());
        response.setCreateTime(groupBuyRecord.getCreateTime());
        response.setEndTime(groupBuyRecord.getEndTime());
        Product product = (Product)this.productService.getById(groupBuyRecord.getProductGroupId());
        response.setProductName(product.getName());
        response.setProductImage(product.getImage());
        List<GroupBuyUser> groupBuyUserList = this.groupBuyUserService.getListByGroupRecordId(groupBuyRecord.getGroupBuyingId());
        List memberResponseList = groupBuyUserList.stream().map(groupBuyUser -> {
            GroupBuyRecordDetailMemberResponse memberResponse = new GroupBuyRecordDetailMemberResponse();
            User user = (User)this.userService.getById(groupBuyUser.getGroupUid());
            Order order = this.orderService.getByOrderNo(groupBuyUser.getOrderId());
            List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(groupBuyUser.getOrderId());
            OrderDetail orderDetail = orderDetailList.get(0);
            memberResponse.setId(groupBuyUser.getId());
            memberResponse.setMemberId(groupBuyUser.getGroupUid());
            memberResponse.setMemberNickname(user.getNickname());
            memberResponse.setMemberAvatar(user.getAvatar());
            memberResponse.setOrderNo(groupBuyUser.getOrderId());
            memberResponse.setOrderDetailSku(orderDetail.getSku());
            memberResponse.setPayNum(groupBuyUser.getPayNum());
            memberResponse.setPayPrice(order.getPayPrice());
            memberResponse.setRefundNum(orderDetail.getRefundNum());
            memberResponse.setIsLeader(groupBuyUser.getIsLeader());
            memberResponse.setCreateTime(groupBuyUser.getCreateTime());
            return memberResponse;
        }).collect(Collectors.toList());
        response.setMemberDataList(memberResponseList);
        return response;
    }

    private GroupBuyRecord getByIdException(Integer id) {
        GroupBuyRecord groupBuyRecord = (GroupBuyRecord)this.getById(id);
        if (ObjectUtil.isNull((Object)groupBuyRecord) || groupBuyRecord.getIsDel().equals(1)) {
            throw new CrmebException("\u62fc\u56e2\u5f00\u56e2\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return groupBuyRecord;
    }

    private Integer getListHeaderCountNum(GroupBuyRecordPageNumRequest request, Integer recordStatus, Integer merId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recordStatus", recordStatus);
        if (StrUtil.isNotBlank((CharSequence)request.getGroupActivityName())) {
            map.put("groupActivityName", URLUtil.decode((String)request.getGroupActivityName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProductName())) {
            map.put("productName", URLUtil.decode((String)request.getProductName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getStartTime())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)(request.getStartTime() + "," + request.getEndTime()));
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (merId > 0) {
            map.put("merId", merId);
        } else if (StrUtil.isNotBlank((CharSequence)request.getMerName())) {
            map.put("merName", URLUtil.decode((String)request.getMerName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        return this.dao.getAdminListHeaderCount(map);
    }

    @Override
    public OrderNoResponse validationBeforeCreateOrder(CreateOrderRequest orderRequest, PreOrderInfoVo orderInfoVo, User user) {
        OrderNoResponse response = new OrderNoResponse();
        for (PreMerchantOrderVo preMerchantOrderVo : orderInfoVo.getMerchantOrderVoList()) {
            for (PreOrderInfoDetailVo preOrderInfoDetailVo : preMerchantOrderVo.getOrderInfoList()) {
                GroupBuyActivityResponse groupBuyActivity = this.groupBuyActivityService.getGroupBuyActivityForFront(preOrderInfoDetailVo.getGroupBuyActivityId());
                if (ObjectUtil.isNull((Object)groupBuyActivity)) {
                    throw new CrmebException("\u62fc\u56e2\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (!groupBuyActivity.getGroupProcess().equals(1)) {
                    throw new CrmebException("\u5f53\u524d\u62fc\u56e2\u6d3b\u52a8\u5df2\u5931\u6548");
                }
                GroupBuyActivitySku currentActivitySku = this.groupBuyActivitySkuService.getByAttrId(groupBuyActivity.getId(), preOrderInfoDetailVo.getAttrValueId());
                if (ObjectUtil.isNull((Object)currentActivitySku)) {
                    throw new CrmebException("\u62fc\u56e2\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (currentActivitySku.getQuota() < preOrderInfoDetailVo.getPayNum()) {
                    throw new CrmebException("\u62fc\u56e2\u5546\u54c1\u5f53\u524d\u5e93\u5b58\u4e0d\u8db3");
                }
                List<GroupBuyUser> currentGroupBuy = this.groupBuyUserService.getCurrentGroupBuyActivityRecordListByUserId(user.getId(), groupBuyActivity.getId(), preOrderInfoDetailVo.getGroupBuyRecordId(), -1);
                Integer currentUserBuyedCount = 0;
                if (!currentGroupBuy.isEmpty()) {
                    currentUserBuyedCount = currentGroupBuy.stream().map(GroupBuyUser::getPayNum).reduce(Integer::sum).get();
                }
                this.logger.info("\u5f53\u524d\u7684\u8d2d\u4e70\u7684\u4eba\u5458:{}", (Object)JSONObject.toJSONString(currentGroupBuy));
                List<Object> currentGroupBuyEd = new ArrayList();
                Integer historyGroupBuyCount = 0;
                if (preOrderInfoDetailVo.getGroupBuyRecordId() > 0) {
                    currentGroupBuyEd = this.groupBuyUserService.getCurrentGroupBuyActivityRecordList(groupBuyActivity.getId(), 0, preOrderInfoDetailVo.getGroupBuyRecordId());
                    if (!currentGroupBuyEd.isEmpty()) {
                        historyGroupBuyCount = currentGroupBuyEd.stream().map(GroupBuyUser::getPayNum).reduce(Integer::sum).get();
                    }
                    this.logger.info("\u5df2\u7ecf\u53c2\u4e0e\u5f53\u524d\u62fc\u56e2\u7684\u4eba\u5458:{}", (Object)JSONObject.toJSONString(currentGroupBuyEd));
                }
                if (groupBuyActivity.getAllQuota() > 0 && groupBuyActivity.getAllQuota() <= currentGroupBuy.size()) {
                    throw new CrmebException("\u62fc\u56e2\u4eba\u6570\u5df2\u8fbe\u4e0a\u7ebf");
                }
                this.logger.info("\u5f53\u524d\u62fc\u56e2\u8d2d\u4e70\u4ef6\u6570:{}", (Object)preOrderInfoDetailVo.getPayNum());
                this.logger.info("\u5f53\u524d\u62fc\u56e2\u5386\u53f2\u5df2\u7ecf\u8d2d\u4e70\u4ef6\u6570:{}", (Object)historyGroupBuyCount);
                int total = preOrderInfoDetailVo.getPayNum() + historyGroupBuyCount;
                if (groupBuyActivity.getAllQuota() > 0 && preOrderInfoDetailVo.getPayNum() > groupBuyActivity.getAllQuota()) {
                    throw new CrmebException("\u771f\u4eba\u62fc\u56e2\u5df2\u8fbe\u4e0a\u9650");
                }
                if (currentGroupBuyEd.size() > groupBuyActivity.getBuyCount()) {
                    response.setGroupBuyIsFull(Integer.valueOf(1));
                    return response;
                }
                int total_kai = currentUserBuyedCount + preOrderInfoDetailVo.getPayNum();
                if (groupBuyActivity.getAllQuota() > 0 && total_kai > groupBuyActivity.getAllQuota()) {
                    throw new CrmebException("\u5f00\u56e2\u5df2\u8fbe\u4e0a\u9650");
                }
                if (groupBuyActivity.getOncQuota() > 0 && preOrderInfoDetailVo.getPayNum() > groupBuyActivity.getOncQuota()) {
                    response.setGroupBuyIsFull(Integer.valueOf(1));
                    return response;
                }
                if (groupBuyActivity.getAllQuota() == 0 && groupBuyActivity.getBuyCount() > 0 && currentGroupBuyEd.size() >= groupBuyActivity.getBuyCount()) {
                    response.setGroupBuyIsFull(Integer.valueOf(1));
                    return response;
                }
                if (groupBuyActivity.getAllQuota() > 0 && groupBuyActivity.getBuyCount() > 0 && currentGroupBuyEd.size() >= groupBuyActivity.getBuyCount()) {
                    response.setGroupBuyIsFull(Integer.valueOf(1));
                    return response;
                }
                if (currentActivitySku.getQuota() <= 0) {
                    throw new CrmebException("\u62fc\u56e2\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                Integer waitPayCount = this.orderDetailService.getByGroupBuyActivityId(preOrderInfoDetailVo.getGroupBuyActivityId(), preOrderInfoDetailVo.getProductId(), user.getId());
                total += waitPayCount.intValue();
                this.logger.info("\u62fc\u56e2 \u6709 \u5f85\u652f\u4ed8\u8ba2\u5355\u6570\u91cf :{}", (Object)waitPayCount);
                int buyNowCount = preOrderInfoDetailVo.getPayNum() + currentUserBuyedCount;
                this.logger.info("\u62fc\u56e2 \u5f53\u524d\u7528\u6237\u8d2d\u4e70\u6570\u91cf\uff1a{}", (Object)buyNowCount);
                if (groupBuyActivity.getAllQuota() <= 0 || buyNowCount <= groupBuyActivity.getAllQuota()) continue;
                throw new CrmebException("\u9650\u8d2d\u5df2\u8fbe\u4e0a\u9650 4");
            }
        }
        return response;
    }

    @Override
    public void subStock(String orderNo, CreateOrderRequest orderRequest, PreOrderInfoVo orderInfoVo, User user) {
        this.logger.info("\u62fc\u56e2\u6263\u51cf\u5e93\u5b58\u5f00\u59cb\uff1a${}", (Object)JSON.toJSONString((Object)orderInfoVo));
        for (PreMerchantOrderVo preMerchantOrderVo : orderInfoVo.getMerchantOrderVoList()) {
            for (PreOrderInfoDetailVo preOrderInfoDetailVo : preMerchantOrderVo.getOrderInfoList()) {
                this.groupBuyActivitySkuService.subSKUStock(preOrderInfoDetailVo.getGroupBuyActivityId(), preOrderInfoDetailVo.getAttrValueId(), preOrderInfoDetailVo.getPayNum());
            }
        }
    }

    @Override
    public List<GroupBuyRecord> getGroupBuyUserActivityDoneList(Integer groupActivityId, Integer userId, Integer productId, int limit) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(GroupBuyRecord::getGroupActivityId, (Object)groupActivityId);
        queryWrapper.eq(GroupBuyRecord::getProductGroupId, (Object)productId);
        queryWrapper.eq(GroupBuyRecord::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        queryWrapper.last("limit " + limit);
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public GroupBuyRecord newGroupBuyRecordOrContinueBuy(String orderNo, Integer payNum, Integer groupActivityId, Integer groupProductId, Integer groupBuyRecordId, Integer fictiStatus, Integer merId, Integer skuid, Integer uid, String nickname, String avatar) {
        GroupBuyRecord record;
        GroupBuyActivity currentActivity = (GroupBuyActivity)this.groupBuyActivityService.getById(groupActivityId);
        if (groupBuyRecordId == 0) {
            currentActivity.setTotalActivityBegin(Integer.valueOf(currentActivity.getTotalActivityBegin() + 1));
            record = new GroupBuyRecord();
            record.setProductGroupId(groupProductId);
            record.setMerId(merId);
            record.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
            record.setBuyingCountNum(currentActivity.getBuyCount());
            record.setBuyingNum(Integer.valueOf(1));
            record.setYetBuyingNum(Integer.valueOf(1));
            record.setShowGroup(currentActivity.getShowGroup());
            record.setGroupLeaderUid(uid);
            record.setGroupLeaderNickname(nickname);
            record.setGroupActivityId(groupActivityId);
            record.setSkuid(skuid);
            record.setFictiStatus(fictiStatus);
            DateTime currentDate = DateUtil.date();
            DateTime groupDoneTime = DateUtil.offsetHour((Date)currentDate, (int)currentActivity.getValidHour());
            record.setEndTime((Date)groupDoneTime);
            this.save(record);
            this.redisUtil.lPush("groupBuyRecordStatusKey", (Object)record.getGroupBuyingId());
            this.logger.info("\u62fc\u56e2-\u5f00\u56e2-\u4efb\u52a1\u52a0\u5165:{}", (Object)record.getGroupBuyingId());
        } else {
            record = (GroupBuyRecord)this.getById(groupBuyRecordId);
            record.setBuyingNum(Integer.valueOf(record.getBuyingNum() + 1));
            record.setYetBuyingNum(Integer.valueOf(record.getYetBuyingNum() + 1));
            this.updateById(record);
        }
        currentActivity.setTotalOrderBegin(Integer.valueOf(currentActivity.getTotalOrderBegin() + 1));
        this.groupBuyActivityService.updateById(currentActivity);
        return record;
    }

    @Override
    public OrderNoResponse createOrder(CreateOrderRequest orderRequest, PreOrderInfoVo orderInfoVo, User user, String perOrderKey) {
        UserAddress userAddress = null;
        List orderMerchantRequestList = orderRequest.getOrderMerchantRequestList();
        if (orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) || orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY) || orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIRTUALLY)) {
            orderRequest.setAddressId(Integer.valueOf(0));
        } else {
            if (orderMerchantRequestList.stream().anyMatch(e -> e.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS))) {
                if (ObjectUtil.isNull((Object)orderRequest.getAddressId())) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u6536\u8d27\u5730\u5740");
                }
                userAddress = (UserAddress)this.userAddressService.getById(orderRequest.getAddressId());
                if (ObjectUtil.isNull((Object)userAddress) || userAddress.getIsDel().booleanValue()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6536\u8d27\u5730\u5740\u6709\u8bef");
                }
            }
            if (orderMerchantRequestList.stream().anyMatch(e -> e.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP))) {
                orderMerchantRequestList.forEach(m -> {
                    Merchant merchant;
                    if (m.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP) && !(merchant = this.merchantService.getByIdException(m.getMerId())).getIsTakeTheir().booleanValue()) {
                        throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"{}\u6ca1\u6709\u914d\u7f6e\u5e97\u94fa\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d", (Object[])new Object[]{merchant.getName()}));
                    }
                });
            }
        }
        List<MyRecord> skuRecordList = this.validateProductStock(orderInfoVo);
        orderInfoVo.getMerchantOrderVoList().forEach(e -> orderMerchantRequestList.forEach(o -> {
            if (o.getMerId().equals(e.getMerId())) {
                e.setShippingType(o.getShippingType());
                e.setUserCouponId(o.getUserCouponId());
                e.setCouponFee(BigDecimal.ZERO);
                e.setMerCouponFee(BigDecimal.ZERO);
            }
        }));
        this.getFreightFee_V_1_8(orderInfoVo, userAddress, user.getIsPaidMember());
        orderInfoVo.setPlatUserCouponId(orderRequest.getPlatUserCouponId());
        orderInfoVo.setPlatCouponFee(BigDecimal.ZERO);
        orderInfoVo.setCouponFee(BigDecimal.ZERO);
        orderInfoVo.setMerCouponFee(BigDecimal.ZERO);
        List merchantOrderVoList = orderInfoVo.getMerchantOrderVoList();
        OrderNoResponse responseValidation = this.validationBeforeCreateOrder(orderRequest, orderInfoVo, user);
        this.logger.info("\u62fc\u56e2\u6ee1\u5458 = {}", (Object)JSON.toJSONString((Object)responseValidation));
        if (ObjectUtil.isNotNull((Object)responseValidation.getGroupBuyIsFull()) && responseValidation.getGroupBuyIsFull().equals(1)) {
            return responseValidation;
        }
        Order order = new Order();
        String orderNo = CrmebUtil.getOrderNo((String)"PT");
        order.setOrderNo(orderNo);
        order.setMerId(Integer.valueOf(0));
        order.setUid(user.getId());
        order.setTotalNum(orderInfoVo.getOrderProNum());
        order.setProTotalPrice(orderInfoVo.getProTotalFee());
        order.setTotalPostage(orderInfoVo.getFreightFee());
        order.setSvipDiscountPrice(orderInfoVo.getSvipDiscountPrice());
        order.setTotalPrice(order.getProTotalPrice().add(order.getTotalPostage()));
        order.setCouponPrice(orderInfoVo.getCouponFee());
        order.setUseIntegral(Integer.valueOf(merchantOrderVoList.stream().mapToInt(PreMerchantOrderVo::getUseIntegral).sum()));
        order.setIntegralPrice(merchantOrderVoList.stream().map(PreMerchantOrderVo::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        order.setPayPrice(order.getTotalPrice().subtract(order.getSvipDiscountPrice()).subtract(order.getCouponPrice()).subtract(order.getIntegralPrice()));
        order.setPayPostage(order.getTotalPostage());
        order.setPaid(Boolean.valueOf(false));
        order.setCancelStatus(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
        order.setLevel(OrderConstants.ORDER_LEVEL_PLATFORM);
        order.setType(orderInfoVo.getType());
        order.setSecondType(orderInfoVo.getSecondType());
        order.setMerCouponPrice(orderInfoVo.getMerCouponFee());
        order.setPlatCouponPrice(orderInfoVo.getPlatCouponFee());
        order.setPlatCouponId(orderInfoVo.getPlatUserCouponId());
        order.setIsSvip(user.getIsPaidMember());
        order.setSystemFormId(orderInfoVo.getSystemFormId());
        order.setOrderExtend(StrUtil.isNotBlank((CharSequence)orderRequest.getOrderExtend()) ? this.systemAttachmentService.clearPrefix(orderRequest.getOrderExtend(), this.systemAttachmentService.getCdnUrl()) : "");
        PreOrderInfoDetailVo detailVoForGroupBuy = new PreOrderInfoDetailVo();
        Integer merId = 0;
        ArrayList couponIdList = CollUtil.newArrayList((Object[])new Integer[0]);
        if (orderRequest.getPlatUserCouponId() > 0) {
            couponIdList.add(orderRequest.getPlatUserCouponId());
        }
        ArrayList<MerchantOrder> merchantOrderList = new ArrayList<MerchantOrder>();
        ArrayList<OrderDetail> orderDetailList = new ArrayList<OrderDetail>();
        for (PreMerchantOrderVo merchantOrderVo : merchantOrderVoList) {
            MerchantOrder merchantOrder = new MerchantOrder();
            merchantOrder.setOrderNo(order.getOrderNo());
            merchantOrder.setMerId(merchantOrderVo.getMerId());
            merchantOrder.setUid(user.getId());
            for (OrderMerchantRequest om : orderMerchantRequestList) {
                if (!om.getMerId().equals(merchantOrderVo.getMerId())) continue;
                if (StrUtil.isNotBlank((CharSequence)om.getRemark())) {
                    merchantOrder.setUserRemark(om.getRemark());
                }
                merchantOrder.setShippingType(om.getShippingType());
                break;
            }
            if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) || order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY) || orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIRTUALLY)) {
                merchantOrder.setRealName(user.getNickname());
                merchantOrder.setUserPhone(user.getPhone());
                merchantOrder.setUserAddress("");
            } else if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                merchantOrder.setUserAddress(merchantOrderVo.getMerName());
                merchantOrder.setVerifyCode(String.valueOf(CrmebUtil.randomCount((Integer)1111111111, (Integer)999999999)));
            } else {
                merchantOrder.setRealName(userAddress.getRealName());
                merchantOrder.setUserPhone(userAddress.getPhone());
                String userAddressStr = userAddress.getProvince() + userAddress.getCity() + userAddress.getDistrict() + userAddress.getStreet() + userAddress.getDetail();
                merchantOrder.setUserAddress(userAddressStr);
            }
            merchantOrder.setTotalNum(merchantOrderVo.getProTotalNum());
            merchantOrder.setProTotalPrice(merchantOrderVo.getProTotalFee());
            merchantOrder.setTotalPostage(merchantOrderVo.getFreightFee());
            merchantOrder.setTotalPrice(merchantOrder.getProTotalPrice().add(merchantOrder.getTotalPostage()));
            merchantOrder.setPayPostage(merchantOrder.getTotalPostage());
            merchantOrder.setUseIntegral(merchantOrderVo.getUseIntegral());
            merchantOrder.setIntegralPrice(merchantOrderVo.getIntegralPrice());
            merchantOrder.setCouponId(merchantOrderVo.getUserCouponId());
            if (merchantOrder.getCouponId() > 0) {
                couponIdList.add(merchantOrder.getCouponId());
            }
            merchantOrder.setSvipDiscountPrice(merchantOrderVo.getSvipDiscountPrice());
            List detailVoList = merchantOrderVo.getOrderInfoList();
            BigDecimal merCouponPrice = detailVoList.stream().map(PreOrderInfoDetailVo::getMerCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantOrder.setMerCouponPrice(merCouponPrice);
            BigDecimal platCouponPrice = detailVoList.stream().map(PreOrderInfoDetailVo::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantOrder.setPlatCouponPrice(platCouponPrice);
            merchantOrder.setCouponPrice(merchantOrder.getMerCouponPrice().add(merchantOrder.getPlatCouponPrice()));
            merchantOrder.setPayPrice(merchantOrder.getTotalPrice().subtract(merchantOrder.getSvipDiscountPrice()).subtract(merchantOrder.getCouponPrice()).subtract(merchantOrder.getIntegralPrice()));
            merchantOrder.setGainIntegral(Integer.valueOf(0));
            merchantOrder.setType(order.getType());
            merchantOrder.setSecondType(order.getSecondType());
            merchantOrder.setIsSvip(order.getIsSvip());
            merchantOrderList.add(merchantOrder);
            for (PreOrderInfoDetailVo detailVo : detailVoList) {
                OrderDetail orderDetail = new OrderDetail();
                detailVoForGroupBuy = detailVo;
                orderDetail.setOrderNo(order.getOrderNo());
                orderDetail.setMerId(merchantOrder.getMerId());
                merId = merchantOrder.getMerId();
                orderDetail.setUid(user.getId());
                orderDetail.setProductId(detailVo.getProductId());
                orderDetail.setProductName(detailVo.getProductName());
                orderDetail.setImage(detailVo.getImage());
                orderDetail.setAttrValueId(detailVo.getAttrValueId());
                orderDetail.setSku(detailVo.getSku());
                orderDetail.setPrice(detailVo.getPrice());
                orderDetail.setPayNum(detailVo.getPayNum());
                orderDetail.setWeight(detailVo.getWeight());
                orderDetail.setVolume(detailVo.getVolume());
                orderDetail.setProductType(detailVo.getProductType());
                orderDetail.setProductMarketingType(detailVo.getProductMarketingType());
                orderDetail.setSubBrokerageType(detailVo.getSubBrokerageType());
                orderDetail.setBrokerage(detailVo.getBrokerage());
                orderDetail.setBrokerageTwo(detailVo.getBrokerageTwo());
                orderDetail.setFreightFee(detailVo.getFreightFee());
                orderDetail.setUseIntegral(detailVo.getUseIntegral());
                orderDetail.setIntegralPrice(detailVo.getIntegralPrice());
                orderDetail.setPayPrice(BigDecimal.ZERO);
                orderDetail.setIsSvip(order.getIsSvip());
                orderDetail.setIsPaidMemberProduct(detailVo.getIsPaidMember());
                orderDetail.setVipPrice(detailVo.getVipPrice());
                orderDetail.setMerCouponPrice(detailVo.getMerCouponPrice());
                orderDetail.setPlatCouponPrice(detailVo.getPlatCouponPrice());
                orderDetail.setCouponPrice(detailVo.getMerCouponPrice().add(detailVo.getPlatCouponPrice()));
                orderDetail.setProRefundSwitch(detailVo.getProRefundSwitch());
                BigDecimal detailPayPrice = orderDetail.getPrice().multiply(new BigDecimal(orderDetail.getPayNum().toString())).add(orderDetail.getFreightFee()).subtract(orderDetail.getCouponPrice()).subtract(orderDetail.getIntegralPrice());
                if (detailPayPrice.compareTo(BigDecimal.ZERO) < 0) {
                    throw new CrmebException("\u8ba2\u5355\u8be6\u60c5\u4ef7\u683c\u8ba1\u7b97\u9519\u8bef\uff0c\u8be6\u60c5\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                orderDetail.setPayPrice(detailPayPrice);
                orderDetail.setGroupBuyActivityId(detailVoForGroupBuy.getGroupBuyActivityId());
                orderDetailList.add(orderDetail);
            }
        }
        PreOrderInfoDetailVo finalDetailVoForGroupBuy = detailVoForGroupBuy;
        Integer finalMerId = merId;
        order.setCreateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Object skuRecord;
            Boolean result = true;
            if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD)) {
                skuRecord = (MyRecord)skuRecordList.get(0);
                result = this.productService.operationStock(skuRecord.getInt("productId"), skuRecord.getInt("num"), "sub");
                if (!result.booleanValue()) {
                    e.setRollbackOnly();
                    this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1ID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("productId"));
                    return result;
                }
                result = this.productAttrValueService.operationStock(skuRecord.getInt("attrValueId"), skuRecord.getInt("num"), "sub", skuRecord.getInt("type"), skuRecord.getInt("attrValueVersion"));
                if (!result.booleanValue()) {
                    e.setRollbackOnly();
                    this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1sku\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1skuID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("attrValueId"));
                    return result;
                }
                orderDetailList.forEach(arg_0 -> GroupBuyRecordServiceImpl.lambda$null$6((MyRecord)skuRecord, arg_0));
            }
            if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY)) {
                skuRecord = (MyRecord)skuRecordList.get(0);
                result = this.productService.operationStock(skuRecord.getInt("productId"), skuRecord.getInt("num"), "sub");
                if (!result.booleanValue()) {
                    e.setRollbackOnly();
                    this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1ID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("productId"));
                    return result;
                }
                result = this.productAttrValueService.operationStock(skuRecord.getInt("attrValueId"), skuRecord.getInt("num"), "sub", skuRecord.getInt("type"), skuRecord.getInt("attrValueVersion"));
                if (!result.booleanValue()) {
                    e.setRollbackOnly();
                    this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1sku\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1skuID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("attrValueId"));
                    return result;
                }
                Integer cdkeyId = skuRecord.getInt("cdkeyId");
                ArrayList<Integer> csIdList = new ArrayList<Integer>();
                for (int i = 0; i < skuRecord.getInt("num"); ++i) {
                    CardSecret cardSecret = this.cardSecretService.consume(cdkeyId);
                    if (ObjectUtil.isNull((Object)cardSecret)) {
                        e.setRollbackOnly();
                        this.logger.error("\u751f\u6210\u8ba2\u5355\u6d88\u8d39\u5361\u5bc6\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1skuID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("attrValueId"));
                        return Boolean.FALSE;
                    }
                    csIdList.add(cardSecret.getId());
                }
                String cardSecretIds = StrUtil.join((CharSequence)",", (Object[])new Object[]{csIdList});
                orderDetailList.forEach(detail -> detail.setCardSecretIds(cardSecretIds));
                this.cdkeyLibraryService.operationUseNum(cdkeyId, csIdList.size(), "add");
            }
            if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIDEO)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u89c6\u9891\u53f7\u4e0b\u5355\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_NORMAL) || order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL) || order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIRTUALLY)) {
                for (MyRecord skuRecord2 : skuRecordList) {
                    result = this.productService.operationStock(skuRecord2.getInt("productId"), skuRecord2.getInt("num"), "sub");
                    if (!result.booleanValue()) {
                        e.setRollbackOnly();
                        this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1ID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord2.getInt("productId"));
                        return result;
                    }
                    result = this.productAttrValueService.operationStock(skuRecord2.getInt("attrValueId"), skuRecord2.getInt("num"), "sub", ProductConstants.PRODUCT_TYPE_NORMAL, skuRecord2.getInt("attrValueVersion"));
                    if (result.booleanValue()) continue;
                    e.setRollbackOnly();
                    this.logger.error("\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1sku\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1skuID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord2.getInt("attrValueId"));
                    return result;
                }
            }
            if (order.getType().equals(OrderConstants.ORDER_TYPE_PITUAN)) {
                order.setGroupBuyRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
                this.logger.info("\u521b\u5efa\u8ba2\u5355 - \u5f00\u59cb\u6263\u51cf\u62fc\u56e2\u5e93\u5b58\u4e86: ${}", (Object)JSON.toJSONString((Object)order));
                this.subStock(order.getOrderNo(), orderRequest, orderInfoVo, user);
                this.groupBuyUserService.beforePay(orderNo, finalDetailVoForGroupBuy.getPayNum(), user.getId(), user.getAvatar(), user.getNickname());
                GroupBuyActivity currentActivity = (GroupBuyActivity)this.groupBuyActivityService.getById(finalDetailVoForGroupBuy.getGroupBuyActivityId());
                GroupBuyRecordForCache cache = new GroupBuyRecordForCache();
                cache.setGroupBuyActivityId(finalDetailVoForGroupBuy.getGroupBuyActivityId());
                cache.setGroupBuyRecordId(finalDetailVoForGroupBuy.getGroupBuyRecordId());
                cache.setProductId(finalDetailVoForGroupBuy.getProductId());
                cache.setAttrValueId(finalDetailVoForGroupBuy.getAttrValueId());
                cache.setPayNum(finalDetailVoForGroupBuy.getPayNum());
                cache.setMerId(finalMerId);
                cache.setAvatar(user.getAvatar());
                cache.setId(user.getId());
                cache.setNickname(user.getNickname());
                cache.setFictiStatus(currentActivity.getFictiStatus());
                this.redisUtil.set(StrUtil.format((CharSequence)"pintuan_record:{}", (Object[])new Object[]{orderNo}), (Object)JSONObject.toJSONString((Object)cache));
            }
            this.orderService.save(order);
            this.merchantOrderService.saveBatch(merchantOrderList);
            this.orderDetailService.saveBatch(orderDetailList);
            if (CollUtil.isNotEmpty((Collection)couponIdList)) {
                this.couponUserService.useBatch(couponIdList);
            }
            this.orderFlowRecordService.orderCreate(order.getOrderNo(), order.getUid());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u8ba2\u5355\u751f\u6210\u5931\u8d25");
        }
        if (this.redisUtil.exists(perOrderKey).booleanValue()) {
            this.redisUtil.delete(new String[]{perOrderKey});
        }
        this.redisUtil.lPush("order_auto_cancel_key", (Object)order.getOrderNo());
        Integer orderCancelTimeMinute = this.crmebConfig.getOrderCancelTime();
        DateTime expirationTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
        Long expireTime = (long)orderCancelTimeMinute.intValue() * 60L;
        this.redisUtil.set(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()}), (Object)expirationTime.toString(), expireTime);
        OrderNoResponse response = new OrderNoResponse();
        response.setOrderNo(order.getOrderNo());
        response.setPayPrice(order.getPayPrice());
        return response;
    }

    @Override
    public PreMerchantOrderVo validatePreOrderGroupBuy(PreOrderDetailRequest detailRequest) {
        if (ObjectUtil.isNull((Object)detailRequest.getProductId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)detailRequest.getAttrValueId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)detailRequest.getProductNum()) || detailRequest.getProductNum() <= 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        Product product = (Product)this.productService.getById(detailRequest.getProductId());
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getStock() < detailRequest.getProductNum()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(detailRequest.getAttrValueId(), product.getId(), product.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (ObjectUtil.isNull((Object)attrValue)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (!attrValue.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (attrValue.getStock() < detailRequest.getProductNum()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        Merchant merchant = new Merchant();
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_INTEGRAL)) {
            User user = this.userService.getInfo();
            if (user.getIntegral() < attrValue.getRedeemIntegral() * detailRequest.getProductNum()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8d2d\u4e70\u6b64\u5546\u54c1");
            }
        } else {
            merchant = this.merchantService.getByIdException(product.getMerId());
            if (!merchant.getIsSwitch().booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
            }
            if (!merchant.getIsTakeTheir().booleanValue() && product.getDeliveryMethod().equals("2")) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6b64\u5546\u54c1\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
        }
        GroupBuyActivitySku groupBuyActivitySku = this.groupBuyActivitySkuService.getByAttrId(detailRequest.getGroupBuyActivityId(), detailRequest.getAttrValueId());
        PreMerchantOrderVo merchantOrderVo = new PreMerchantOrderVo();
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_INTEGRAL)) {
            merchantOrderVo.setMerId(Integer.valueOf(0));
            merchantOrderVo.setMerName("");
            merchantOrderVo.setTakeTheirSwitch(Boolean.valueOf(false));
            merchantOrderVo.setIsSelf(Boolean.valueOf(false));
        } else {
            merchantOrderVo.setMerId(merchant.getId());
            merchantOrderVo.setMerName(merchant.getName());
            merchantOrderVo.setTakeTheirSwitch(merchant.getIsTakeTheir());
            merchantOrderVo.setIsSelf(merchant.getIsSelf());
        }
        merchantOrderVo.setType(OrderConstants.ORDER_TYPE_PITUAN);
        merchantOrderVo.setSecondType(product.getType());
        merchantOrderVo.setFreightFee(BigDecimal.ZERO);
        merchantOrderVo.setCouponFee(BigDecimal.ZERO);
        merchantOrderVo.setUserCouponId(Integer.valueOf(0));
        merchantOrderVo.setDeliveryMethodMer(product.getDeliveryMethod());
        PreOrderInfoDetailVo detailVo = new PreOrderInfoDetailVo();
        detailVo.setProductId(product.getId());
        detailVo.setProductName(product.getName());
        detailVo.setAttrValueId(attrValue.getId());
        detailVo.setSku(attrValue.getSku());
        detailVo.setPrice(groupBuyActivitySku.getActivePrice());
        detailVo.setPayPrice(groupBuyActivitySku.getActivePrice());
        detailVo.setPayNum(detailRequest.getProductNum());
        detailVo.setImage(StrUtil.isNotBlank((CharSequence)attrValue.getImage()) ? attrValue.getImage() : product.getImage());
        detailVo.setVolume(attrValue.getVolume());
        detailVo.setWeight(attrValue.getWeight());
        detailVo.setTempId(product.getTempId());
        detailVo.setSubBrokerageType(Integer.valueOf(product.getIsSub() != false ? 1 : 2));
        detailVo.setBrokerage(attrValue.getBrokerage());
        detailVo.setBrokerageTwo(attrValue.getBrokerageTwo());
        detailVo.setIsPaidMember(product.getIsPaidMember());
        detailVo.setVipPrice(BigDecimal.ZERO);
        if (detailVo.getSubBrokerageType() == 2) {
            String firstRatio = this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio");
            String secondRatio = this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio");
            detailVo.setBrokerage(Integer.valueOf(StrUtil.isNotBlank((CharSequence)firstRatio) ? Integer.parseInt(firstRatio) : 0));
            detailVo.setBrokerageTwo(Integer.valueOf(StrUtil.isNotBlank((CharSequence)secondRatio) ? Integer.parseInt(secondRatio) : 0));
        }
        detailVo.setProductType(product.getType());
        detailVo.setProductMarketingType(product.getMarketingType());
        detailVo.setDeliveryMethod(product.getDeliveryMethod());
        detailVo.setProRefundSwitch(product.getRefundSwitch());
        ArrayList infoList = CollUtil.newArrayList((Object[])new PreOrderInfoDetailVo[0]);
        infoList.add(detailVo);
        if (product.getSystemFormId() > 0) {
            merchantOrderVo.setSystemFormId(product.getSystemFormId());
            SystemForm systemForm = (SystemForm)this.systemFormService.getById(product.getSystemFormId());
            merchantOrderVo.setSystemFormValue(systemForm.getFormValue());
        }
        if (product.getType().equals(5) || product.getType().equals(6)) {
            merchantOrderVo.setShippingType(Integer.valueOf(3));
        } else if (product.getDeliveryMethod().equals("2")) {
            merchantOrderVo.setShippingType(Integer.valueOf(2));
        } else {
            merchantOrderVo.setShippingType(Integer.valueOf(1));
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_INTEGRAL)) {
            detailVo.setRedeemIntegral(attrValue.getRedeemIntegral());
        }
        merchantOrderVo.setOrderInfoList((List)infoList);
        return merchantOrderVo;
    }

    private Boolean doneGroupBuyRecord(Integer groupBuyRecordId) {
        GroupBuyRecord currentGroupBuyRecord = (GroupBuyRecord)this.getById(groupBuyRecordId);
        if (ObjectUtil.isNull((Object)currentGroupBuyRecord)) {
            this.logger.error("\u62fc\u56e2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0cid={}", (Object)groupBuyRecordId);
            return Boolean.TRUE;
        }
        if (!currentGroupBuyRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode())) {
            this.logger.error("\u62fc\u56e2\u8bb0\u5f55\u4e0d\u662f\u5728\u62fc\u56e2\u4e2d\u7684\u72b6\u6001\uff0cid={}", (Object)groupBuyRecordId);
            return Boolean.TRUE;
        }
        this.logger.info("\u62fc\u56e2\u4efb\u52a1\u6b63\u5728\u6267\u884c\u7684\u62fc\u56e2\u6570\u636e :{}", (Object)JSONObject.toJSONString((Object)currentGroupBuyRecord));
        this.logger.info("\u5f53\u524d\u4efb\u52a1\u5dee\u65f6:{}", (Object)(currentGroupBuyRecord.getEndTime().getTime() - System.currentTimeMillis()));
        if (currentGroupBuyRecord.getEndTime().getTime() < System.currentTimeMillis()) {
            if (currentGroupBuyRecord.getYetBuyingNum().equals(currentGroupBuyRecord.getBuyingCountNum()) && currentGroupBuyRecord.getFictiStatus().equals(0)) {
                List<GroupBuyUser> groupBuyUserList = this.groupBuyUserService.getListByGroupRecordId(currentGroupBuyRecord.getGroupBuyingId());
                List groupBuyUserAsPayed = groupBuyUserList.stream().filter(groupBuyUser -> groupBuyUser.getOrderStatus().equals(OrderConstants.ORDER_STATUS_WAIT_SHIPPING)).collect(Collectors.toList());
                this.logger.info("\u62fc\u56e2\u4efb\u52a1 - \u5f53\u524d\u62fc\u56e2\u4efb\u52a1\u4e2d\u6709\u672a\u652f\u4ed8\u8ba2\u5355 :{}", (Object)JSON.toJSONString(groupBuyUserAsPayed));
                if (groupBuyUserAsPayed.size() != groupBuyUserList.size()) {
                    this.logger.info("\u62fc\u56e2 - \u771f\u4eba - \u5931\u8d25\u5f00\u59cb\u6267\u884c");
                    this.groupFailed(currentGroupBuyRecord);
                    this.logger.info("\u62fc\u56e2 - \u771f\u4eba - \u5931\u8d25\u7ed3\u675f\u6267\u884c");
                } else {
                    this.logger.info("\u62fc\u56e2 - \u771f\u4eba - \u6210\u529f\u5f00\u59cb\u6267\u884c");
                    this.groupSuccess(currentGroupBuyRecord, groupBuyUserList);
                    this.logger.info("\u62fc\u56e2 - \u771f\u4eba \u6210\u529f\u7ed3\u675f\u6267\u884c");
                }
                return Boolean.TRUE;
            }
            if (currentGroupBuyRecord.getFictiStatus().equals(1)) {
                int countNeed = currentGroupBuyRecord.getBuyingCountNum() - currentGroupBuyRecord.getYetBuyingNum();
                List<GroupBuyUser> groupBuyUserList = this.groupBuyUserService.getListByGroupRecordId(currentGroupBuyRecord.getGroupBuyingId());
                this.logger.info("\u62fc\u56e2 - \u865a\u62df - \u6210\u529f\u5f00\u59cb\u6267\u884c");
                this.groupSuccess(currentGroupBuyRecord, groupBuyUserList);
                this.logger.info("\u62fc\u56e2 - \u865a\u62df \u6210\u529f\u7ed3\u675f\u6267\u884c");
                return Boolean.TRUE;
            }
            this.logger.info("\u62fc\u56e2 - \u5931\u8d25\u5f00\u59cb\u6267\u884c");
            this.groupFailed(currentGroupBuyRecord);
            this.logger.info("\u62fc\u56e2 - \u5931\u8d25\u7ed3\u675f\u6267\u884c");
            return Boolean.TRUE;
        }
        this.logger.info("\u62fc\u56e2\u4efb\u52a1\u6267\u884c\u6ca1\u6709\u627e\u5230\u8981\u8ba1\u7b97\u7684\u4efb\u52a1\uff01\uff01");
        return Boolean.FALSE;
    }

    @Override
    public void groupSuccess(GroupBuyRecord currentGroupBuyRecord, List<GroupBuyUser> groupBuyUserList) {
        this.logger.info("\u771f\u4eba\u62fc\u56e2\u5373\u65f6\u6210\u529f\u7684\u4e5f\u4f1a\u8c03\u7528");
        this.logger.info("\u6b63\u5728\u6267\u884c\u62fc\u56e2 \u6210\u56e2\u4efb\u52a1 START :currentGroupBuyRecord| {}", (Object)JSONObject.toJSONString((Object)currentGroupBuyRecord));
        this.logger.info("\u6b63\u5728\u6267\u884c\u62fc\u56e2 \u6210\u56e2\u4efb\u52a1 START :groupBuyUserList| {}", (Object)JSONObject.toJSONString(groupBuyUserList));
        currentGroupBuyRecord.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        this.updateById(currentGroupBuyRecord);
        ArrayList orderListForGroupUpdate = new ArrayList();
        groupBuyUserList.forEach(groupBuyUser -> {
            groupBuyUser.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
            Order order = this.orderService.getByOrderNo(groupBuyUser.getOrderId());
            order.setGroupBuyRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
            MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                order.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            }
            order.setUpdateTime((Date)DateUtil.date());
            orderListForGroupUpdate.add(order);
        });
        this.logger.info("\u66f4\u65b0\u7684\u8ba2\u5355\u6709\uff1a{}", orderListForGroupUpdate);
        this.orderService.updateBatchById(orderListForGroupUpdate);
        this.logger.info("\u66f4\u65b0\u7684\u8ba2\u5355\u72b6\u6001\u6210\u529f");
        this.groupBuyUserService.updateBatchById(groupBuyUserList);
        GroupBuyActivity activity = (GroupBuyActivity)this.groupBuyActivityService.getById(currentGroupBuyRecord.getGroupActivityId());
        activity.setTotalActivityDone(Integer.valueOf(activity.getTotalActivityDone() + 1));
        activity.setTotalOrderDone(Integer.valueOf(activity.getTotalOrderDone() + groupBuyUserList.size()));
        this.groupBuyActivityService.updateById(activity);
        this.logger.info("\u6b63\u5728\u6267\u884c\u62fc\u56e2 \u6210\u56e2\u4efb\u52a1 END");
        for (Order order : orderListForGroupUpdate) {
            if (!order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) && !order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY)) continue;
            this.orderService.virtualShipment(order);
        }
    }

    private void groupFailed(GroupBuyRecord currentGroupBuyRecord) {
        this.logger.info("\u6b63\u5728\u6267\u884c\u62fc\u56e2 \u5931\u8d25\u4efb\u52a1 START :currentGroupBuyRecord| {}", (Object)JSONObject.toJSONString((Object)currentGroupBuyRecord));
        currentGroupBuyRecord.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode());
        this.updateById(currentGroupBuyRecord);
        List<GroupBuyUser> groupBuyUserList = this.groupBuyUserService.getListByGroupRecordId(currentGroupBuyRecord.getGroupBuyingId());
        this.logger.info("\u62fc\u56e2\u5931\u8d25\u7684\u7528\u6237:{}", (Object)JSONObject.toJSONString(groupBuyUserList));
        groupBuyUserList.forEach(groupBuyUser -> {
            groupBuyUser.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode());
            Order order = this.orderService.getByOrderNo(groupBuyUser.getOrderId());
            order.setGroupBuyRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode());
            this.logger.info("\u62fc\u56e2\u5931\u8d25 - \u5f00\u59cb\u9000\u6b3e");
            List<Object> orderDetailList = new ArrayList();
            orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            int i = 0;
            while (i < orderDetailList.size()) {
                OrderDetail orderDetail = (OrderDetail)orderDetailList.get(i);
                if (orderDetail.getApplyRefundNum() > 0) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u5546\u54c1\u8ba2\u5355\u8be6\u60c5\u5b58\u5728\u9000\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u64cd\u4f5c\u76f4\u63a5\u9000\u6b3e,\u8ba2\u5355\u8be6\u60c5ID=" + orderDetail.getId());
                }
                if (orderDetail.getPayNum() <= orderDetail.getRefundNum()) {
                    orderDetailList.remove(i);
                    continue;
                }
                orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getPayNum() - orderDetail.getRefundNum()));
                ++i;
            }
            this.refundOrderService.merchantDirectRefund(order, orderDetailList, new ArrayList<Integer>());
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            this.logger.info("\u62fc\u56e2\u5931\u8d25 - \u7ed3\u675f\u9000\u6b3e");
        });
        this.groupBuyUserService.updateBatchById(groupBuyUserList);
    }

    @Override
    public void groupBuyOrderRefund() {
        String redisKey = "groupBuyRecordStatusKey";
        Long size = this.redisUtil.getListSize(redisKey);
        this.logger.info("GroupBuyRecordServiceImpl.groupBuyOrderRefund | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object orderNoData = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)orderNoData)) {
                try {
                    this.logger.info("\u62fc\u56fe\u8ba2\u5355\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1 | \u83b7\u53d6\u5230\u6570\u636e:" + orderNoData);
                    Boolean result = this.doneGroupBuyRecord(Integer.valueOf(orderNoData.toString()));
                    if (!result.booleanValue()) {
                        this.redisUtil.lPush(redisKey, orderNoData);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u62fc\u56e2\u8ba2\u5355\u9000\u6b3e\u9519\u8bef\uff1a" + e.getMessage());
                    this.redisUtil.lPush(redisKey, orderNoData);
                }
            }
            ++i;
        }
    }

    @Override
    public void groupBuyOrderRefundEt() {
        this.rollBackIsBuyed();
    }

    private List<MyRecord> validateProductStock(PreOrderInfoVo orderInfoVo) {
        ArrayList recordList = CollUtil.newArrayList((Object[])new MyRecord[0]);
        List merchantOrderVoList = orderInfoVo.getMerchantOrderVoList();
        merchantOrderVoList.forEach(merchantOrderVo -> {
            Merchant merchant = this.merchantService.getByIdException(merchantOrderVo.getMerId());
            if (!merchant.getIsSwitch().booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
            }
            merchantOrderVo.getOrderInfoList().forEach(info -> {
                Product product = (Product)this.productService.getById(info.getProductId());
                if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
                    throw new CrmebException("\u5f53\u524d\u5546\u54c1\u672a\u5ba1\u6838\u6216\u8005\u5ba1\u6838\u62d2\u7edd");
                }
                if (product.getStock().equals(0) || info.getPayNum() > product.getStock()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(info.getAttrValueId(), info.getProductId(), product.getType(), product.getMarketingType());
                if (ObjectUtil.isNull((Object)attrValue)) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (attrValue.getStock() < info.getPayNum()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                MyRecord record = new MyRecord();
                record.set("productId", (Object)info.getProductId());
                record.set("num", (Object)info.getPayNum());
                record.set("attrValueId", (Object)info.getAttrValueId());
                record.set("attrValueVersion", (Object)attrValue.getVersion());
                record.set("type", (Object)attrValue.getType());
                record.set("marketingType", (Object)attrValue.getMarketingType());
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD)) {
                    record.set("expand", (Object)attrValue.getExpand());
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    record.set("cdkeyId", (Object)attrValue.getCdkeyId());
                }
                record.set("isPaidMember", (Object)product.getIsPaidMember());
                record.set("vipPrice", (Object)attrValue.getVipPrice());
                recordList.add(record);
            });
        });
        return recordList;
    }

    private void getFreightFee_V_1_8(PreOrderInfoVo orderInfoVo, UserAddress userAddress, Boolean userIsPaidMember) {
        BigDecimal freightFee = BigDecimal.ZERO;
        List merchantOrderVoList = orderInfoVo.getMerchantOrderVoList();
        for (PreMerchantOrderVo merchantOrderVo : merchantOrderVoList) {
            if (orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) || orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY) || orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_VIRTUALLY)) {
                orderInfoVo.setAddressId(Integer.valueOf(0));
                merchantOrderVo.setFreightFee(BigDecimal.ZERO);
                merchantOrderVo.getOrderInfoList().forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                continue;
            }
            BigDecimal storePostage = BigDecimal.ZERO;
            if (merchantOrderVo.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                merchantOrderVo.setFreightFee(storePostage);
                merchantOrderVo.getOrderInfoList().forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                continue;
            }
            if (orderInfoVo.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
                merchantOrderVo.setFreightFee(storePostage);
                merchantOrderVo.getOrderInfoList().forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                continue;
            }
            if (ObjectUtil.isNull((Object)userAddress) || userAddress.getCityId() <= 0) {
                merchantOrderVo.setFreightFee(storePostage);
                merchantOrderVo.getOrderInfoList().forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                continue;
            }
            HashMap tempMap = CollUtil.newHashMap();
            merchantOrderVo.getOrderInfoList().forEach(e -> {
                Integer tempId = e.getTempId();
                BigDecimal proPrice = e.getIsPaidMember() != false && userIsPaidMember != false ? e.getVipPrice().multiply(BigDecimal.valueOf(e.getPayNum().intValue())) : e.getPrice().multiply(BigDecimal.valueOf(e.getPayNum().intValue()));
                if (tempMap.containsKey(tempId)) {
                    MyRecord record = (MyRecord)tempMap.get(tempId);
                    record.set("totalPrice", (Object)record.getBigDecimal("totalPrice").add(proPrice));
                    record.set("totalNum", (Object)(record.getInt("totalNum") + e.getPayNum()));
                    BigDecimal weight = e.getWeight().multiply(BigDecimal.valueOf(e.getPayNum().intValue()));
                    record.set("weight", (Object)record.getBigDecimal("weight").add(weight));
                    BigDecimal volume = e.getVolume().multiply(BigDecimal.valueOf(e.getPayNum().intValue()));
                    record.set("volume", (Object)record.getBigDecimal("volume").add(volume));
                } else {
                    MyRecord record = new MyRecord();
                    record.set("totalPrice", (Object)proPrice);
                    record.set("totalNum", (Object)e.getPayNum());
                    record.set("tempId", (Object)tempId);
                    BigDecimal weight = e.getWeight().multiply(BigDecimal.valueOf(e.getPayNum().intValue()));
                    record.set("weight", (Object)weight);
                    BigDecimal volume = e.getVolume().multiply(BigDecimal.valueOf(e.getPayNum().intValue()));
                    record.set("volume", (Object)volume);
                    tempMap.put(tempId, record);
                }
            });
            int districtId = userAddress.getDistrictId();
            block5: for (Map.Entry m : tempMap.entrySet()) {
                ShippingTemplatesRegion shippingTemplatesRegion;
                ShippingTemplatesFree shippingTemplatesFree;
                MyRecord record = (MyRecord)m.getValue();
                Integer tempId = record.getInt("tempId");
                ShippingTemplates shippingTemplate = (ShippingTemplates)this.shippingTemplatesService.getById(tempId);
                if (ObjectUtil.isNull((Object)shippingTemplate) || shippingTemplate.getAppoint().equals(ShippingTemplatesConstants.APPOINT_TYPE_ALL)) {
                    merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(m.getKey())).forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                    continue;
                }
                if (shippingTemplate.getAppoint().equals(ShippingTemplatesConstants.APPOINT_TYPE_DEFINED) && ObjectUtil.isNotNull((Object)(shippingTemplatesFree = this.shippingTemplatesFreeService.getByTempIdAndCityId(tempId, districtId)))) {
                    BigDecimal surplus;
                    BigDecimal totalPrice = record.getBigDecimal("totalPrice");
                    if (totalPrice.compareTo(shippingTemplatesFree.getPrice()) >= 0) {
                        merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(m.getKey())).forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                        continue;
                    }
                    if (shippingTemplate.getType().equals(1) && BigDecimal.valueOf(record.getInt("totalNum").intValue()).compareTo(shippingTemplatesFree.getNumber()) >= 0) {
                        merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(m.getKey())).forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                        continue;
                    }
                    BigDecimal bigDecimal = surplus = shippingTemplate.getType().equals(2) ? record.getBigDecimal("weight") : record.getBigDecimal("volume");
                    if (surplus.compareTo(shippingTemplatesFree.getNumber()) >= 0) {
                        merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(m.getKey())).forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                        continue;
                    }
                }
                if (ObjectUtil.isNull((Object)(shippingTemplatesRegion = this.shippingTemplatesRegionService.getByTempIdAndCityId(tempId, districtId)))) {
                    shippingTemplatesRegion = this.shippingTemplatesRegionService.getByTempIdAndCityId(tempId, 0);
                }
                if (shippingTemplate.getAppoint().equals(ShippingTemplatesConstants.APPOINT_TYPE_PART) && ObjectUtil.isNull((Object)shippingTemplatesRegion)) {
                    merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(m.getKey())).forEach(info -> info.setFreightFee(BigDecimal.ZERO));
                    continue;
                }
                BigDecimal postageFee = BigDecimal.ZERO;
                block0 : switch (shippingTemplate.getType()) {
                    case 1: {
                        Integer num = record.getInt("totalNum");
                        if (num <= shippingTemplatesRegion.getFirst().intValue()) {
                            storePostage = storePostage.add(shippingTemplatesRegion.getFirstPrice());
                            postageFee = shippingTemplatesRegion.getFirstPrice();
                        } else {
                            int renewalNum = num - shippingTemplatesRegion.getFirst().intValue();
                            BigDecimal renewalPrice = shippingTemplatesRegion.getRenewalPrice().multiply(new BigDecimal(String.valueOf(renewalNum)).divide(shippingTemplatesRegion.getRenewal(), 0, RoundingMode.UP));
                            storePostage = storePostage.add(shippingTemplatesRegion.getFirstPrice()).add(renewalPrice);
                            postageFee = shippingTemplatesRegion.getFirstPrice().add(renewalPrice);
                        }
                        List detailVoList = merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(tempId)).collect(Collectors.toList());
                        if (detailVoList.size() == 1) {
                            ((PreOrderInfoDetailVo)detailVoList.get(0)).setFreightFee(postageFee);
                            break;
                        }
                        Integer tempNum = num;
                        for (int i = 0; i < detailVoList.size(); ++i) {
                            PreOrderInfoDetailVo detail = (PreOrderInfoDetailVo)detailVoList.get(i);
                            if (detailVoList.size() == i + 1) {
                                detail.setFreightFee(postageFee);
                                break block0;
                            }
                            BigDecimal multiply = postageFee.multiply(new BigDecimal(detail.getPayNum().toString())).divide(new BigDecimal(tempNum.toString()), 2, RoundingMode.UP);
                            if (postageFee.compareTo(multiply) < 0) {
                                multiply = postageFee;
                            }
                            detail.setFreightFee(multiply);
                            postageFee = postageFee.subtract(multiply);
                            tempNum = tempNum - detail.getPayNum();
                        }
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal surplus;
                        BigDecimal bigDecimal = surplus = shippingTemplate.getType().equals(2) ? record.getBigDecimal("weight") : record.getBigDecimal("volume");
                        if (surplus.compareTo(shippingTemplatesRegion.getFirst()) <= 0) {
                            storePostage = storePostage.add(shippingTemplatesRegion.getFirstPrice());
                            postageFee = shippingTemplatesRegion.getFirstPrice();
                        } else {
                            BigDecimal renewalNum = surplus.subtract(shippingTemplatesRegion.getFirst());
                            BigDecimal renewalPrice = shippingTemplatesRegion.getRenewalPrice().multiply(renewalNum.divide(shippingTemplatesRegion.getRenewal(), 0, RoundingMode.UP));
                            storePostage = storePostage.add(shippingTemplatesRegion.getFirstPrice()).add(renewalPrice);
                            postageFee = shippingTemplatesRegion.getFirstPrice().add(renewalPrice);
                        }
                        List infoDetailVoList = merchantOrderVo.getOrderInfoList().stream().filter(e -> e.getTempId().equals(tempId)).collect(Collectors.toList());
                        if (infoDetailVoList.size() == 1) {
                            ((PreOrderInfoDetailVo)infoDetailVoList.get(0)).setFreightFee(postageFee);
                            break;
                        }
                        BigDecimal tempSurplus = surplus;
                        for (int i = 0; i < infoDetailVoList.size(); ++i) {
                            PreOrderInfoDetailVo detail = (PreOrderInfoDetailVo)infoDetailVoList.get(i);
                            if (infoDetailVoList.size() == i + 1) {
                                detail.setFreightFee(postageFee);
                                break block0;
                            }
                            BigDecimal wv = shippingTemplate.getType().equals(2) ? detail.getWeight() : detail.getVolume();
                            BigDecimal multiply = postageFee.multiply(wv.multiply(new BigDecimal(detail.getPayNum().toString()))).divide(tempSurplus, 2, RoundingMode.HALF_UP);
                            if (postageFee.compareTo(multiply) < 0) {
                                multiply = postageFee;
                            }
                            detail.setFreightFee(multiply);
                            postageFee = postageFee.subtract(multiply);
                            tempSurplus = tempSurplus.subtract(wv.multiply(new BigDecimal(detail.getPayNum().toString())));
                        }
                        break;
                    }
                }
            }
            merchantOrderVo.setFreightFee(storePostage);
            freightFee = freightFee.add(storePostage);
        }
        orderInfoVo.setFreightFee(freightFee);
    }

    @Override
    public List<GroupBuyRecord> getGroupRecordListForNotExist(Integer groupActivityId, Integer userId, Integer productId, int limit) {
        return this.dao.getGroupRecordListForNotExist(groupActivityId, userId, productId, limit);
    }

    @Override
    public Boolean rollBackIsBuyed() {
        LambdaQueryWrapper groupBuyRecordQueryWrapper = new LambdaQueryWrapper();
        groupBuyRecordQueryWrapper.eq(GroupBuyRecord::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        List groupBuyRecords = this.dao.selectList((Wrapper)groupBuyRecordQueryWrapper);
        groupBuyRecords.forEach(groupBuyRecord -> {
            LambdaQueryWrapper groupBuyUserQueryWrapper = new LambdaQueryWrapper();
            groupBuyUserQueryWrapper.eq(GroupBuyUser::getGroupActivityId, (Object)groupBuyRecord.getGroupActivityId());
            groupBuyUserQueryWrapper.eq(GroupBuyUser::getGroupRecordId, (Object)groupBuyRecord.getGroupBuyingId());
            List groupBuyUserListAll = this.groupBuyUserService.list((Wrapper)groupBuyUserQueryWrapper);
            GroupBuyActivity currentABA = (GroupBuyActivity)this.groupBuyActivityService.getById(groupBuyRecord.getGroupActivityId());
            if (currentABA.getBuyCount() < groupBuyUserListAll.size()) {
                this.logger.info("\u62fc\u56e2\u5931\u8d25\u9000\u6b3e");
                List<GroupBuyUser> buyUserWaiteRe = groupBuyUserListAll.stream().filter(groupBuyUser -> groupBuyUser.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode())).collect(Collectors.toList());
                buyUserWaiteRe.forEach(user -> {
                    Order order = this.orderService.getByOrderNo(user.getOrderId());
                    order.setGroupBuyRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode());
                    this.logger.info("\u62fc\u56e2\u8d85\u5356 - \u5f00\u59cb\u9000\u6b3e");
                    List<Object> orderDetailList = new ArrayList();
                    orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
                    int i = 0;
                    while (i < orderDetailList.size()) {
                        OrderDetail orderDetail = (OrderDetail)orderDetailList.get(i);
                        if (orderDetail.getApplyRefundNum() > 0) {
                            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9009\u62e9\u7684\u9000\u6b3e\u5546\u54c1\u8ba2\u5355\u8be6\u60c5\u5b58\u5728\u9000\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u64cd\u4f5c\u76f4\u63a5\u9000\u6b3e,\u8ba2\u5355\u8be6\u60c5ID=" + orderDetail.getId());
                        }
                        if (orderDetail.getPayNum() <= orderDetail.getRefundNum()) {
                            orderDetailList.remove(i);
                            continue;
                        }
                        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getPayNum() - orderDetail.getRefundNum()));
                        ++i;
                    }
                    this.refundOrderService.merchantDirectRefund(order, orderDetailList, new ArrayList<Integer>());
                    order.setUpdateTime((Date)DateUtil.date());
                    this.orderService.updateById(order);
                    this.logger.info("\u62fc\u56e2\u8d85\u5356 - \u9000\u6b3e\u6210\u529f:{}", (Object)order.getOrderNo());
                });
            }
        });
        return true;
    }

    private static /* synthetic */ void lambda$null$6(MyRecord skuRecord, OrderDetail detail) {
        detail.setExpand(skuRecord.getStr("expand"));
    }
}

