/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    @Autowired
    private RestTemplate restTemplate;
    public static final String WXPAYSDK_VERSION = "WXPaySDK/3.0.9";
    public static final String USER_AGENT = "WXPaySDK/3.0.9 (" + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ") Java/" + System.getProperty("java.version") + " HttpClient/" + HttpClient.class.getPackage().getImplementationVersion();

    public String getData(String url, Map<String, String> param) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return (String)this.restTemplate.getForEntity(url, String.class, param).getBody();
    }

    public String getLink(String url) {
        return (String)this.restTemplate.getForEntity(url, String.class, new Object[0]).getBody();
    }

    public JSONObject getData(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_JSON);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        return (JSONObject)this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]).getBody();
    }

    public JSONObject getData(String url, HashMap<String, String> hashMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        return (JSONObject)this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]).getBody();
    }

    public String postJsonData(String url, JSONObject param) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)param, (MultiValueMap)headers);
        return (String)this.restTemplate.postForEntity(url, (Object)param, String.class, new Object[0]).getBody();
    }

    public String postFormData(String url, MultiValueMap<String, String> map) {
        HttpHeaders headers = new HttpHeaders();
        org.springframework.http.HttpEntity requests = new org.springframework.http.HttpEntity(map, (MultiValueMap)headers);
        String body = (String)this.restTemplate.postForEntity(url, (Object)requests, String.class, new Object[0]).getBody();
        return body;
    }

    public String postFormData(String url, Map<String, Object> map) {
        HttpHeaders headers = new HttpHeaders();
        org.springframework.http.HttpEntity requests = new org.springframework.http.HttpEntity(map, (MultiValueMap)headers);
        return (String)this.restTemplate.postForEntity(url, (Object)requests, String.class, new Object[0]).getBody();
    }

    public JSONObject postJsonDataAndReturnJson(String url, JSONObject param) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)param, (MultiValueMap)headers);
        JSONObject body = (JSONObject)this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]).getBody();
        return body;
    }

    public JSONObject post(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        JSONObject body = (JSONObject)this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]).getBody();
        return body;
    }

    public JSONObject post(String url, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        for (Map.Entry<String, String> entry : header.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        return (JSONObject)this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]).getBody();
    }

    public JSONObject postJson(String url, JSONObject json, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        for (Map.Entry<String, String> entry : header.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)json, (MultiValueMap)headers);
        return (JSONObject)this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]).getBody();
    }

    public JSONObject post(String url, Map<String, Object> params, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        for (Map.Entry<String, String> entry : header.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        return (JSONObject)this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]).getBody();
    }

    public String postXml(String url, String xml) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/xml; charset=UTF-8");
        headers.setContentType(type);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)xml, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        try {
            System.out.println("responseEntity" + responseEntity);
            return new String(((String)Objects.requireNonNull(responseEntity.getBody())).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postWXRefundXml(String url, String xml, String mchId, String path) throws Exception {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream instream = new FileInputStream(path);){
            clientStore.load(instream, mchId.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, mchId.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build(), null, null, null);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(8000).setConnectTimeout(6000).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(xml, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", USER_AGENT + " " + mchId);
        httpPost.setEntity((HttpEntity)postEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
    }

    public String postFormData(String url, LinkedMultiValueMap<String, Object> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        return body;
    }

    public String postMapData(String url, Map<String, Object> params) {
        logger.info("\u5fae\u4fe1 Url\uff1a{}", (Object)url);
        logger.info("\u5fae\u4fe1 params\uff1a{}", (Object)JSON.toJSONString(params));
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        String body1 = (String)this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]).getBody();
        logger.info("\u5fae\u4fe1 Response\uff1a{}", (Object)body1);
        return body1;
    }

    public String postMapData(String url, Map<String, Object> params, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        for (Map.Entry<String, String> entry : header.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        String body1 = (String)this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]).getBody();
        System.out.println(body1);
        return body1;
    }

    public String postStringData(String url, String data) {
        logger.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)url);
        logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)data);
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)data, (MultiValueMap)headers);
        String body1 = (String)this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]).getBody();
        logger.info("\u8bf7\u6c42\u7ed3\u679c:{}", (Object)body1);
        return body1;
    }

    public byte[] postJsonDataAndReturnBuffer(String url, JSONObject param) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)param, (MultiValueMap)headers);
        return (byte[])this.restTemplate.postForEntity(url, (Object)param, byte[].class, new Object[0]).getBody();
    }

    public byte[] getBuffer(String url) {
        return (byte[])this.restTemplate.getForEntity(url, byte[].class, new Object[0]).getBody();
    }

    public String postFromUrlencoded(String url, MultiValueMap<String, Object> params, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (CollUtil.isNotEmpty(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                headers.add(entry.getKey(), entry.getValue());
            }
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        return (String)this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]).getBody();
    }
}

