/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.admin.SystemRole;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemAdminAddRequest;
import com.zbkj.common.request.SystemAdminRequest;
import com.zbkj.common.request.SystemAdminUpdateRequest;
import com.zbkj.common.response.SystemAdminResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.SystemAdminDao;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAdminServiceImpl
extends ServiceImpl<SystemAdminDao, SystemAdmin>
implements SystemAdminService {
    @Resource
    private SystemAdminDao dao;
    @Autowired
    private SystemRoleService systemRoleService;

    @Override
    public SystemAdmin selectUserByUserNameAndType(String username, Integer type) {
        List<Integer> types = this.addSuperRoleType(type);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getAccount, (Object)username);
        lqw.in(SystemAdmin::getType, types);
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<SystemAdminResponse> getList(SystemAdminRequest request, PageParamRequest pageParamRequest) {
        List systemAdmins;
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(SystemAdmin::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRealName())) {
            String decode = URLUtil.decode((String)request.getRealName());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SystemAdmin::getRealName, (Object)decode)).or()).like(SystemAdmin::getAccount, (Object)decode);
            });
        }
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        lqw.eq(SystemAdmin::getMerId, (Object)currentAdmin.getMerId());
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (currentAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            types.add(RoleEnum.MERCHANT_ADMIN.getValue());
            types.add(RoleEnum.SUPER_MERCHANT.getValue());
            lqw.in(SystemAdmin::getType, types);
        } else if (currentAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue())) {
            types.add(RoleEnum.PLATFORM_ADMIN.getValue());
            types.add(RoleEnum.SUPER_ADMIN.getValue());
            lqw.in(SystemAdmin::getType, types);
        } else {
            lqw.eq(SystemAdmin::getType, (Object)this.systemRoleService.getRoleTypeByCurrentAdmin());
        }
        if (ObjectUtil.isNotNull((Object)request.getRoles()) && request.getRoles() > 0) {
            lqw.apply(StrUtil.format((CharSequence)" find_in_set('{}', roles)", (Object[])new Object[]{request.getRoles()}), new Object[0]);
        }
        if (CollUtil.isEmpty((Collection)(systemAdmins = this.dao.selectList((Wrapper)lqw)))) {
            return CollUtil.newArrayList((Object[])new SystemAdminResponse[0]);
        }
        ArrayList<SystemAdminResponse> adminResponseList = new ArrayList<SystemAdminResponse>();
        List<SystemRole> roleList = this.systemRoleService.getListByMerId(currentAdmin.getMerId());
        for (SystemAdmin admin : systemAdmins) {
            SystemAdminResponse sar = new SystemAdminResponse();
            BeanUtils.copyProperties((Object)admin, (Object)sar);
            sar.setLastTime(admin.getUpdateTime());
            List roleIds = CrmebUtil.stringToArrayInt((String)admin.getRoles());
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Integer roleId : roleIds) {
                for (SystemRole role : roleList) {
                    if (!role.getId().equals(roleId)) continue;
                    roleNames.add(role.getRoleName());
                }
            }
            sar.setRoleNames(StringUtils.join(roleNames, (String)","));
            adminResponseList.add(sar);
        }
        return adminResponseList;
    }

    @Override
    public Boolean isExistRole(Integer roleId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemAdmin::getId});
        lqw.apply(StrUtil.format((CharSequence)" find_in_set('{}', roles)", (Object[])new Object[]{roleId}), new Object[0]);
        lqw.last(" limit 1");
        SystemAdmin systemAdmin = (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)systemAdmin);
    }

    @Override
    public Boolean saveAdmin(SystemAdminAddRequest systemAdminAddRequest) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        if (this.checkAccount(systemAdminAddRequest.getAccount()).booleanValue()) {
            throw new CrmebException("\u7ba1\u7406\u5458\u5df2\u5b58\u5728");
        }
        SystemAdmin systemAdmin = new SystemAdmin();
        BeanUtils.copyProperties((Object)systemAdminAddRequest, (Object)systemAdmin);
        String pwd = CrmebUtil.encryptPassword((String)systemAdmin.getPwd(), (String)systemAdmin.getAccount());
        systemAdmin.setPwd(pwd);
        systemAdmin.setMerId(currentUser.getMerId());
        systemAdmin.setType(this.systemRoleService.getRoleTypeByCurrentAdmin());
        return this.save(systemAdmin);
    }

    @Override
    public Boolean checkAccount(String account) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getAccount, (Object)account);
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public Boolean updateAdmin(SystemAdminUpdateRequest systemAdminRequest) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin adminDetail = this.getDetail(systemAdminRequest.getId());
        if (adminDetail.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || adminDetail.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        this.verifyAccount(systemAdminRequest.getId(), systemAdminRequest.getAccount());
        SystemAdmin systemAdmin = new SystemAdmin();
        BeanUtils.copyProperties((Object)systemAdminRequest, (Object)systemAdmin);
        systemAdmin.setPwd(null);
        if (StrUtil.isNotBlank((CharSequence)systemAdminRequest.getPwd())) {
            String pwd = CrmebUtil.encryptPassword((String)systemAdminRequest.getPwd(), (String)systemAdminRequest.getAccount());
            systemAdmin.setPwd(pwd);
        }
        systemAdmin.setMerId(currentUser.getMerId());
        return this.updateById(systemAdmin);
    }

    @Override
    public Boolean removeAdmin(Integer id) {
        SystemAdmin perDelAdmin = this.getDetail(id);
        if (perDelAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || perDelAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.removeById(id);
    }

    @Override
    public Boolean updateStatus(Integer id, Boolean status) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin systemAdmin = this.getDetail(id);
        if (systemAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || systemAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!currentUser.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException("\u4e0d\u540c\u5e73\u53f0\u7684\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (systemAdmin.getStatus().equals(status)) {
            return true;
        }
        systemAdmin.setStatus(status);
        return this.updateById(systemAdmin);
    }

    @Override
    public SystemAdmin getDetail(Integer id) {
        SystemAdmin systemAdmin = (SystemAdmin)this.getById(id);
        if (ObjectUtil.isNull((Object)systemAdmin) || systemAdmin.getIsDel().booleanValue()) {
            throw new CrmebException("\u7ba1\u7406\u5458\u4e0d\u5b58\u5728");
        }
        return systemAdmin;
    }

    @Override
    public Map<Integer, String> getNameMapByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemAdmin::getId, SystemAdmin::getRealName});
        lqw.in(SystemAdmin::getId, idList);
        List adminList = this.dao.selectList((Wrapper)lqw);
        HashMap map = CollUtil.newHashMap();
        adminList.forEach(admin -> map.put(admin.getId(), admin.getRealName()));
        return map;
    }

    private void verifyAccount(Integer id, String account) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.ne(SystemAdmin::getId, (Object)id);
        lqw.eq(SystemAdmin::getAccount, (Object)account);
        SystemAdmin systemAdmin = (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)systemAdmin)) {
            throw new CrmebException("\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    private List<Integer> addSuperRoleType(Integer type) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
            types.add(RoleEnum.SUPER_ADMIN.getValue());
            types.add(RoleEnum.PLATFORM_ADMIN.getValue());
        }
        if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            types.add(RoleEnum.SUPER_MERCHANT.getValue());
            types.add(RoleEnum.MERCHANT_ADMIN.getValue());
        }
        if (types.isEmpty()) {
            types.add(type);
        }
        return types;
    }

    @Override
    public SystemAdmin selectMerchantAdminByOrgAccount(String orgAccount) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getOrgAccount, (Object)orgAccount);
        lqw.eq(SystemAdmin::getType, (Object)2);
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
    }
}

