/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MyRecord
implements Serializable {
    private static final long serialVersionUID = 905784513600884082L;
    private static final Logger logger = LoggerFactory.getLogger(MyRecord.class);
    private Map<String, Object> columns;

    void setColumnsMap(Map<String, Object> columns) {
        this.columns = columns;
    }

    public Map<String, Object> getColumns() {
        if (null == this.columns) {
            this.columns = new HashMap<String, Object>();
        }
        return this.columns;
    }

    public MyRecord setColums(Map<String, Object> columns) {
        this.getColumns().putAll(columns);
        return this;
    }

    public MyRecord setColums(MyRecord record) {
        this.getColumns().putAll(record.getColumns());
        return this;
    }

    public MyRecord setColums(JSONObject jsonObject) {
        Map<String, Object> columns = this.getColumns();
        jsonObject.forEach(columns::put);
        return this;
    }

    public <T> MyRecord setColums(T t) {
        Map<String, Object> columns = this.getColumns();
        String[] fieldNames = MyRecord.getFiledName(t);
        for (int i = 0; i < fieldNames.length; ++i) {
            Object value;
            String name = fieldNames[i];
            if (!StringUtils.isEmpty((Object)name) && "serialVersionUID".equals(name) || null == (value = MyRecord.getFieldValueByName(name, t))) continue;
            columns.put(name, value);
        }
        return this;
    }

    public MyRecord remove(String column) {
        this.getColumns().remove(column);
        return this;
    }

    public MyRecord remove(String ... columns) {
        if (columns != null) {
            for (String c : columns) {
                this.getColumns().remove(c);
            }
        }
        return this;
    }

    public MyRecord removeNullValueColumns() {
        Iterator<Map.Entry<String, Object>> it = this.getColumns().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
        }
        return this;
    }

    public MyRecord keep(String ... columns) {
        if (columns != null && columns.length > 0) {
            HashMap<String, Object> newColumns = new HashMap<String, Object>(columns.length);
            for (String c : columns) {
                if (!this.getColumns().containsKey(c)) continue;
                newColumns.put(c, this.getColumns().get(c));
            }
            this.getColumns().clear();
            this.getColumns().putAll(newColumns);
        } else {
            this.getColumns().clear();
        }
        return this;
    }

    public MyRecord keep(String column) {
        if (this.getColumns().containsKey(column)) {
            Object keepIt = this.getColumns().get(column);
            this.getColumns().clear();
            this.getColumns().put(column, keepIt);
        } else {
            this.getColumns().clear();
        }
        return this;
    }

    public MyRecord clear() {
        this.getColumns().clear();
        return this;
    }

    public MyRecord set(String column, Object value) {
        this.getColumns().put(column, value);
        return this;
    }

    public MyRecord set(String column, List<MyRecord> valueList) {
        ArrayList value = new ArrayList();
        valueList.forEach(o -> {
            HashMap<String, Object> va = new HashMap<String, Object>(o.getColumns());
            value.add(va);
        });
        this.getColumns().put(column, value);
        return this;
    }

    public <T> T get(String column) {
        return (T)this.getColumns().get(column);
    }

    public <T> T get(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return (T)(result != null ? result : defaultValue);
    }

    public Object getObject(String column) {
        return this.getColumns().get(column);
    }

    public Object getObject(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return result != null ? result : defaultValue;
    }

    public String getStr(String column) {
        Object s = this.getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(String column) {
        Number n = this.getNumber(column);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Long getLong(String column) {
        Number n = this.getNumber(column);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public BigInteger getBigInteger(String column) {
        return (BigInteger)this.getColumns().get(column);
    }

    public Date getDate(String column) {
        return (Date)this.getColumns().get(column);
    }

    public Time getTime(String column) {
        return (Time)this.getColumns().get(column);
    }

    public Timestamp getTimestamp(String column) {
        return (Timestamp)this.getColumns().get(column);
    }

    public Double getDouble(String column) {
        Number n = this.getNumber(column);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Float getFloat(String column) {
        Number n = this.getNumber(column);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Short getShort(String column) {
        Number n = this.getNumber(column);
        return n != null ? Short.valueOf(n.shortValue()) : null;
    }

    public Byte getByte(String column) {
        Number n = this.getNumber(column);
        return n != null ? Byte.valueOf(n.byteValue()) : null;
    }

    public Boolean getBoolean(String column) {
        return (Boolean)this.getColumns().get(column);
    }

    public BigDecimal getBigDecimal(String column) {
        Object n = this.getColumns().get(column);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public byte[] getBytes(String column) {
        return (byte[])this.getColumns().get(column);
    }

    public Number getNumber(String column) {
        if (this.getColumns().get(column) instanceof String) {
            try {
                return NumberFormat.getInstance().parse(this.getColumns().get(column).toString());
            }
            catch (ParseException e) {
                System.out.println("\u7c7b\u578b\u8f6c\u6362\u9519\u8befe = " + e.getMessage());
                e.printStackTrace();
            }
        }
        return (Number)this.getColumns().get(column);
    }

    public String toString() {
        if (this.columns == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.getColumns().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MyRecord)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getColumns().equals(((MyRecord)o).getColumns());
    }

    public int hashCode() {
        return this.getColumns().hashCode();
    }

    public String[] getColumnNames() {
        Set<String> attrNameSet = this.getColumns().keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getColumnValues() {
        Collection<Object> attrValueCollection = this.getColumns().values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String toJson() {
        return JSON.toJSONString(this.getColumns());
    }

    private static String[] getFiledName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u5c5e\u6027\u503c\u5931\u8d25\uff01" + e, (Throwable)e);
            return null;
        }
    }

    private static Object getFiledType(String fieldName, Object o) {
        Field[] fields;
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            if (!Objects.equals(fieldName, field.getName())) continue;
            return field.getType();
        }
        return null;
    }
}

