/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.constants.DateConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrmebDateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmebDateUtil.class);

    private CrmebDateUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String nowDate() {
        return CrmebDateUtil.nowDate("yyyyMMdd");
    }

    public static String nowYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1) + "";
    }

    public static String lastYear() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        return cal.get(1) + "";
    }

    public static String nextYear() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        return cal.get(1) + "";
    }

    public static Date nowDateTime() {
        return CrmebDateUtil.strToDate(CrmebDateUtil.nowDateTimeStr(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String nowDateTimeStr() {
        return CrmebDateUtil.nowDate("yyyy-MM-dd HH:mm:ss");
    }

    public static String nowDate(String DATE_FORMAT) {
        SimpleDateFormat dft = new SimpleDateFormat(DATE_FORMAT);
        return dft.format(new Date());
    }

    public static String nowDateTime(String DATE_FORMAT) {
        SimpleDateFormat dft = new SimpleDateFormat(DATE_FORMAT);
        return dft.format(new Date());
    }

    public static Integer getNowTime() {
        long t = System.currentTimeMillis() / 1000L;
        return Integer.parseInt(String.valueOf(t));
    }

    public static Long getTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Date nowDateTimeReturnDate(String DATE_FORMAT) {
        SimpleDateFormat dft = new SimpleDateFormat(DATE_FORMAT);
        return CrmebDateUtil.strToDate(dft.format(new Date()), DATE_FORMAT);
    }

    public static String dateToStr(Date date, String DATE_FORMAT) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat myFormat = new SimpleDateFormat(DATE_FORMAT);
        return myFormat.format(date);
    }

    public static Date strToDate(String dateStr, String DATE_FORMAT) {
        SimpleDateFormat myFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            return myFormat.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date addSecond(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, num);
        return calendar.getTime();
    }

    public static String addSecond(Date date, int num, String DATE_FORMAT) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, num);
        return CrmebDateUtil.dateToStr(calendar.getTime(), DATE_FORMAT);
    }

    public static final String addDay(String newDate, int num, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            Date currdate = format.parse(newDate);
            Calendar ca = Calendar.getInstance();
            ca.setTime(currdate);
            ca.add(5, num);
            return format.format(ca.getTime());
        }
        catch (ParseException e) {
            LOGGER.error("\u8f6c\u5316\u65f6\u95f4\u51fa\u9519,", (Throwable)e);
            return null;
        }
    }

    public static final String addDay(Date newDate, int num, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        Calendar ca = Calendar.getInstance();
        ca.setTime(newDate);
        ca.add(5, num);
        return format.format(ca.getTime());
    }

    public static Date timeStamp11ToDate(Integer date) {
        return new Date(date.intValue());
    }

    public static String timeStamp11ToDate(Integer date, String DATE_FORMAT) {
        return CrmebDateUtil.dateToStr(new Date(date.intValue()), DATE_FORMAT);
    }

    public static int compareDate(String date1, String date2, String pattern) {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(pattern);
        try {
            Date dt1 = DATE_FORMAT.parse(date1);
            Date dt2 = DATE_FORMAT.parse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean checkDateFormat(String date, String style) {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(style);
        try {
            DATE_FORMAT.setLenient(false);
            DATE_FORMAT.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static long getTwoDateDays(Date beforeDay, Date afterDay) {
        SimpleDateFormat sm = new SimpleDateFormat("yyyyMMdd");
        long days = -1L;
        try {
            days = (sm.parse(sm.format(afterDay)).getTime() - sm.parse(sm.format(beforeDay)).getTime()) / 86400000L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }

    public static int getSecondTimestamp(Date date) {
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime() / 1000L);
        return Integer.parseInt(timestamp);
    }

    public static int getSecondTimestamp(String date) {
        if (null == date) {
            return 0;
        }
        Date date1 = CrmebDateUtil.strToDate(date, "yyyy-MM-dd HH:mm:ss");
        if (date1 == null) {
            return 0;
        }
        String timestamp = String.valueOf(date1.getTime() / 1000L);
        return Integer.parseInt(timestamp);
    }

    public static int getSecondTimestamp(Long timeMillis) {
        if (null == timeMillis) {
            return 0;
        }
        String timestamp = String.valueOf(timeMillis / 1000L);
        return Integer.parseInt(timestamp);
    }

    public static int getSecondTimestamp() {
        Date date = CrmebDateUtil.strToDate(CrmebDateUtil.nowDateTime("yyyy-MM-dd HH:mm:ss"), "yyyy-MM-dd HH:mm:ss");
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime() / 1000L);
        return Integer.parseInt(timestamp);
    }

    public static String getYesterdayStr() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        SimpleDateFormat startSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return startSdf.format(c.getTime());
    }

    public static String getWeekStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(4, 0);
        c.set(7, 2);
        SimpleDateFormat startSdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        return startSdf.format(c.getTime());
    }

    public static String getWeekEndDay() {
        return CrmebDateUtil.addDay(CrmebDateUtil.getWeekStartDay(), 7, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getLastWeekStartDay() {
        return CrmebDateUtil.addDay(CrmebDateUtil.getWeekStartDay(), -7, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getLastWeekEndDay() {
        return CrmebDateUtil.addDay(CrmebDateUtil.getLastWeekStartDay(), 7, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getMonthEndDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, c.getActualMaximum(5));
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return endSdf.format(c.getTime());
    }

    public static String getLastMonthStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, 1);
        SimpleDateFormat startSdf = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        return startSdf.format(c.getTime());
    }

    public static String getLastMonthEndDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, c.getActualMaximum(5));
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return endSdf.format(c.getTime());
    }

    public static String getLastYearStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        SimpleDateFormat startSdf = new SimpleDateFormat("yyyy-01-01 00:00:00");
        return startSdf.format(c.getTime());
    }

    public static String getLastYearEndDay() {
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-12-31 23:59:59");
        return endSdf.format(c.getTime());
    }

    public static DateLimitUtilVo getDateLimit(String data) {
        String startTime = null;
        String endTime = CrmebDateUtil.nowDateTime("yyyy-MM-dd HH:mm:ss");
        String day = CrmebDateUtil.nowDateTime("yyyy-MM-dd 00:00:00");
        String end = CrmebDateUtil.nowDateTime("yyyy-MM-dd 23:59:59");
        if (StrUtil.isNotBlank((CharSequence)data)) {
            switch (data) {
                case "today": {
                    startTime = day;
                    break;
                }
                case "yesterday": {
                    startTime = CrmebDateUtil.addDay(day, -1, "yyyy-MM-dd 00:00:00");
                    endTime = CrmebDateUtil.addDay(end, -1, "yyyy-MM-dd 23:59:59");
                    break;
                }
                case "lately7": {
                    startTime = CrmebDateUtil.addDay(day, -6, "yyyy-MM-dd 00:00:00");
                    break;
                }
                case "week": {
                    startTime = CrmebDateUtil.getWeekStartDay();
                    endTime = CrmebDateUtil.getWeekEndDay();
                    break;
                }
                case "preWeek": {
                    startTime = CrmebDateUtil.getLastWeekStartDay();
                    endTime = CrmebDateUtil.getLastWeekEndDay();
                    break;
                }
                case "lately30": {
                    startTime = CrmebDateUtil.addDay(day, -30, "yyyy-MM-dd 00:00:00");
                    break;
                }
                case "month": {
                    startTime = CrmebDateUtil.nowDateTime("yyyy-MM-01 00:00:00");
                    endTime = CrmebDateUtil.getMonthEndDay();
                    break;
                }
                case "preMonth": {
                    startTime = CrmebDateUtil.getLastMonthStartDay();
                    endTime = CrmebDateUtil.getLastMonthEndDay();
                    break;
                }
                case "year": {
                    startTime = CrmebDateUtil.nowDateTime("yyyy-01-01 00:00:00");
                    endTime = CrmebDateUtil.nowDateTime("yyyy-12-31 23:59:59");
                    break;
                }
                case "preYear": {
                    startTime = CrmebDateUtil.getLastYearStartDay();
                    endTime = CrmebDateUtil.getLastYearEndDay();
                    break;
                }
                default: {
                    List<String> list = CrmebUtil.stringToArrayStr(data);
                    if (list.size() == 1) {
                        throw new CrmebException("\u9009\u62e9\u65f6\u95f4\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u5728 today|yesterday|lately7|lately30|month|year|\u81ea\u5b9a\u4e49\u65f6\u95f4\u8303\u56f4\uff08\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss\uff0c\u4e24\u4e2a\u65f6\u95f4\u8303\u56f4\u7528\u9017\u53f7\u5206\u5272\uff09");
                    }
                    startTime = list.get(0);
                    endTime = list.get(1);
                    startTime = CrmebDateUtil.appointedDayStrToFormatStr(startTime, "yyyy-MM-dd", "yyyy-MM-dd 00:00:00");
                    endTime = CrmebDateUtil.appointedDayStrToFormatStr(endTime, "yyyy-MM-dd", "yyyy-MM-dd 23:59:59");
                }
            }
        }
        return new DateLimitUtilVo(startTime, endTime);
    }

    public static DateLimitUtilVo getMonthLimit(String data) {
        List<String> monthList = CrmebUtil.stringToArrayStr(data);
        if (monthList.size() != 2) {
            throw new CrmebException("\u9009\u62e9\u65f6\u95f4\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u8303\u56f4\uff08\u683c\u5f0f\uff1ayyyy-MM\uff0c\u4e24\u4e2a\u65f6\u95f4\u8303\u56f4\u7528\u9017\u53f7\u5206\u5272\uff09");
        }
        String startMonth = monthList.get(0);
        String endMonth = monthList.get(1);
        if (!CrmebDateUtil.isValidMonth(startMonth) || !CrmebDateUtil.isValidMonth(endMonth)) {
            throw new CrmebException("\u65f6\u95f4\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0fyyyy-MM");
        }
        return new DateLimitUtilVo(startMonth, endMonth);
    }

    public static boolean isValidMonth(String month) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        ParsePosition pos = new ParsePosition(0);
        format.setLenient(false);
        Date result = format.parse(month, pos);
        return pos.getIndex() != 0 && month.equals(format.format(result));
    }

    public static List<String> getListDate(String data) {
        DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit(data);
        ArrayList<String> date = new ArrayList<String>();
        Date startDate = CrmebDateUtil.strToDate(dateLimit.getStartTime(), "yyyy-MM-dd HH:mm:ss");
        Date endDate = CrmebDateUtil.strToDate(dateLimit.getEndTime(), "yyyy-MM-dd HH:mm:ss");
        while (endDate.after(startDate)) {
            date.add(CrmebDateUtil.dateToStr(startDate, "yyyy-MM-dd"));
            startDate = CrmebDateUtil.strToDate(CrmebDateUtil.addDay(startDate, 1, "yyyy-MM-dd HH:mm:ss"), "yyyy-MM-dd HH:mm:ss");
        }
        return date;
    }

    public static int daysBetween(Date starDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(starDate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(endDate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String appointedDayStrToFormatStr(String dateStr, String STR_DATE_FORMAT, String DATE_FORMAT) {
        Date date = CrmebDateUtil.strToDate(dateStr, STR_DATE_FORMAT);
        return CrmebDateUtil.dateToStr(date, DATE_FORMAT);
    }

    public static int getCurrentHour() {
        int hour = Calendar.getInstance().get(11);
        return hour;
    }

    public static String timestamp2DateStr(Long timestamp, String dateFormat) {
        if (ObjectUtil.isNull((Object)timestamp)) {
            return "";
        }
        if (StrUtil.isBlank((CharSequence)dateFormat)) {
            dateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        Date date = new Date(timestamp);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return simpleDateFormat.format(date);
    }

    public static Long dateStr2Timestamp(String dateStr, String type) {
        DateTime parse = DateUtil.parse((String)dateStr);
        if (StrUtil.isNotBlank((CharSequence)type)) {
            if (type.equals(DateConstants.DATE_TIME_TYPE_BEGIN)) {
                parse = DateUtil.beginOfDay((Date)parse);
            }
            if (type.equals(DateConstants.DATE_TIME_TYPE_END)) {
                parse = DateUtil.endOfDay((Date)parse);
            }
        }
        return parse.getTime();
    }

    public static void main(String[] args) {
        DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit("lately7");
        System.out.println(dateLimit.getStartTime());
        System.out.println(dateLimit.getEndTime());
    }

    public static List<String> getAllDayByMonth(Integer yearParam, Integer monthParam) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.set(yearParam, monthParam - 1, 1);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.getActualMaximum(5);
        for (int i = 1; i <= day; ++i) {
            String date = null;
            if (month < 10 && i < 10) {
                date = year + "-0" + month + "-0" + i;
            }
            if (month < 10 && i >= 10) {
                date = year + "-0" + month + "-" + i;
            }
            if (month >= 10 && i < 10) {
                date = year + "-" + month + "-0" + i;
            }
            if (month >= 10 && i >= 10) {
                date = year + "-" + month + "-" + i;
            }
            list.add(date);
        }
        return list;
    }
}

