/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.token;

import cn.hutool.core.util.StrUtil;
import com.zbkj.common.model.user.User;
import com.zbkj.common.token.TokenUtils;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.vo.LoginUserVo;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FrontTokenComponent {
    @Resource
    private RedisUtil redisUtil;
    private static final Long MILLIS_MINUTE_TEN = 1200000L;
    private static final Long MILLIS_MINUTE = 60000L;
    private static final int expireTime = 300;

    public void delLoginUser(String token) {
        if (StrUtil.isNotBlank((CharSequence)token)) {
            String userKey = this.getTokenKey(token);
            this.redisUtil.delete(userKey);
        }
    }

    public String createToken(User user) {
        String token = UUID.randomUUID().toString().replace("-", "");
        this.redisUtil.set(this.getTokenKey(token), user.getId(), 1440L, TimeUnit.MINUTES);
        this.redisUtil.set("UNION_ID:" + token, user.getIdentityNo(), 180L, TimeUnit.MINUTES);
        return token;
    }

    public String createBcxToken(String bcxToken, User user) {
        String key = this.getTokenKey(bcxToken);
        this.redisUtil.set(key, user.getId(), 1440L, TimeUnit.MINUTES);
        this.redisUtil.set("UNION_ID:" + bcxToken, user.getIdentityNo(), 180L, TimeUnit.MINUTES);
        return key;
    }

    public void verifyToken(LoginUserVo loginUser) {
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= MILLIS_MINUTE_TEN) {
            this.refreshToken(loginUser);
        }
    }

    public void refreshToken(LoginUserVo loginUser) {
        loginUser.setLoginTime(System.currentTimeMillis());
        loginUser.setExpireTime(loginUser.getLoginTime() + 300L * MILLIS_MINUTE);
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisUtil.set(userKey, loginUser, 300L, TimeUnit.MINUTES);
    }

    public String getToken(HttpServletRequest request) {
        String token = request.getHeader("Authori-zation");
        if (StrUtil.isNotBlank((CharSequence)token) && token.startsWith("TOKEN_USER:")) {
            token = token.replace("TOKEN_USER:", "");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = TokenUtils.getBcxToken(request);
        }
        return token;
    }

    private String getTokenKey(String uuid) {
        return "TOKEN_USER:" + uuid;
    }

    public void logout(HttpServletRequest request) {
        String token = this.getToken(request);
        this.delLoginUser(token);
    }

    public String accoutCode() {
        HttpServletRequest request = RequestUtil.getRequest();
        String token = this.getToken(request);
        if (StrUtil.isEmpty((CharSequence)token)) {
            return null;
        }
        String key = "UNION_ID:" + token;
        return (String)this.redisUtil.get(key);
    }

    public Integer getUserId() {
        HttpServletRequest request = RequestUtil.getRequest();
        String token = this.getToken(request);
        if (StrUtil.isEmpty((CharSequence)token)) {
            return null;
        }
        return (Integer)this.redisUtil.get(this.getTokenKey(token));
    }

    public Integer getUserIdByToken(String token) {
        return (Integer)this.redisUtil.get(this.getTokenKey(token));
    }

    public Boolean check(String token) {
        try {
            boolean exists = this.redisUtil.exists(this.getTokenKey(token));
            if (exists) {
                Integer uid = (Integer)this.redisUtil.get(this.getTokenKey(token));
                this.redisUtil.set(this.getTokenKey(token), uid, 1440L, TimeUnit.MINUTES);
            }
            return exists;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean checkBcxToken(String bcxToken) {
        try {
            String key = this.getTokenKey(bcxToken);
            boolean exists = this.redisUtil.exists(key);
            if (exists) {
                Integer uid = (Integer)this.redisUtil.get(key);
                this.redisUtil.set(key, uid, 1440L, TimeUnit.MINUTES);
            }
            return exists;
        }
        catch (Exception e) {
            return false;
        }
    }
}

