package com.zbkj.service.wangshang.api.domain.model.order;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 协议授权代扣接口
 * <ant.mybank.bkcloudfunds.order.withhold.apply>
 **/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsOrderWithholdApplyRequestModel extends RequestBody {


    private static final long serialVersionUID = 3167041743646941652L;

    /**
     * 合作方机构号（网商银行分配）。
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 代扣业务订单号
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 业务场景：
     * 品牌协议代扣场景：PROTOCOL_WITHHOLD
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Scene")
    private String scene;

    /**
     * 交易金额（分）
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 冻结部分出金（分）
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "FreezeAmount")
    private String freezeAmount;

    /**
     * 可用部分金额（分）
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "AvailableAmount")
    private String availableAmount;

    /**
     * 币种
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 付款方商户号
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayerId")
    private String payerId;

    /**
     * 付款方类型：
     * MERCHANT
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayerType")
    private String payerType;

    /**
     * 收款方ID
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayeeId")
    private String payeeId;

    /**
     * PayeeType	收款方类型
     * MERCHANT
     * PLATFORM
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayeeType")
    private String payeeType;

    /**
     * 备注（可填写订单描述信息）
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Memo")
    private String memo;

    /**
     * 扩展信息
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getFreezeAmount() {
        return freezeAmount;
    }

    public void setFreezeAmount(String freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public String getAvailableAmount() {
        return availableAmount;
    }

    public void setAvailableAmount(String availableAmount) {
        this.availableAmount = availableAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayerId() {
        return payerId;
    }

    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public String getPayerType() {
        return payerType;
    }

    public void setPayerType(String payerType) {
        this.payerType = payerType;
    }

    public String getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public String getPayeeType() {
        return payeeType;
    }

    public void setPayeeType(String payeeType) {
        this.payeeType = payeeType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}