package com.zbkj.admin.controller.platform;

import com.zbkj.common.request.BcxProductMenuRequest;
import com.zbkj.common.response.BcxProductMenuResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxProductMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商城商品菜单 控制层
 */
@Slf4j
@Api(tags = "商城商品菜单控制器")
@RestController
@RequestMapping("/api/admin/platform/product/menu")
public class BcxProductMenuController {

    @Autowired
    private BcxProductMenuService bcxProductMenuService;

    @ApiOperation("新增商城商品菜单")
    //@PreAuthorize("hasAuthority('platform:product:menu:create')")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<String> create(@RequestBody @Validated BcxProductMenuRequest bcxProductMenu){
        if(bcxProductMenuService.create(bcxProductMenu)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("修改商城商品菜单")
    //@PreAuthorize("hasAuthority('platform:product:menu:update')")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public CommonResult<String> update(@RequestBody @Validated BcxProductMenuRequest bcxProductMenu){
        if (bcxProductMenuService.update(bcxProductMenu)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("删除商城商品菜单")
    //@PreAuthorize("hasAuthority('platform:product:menu:delete')")
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
    public CommonResult<String> delete(@PathVariable Integer id) {
        if (bcxProductMenuService.delete(id)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation(value = "商品菜单缓存树")
    //@PreAuthorize("hasAuthority('platform:product:menu:tree')")
    @RequestMapping(value = "/cache/tree/{type}", method = RequestMethod.POST)
    public CommonResult<List<BcxProductMenuResponse>> getProductMenuCacheTree(@PathVariable Integer type) {
        return CommonResult.success(bcxProductMenuService.getCacheTree(type));
    }
}
