package com.zbkj.admin.controller.platform;

import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.*;
import com.zbkj.common.response.BcxBrokerageConfigResponse;
import com.zbkj.common.response.BcxBrokerageLoadResponse;
import com.zbkj.common.response.PlatformProductListResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxBrokerageConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * description: 佣金绩效配置表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-佣金绩效配置表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/brokerage/config")
public class BcxBrokerageConfigController {
    
    @Autowired
    private BcxBrokerageConfigService bcxBrokerageConfigService;


//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "佣金绩效配置信息保存")
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public CommonResult<Object> saveBcxBrokerageConfig(@RequestBody @Validated BcxBrokerageConfigRequest request) {
        return CommonResult.success(bcxBrokerageConfigService.saveBcxBrokerageConfig(request));
    }

//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "查询佣金配置")
    @RequestMapping(value = "/load", method = RequestMethod.GET)
    public CommonResult<BcxBrokerageLoadResponse> load(@Validated BcxBrokerageLoadSearchRequest searchRequest) {
        return CommonResult.success(bcxBrokerageConfigService.load(searchRequest));
    }

//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
//    @ApiOperation(value = "查询列表")
//    @RequestMapping(value = "/list", method = RequestMethod.GET)
//    public CommonResult<List<BcxBrokerageConfigResponse>> getList(@Validated BcxBrokerageConfigSearchRequest searchRequest) {
//        return CommonResult.success(bcxBrokerageConfigService.getList(searchRequest));
//    }

//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "设置/取消分销商品")
    @RequestMapping(value = "/set/product", method = RequestMethod.POST)
    public CommonResult<Object> setProduct(@RequestBody @Validated BcxSetProductBrokerageRequest request) {
        return CommonResult.success(bcxBrokerageConfigService.setProductBrokerage(request));
    }

//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "查询商品列表")
    @RequestMapping(value = "/product/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<PlatformProductListResponse>> getProductList(@Validated ProductSearchRequest searchRequest,
                                                                                @Validated PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(bcxBrokerageConfigService.getProductList(searchRequest, pageParamRequest)));
    }
}