/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import com.huifu.bspay.sdk.opps.core.utils.RsaUtils;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.dto.JsPayTransferDto;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.alipay.AliPayInfo;
import com.zbkj.common.model.bcx.BcxOrderRelation;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bcx.BcxPayOfflineFile;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.bill.MerchantBill;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.huifu.JsPayTrade;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.order.VirtualOrder;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductCoupon;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.model.wechat.video.PayComponentProduct;
import com.zbkj.common.request.OrderPayRequest;
import com.zbkj.common.request.bcx.BcxMerchantPayOfflineRequest;
import com.zbkj.common.response.OrderPayResultResponse;
import com.zbkj.common.response.PayConfigResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ERiskUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.utils.WxPayUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoDetailVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoVo;
import com.zbkj.common.vo.CreateOrderRequestVo;
import com.zbkj.common.vo.CreateOrderResponseVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.WxPayJsResultVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderAddResultVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddressInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderDeliveryDetailAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderDetailAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderGetPaymentParamsRequestVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderGetPaymentParamsRersponseVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPayInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPriceInfoVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderProductInfoAddVo;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.JsPayTradeDao;
import com.zbkj.service.factory.PaymentFactory;
import com.zbkj.service.service.AliPayInfoService;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.HuifuReconcileService;
import com.zbkj.service.service.HuifuWalletService;
import com.zbkj.service.service.MerchantBillService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.OrderStatusService;
import com.zbkj.service.service.PayComponentOrderService;
import com.zbkj.service.service.PayComponentProductService;
import com.zbkj.service.service.PayService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductCouponService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.VirtualOrderService;
import com.zbkj.service.service.WechatPayInfoService;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoOrderService;
import com.zbkj.service.service.bcx.BcxOrderRelationService;
import com.zbkj.service.service.bcx.BcxPayOfflineFileService;
import com.zbkj.service.service.bcx.BcxPayOfflineService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import com.zbkj.service.service.impl.AsyncServiceImpl;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger logger = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private OrderStatusService orderStatusService;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private ProductCouponService productCouponService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private MerchantBillService merchantBillService;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private BillService billService;
    @Autowired
    private WechatVideoOrderService wechatVideoOrderService;
    @Autowired
    @Lazy
    private AsyncService asyncService;
    @Autowired
    private PayComponentOrderService payComponentOrderService;
    @Autowired
    private PayComponentProductService payComponentProductService;
    @Autowired
    private AliPayInfoService aliPayInfoService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Resource
    private BcxPlatformFeeService bcxPlatformFeeService;
    @Resource
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    HuifuReconcileService huifuReconcileService;
    @Resource
    private JsPayTradeDao jsPayTradeDao;
    @Resource
    private ProductAttrValueService productAttrValueService;
    @Autowired
    TransactionLogService transactionLogService;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Resource
    private BcxPayOfflineService bcxPayOfflineService;
    @Resource
    private BcxPayOfflineFileService bcxPayOfflineFileService;
    @Resource
    BcxOrderRelationService bcxOrderRelationService;
    @Resource
    VirtualOrderService virtualOrderService;
    @Autowired
    private PaymentFactory paymentFactory;
    @Autowired
    private RedissonClient redisson;
    private static final String TRANSFERKEY = "Callback:";
    private static final DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private static Map<String, String> smap = Maps.newHashMap();

    @Override
    public Boolean sendWalletCode(String phone) {
        return this.smsService.sendCommonCode(phone);
    }

    @Override
    public PayConfigResponse getPayConfig() {
        String payWxOpen = this.systemConfigService.getValueByKey("pay_weixin_open");
        String yuePayStatus = this.systemConfigService.getValueByKey("yue_pay_status");
        String aliPayStatus = this.systemConfigService.getValueByKey("ali_pay_status");
        PayConfigResponse response = new PayConfigResponse();
        response.setWalletStatus(Boolean.valueOf(true));
        User user = this.userService.getInfo();
        try {
            BigDecimal accountBalance = this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).getHuifuWallectBalanceByUniId(user.getIdentityNo());
            response.setWalletBalance(accountBalance);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u51fa\u9519\uff1a", (Throwable)e);
            response.setWalletStatus(Boolean.valueOf(false));
        }
        response.setYuePayStatus(Boolean.valueOf("'1'".equals(yuePayStatus)));
        response.setPayWechatOpen(Boolean.valueOf("'1'".equals(payWxOpen)));
        response.setAliPayStatus(Boolean.valueOf("'1'".equals(aliPayStatus)));
        if ("'1'".equals(yuePayStatus)) {
            response.setUserBalance(user.getNowMoney());
        }
        return response;
    }

    @Override
    public Map<String, String> getIdentifyNoByOrderNo(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (order == null) {
            throw new CrmebException("\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        Integer merId = order.getMerId();
        Merchant merchant = this.merchantService.getByIdException(merId);
        if (StrUtil.isBlank((CharSequence)merchant.getIdentityNo())) {
            throw new CrmebException("\u5546\u6237\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305");
        }
        HashMap map = Maps.newHashMap();
        map.put("inId", merchant.getIdentityNo());
        map.put("amount", order.getPayPrice().toPlainString());
        return map;
    }

    private OrderPayResultResponse virtualPayment(OrderPayRequest orderPayRequest) {
        Integer merId;
        Merchant merchant;
        VirtualOrder virtualOrder = this.virtualOrderService.getByVirtualOrderNo(orderPayRequest.getOrderNo());
        OrderPayResultResponse response = new OrderPayResultResponse();
        if (virtualOrder == null) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        User user = (User)this.userService.getById(virtualOrder.getUid());
        if (virtualOrder.getTotalPrice().compareTo(BigDecimal.ZERO) <= 0) {
            response.setPayType("zero");
            response.setStatus(Boolean.valueOf(this.virtualOrderService.virtualOrderPay(virtualOrder, user.getIdentityNo())));
            response.setOrderNo(orderPayRequest.getOrderNo());
            return response;
        }
        if (orderPayRequest.getPayType().equals("yue") && user.getNowMoney().compareTo(virtualOrder.getTotalPrice()) < 0) {
            throw new CrmebException("\u7528\u6237\u4f59\u989d\u4e0d\u8db3");
        }
        if (orderPayRequest.getPayType().equals("wallet")) {
            if (StrUtil.isBlank((CharSequence)user.getIdentityNo())) {
                throw new CrmebException("\u7528\u6237\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305");
            }
            BigDecimal accountBalance = null;
            try {
                accountBalance = this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).getHuifuWallectBalanceByUniId(user.getIdentityNo());
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u51fa\u9519\uff1a", (Throwable)e);
                throw new CrmebException("\u83b7\u53d6\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u51fa\u9519,\u662f\u5426\u6709\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff1f");
            }
            if (accountBalance.compareTo(virtualOrder.getTotalPrice()) < 0) {
                throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u4e0d\u8db3");
            }
        }
        if (StrUtil.isBlank((CharSequence)(merchant = this.merchantService.getByIdException(merId = virtualOrder.getMerId())).getIdentityNo())) {
            throw new CrmebException("\u5546\u6237\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305");
        }
        response.setOrderNo(orderPayRequest.getOrderNo());
        response.setPayType(orderPayRequest.getPayType());
        response.setPayChannel(orderPayRequest.getPayChannel());
        response.setStatus(Boolean.valueOf(this.virtualOrderService.virtualOrderPay(virtualOrder, user.getIdentityNo())));
        return response;
    }

    @Override
    public OrderPayResultResponse payment(OrderPayRequest orderPayRequest) {
        WxPayJsResultVo vo;
        Integer merId;
        Merchant merchant;
        logger.info("\u8ba2\u5355\u652f\u4ed8 START orderPayRequest:{}", (Object)JSON.toJSONString((Object)orderPayRequest));
        if (orderPayRequest.getOrderNo().startsWith("VIR")) {
            return this.virtualPayment(orderPayRequest);
        }
        Order order = this.orderService.getByOrderNo(orderPayRequest.getOrderNo());
        logger.info("\u8ba2\u5355\u652f\u4ed8 \u5f53\u524d\u64cd\u4f5c\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)order));
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (order.getPaid().booleanValue()) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        if (order.getStatus() > OrderConstants.ORDER_STATUS_WAIT_PAY) {
            throw new CrmebException("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        User user = (User)this.userService.getById(order.getUid());
        OrderPayResultResponse response = new OrderPayResultResponse();
        if (order.getPayPrice().compareTo(BigDecimal.ZERO) <= 0) {
            Boolean aBoolean = this.zeroPay(order, user);
            response.setPayType("zero");
            response.setStatus(aBoolean);
            response.setOrderNo(order.getOrderNo());
            return response;
        }
        order.setPayType(orderPayRequest.getPayType());
        order.setPayChannel(orderPayRequest.getPayChannel());
        if (orderPayRequest.getPayType().equals("yue") && user.getNowMoney().compareTo(order.getPayPrice()) < 0) {
            throw new CrmebException("\u7528\u6237\u4f59\u989d\u4e0d\u8db3");
        }
        if (orderPayRequest.getPayType().equals("wallet")) {
            if (StrUtil.isBlank((CharSequence)user.getIdentityNo())) {
                throw new CrmebException("\u7528\u6237\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305");
            }
            BigDecimal accountBalance = null;
            try {
                accountBalance = StringUtils.isEmpty((CharSequence)order.getVirtualOrderNo()) ? this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).getHuifuWallectBalanceByUniId(user.getIdentityNo()) : this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).getWallectFrozenAmountByUniId(user.getIdentityNo());
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u51fa\u9519\uff1a", (Throwable)e);
                throw new CrmebException("\u83b7\u53d6\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u51fa\u9519,\u662f\u5426\u6709\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff1f");
            }
            if (accountBalance.compareTo(order.getPayPrice()) < 0) {
                throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u4f59\u989d\u4e0d\u8db3");
            }
        }
        if (StrUtil.isBlank((CharSequence)(merchant = this.merchantService.getByIdException(merId = order.getMerId())).getIdentityNo())) {
            throw new CrmebException("\u5546\u6237\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305");
        }
        response.setOrderNo(order.getOrderNo());
        response.setPayType(order.getPayType());
        response.setPayChannel(order.getPayChannel());
        if (order.getPayType().equals("yue")) {
            Boolean yueBoolean = this.yuePay(order, user);
            response.setStatus(yueBoolean);
            logger.info("\u4f59\u989d\u652f\u4ed8 response : {}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        if (order.getPayType().equals("wallet")) {
            List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(orderPayRequest.getOrderNo());
            Boolean walletBoolean = this.walletFreezeAndPay(order, orderDetails.get(0), order.getBizType(), user, merchant);
            response.setStatus(walletBoolean);
            logger.info("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8 response : {}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        if (order.getPayType().equals("weixin")) {
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u5fae\u4fe1\u4e0b\u5355");
            vo = this.wechatPayment(order);
            this.orderService.updateById(order);
            response.setStatus(Boolean.valueOf(true));
            response.setJsConfig(vo);
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u5fae\u4fe1\u4e0b\u5355 response :{}", (Object)JSON.toJSONString((Object)response));
        }
        if (order.getPayChannel().equals("video")) {
            vo = new WxPayJsResultVo();
            UserToken tokenByUser = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            logger.info("\u89c6\u9891\u53f7\u4e0b\u5355\uff0c\u8ba2\u5355\u8be6\u60c5:{}", (Object)JSON.toJSONString(orderDetailList));
            PayComponentProduct payComponentProduct = (PayComponentProduct)this.payComponentProductService.getById(orderDetailList.get(0).getProductId());
            logger.info("\u89c6\u9891\u53f7\u4e0b\u5355\uff0c\u5f53\u524d\u89c6\u9891\u53f7\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)payComponentProduct));
            ShopOrderDetailAddVo shopOrderDetailAddVo = new ShopOrderDetailAddVo();
            ArrayList<ShopOrderProductInfoAddVo> shopOrderProductInfoAddVoList = new ArrayList<ShopOrderProductInfoAddVo>();
            for (OrderDetail orderDetail : orderDetailList) {
                ShopOrderProductInfoAddVo shopOrderProductInfoAddVo = new ShopOrderProductInfoAddVo();
                shopOrderProductInfoAddVo.setOutProductId(orderDetail.getProductId().toString());
                shopOrderProductInfoAddVo.setOutSkuId(orderDetail.getAttrValueId().toString());
                shopOrderProductInfoAddVo.setProductCnt(orderDetail.getPayNum());
                shopOrderProductInfoAddVo.setSalePrice(Long.valueOf(orderDetail.getPrice().multiply(new BigDecimal("100")).longValue()));
                shopOrderProductInfoAddVo.setSkuRealPrice(Long.valueOf(orderDetail.getPayPrice().multiply(new BigDecimal("100")).longValue()));
                shopOrderProductInfoAddVo.setPath(payComponentProduct.getPath());
                shopOrderProductInfoAddVo.setTitle(payComponentProduct.getTitle());
                shopOrderProductInfoAddVo.setHeadImg(payComponentProduct.getHeadImg());
                shopOrderProductInfoAddVoList.add(shopOrderProductInfoAddVo);
            }
            shopOrderDetailAddVo.setProductInfos(shopOrderProductInfoAddVoList);
            ShopOrderPayInfoAddVo payInfoAddVo = new ShopOrderPayInfoAddVo();
            payInfoAddVo.setPayMethodType(Integer.valueOf(0));
            payInfoAddVo.setPayMethod("\u5fae\u4fe1\u652f\u4ed8");
            shopOrderDetailAddVo.setPayInfo(payInfoAddVo);
            ShopOrderPriceInfoVo shopOrderPriceInfoVo = new ShopOrderPriceInfoVo();
            shopOrderPriceInfoVo.setOrderPrice(Long.valueOf(order.getPayPrice().multiply(new BigDecimal("100")).longValue()));
            shopOrderPriceInfoVo.setFreight(Long.valueOf(0L));
            shopOrderPriceInfoVo.setDiscountedPrice(Long.valueOf(0L));
            shopOrderPriceInfoVo.setAdditionalPrice(Long.valueOf(0L));
            shopOrderPriceInfoVo.setAdditional_remarks(null);
            shopOrderDetailAddVo.setPriceInfo(shopOrderPriceInfoVo);
            ShopOrderAddVo shopOrderAddVo = new ShopOrderAddVo();
            shopOrderAddVo.setOrderDetail(shopOrderDetailAddVo);
            shopOrderAddVo.setFund_type(Integer.valueOf(1));
            shopOrderAddVo.setTrace_id(null);
            shopOrderAddVo.setOutOrderId(order.getOrderNo());
            shopOrderAddVo.setOpenid(tokenByUser.getToken());
            shopOrderAddVo.setOutUserId(user.getId());
            shopOrderAddVo.setMerId(merId);
            shopOrderAddVo.setPath("/pages/users/order_details/index?orderNo=" + orderPayRequest.getOrderNo());
            List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(orderPayRequest.getOrderNo());
            if (ObjectUtil.isNull(merchantOrderList) || merchantOrderList.size() == 0) {
                throw new CrmebException("\u672a\u627e\u5230\u89c6\u9891\u53f7\u5546\u54c1\u8ba2\u5355");
            }
            MerchantOrder CurrentMerchantOrder = merchantOrderList.get(0);
            ShopOrderAddressInfoAddVo shopOrderAddressInfoAddVo = new ShopOrderAddressInfoAddVo();
            shopOrderAddressInfoAddVo.setReceiverName(CurrentMerchantOrder.getRealName());
            shopOrderAddressInfoAddVo.setDetailedAddress(CurrentMerchantOrder.getUserAddress());
            shopOrderAddressInfoAddVo.setTelNumber(CurrentMerchantOrder.getUserPhone());
            shopOrderAddVo.setAddressInfo(shopOrderAddressInfoAddVo);
            ShopOrderDeliveryDetailAddVo shopOrderDeliveryDetailAddVo = new ShopOrderDeliveryDetailAddVo();
            shopOrderDeliveryDetailAddVo.setDeliveryType(Integer.valueOf(1));
            shopOrderAddVo.setDeliveryDetail(shopOrderDeliveryDetailAddVo);
            shopOrderAddVo.setExpire_time(Integer.valueOf(WxPayUtil.getCurrentTimestamp().intValue() + 900));
            shopOrderAddVo.setCreateTime(CrmebDateUtil.nowDateTimeStr());
            ShopOrderAddResultVo shopOrderAddResultVo = this.payComponentOrderService.create(shopOrderAddVo);
            ShopOrderGetPaymentParamsRequestVo videoPaymentRequestVo = new ShopOrderGetPaymentParamsRequestVo(shopOrderAddResultVo.getOutOrderId(), order.getOrderNo(), tokenByUser.getToken());
            logger.info("\u89c6\u9891\u53f7\u4e0b\u5355\u65f6 \u652f\u4ed8\u63a5\u53e3\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)videoPaymentRequestVo));
            ShopOrderGetPaymentParamsRersponseVo shopOrderGetPaymentParamsRersponseVo = this.wechatVideoOrderService.shopOrderGetPaymentParams(videoPaymentRequestVo);
            logger.info("\u89c6\u9891\u53f7\u4e0b\u5355\u65f6 \u83b7\u53d6\u7684\u652f\u4ed8\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)shopOrderGetPaymentParamsRersponseVo));
            response.setStatus(Boolean.valueOf(true));
            vo.setTimeStamp(WxPayUtil.getCurrentTimestamp() + "");
            vo.setNonceStr(shopOrderGetPaymentParamsRersponseVo.getNonceStr());
            vo.setPackages(shopOrderGetPaymentParamsRersponseVo.get_package());
            vo.setPaySign(shopOrderGetPaymentParamsRersponseVo.getPaySign());
            vo.setSignType(shopOrderGetPaymentParamsRersponseVo.getSignType());
            response.setJsConfig(vo);
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u89c6\u9891\u53f7\u4e0b\u5355 response:{}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        if (order.getPayType().equals("weixin")) {
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u5fae\u4fe1\u4e0b\u5355");
            vo = this.wechatPayment(order);
            this.orderService.updateById(order);
            response.setStatus(Boolean.valueOf(true));
            response.setJsConfig(vo);
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u5fae\u4fe1\u4e0b\u5355 response :{}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        if (order.getPayType().equals("alipay")) {
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u652f\u4ed8\u5b9d");
            String result = this.aliPayment(order);
            order.setOutTradeNo(order.getOrderNo());
            this.orderService.updateById(order);
            response.setStatus(Boolean.valueOf(true));
            response.setAlipayRequest(result);
            logger.info("\u8ba2\u5355\u652f\u4ed8 \u652f\u4ed8\u5b9d response :{}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        response.setStatus(Boolean.valueOf(false));
        logger.info("\u8ba2\u5355\u652f\u4ed8 END response:{}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    @Override
    public Boolean queryWechatPayResult(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (!order.getPayType().equals("weixin") && !order.getPayType().equals("weixin2huifu")) {
            throw new CrmebException("\u4e0d\u662f\u5fae\u4fe1\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        if (order.getPayType().equals("weixin2huifu")) {
            return false;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            throw new CrmebException("\u672a\u627e\u5230\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355");
        }
        Map<String, String> payVo = this.getWechatQueryPayVo(order.getOutTradeNo(), order.getPayChannel());
        MyRecord myRecord = this.wechatService.payOrderQuery(payVo);
        wechatPayInfo.setIsSubscribe(myRecord.getStr("is_subscribe"));
        wechatPayInfo.setTradeState(myRecord.getStr("trade_state"));
        wechatPayInfo.setBankType(myRecord.getStr("bank_type"));
        wechatPayInfo.setCashFee(myRecord.getInt("cash_fee"));
        wechatPayInfo.setCouponFee(myRecord.getInt("coupon_fee"));
        wechatPayInfo.setTransactionId(myRecord.getStr("transaction_id"));
        wechatPayInfo.setTimeEnd(myRecord.getStr("time_end"));
        wechatPayInfo.setTradeStateDesc(myRecord.getStr("trade_state_desc"));
        Boolean updatePaid = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderService.updatePaid(orderNo);
            this.wechatPayInfoService.updateById(wechatPayInfo);
            return Boolean.TRUE;
        });
        if (!updatePaid.booleanValue()) {
            throw new CrmebException("\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return Boolean.TRUE;
    }

    @Override
    public Boolean queryAliPayResult(String orderNo) {
        String decode;
        AliPayInfo aliPayInfo = this.aliPayInfoService.getByOutTradeNo(orderNo);
        if (ObjectUtil.isNull((Object)aliPayInfo)) {
            throw new CrmebException("\u652f\u4ed8\u5b9d\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String passbackParams = aliPayInfo.getPassbackParams();
        if (StrUtil.isBlank((CharSequence)passbackParams)) {
            throw new CrmebException("\u672a\u77e5\u7684\u652f\u4ed8\u5b9d\u8ba2\u5355\u7c7b\u578b");
        }
        try {
            decode = URLDecoder.decode(passbackParams, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            throw new CrmebException("ali pay query error : \u8ba2\u5355\u652f\u4ed8\u7c7b\u578b\u89e3\u7801\u5931\u8d25==\u300b" + orderNo);
        }
        String[] split = decode.split("=");
        String orderType = split[1];
        if ("recharge".equals(orderType)) {
            RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(orderNo);
            if (ObjectUtil.isNull((Object)rechargeOrder)) {
                throw new CrmebException(StrUtil.format((CharSequence)"ali pay query error : \u5145\u503c\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object[])new Object[]{orderNo}));
            }
            if (rechargeOrder.getPaid().booleanValue()) {
                return Boolean.TRUE;
            }
            this.aliPayQuery(orderNo);
            Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
            if (!rechargePayAfter.booleanValue()) {
                throw new CrmebException(StrUtil.format((CharSequence)("ali pay recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + orderNo), (Object[])new Object[0]));
            }
            return Boolean.TRUE;
        }
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (!order.getPayType().equals("alipay")) {
            throw new CrmebException("\u4e0d\u662f\u652f\u4ed8\u5b9d\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        this.aliPayQuery(orderNo);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean updatePaid = this.orderService.updatePaid(orderNo);
            if (!updatePaid.booleanValue()) {
                logger.warn("\u5546\u54c1\u8ba2\u5355\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0corderNo = {}", (Object)orderNo);
                e.setRollbackOnly();
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return Boolean.TRUE;
    }

    private AlipayTradeQueryResponse aliPayQuery(String orderNo) {
        String aliPayAppid = this.systemConfigService.getValueByKey(AlipayConfig.APPID);
        String aliPayPrivateKey = this.systemConfigService.getValueByKey(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY_2);
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeQueryRequest alipay_request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderNo);
        alipay_request.setBizModel((AlipayObject)model);
        logger.info("alipay_request = " + alipay_request);
        AlipayTradeQueryResponse alipay_response = null;
        try {
            alipay_response = (AlipayTradeQueryResponse)client.execute((AlipayRequest)alipay_request);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            logger.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38\uff0c" + e.getMessage());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38");
        }
        logger.info("alipay_response = ");
        if (!alipay_response.getTradeStatus().equals("TRADE_SUCCESS")) {
            logger.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38\uff0ctradeStatus = " + alipay_response.getTradeStatus());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38");
        }
        return alipay_response;
    }

    @Override
    public Boolean payAfterProcessing(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: {}", (Object)orderNo);
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        User user = (User)this.userService.getById(order.getUid());
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(orderNo);
        if (CollUtil.isEmpty(merchantOrderList)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,orderNo: {}", (Object)orderNo);
            throw new CrmebException("\u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        if (merchantOrderList.size() != 1) {
            throw new CrmebException("\u5546\u57ce\u5df2\u91cd\u5ea6\u4e8c\u6b21\u5f00\u53d1\uff0c\u6682\u4e0d\u652f\u6301\u591a\u5546\u6237\u4e00\u4e2a\u8ba2\u5355");
        }
        Boolean execute = this.oneMerchantOrderProcessing(order, merchantOrderList.get(0), user);
        if (execute.booleanValue()) {
            SystemNotification payNotification = this.systemNotificationService.getByMark("paySuccess");
            if (StrUtil.isNotBlank((CharSequence)user.getPhone()) && payNotification.getIsSms().equals(1)) {
                try {
                    this.smsService.sendPaySuccess(user.getPhone(), order.getOrderNo(), order.getPayPrice());
                }
                catch (Exception e) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
                }
            }
            this.autoSendCoupons(order);
        }
        return execute;
    }

    @Override
    public Boolean payAfterProcessingTemp(String orderNo) {
        Order platOrder = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)platOrder)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: {}", (Object)orderNo);
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        User user = (User)this.userService.getById(platOrder.getUid());
        List<Order> orderList = this.orderService.getByPlatOrderNo(platOrder.getOrderNo());
        if (CollUtil.isEmpty(orderList)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,orderNo: {}", (Object)orderNo);
            throw new CrmebException("\u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        ArrayList integralList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        ArrayList brokerageRecordList = CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        ArrayList profitSharingList = CollUtil.newArrayList((Object[])new OrderProfitSharing[0]);
        ArrayList merchantBillList = CollUtil.newArrayList((Object[])new MerchantBill[0]);
        ArrayList billList = CollUtil.newArrayList((Object[])new Bill[0]);
        ArrayList merchantOrderList = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList orderDetailList = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        for (Order order : orderList) {
            List<OrderDetail> merOrderDetailList;
            List<UserBrokerageRecord> broRecordList;
            MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
            if (order.getGainIntegral() > 0) {
                UserIntegralRecord integralRecord = this.integralRecordGainInit(user.getId(), order.getOrderNo(), order.getGainIntegral());
                integralList.add(integralRecord);
            }
            if (CollUtil.isNotEmpty(broRecordList = this.assignCommission(merchantOrder, merOrderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo())))) {
                brokerageRecordList.addAll(broRecordList);
                merchantOrderList.add(merchantOrder);
                orderDetailList.addAll(merOrderDetailList);
            }
            OrderProfitSharing orderProfitSharing = this.initOrderProfitSharing(merchantOrder);
            MerchantBill merchantBill = this.initPayMerchantBill(merchantOrder, orderProfitSharing.getProfitSharingMerPrice());
            List<Bill> platBillList = this.initPlatformBill(order, merchantOrder, orderProfitSharing);
            profitSharingList.add(orderProfitSharing);
            merchantBillList.add(merchantBill);
            billList.addAll(platBillList);
        }
        if (!user.getIsPromoter().booleanValue()) {
            String broQuota;
            String funcStatus = this.systemConfigService.getValueByKey("retail_store_switch");
            if (funcStatus.equals("1") && !(broQuota = this.systemConfigService.getValueByKey("retail_store_line")).equals("-1") && platOrder.getPayPrice().compareTo(new BigDecimal(broQuota)) >= 0) {
                user.setIsPromoter(Boolean.valueOf(true));
            }
        } else {
            user.setIsPromoter(Boolean.valueOf(false));
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                this.merchantOrderService.updateBatchById(merchantOrderList);
                this.orderDetailService.updateBatchById(orderDetailList);
                this.userBrokerageRecordService.saveBatch(brokerageRecordList);
            }
            orderList.forEach(o -> this.orderStatusService.createLog(o.getOrderNo(), "pay_split", StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u6309\u5546\u6237\u62c6\u5355\uff0c\u5386\u53f2\u5355\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{platOrder.getOrderNo()})));
            this.userService.paySuccessChange(user.getId(), user.getIsPromoter());
            if (CollUtil.isNotEmpty((Collection)integralList)) {
                this.userIntegralRecordService.saveBatch(integralList);
            }
            this.billService.saveBatch(billList);
            this.merchantBillService.saveBatch(merchantBillList);
            this.orderProfitSharingService.saveBatch(profitSharingList);
            profitSharingList.forEach(p -> this.merchantService.operationBalance(p.getMerId(), p.getProfitSharingMerPrice(), "add"));
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            SystemNotification payNotification = this.systemNotificationService.getByMark("paySuccess");
            if (StrUtil.isNotBlank((CharSequence)user.getPhone()) && payNotification.getIsSms().equals(1)) {
                try {
                    this.smsService.sendPaySuccess(user.getPhone(), platOrder.getOrderNo(), platOrder.getPayPrice());
                }
                catch (Exception e2) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e2);
                }
            }
            if (payNotification.getIsWechat().equals(1) || payNotification.getIsRoutine().equals(1)) {
                try {
                    this.pushMessageOrder(platOrder, user, payNotification);
                }
                catch (Exception e3) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25", (Throwable)e3);
                }
            }
            this.autoSendCoupons(platOrder);
        }
        return execute;
    }

    private Boolean oneMerchantOrderProcessing(Order order, MerchantOrder merchantOrder, User user) {
        ArrayList integralList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        this.presentIntegral(merchantOrder, orderDetailList, (List<UserIntegralRecord>)integralList, user, order);
        List<UserBrokerageRecord> brokerageRecordList = this.assignCommission(merchantOrder, orderDetailList);
        Order newOrder = new Order();
        BeanUtils.copyProperties((Object)order, (Object)newOrder);
        MerchantOrder newMerOrder = new MerchantOrder();
        BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerOrder);
        newOrder.setOrderNo(order.getOrderNo() + "S01");
        newOrder.setMerId(merchantOrder.getMerId());
        newOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
        newOrder.setPlatOrderNo(order.getOrderNo());
        if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
        }
        newMerOrder.setOrderNo(newOrder.getOrderNo());
        List newOrderDetailList = orderDetailList.stream().map(e -> {
            OrderDetail orderDetail = new OrderDetail();
            BeanUtils.copyProperties((Object)e, (Object)orderDetail);
            orderDetail.setId(null);
            orderDetail.setOrderNo(newOrder.getOrderNo());
            return orderDetail;
        }).collect(Collectors.toList());
        if (!user.getIsPromoter().booleanValue()) {
            String broQuota;
            String funcStatus = this.systemConfigService.getValueByKey("retail_store_switch");
            if (funcStatus.equals("1") && !(broQuota = this.systemConfigService.getValueByKey("retail_store_line")).equals("-1") && order.getPayPrice().compareTo(new BigDecimal(broQuota)) >= 0) {
                user.setIsPromoter(Boolean.valueOf(true));
                user.setPromoterTime((Date)DateUtil.date());
            }
        } else {
            user.setIsPromoter(Boolean.valueOf(false));
        }
        OrderProfitSharing orderProfitSharing = this.initOrderProfitSharing(newMerOrder);
        MerchantBill merchantBill = this.initPayMerchantBill(newMerOrder, orderProfitSharing.getProfitSharingMerPrice());
        List<Bill> billList = this.initPlatformBill(newOrder, newMerOrder, orderProfitSharing);
        BcxPlatformFee oldFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        BcxPlatformFee newFee = new BcxPlatformFee();
        BeanUtils.copyProperties((Object)oldFee, (Object)newFee);
        newFee.setId(null);
        newFee.setOrderNo(newOrder.getOrderNo());
        order.setIsDel(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.orderService.updateById(order);
            this.merchantOrderService.updateById(merchantOrder);
            if (order.getGainIntegral() > 0) {
                this.orderDetailService.updateBatchById(orderDetailList);
            }
            this.orderService.save(newOrder);
            this.merchantOrderService.save(newMerOrder);
            this.orderDetailService.saveBatch(newOrderDetailList);
            this.bcxPlatformFeeService.save(newFee);
            this.orderStatusService.createLog(order.getOrderNo(), "pay_success", "\u7528\u6237\u4ed8\u6b3e\u6210\u529f");
            this.userService.paySuccessChange(user.getId(), user.getIsPromoter());
            this.userIntegralRecordService.saveBatch(integralList);
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                brokerageRecordList.forEach(temp -> temp.setLinkNo(order.getOrderNo()));
                this.userBrokerageRecordService.saveBatch(brokerageRecordList);
            }
            this.billService.saveBatch(billList);
            this.merchantBillService.save(merchantBill);
            this.orderProfitSharingService.save(orderProfitSharing);
            this.merchantService.operationBalance(orderProfitSharing.getMerId(), orderProfitSharing.getProfitSharingMerPrice(), "add");
            return Boolean.TRUE;
        });
    }

    private Boolean manyMerchantOrderProcessing(Order order, List<MerchantOrder> merchantOrderList, User user) {
        ArrayList integralList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        if (order.getUseIntegral() > 0) {
            UserIntegralRecord integralRecordSub = this.integralRecordSubInit(order, user.getIntegral());
            integralList.add(integralRecordSub);
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        this.presentIntegral(merchantOrderList, orderDetailList, (List<UserIntegralRecord>)integralList, user, order);
        if (!user.getIsPromoter().booleanValue()) {
            String broQuota;
            String funcStatus = this.systemConfigService.getValueByKey("retail_store_switch");
            if (funcStatus.equals("1") && !(broQuota = this.systemConfigService.getValueByKey("retail_store_line")).equals("-1") && order.getPayPrice().compareTo(new BigDecimal(broQuota)) >= 0) {
                user.setIsPromoter(Boolean.valueOf(true));
                user.setPromoterTime((Date)DateUtil.date());
            }
        } else {
            user.setIsPromoter(Boolean.valueOf(false));
        }
        List<UserBrokerageRecord> brokerageRecordList = this.assignCommission(order, merchantOrderList, orderDetailList);
        ArrayList newOrderList = CollUtil.newArrayList((Object[])new Order[0]);
        ArrayList newMerchantOrderList = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList newOrderDetailList = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        ArrayList profitSharingList = CollUtil.newArrayList((Object[])new OrderProfitSharing[0]);
        ArrayList merchantBillList = CollUtil.newArrayList((Object[])new MerchantBill[0]);
        ArrayList billList = CollUtil.newArrayList((Object[])new Bill[0]);
        order.setIsDel(Boolean.valueOf(true));
        for (MerchantOrder merchantOrder : merchantOrderList) {
            Order newOrder = AsyncServiceImpl.copyNewOrder(order, merchantOrder);
            newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            newOrder.setPlatOrderNo(order.getOrderNo());
            newOrder.setIsDel(Boolean.valueOf(false));
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            }
            MerchantOrder newMerchantOrder = new MerchantOrder();
            BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerchantOrder);
            AsyncServiceImpl.constructNewOrders(orderDetailList, newOrderList, newMerchantOrderList, newOrderDetailList, merchantOrder, newOrder, newMerchantOrder);
            if (CollUtil.isNotEmpty(brokerageRecordList)) {
                for (UserBrokerageRecord record : brokerageRecordList) {
                    if (!record.getLinkNo().equals(newMerchantOrder.getMerId().toString())) continue;
                    record.setLinkNo(newOrder.getOrderNo());
                }
            }
            OrderProfitSharing orderProfitSharing = this.initOrderProfitSharing(newMerchantOrder);
            MerchantBill merchantBill = this.initPayMerchantBill(newMerchantOrder, orderProfitSharing.getProfitSharingMerPrice());
            List<Bill> platBillList = this.initPlatformBill(newOrder, newMerchantOrder, orderProfitSharing);
            profitSharingList.add(orderProfitSharing);
            merchantBillList.add(merchantBill);
            billList.addAll(platBillList);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.orderService.updateById(order);
            this.merchantOrderService.updateBatchById(merchantOrderList);
            this.orderService.saveBatch(newOrderList);
            this.merchantOrderService.saveBatch(newMerchantOrderList);
            this.orderDetailService.saveBatch(newOrderDetailList);
            this.orderStatusService.createLog(order.getOrderNo(), "pay_success", "\u7528\u6237\u4ed8\u6b3e\u6210\u529f");
            newOrderList.forEach(o -> this.orderStatusService.createLog(o.getOrderNo(), "pay_split", StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u6309\u5546\u6237\u62c6\u5355\uff0c\u5386\u53f2\u5355\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{order.getOrderNo()})));
            this.userService.paySuccessChange(user.getId(), user.getIsPromoter());
            this.userIntegralRecordService.saveBatch(integralList);
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                this.userBrokerageRecordService.saveBatch(brokerageRecordList);
            }
            this.billService.saveBatch(billList);
            this.merchantBillService.saveBatch(merchantBillList);
            this.orderProfitSharingService.saveBatch(profitSharingList);
            profitSharingList.forEach(p -> this.merchantService.operationBalance(p.getMerId(), p.getProfitSharingMerPrice(), "add"));
            return Boolean.TRUE;
        });
    }

    private void pushMessageOrder(Order order, User user, SystemNotification payNotification) {
        logger.info("\u53d1\u9001\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a" + order.getOrderNo());
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (!order.getPayType().equals("weixin") && !order.getPayType().equals("weixin2huifu")) {
            return;
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (order.getPayChannel().equals("public") && payNotification.getIsWechat().equals(1) && user.getIsWechatPublic().booleanValue()) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u901a\u77e5\uff01");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", orderDetailList.stream().map(OrderDetail::getProductName).collect(Collectors.joining(",")));
            temMap.put("keyword3", order.getPayPrice().toString());
            temMap.put("keyword4", user.getNickname());
            temMap.put("keyword5", order.getPayTime().toString());
            temMap.put("remark", "\u6b22\u8fce\u4e0b\u6b21\u518d\u6765\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (order.getPayChannel().equals("mini") && payNotification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string3", order.getOrderNo());
            temMap.put("amount9", order.getPayPrice().toString() + "\u5143");
            temMap.put("thing6", "\u60a8\u7684\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
            this.templateMessageService.pushMiniTemplateMessage(payNotification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    private List<UserBrokerageRecord> assignCommission(MerchantOrder merchantOrder, List<OrderDetail> orderDetailList) {
        if (merchantOrder.getType().equals(OrderConstants.ORDER_TYPE_SECKILL)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        String isOpen = this.systemConfigService.getValueByKey("retail_store_switch");
        if (StrUtil.isBlank((CharSequence)isOpen) || isOpen.equals("0")) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        long count = orderDetailList.stream().filter(e -> e.getSubBrokerageType() > 0).count();
        if (count <= 0L) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        User user = (User)this.userService.getById(merchantOrder.getUid());
        if (ObjectUtil.isNull((Object)user.getSpreadUid()) || user.getSpreadUid() < 1 || user.getSpreadUid().equals(merchantOrder.getUid())) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        List<MyRecord> spreadRecordList = this.getSpreadRecordList(user.getSpreadUid());
        if (CollUtil.isEmpty(spreadRecordList)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        String freezingTime = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time");
        ArrayList<UserBrokerageRecord> brokerageRecordList = new ArrayList();
        if (spreadRecordList.size() == 1) {
            BigDecimal firstBrokerage = BigDecimal.ZERO;
            for (OrderDetail orderDetail : orderDetailList) {
                if (orderDetail.getSubBrokerageType().equals(0)) continue;
                BigDecimal brokerage = orderDetail.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
                orderDetail.setFirstBrokerageFee(brokerage);
                firstBrokerage = firstBrokerage.add(brokerage);
            }
            merchantOrder.setFirstBrokerage(firstBrokerage);
            UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
            brokerageRecord.setUid(spreadRecordList.get(0).getInt("spreadUid"));
            brokerageRecord.setSubUid(merchantOrder.getUid());
            brokerageRecord.setLinkNo(merchantOrder.getOrderNo());
            brokerageRecord.setLinkType("order");
            brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
            brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
            brokerageRecord.setPrice(firstBrokerage);
            brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{firstBrokerage}));
            brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
            brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
            brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
            brokerageRecord.setBrokerageLevel(spreadRecordList.get(0).getInt("index"));
            brokerageRecordList.add(brokerageRecord);
            return brokerageRecordList;
        }
        BigDecimal firstBrokerage = BigDecimal.ZERO;
        BigDecimal secondBrokerage = BigDecimal.ZERO;
        for (OrderDetail orderDetail : orderDetailList) {
            if (orderDetail.getSubBrokerageType().equals(0)) continue;
            BigDecimal brokerage = orderDetail.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
            BigDecimal brokerageTwo = orderDetail.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail.getBrokerageTwo().toString())).divide(new BigDecimal("100"), 2, 1);
            orderDetail.setFirstBrokerageFee(brokerage);
            orderDetail.setSecondBrokerageFee(brokerageTwo);
            firstBrokerage = firstBrokerage.add(brokerage);
            secondBrokerage = secondBrokerage.add(brokerageTwo);
        }
        merchantOrder.setFirstBrokerage(firstBrokerage);
        merchantOrder.setSecondBrokerage(secondBrokerage);
        brokerageRecordList = spreadRecordList.stream().map(record -> {
            UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
            brokerageRecord.setUid(record.getInt("spreadUid"));
            brokerageRecord.setSubUid(merchantOrder.getUid());
            brokerageRecord.setLinkNo(merchantOrder.getOrderNo());
            brokerageRecord.setLinkType("order");
            brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
            brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
            BigDecimal price = record.getInt("index") == 1 ? merchantOrder.getFirstBrokerage() : merchantOrder.getSecondBrokerage();
            brokerageRecord.setPrice(price);
            brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{price}));
            brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
            brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
            brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
            brokerageRecord.setBrokerageLevel(record.getInt("index"));
            return brokerageRecord;
        }).collect(Collectors.toList());
        return brokerageRecordList;
    }

    private List<UserBrokerageRecord> assignCommission(Order order, List<MerchantOrder> merchantOrderList, List<OrderDetail> orderDetailList) {
        String isOpen = this.systemConfigService.getValueByKey("retail_store_switch");
        if (StrUtil.isBlank((CharSequence)isOpen) || isOpen.equals("0")) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        long count = orderDetailList.stream().filter(e -> e.getSubBrokerageType() > 0).count();
        if (count <= 0L) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        User user = (User)this.userService.getById(order.getUid());
        if (ObjectUtil.isNull((Object)user.getSpreadUid()) || user.getSpreadUid() < 1 || user.getSpreadUid().equals(order.getUid())) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        List<MyRecord> spreadRecordList = this.getSpreadRecordList(user.getSpreadUid());
        if (CollUtil.isEmpty(spreadRecordList)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        ArrayList<UserBrokerageRecord> brokerageRecordList = new ArrayList<UserBrokerageRecord>();
        String freezingTime = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time");
        for (MerchantOrder merchantOrder : merchantOrderList) {
            OrderDetail orderDetail2;
            BigDecimal firstBrokerage;
            if (spreadRecordList.size() == 1) {
                firstBrokerage = BigDecimal.ZERO;
                for (OrderDetail orderDetail2 : orderDetailList) {
                    if (orderDetail2.getSubBrokerageType().equals(0)) continue;
                    BigDecimal brokerage = orderDetail2.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail2.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
                    orderDetail2.setFirstBrokerageFee(brokerage);
                    firstBrokerage = firstBrokerage.add(brokerage);
                }
                merchantOrder.setFirstBrokerage(firstBrokerage);
                UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
                brokerageRecord.setLinkNo(merchantOrder.getMerId().toString());
                brokerageRecord.setUid(spreadRecordList.get(0).getInt("spreadUid"));
                brokerageRecord.setSubUid(merchantOrder.getUid());
                brokerageRecord.setLinkType("order");
                brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
                brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
                brokerageRecord.setPrice(firstBrokerage);
                brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{firstBrokerage}));
                brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
                brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
                brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
                brokerageRecord.setBrokerageLevel(spreadRecordList.get(0).getInt("index"));
                brokerageRecordList.add(brokerageRecord);
                continue;
            }
            firstBrokerage = BigDecimal.ZERO;
            BigDecimal secondBrokerage = BigDecimal.ZERO;
            orderDetail2 = orderDetailList.iterator();
            while (orderDetail2.hasNext()) {
                OrderDetail orderDetail3 = (OrderDetail)orderDetail2.next();
                if (orderDetail3.getSubBrokerageType().equals(0)) continue;
                BigDecimal brokerage = orderDetail3.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail3.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
                BigDecimal brokerageTwo = orderDetail3.getCanBrokeragePrice().multiply(new BigDecimal(orderDetail3.getBrokerageTwo().toString())).divide(new BigDecimal("100"), 2, 1);
                orderDetail3.setFirstBrokerageFee(brokerage);
                orderDetail3.setSecondBrokerageFee(brokerageTwo);
                firstBrokerage = firstBrokerage.add(brokerage);
                secondBrokerage = secondBrokerage.add(brokerageTwo);
            }
            merchantOrder.setFirstBrokerage(firstBrokerage);
            merchantOrder.setSecondBrokerage(secondBrokerage);
            List recordList = spreadRecordList.stream().map(record -> {
                UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
                brokerageRecord.setLinkNo(merchantOrder.getMerId().toString());
                brokerageRecord.setUid(record.getInt("spreadUid"));
                brokerageRecord.setSubUid(merchantOrder.getUid());
                brokerageRecord.setLinkType("order");
                brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
                brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
                BigDecimal price = record.getInt("index") == 1 ? merchantOrder.getFirstBrokerage() : merchantOrder.getSecondBrokerage();
                brokerageRecord.setPrice(price);
                brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{price}));
                brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
                brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
                brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
                brokerageRecord.setBrokerageLevel(record.getInt("index"));
                return brokerageRecord;
            }).collect(Collectors.toList());
            brokerageRecordList.addAll(recordList);
        }
        return brokerageRecordList;
    }

    private List<MyRecord> getSpreadRecordList(Integer spreadUid) {
        ArrayList recordList = CollUtil.newArrayList((Object[])new MyRecord[0]);
        User spreadUser = (User)this.userService.getById(spreadUid);
        if (ObjectUtil.isNull((Object)spreadUser) || !spreadUser.getIsPromoter().booleanValue()) {
            return recordList;
        }
        MyRecord firstRecord = new MyRecord();
        firstRecord.set("index", (Object)1);
        firstRecord.set("spreadUid", (Object)spreadUid);
        recordList.add(firstRecord);
        User spreadSpreadUser = (User)this.userService.getById(spreadUser.getSpreadUid());
        if (ObjectUtil.isNull((Object)spreadSpreadUser) || !spreadSpreadUser.getIsPromoter().booleanValue()) {
            return recordList;
        }
        MyRecord secondRecord = new MyRecord();
        secondRecord.set("index", (Object)2);
        secondRecord.set("spreadUid", (Object)spreadSpreadUser.getId());
        recordList.add(secondRecord);
        return recordList;
    }

    private void presentIntegral(MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, List<UserIntegralRecord> integralList, User user, Order order) {
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0 && new BigDecimal(integralRatioStr).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal integralBig = new BigDecimal(integralRatioStr);
            int giveIntegral = merchantOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
            merchantOrder.setGainIntegral(Integer.valueOf(giveIntegral));
            order.setGainIntegral(Integer.valueOf(giveIntegral));
            if (giveIntegral > 0) {
                UserIntegralRecord integralRecord = this.integralRecordGainInit(user.getId(), order.getOrderNo(), giveIntegral);
                integralList.add(integralRecord);
                for (int i = 0; i < orderDetailList.size(); ++i) {
                    OrderDetail orderDetail = orderDetailList.get(i);
                    if (orderDetailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merchantOrder.getPayPrice(), 10, 4);
                    int integral = new BigDecimal(Integer.toString(giveIntegral)).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(integral));
                    giveIntegral -= integral;
                }
            }
        }
    }

    private void presentIntegral(List<MerchantOrder> merchantOrderList, List<OrderDetail> orderDetailList, List<UserIntegralRecord> integralList, User user, Order order) {
        int integral = 0;
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            for (MerchantOrder merOrder : merchantOrderList) {
                BigDecimal integralBig = new BigDecimal(integralRatioStr);
                int giveIntegral = merOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
                integral += giveIntegral;
                merOrder.setGainIntegral(Integer.valueOf(giveIntegral));
                if (giveIntegral <= 0) continue;
                List detailList = orderDetailList.stream().filter(e -> e.getMerId().equals(merOrder.getMerId())).collect(Collectors.toList());
                for (int i = 0; i < detailList.size(); ++i) {
                    OrderDetail orderDetail = (OrderDetail)detailList.get(i);
                    if (detailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merOrder.getPayPrice(), 10, 4);
                    int detailIntegral = new BigDecimal(Integer.toString(giveIntegral)).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(detailIntegral));
                    giveIntegral -= detailIntegral;
                }
            }
            if (integral > 0) {
                order.setGainIntegral(Integer.valueOf(integral));
                UserIntegralRecord integralRecord = this.integralRecordGainInit(user.getId(), order.getOrderNo(), integral);
                integralList.add(integralRecord);
            }
        }
    }

    private OrderProfitSharing initOrderProfitSharing(MerchantOrder merchantOrder) {
        Merchant merchant = this.merchantService.getByIdException(merchantOrder.getMerId());
        BigDecimal orderPrice = merchantOrder.getPayPrice().add(merchantOrder.getIntegralPrice()).add(merchantOrder.getPlatCouponPrice()).subtract(merchantOrder.getPayPostage());
        BigDecimal platFee = orderPrice.multiply(new BigDecimal(merchant.getHandlingFee())).divide(new BigDecimal(100), 2, 0);
        BigDecimal merchantFee = orderPrice.subtract(platFee).subtract(merchantOrder.getFirstBrokerage()).subtract(merchantOrder.getSecondBrokerage());
        OrderProfitSharing orderProfitSharing = new OrderProfitSharing();
        orderProfitSharing.setOrderNo(merchantOrder.getOrderNo());
        orderProfitSharing.setMerId(merchantOrder.getMerId());
        orderProfitSharing.setOrderPrice(merchantOrder.getPayPrice());
        orderProfitSharing.setIntegralNum(merchantOrder.getUseIntegral());
        orderProfitSharing.setIntegralPrice(merchantOrder.getIntegralPrice());
        orderProfitSharing.setProfitSharingPlatPrice(platFee);
        orderProfitSharing.setProfitSharingMerPrice(merchantFee);
        orderProfitSharing.setFirstBrokerageFee(merchantOrder.getFirstBrokerage());
        orderProfitSharing.setSecondBrokerageFee(merchantOrder.getSecondBrokerage());
        orderProfitSharing.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
        orderProfitSharing.setFreightFee(merchantOrder.getPayPostage());
        return orderProfitSharing;
    }

    private MerchantBill initPayMerchantBill(MerchantOrder merchantOrder, BigDecimal merchantFee) {
        MerchantBill merchantBill = new MerchantBill();
        merchantBill.setMerId(merchantOrder.getMerId());
        merchantBill.setType("pay_order");
        merchantBill.setOrderNo(merchantOrder.getOrderNo());
        merchantBill.setUid(merchantOrder.getUid());
        merchantBill.setPm(BillConstants.BILL_PM_ADD);
        merchantBill.setAmount(merchantFee);
        merchantBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355{}\u652f\u4ed8{}\u5143\uff0c\u5546\u6237\u6536\u5165{}\u5143", (Object[])new Object[]{merchantOrder.getOrderNo(), merchantOrder.getPayPrice(), merchantFee}));
        return merchantBill;
    }

    private List<Bill> initPlatformBill(Order order, MerchantOrder merchantOrder, OrderProfitSharing orderProfitSharing) {
        ArrayList billList = CollUtil.newArrayList((Object[])new Bill[0]);
        Bill payBill = new Bill();
        payBill.setUid(order.getUid());
        payBill.setOrderNo(order.getOrderNo());
        payBill.setAmount(order.getPayPrice());
        if (order.getPayType().equals("yue")) {
            payBill.setPm(BillConstants.BILL_PM_SUB);
            payBill.setType("yue_pay");
            payBill.setMark(StrUtil.format((CharSequence)"\u4f59\u989d\u652f\u4ed8\u6210\u529f\uff0c\u6263\u9664\u7528\u6237\u4f59\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
        } else {
            payBill.setPm(BillConstants.BILL_PM_ADD);
            payBill.setType("pay_order");
            payBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u652f\u4ed8\u91d1\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
        }
        billList.add(payBill);
        Bill collectBill = new Bill();
        collectBill.setMerId(merchantOrder.getMerId());
        collectBill.setOrderNo(order.getOrderNo());
        collectBill.setAmount(orderProfitSharing.getProfitSharingMerPrice());
        collectBill.setPm(BillConstants.BILL_PM_SUB);
        collectBill.setType("merchant_collect");
        collectBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5546\u6237\u5206\u8d26{}\u5143", (Object[])new Object[]{orderProfitSharing.getProfitSharingMerPrice()}));
        billList.add(collectBill);
        Bill platBill = new Bill();
        platBill.setOrderNo(order.getOrderNo());
        platBill.setAmount(orderProfitSharing.getProfitSharingPlatPrice());
        platBill.setPm(BillConstants.BILL_PM_ADD);
        platBill.setType("pay_order");
        platBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5e73\u53f0\u624b\u7eed\u8d39{}\u5143", (Object[])new Object[]{orderProfitSharing.getProfitSharingPlatPrice()}));
        billList.add(platBill);
        if (ObjectUtil.isNotNull((Object)orderProfitSharing.getFirstBrokerageFee()) && orderProfitSharing.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            Bill firstBill = new Bill();
            firstBill.setOrderNo(order.getOrderNo());
            firstBill.setAmount(orderProfitSharing.getFirstBrokerageFee());
            firstBill.setPm(BillConstants.BILL_PM_SUB);
            firstBill.setType("brokerage");
            firstBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5206\u914d\u4e00\u7ea7\u4f63\u91d1{}\u5143", (Object[])new Object[]{orderProfitSharing.getFirstBrokerageFee()}));
            billList.add(firstBill);
            if (orderProfitSharing.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                Bill secondBill = new Bill();
                secondBill.setOrderNo(order.getOrderNo());
                secondBill.setAmount(orderProfitSharing.getSecondBrokerageFee());
                secondBill.setPm(BillConstants.BILL_PM_SUB);
                secondBill.setType("brokerage");
                secondBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5206\u914d\u4e8c\u7ea7\u4f63\u91d1{}\u5143", (Object[])new Object[]{orderProfitSharing.getSecondBrokerageFee()}));
                billList.add(secondBill);
            }
        }
        if (orderProfitSharing.getIntegralNum() > 0) {
            Bill integralBill = new Bill();
            integralBill.setOrderNo(order.getOrderNo());
            integralBill.setAmount(order.getIntegralPrice());
            integralBill.setPm(BillConstants.BILL_PM_SUB);
            integralBill.setType("pay_order");
            integralBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u7528\u6237\u4f7f\u7528{}\u79ef\u5206\u62b5\u6263{}\u5143\uff0c\u5e73\u53f0\u6263\u9664", (Object[])new Object[]{orderProfitSharing.getIntegralNum(), orderProfitSharing.getIntegralPrice()}));
            billList.add(integralBill);
        }
        return billList;
    }

    private UserIntegralRecord integralRecordSubInit(Order order, Integer balance) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(order.getUid());
        integralRecord.setLinkId(order.getOrderNo());
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_SUB);
        integralRecord.setTitle("\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f");
        integralRecord.setIntegral(order.getUseIntegral());
        integralRecord.setBalance(balance);
        integralRecord.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u4f7f\u7528{}\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8d2d\u4e70\u5546\u54c1", (Object[])new Object[]{order.getUseIntegral()}));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return integralRecord;
    }

    private UserIntegralRecord integralRecordGainInit(Integer uid, String orderNo, Integer gainIntegral) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(uid);
        integralRecord.setLinkId(orderNo);
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        integralRecord.setTitle("\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f");
        integralRecord.setIntegral(gainIntegral);
        integralRecord.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u5956\u52b1{}\u79ef\u5206", (Object[])new Object[]{gainIntegral}));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE);
        String freezeTime = this.systemConfigService.getValueByKey("freeze_integral_day");
        integralRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezeTime).orElse("0")));
        integralRecord.setCreateTime(CrmebDateUtil.nowDateTime());
        return integralRecord;
    }

    private Map<String, String> getWechatQueryPayVo(String outTradeNo, String payChannel) {
        String appId = "";
        String mchId = "";
        String signKey = "";
        switch (payChannel) {
            case "public": 
            case "h5": {
                appId = this.systemConfigService.getValueByKeyException("wechat_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_key");
                break;
            }
            case "mini": {
                appId = this.systemConfigService.getValueByKeyException("routine_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_routine_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_routine_key");
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                appId = this.systemConfigService.getValueByKeyException("wechat_app_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_app_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_app_key");
            }
        }
        HashMap map = CollUtil.newHashMap();
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("out_trade_no", outTradeNo);
        map.put("nonce_str", WxPayUtil.getNonceStr());
        map.put("sign_type", "MD5");
        map.put("sign", WxPayUtil.getSign((Map)map, (String)signKey));
        return map;
    }

    private String aliPayment(Order order) {
        return this.aliPayService.pay(order.getOrderNo(), order.getPayPrice(), "order", order.getPayChannel());
    }

    private WxPayJsResultVo wechatPayment(Order order) {
        Map<String, String> unifiedorder = this.unifiedorder(order);
        WxPayJsResultVo vo = new WxPayJsResultVo();
        vo.setAppId(unifiedorder.get("appId"));
        vo.setNonceStr(unifiedorder.get("nonceStr"));
        vo.setPackages(unifiedorder.get("package"));
        vo.setSignType(unifiedorder.get("signType"));
        vo.setTimeStamp(unifiedorder.get("timeStamp"));
        vo.setPaySign(unifiedorder.get("paySign"));
        if (order.getPayChannel().equals("h5")) {
            vo.setMwebUrl(unifiedorder.get("mweb_url"));
        }
        if (order.getPayChannel().equals("wechatIos") || order.getPayChannel().equals("wechatAndroid")) {
            vo.setPartnerid(unifiedorder.get("partnerid"));
        }
        order.setOutTradeNo(unifiedorder.get("outTradeNo"));
        return vo;
    }

    private Boolean zeroPay(Order order, User user) {
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = Boolean.TRUE;
            order.setPaid(Boolean.valueOf(true));
            order.setPayType("zero");
            order.setPayTime((Date)DateUtil.date());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            this.orderService.updateById(order);
            UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
            userBalanceRecord.setUid(user.getId());
            userBalanceRecord.setLinkId(order.getOrderNo());
            userBalanceRecord.setLinkType("order");
            userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
            userBalanceRecord.setAmount(BigDecimal.ZERO);
            userBalanceRecord.setBalance(user.getNowMoney());
            userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f,\u6263\u4f59\u989d{}\u5143", (Object[])new Object[]{BigDecimal.ZERO}));
            this.userBalanceRecordService.save(userBalanceRecord);
            return update;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("0\u5143\u652f\u4ed8\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return true;
    }

    private Boolean yuePay(Order order, User user) {
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = Boolean.TRUE;
            order.setPaid(Boolean.valueOf(true));
            order.setPayTime((Date)DateUtil.date());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            this.orderService.updateById(order);
            if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
                update = this.userService.updateNowMoney(order.getUid(), order.getPayPrice(), "sub");
                if (!update.booleanValue()) {
                    logger.error("\u4f59\u989d\u652f\u4ed8\uff0c\u6263\u9664\u7528\u6237\u4f59\u989d\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                    e.setRollbackOnly();
                    return update;
                }
                UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
                userBalanceRecord.setUid(user.getId());
                userBalanceRecord.setLinkId(order.getOrderNo());
                userBalanceRecord.setLinkType("order");
                userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
                userBalanceRecord.setAmount(order.getPayPrice());
                userBalanceRecord.setBalance(user.getNowMoney().subtract(order.getPayPrice()));
                userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f,\u6263\u4f59\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
                this.userBalanceRecordService.save(userBalanceRecord);
            }
            return update;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u4f59\u989d\u652f\u4ed8\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return true;
    }

    @Override
    public void setOrderPaySuccess(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order) || ObjectUtil.isNull(orderDetails) || orderDetails.size() < 1) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException("\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (order.getPaid().booleanValue()) {
            return;
        }
        logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csetOrderPaySuccess=1");
        OrderDetail orderDetail = orderDetails.get(0);
        Boolean updatePaid = (Boolean)this.transactionTemplate.execute(e -> {
            order.setPayType("weixin2huifu");
            order.setPayChannel("mini");
            this.orderService.updateById(order);
            this.orderService.updatePaid(orderNo);
            return Boolean.TRUE;
        });
        if (!updatePaid.booleanValue()) {
            throw new CrmebException("\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        if (order.getBizType().equals(ProductConstants.BIZ_TYPE_RISK)) {
            logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csetOrderPaySuccess=2");
            this.syncReportOrder2RiskSystem(order, orderDetail);
        }
        logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csetOrderPaySuccess=3");
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
    }

    private void syncReportOrder2RiskSystem(Order order, OrderDetail orderDetail) {
        ProductAttrValue sku = (ProductAttrValue)this.productAttrValueService.getById(orderDetail.getAttrValueId());
        try {
            String productCode;
            boolean isPlatOrderNo = StrUtil.isBlank((CharSequence)order.getPlatOrderNo());
            String relateOrderNo = isPlatOrderNo ? order.getOrderNo() : order.getPlatOrderNo();
            BcxOrderRelation relation = (BcxOrderRelation)((QueryChainWrapper)this.bcxOrderRelationService.query().eq((Object)"order_no", (Object)relateOrderNo)).one();
            if (relation == null) {
                logger.error("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf\u5931\u8d25\uff1a\u8ba2\u5355\u4e3b\u526f\u4e1a\u52a1\u5173\u7cfb\u8868\u65e0\u8bb0\u5f55\uff08\u4e00\u822c\u60c5\u51b5\u8ba2\u5355\u7684\u521b\u5efa\u4e3b\u526f\u8868\u5fc5\u5b9a\u76f8\u5e94\u521b\u5efa\u4e00\u6761\u8bb0\u5f55\uff09");
                return;
            }
            String string = productCode = StringUtils.isNotEmpty((CharSequence)sku.getBarCode()) ? sku.getBarCode() : "";
            if (StringUtils.isEmpty((CharSequence)productCode)) {
                logger.error("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf\u5931\u8d25\uff1a\u672a\u914d\u7f6e\u5546\u54c1\u6761\u7801");
                return;
            }
            Merchant merchant = this.merchantService.getByIdException(order.getMerId());
            String orderNo = relation.getMasterOrderNo();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("activityNo", orderNo);
            body.put("costId", orderDetail.getSourceId());
            body.put("amount", orderDetail.getPayPrice());
            body.put("orderNo", order.getOrderNo());
            body.put("productName", orderDetail.getProductName());
            body.put("productCode", productCode.substring(productCode.length() - 3, productCode.length()));
            body.put("serverOrg", merchant.getName());
            body.put("skuId", orderDetail.getAttrValueId());
            String url = "";
            if (sku.getBarCode().toUpperCase().startsWith("ESTAND-BG-")) {
                url = this.systemConfigService.getRiskSystemUrl() + "/wechat/wechat-enter-activity-info";
            } else if (sku.getBarCode().toUpperCase().startsWith("ESTAND-TK-")) {
                url = this.systemConfigService.getRiskSystemUrl() + "/wechat/buySurveyLevel";
            } else if (sku.getBarCode().toUpperCase().startsWith("ESTAND-ZJ-")) {
                url = this.systemConfigService.getRiskSystemUrl() + "/wechat/buyExpertType";
            } else {
                logger.error("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf\u5931\u8d25\uff1a\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5730\u5740");
                return;
            }
            logger.info("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf,url\uff1a" + url);
            logger.info("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf,body\uff1a" + JSON.toJSONString(body));
            JSONObject result = this.restTemplateUtil.postJson(url, new JSONObject(body), ERiskUtil.getHeader());
            logger.info(result.toJSONString());
            if (!result.getBoolean("success").booleanValue()) {
                logger.error("=============\u98ce\u8bc4\u8ba2\u5355\u63a8\u9001\u5230\u98ce\u8bc4\u7cfb\u7edf\u6d3b\u52a8\u521b\u5efa\u5931\u8d25\uff1a" + result.getString("message") + ",orderNo:" + order.getOrderNo());
                return;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        try {
            if (sku.getBarCode().toUpperCase().startsWith("ESTAND-BG-")) {
                User user = (User)this.userService.getById(order.getUid());
                if (StrUtil.isNotBlank((CharSequence)user.getPhone())) {
                    this.smsService.sendMessage(user.getPhone(), "\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u5df2\u6210\u529f\u8d2d\u4e70\u3010\u98ce\u8bc4\u62a5\u544a\u3011\u5546\u54c1\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u3010" + this.systemConfigService.getRiskSystemUrl() + "\u3011\u5b8c\u6210\u7533\u62a5\u6750\u6599\u7684\u63d0\u4ea4\u3002");
                } else {
                    logger.error("\u627e\u4e0d\u5230\u7528\u6237\u624b\u673a\u53f7\uff0c\u53d6\u6d88\u53d1\u9001\u77ed\u4fe1");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private Boolean walletFreezeAndPay(Order order, OrderDetail orderDetail, Integer bizType, User user, Merchant merchant) {
        BcxPlatformFee platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        String productDesc = orderDetail.getProductName() + "(" + orderDetail.getSku() + ") * " + orderDetail.getPayNum();
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update;
            block9: {
                update = Boolean.TRUE;
                order.setPaid(Boolean.valueOf(true));
                order.setBizType(bizType);
                order.setPayTime((Date)DateUtil.date());
                if (order.getStatus().intValue() == OrderConstants.ORDER_STATUS_WAIT_PAY.intValue()) {
                    order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                }
                this.orderService.updateById(order);
                if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
                    HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
                    transferDto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(orderDetail.getProductName()).setGoodsUnit(orderDetail.getSku()).setGoodsNumber(String.valueOf(orderDetail.getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee() != null ? platFee.getPlatFee().toPlainString() : "0");
                    try {
                        if (bizType == 1) {
                            transferDto.setTradeType("03");
                            if ("offline".equalsIgnoreCase(order.getPayType())) {
                                this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).offlinePayPlatTransfer(transferDto);
                            } else {
                                this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountTransfer(transferDto);
                            }
                            break block9;
                        }
                        transferDto.setTradeType("04");
                        if ("offline".equalsIgnoreCase(order.getPayType())) {
                            this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).offlinePayPlatTransfer(transferDto);
                            break block9;
                        }
                        this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountTransfer(transferDto);
                    }
                    catch (Exception exception) {
                        logger.error(exception.getMessage());
                        logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u51bb\u7ed3\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                        e.setRollbackOnly();
                        update = false;
                    }
                } else {
                    logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
                }
            }
            return update;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u51bb\u7ed3\u5931\u8d25");
        }
        if (!"offline".equalsIgnoreCase(order.getPayType())) {
            this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        }
        return true;
    }

    @Override
    public Boolean specialOrderUnfreezeAndPay(String orderNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Order::getOrderNo, (Object)orderNo);
        Order order = (Order)this.orderService.getOne((Wrapper)lqw);
        if (order == null || order.getMerId() < 1) {
            throw new CrmebException("\u6ca1\u6709\u8be5\u8ba2\u5355\u6216\u8ba2\u5355\u5546\u6237\u6570\u636e\u5f02\u5e38");
        }
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(order.getOrderNo());
        OrderDetail orderDetail = orderDetails.get(0);
        String productDesc = orderDetail.getProductName() + "(" + orderDetail.getSku() + ") * " + orderDetail.getPayNum() + "\u786e\u8ba4";
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        if (StrUtil.isBlank((CharSequence)merchant.getIdentityNo())) {
            throw new CrmebException("\u5546\u6237\u672a\u5f00\u901a\u6c47\u4ed8\u94b1\u5305:" + merchant.getId() + ":" + merchant.getName());
        }
        BcxPlatformFee platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        User user = (User)this.userService.getById(order.getUid());
        if (StrUtil.isBlank((CharSequence)user.getIdentityNo())) {
            throw new CrmebException("\u7528\u6237\u672a\u5f00\u901a\u6c47\u4ed8\u94b1\u5305:" + user.getId() + ":" + user.getRealName());
        }
        BigDecimal total = order.getPayPrice();
        if (total.compareTo(BigDecimal.ZERO) > 0) {
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(total.toPlainString()).setBusinessCode(String.valueOf(order.getBizType())).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(orderDetail.getProductName()).setGoodsUnit(orderDetail.getSku()).setGoodsNumber(String.valueOf(orderDetail.getPayNum())).setSellFeePriority(platFee.getTransPriority()).setInId(merchant.getIdentityNo()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee().toPlainString());
            try {
                transferDto.setTradeType("05");
                this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountLock(transferDto);
            }
            catch (Exception exception) {
                logger.error("\u8003\u57f9\u8ba2\u5355\u89e3\u51bb\u652f\u4ed8\u5931\u8d25seqNo = " + orderNo + exception.getMessage());
                throw new CrmebException("\u8003\u57f9\u8ba2\u5355\u89e3\u51bb\u652f\u4ed8\u5931\u8d25seqNo = " + orderNo + exception.getMessage());
            }
        } else {
            logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
        }
        return true;
    }

    @Override
    public Boolean walletUnfreezeAndPay(Order order, List<OrderDetail> orderDetails, Integer bizType, User user, Merchant merchant) {
        BcxPlatformFee platFee;
        if (orderDetails.isEmpty()) {
            throw new CrmebException("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a,\u65e0\u6cd5\u652f\u4ed8,\u8bf7\u8054\u7cfb\u7ba1\u7406\u9875");
        }
        String productDesc = orderDetails.stream().map(d -> d.getProductName() + "(" + d.getSku() + ") * " + d.getPayNum()).collect(Collectors.joining(";"));
        Boolean execute = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$walletUnfreezeAndPay$21(order, bizType, productDesc, orderDetails, merchant, platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0), user, arg_0));
        if (Boolean.FALSE.equals(execute)) {
            throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u89e3\u51bb\u652f\u4ed8\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean platWalletUnfreezeAndPay(Order order, List<OrderDetail> orderDetails, Integer bizType, User user, Merchant merchant) {
        BcxPlatformFee platFee;
        if (orderDetails.isEmpty()) {
            throw new CrmebException("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a,\u65e0\u6cd5\u652f\u4ed8,\u8bf7\u8054\u7cfb\u7ba1\u7406\u9875");
        }
        String productDesc = orderDetails.stream().map(d -> d.getProductName() + "(" + d.getSku() + ") * " + d.getPayNum()).collect(Collectors.joining(";"));
        Boolean execute = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$platWalletUnfreezeAndPay$23(order, bizType, productDesc, orderDetails, merchant, platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0), user, arg_0));
        if (Boolean.FALSE.equals(execute)) {
            throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u89e3\u51bb\u652f\u4ed8\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean walletUnfreeze(Order order, List<OrderDetail> orderDetails, Integer bizType, User user, Merchant merchant) {
        BcxPlatformFee platFee;
        if (orderDetails.isEmpty()) {
            throw new CrmebException("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a,\u65e0\u6cd5\u652f\u4ed8,\u8bf7\u8054\u7cfb\u7ba1\u7406\u9875");
        }
        String productDesc = orderDetails.stream().map(d -> d.getProductName() + "(" + d.getSku() + ") * " + d.getPayNum()).collect(Collectors.joining(";"));
        Boolean execute = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$walletUnfreeze$25(order, bizType, productDesc, orderDetails, merchant, platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0), user, arg_0));
        if (Boolean.FALSE.equals(execute)) {
            throw new CrmebException("\u4f01\u4e1a\u94b1\u5305\u89e3\u51bb\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean wechat2HuifuRefund(Order order) {
        BcxPlatformFee platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            boolean update;
            block5: {
                update = true;
                if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
                    JsPayTransferDto refundDto = new JsPayTransferDto();
                    refundDto.setOldBusinessPartnerSeq(order.getPlatOrderNo());
                    refundDto.setBusinessPartnerSeq(order.getPlatOrderNo());
                    refundDto.setBusinessCode(String.valueOf(order.getBizType()));
                    refundDto.setAmount(String.valueOf(order.getPayPrice()));
                    refundDto.setComment("\u98ce\u8bc4\u5546\u54c1\u5fae\u4fe1\u9000\u6b3e");
                    refundDto.setSellFeePriority(platFee.getTransPriority());
                    refundDto.setPlatAmount(platFee.getPlatFee().toPlainString());
                    try {
                        if (order.getBizType().equals(4)) {
                            refundDto.setTradeType("05");
                            this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuJspayRefund(refundDto);
                            break block5;
                        }
                        logger.error("\u53ea\u6709\u98ce\u8bc4\u5546\u54c1\u624d\u8d70\u8be5\u5fae\u4fe1\u9000\u6b3e\u6d41\u7a0b-orderNo:" + order.getOrderNo());
                        update = false;
                    }
                    catch (Exception exception) {
                        logger.error(exception.getMessage());
                        logger.error("\u98ce\u8bc4\u5546\u54c1 \u5fae\u4fe1\u9000\u6b3e \u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                        e.setRollbackOnly();
                        update = false;
                    }
                } else {
                    logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u5546\u57ce\u4e0d\u8d70\u9000\u6b3e\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
                }
            }
            return update;
        });
        if (Boolean.FALSE.equals(execute)) {
            throw new CrmebException("\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return true;
    }

    private Map<String, String> unifiedorder(Order order) {
        UserToken userToken = new UserToken();
        userToken.setToken("");
        if (order.getPayChannel().equals("public")) {
            userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_WECHAT);
        }
        if (order.getPayChannel().equals("mini") || order.getPayChannel().equals("video")) {
            userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
        }
        String appId = "";
        String mchId = "";
        String signKey = "";
        switch (order.getPayChannel()) {
            case "public": 
            case "h5": {
                appId = this.systemConfigService.getValueByKeyException("wechat_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_key");
                break;
            }
            case "mini": 
            case "video": {
                appId = this.systemConfigService.getValueByKeyException("routine_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_routine_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_routine_key");
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                appId = this.systemConfigService.getValueByKeyException("wechat_app_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_app_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_app_key");
            }
        }
        CreateOrderRequestVo unifiedorderVo = this.getUnifiedorderVo(order, userToken.getToken(), appId, mchId, signKey);
        CreateOrderResponseVo responseVo = this.wechatService.payUnifiedorder(unifiedorderVo);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", unifiedorderVo.getAppid());
        map.put("nonceStr", unifiedorderVo.getAppid());
        map.put("package", "prepay_id=".concat(responseVo.getPrepayId()));
        map.put("signType", unifiedorderVo.getSign_type());
        Long currentTimestamp = WxPayUtil.getCurrentTimestamp();
        map.put("timeStamp", Long.toString(currentTimestamp));
        String paySign = WxPayUtil.getSign(map, (String)signKey);
        map.put("paySign", paySign);
        map.put("prepayId", responseVo.getPrepayId());
        map.put("prepayTime", CrmebDateUtil.nowDateTimeStr());
        map.put("outTradeNo", unifiedorderVo.getOut_trade_no());
        if (order.getPayChannel().equals("h5")) {
            map.put("mweb_url", responseVo.getMWebUrl());
        }
        if (order.getPayChannel().equals("wechatIos") || order.getPayChannel().equals("wechatAndroid")) {
            map.put("partnerid", mchId);
            map.put("package", responseVo.getPrepayId());
            HashMap<String, Object> appMap = new HashMap<String, Object>();
            appMap.put("appid", unifiedorderVo.getAppid());
            appMap.put("partnerid", mchId);
            appMap.put("prepayid", responseVo.getPrepayId());
            appMap.put("package", "Sign=WXPay");
            appMap.put("noncestr", unifiedorderVo.getAppid());
            appMap.put("timestamp", currentTimestamp);
            logger.info("================================================app\u652f\u4ed8\u7b7e\u540d\uff0cmap = " + appMap);
            String sign = WxPayUtil.getSignObject(appMap, (String)signKey);
            logger.info("================================================app\u652f\u4ed8\u7b7e\u540d\uff0csign = " + sign);
            map.put("paySign", sign);
        }
        return map;
    }

    private CreateOrderRequestVo getUnifiedorderVo(Order order, String openid, String appId, String mchId, String signKey) {
        String domain = this.systemConfigService.getValueByKeyException("site_url");
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        AttachVo attachVo = new AttachVo("order", order.getUid());
        CreateOrderRequestVo vo = new CreateOrderRequestVo();
        vo.setAppid(appId);
        vo.setMch_id(mchId);
        vo.setNonce_str(WxPayUtil.getNonceStr());
        vo.setSign_type("MD5");
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        vo.setBody(siteName);
        vo.setAttach(JSONObject.toJSONString((Object)attachVo));
        vo.setOut_trade_no(CrmebUtil.getOrderNo((String)"WX"));
        vo.setTotal_fee(order.getPayPrice().multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue());
        vo.setSpbill_create_ip(RequestUtil.getClientIp());
        vo.setNotify_url(apiDomain + "/api/publicly/payment/callback/wechat");
        switch (order.getPayChannel()) {
            case "h5": {
                vo.setTrade_type("MWEB");
                vo.setOpenid(null);
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                vo.setTrade_type("APP");
                vo.setOpenid(null);
                break;
            }
            default: {
                vo.setTrade_type("JSAPI");
                vo.setOpenid(openid);
            }
        }
        CreateOrderH5SceneInfoVo createOrderH5SceneInfoVo = new CreateOrderH5SceneInfoVo(new CreateOrderH5SceneInfoDetailVo(domain, this.systemConfigService.getValueByKeyException("site_name")));
        vo.setScene_info(JSONObject.toJSONString((Object)createOrderH5SceneInfoVo));
        String sign = WxPayUtil.getSign((CreateOrderRequestVo)vo, (String)signKey);
        vo.setSign(sign);
        return vo;
    }

    private void autoSendCoupons(Order order) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (CollUtil.isEmpty(orderDetailList)) {
            return;
        }
        ArrayList couponUserList = CollUtil.newArrayList((Object[])new CouponUser[0]);
        HashMap couponMap = CollUtil.newHashMap();
        List proIdList = orderDetailList.stream().map(OrderDetail::getProductId).distinct().collect(Collectors.toList());
        for (Integer proId : proIdList) {
            List<ProductCoupon> couponsForGiveUser = this.productCouponService.getListByProductId(proId);
            int i = 0;
            while (i < couponsForGiveUser.size()) {
                ProductCoupon productCoupon = couponsForGiveUser.get(i);
                MyRecord record = this.couponUserService.paySuccessGiveAway(productCoupon.getCouponId(), order.getUid());
                if (record.getStr("status").equals("fail")) {
                    logger.error(StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object[])new Object[]{record.getStr("errMsg")}));
                    couponsForGiveUser.remove(i);
                    continue;
                }
                CouponUser couponUser = (CouponUser)record.get("couponUser");
                couponUserList.add(couponUser);
                couponMap.put(couponUser.getCouponId(), record.getBoolean("isLimited"));
                ++i;
            }
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (CollUtil.isNotEmpty((Collection)couponUserList)) {
                this.couponUserService.saveBatch(couponUserList);
                couponUserList.forEach(i -> this.couponService.deduction(i.getCouponId(), 1, (Boolean)couponMap.get(i.getCouponId())));
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u9886\u53d6\u4f18\u60e0\u5238\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }

    @Override
    public boolean checkPayResult(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return order.getPaid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuJspayCallback(String messageBody) {
        Map<String, Object> response = this.pathToJson(messageBody);
        logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u53c2\u6570\uff0cresponse={}", (Object)response.toString());
        this.transactionLogService.save("huifuJspayCallback", "1", response.toString(), "ok", PaymentChannel.HUIFU.toString());
        if (!"00000000".equals(response.get("resp_code").toString())) {
            return "ok";
        }
        String sign = response.get("sign").toString();
        if (!RsaUtils.verify((String)response.get("resp_data").toString(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAj9mFzw0amiMHrM9B/V2l/RUqljsLwEAANZO4CiGVxeaZodOOFYT4Rve9zwHAqj37HCBcI/hs0lJeVZSO/EKjy+hmqKlHgXhv/mnyP7z4JgOHqQiR5Lr5xUdPjIRhuHzJOUsfdyBbGcfuaUNqh0Y64zKqCFylw0PSgRQ34IqebYW4K3fgNRSJ1ijWt9IsN4YaLVGnB7ISuiUx5OcMitcjsUK58JXecKFfQfxSx7btS+W+f8G70jnEPdAvJRP+2CrjJeiveJjy3K6h8SxPY5lcCfNYCzf9iytODoF7MDsGOmMjHVm8D84etI6MyP0zG1p/oSujf+2P9fxnZO30eev9BQIDAQAB", (String)sign)) {
            logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        JSONObject dataObj = JSON.parseObject((String)response.get("resp_data").toString());
        String subRespCode = dataObj.getString("sub_resp_code");
        String reqSeqId = dataObj.getString("req_seq_id");
        String bankMessage = dataObj.getString("bank_message");
        String tradeStatus = Constants.tradeStatus((String)dataObj.get((Object)"trans_stat").toString());
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                String string;
                Boolean execute;
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                JsPayTrade jsPayTrade = this.jsPayTradeDao.getJsPayTradeByHfSeqId(dataObj.get((Object)"hf_seq_id").toString());
                if (jsPayTrade == null) {
                    logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u4ea4\u6613\u4e0d\u5b58\u5728");
                    String string2 = "RECV_ORD_ID_" + reqSeqId;
                    return string2;
                }
                if ("1".equals(jsPayTrade.getTradeStatus())) {
                    logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc1={}", (Object)reqSeqId);
                    String string3 = "RECV_ORD_ID_" + reqSeqId;
                    return string3;
                }
                if ("00000000".equals(subRespCode) && "1".equals(tradeStatus)) {
                    BcxPlatformFee platFee = this.bcxPlatformFeeService.queryByOrderNo(jsPayTrade.getBusinessPartnerSeq(), 0);
                    this.setOrderPaySuccess(jsPayTrade.getBusinessPartnerSeq());
                    this.transferToPlatBody(jsPayTrade, platFee);
                    String platAmount = platFee.getPlatFee() != null ? platFee.getPlatFee().toPlainString() : "0";
                    String lockAmount = decimalFormat.format(jsPayTrade.getAmount().subtract(new BigDecimal(platAmount)));
                    if (platFee.getTransPriority() == 0) {
                        lockAmount = decimalFormat.format(new BigDecimal(platAmount));
                    }
                    lockAmount = decimalFormat.format(new BigDecimal(lockAmount).subtract(jsPayTrade.getCommissionAmount()));
                    try {
                        HuifuWalletService service = this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService());
                        service.syncUpdateSumFrozenAmount(jsPayTrade.getInUniId(), "04".equals(jsPayTrade.getTradeType()) ? new BigDecimal(lockAmount) : ("05".equals(jsPayTrade.getTradeType()) ? new BigDecimal("-" + lockAmount) : BigDecimal.ZERO));
                    }
                    catch (CrmebWalletException e2) {
                        String string4 = "RECV_ORD_ID_" + reqSeqId;
                        if (lock.isHeldByCurrentThread()) {
                            logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                            lock.unlock();
                        }
                        return string4;
                    }
                }
                if (!(execute = (Boolean)this.transactionTemplate.execute(e -> {
                    Date date;
                    String lTime = dataObj.getString("trans_date") + dataObj.getString("trans_time");
                    try {
                        date = new SimpleDateFormat("yyyyMMddHHmmss").parse(lTime);
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                    jsPayTrade.setTransFinishTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
                    jsPayTrade.setErrorMsg(dataObj.getString("bank_message") + ";" + dataObj.getString("resp_desc"));
                    jsPayTrade.setTradeStatus(tradeStatus);
                    jsPayTrade.setUpdateTime(new Date());
                    this.jsPayTradeDao.updateJsPayTrade(jsPayTrade);
                    logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)jsPayTrade.getErrorMsg());
                    return Boolean.TRUE;
                })).booleanValue()) {
                    logger.error("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    string = "";
                    return string;
                }
                string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String jsPayTrade = "";
            return jsPayTrade;
        }
        catch (InterruptedException e3) {
            logger.error("huifuJspayCallback error", (Throwable)e3);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    private void transferToPlatBody(JsPayTrade jsPayTrade, BcxPlatformFee platFee) {
        HuifuWalletAccountDto platAccount;
        logger.info(">>>>>>>>> C\u7aef\u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1\u5904\u7406transferToPlatBody\uff1a\u4e1a\u52a1\u5f00\u59cb");
        Order order = this.orderService.getByOrderNo(jsPayTrade.getBusinessPartnerSeq());
        Integer merId = order.getMerId();
        Merchant merchant = this.merchantService.getByIdException(merId);
        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(order.getOrderNo());
        List<Integer> productIds = orderDetails.stream().map(OrderDetail::getProductId).collect(Collectors.toList());
        Integer bizType = this.orderService.getBizTypeByProductsType(productIds);
        OrderDetail orderDetail = orderDetails.get(0);
        String productDesc = orderDetail.getProductName() + "(" + orderDetail.getSku() + ") * " + orderDetail.getPayNum();
        HuifuWalletTransferDto dto = new HuifuWalletTransferDto();
        dto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(orderDetail.getProductName()).setGoodsUnit(orderDetail.getSku()).setGoodsNumber(String.valueOf(orderDetail.getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(jsPayTrade.getUniId()).setPlatAmount(platFee.getPlatFee() != null ? platFee.getPlatFee().toPlainString() : "0");
        if (platFee.getTransPriority() == 0) {
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.HUIFU.toString());
        } else {
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo("6666000137445326");
        }
        if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
            HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)dto, (Object)dtoP);
            dtoP.setAmount(dto.getPlatAmount());
            dtoP.setOutId(jsPayTrade.getInUniId());
            dtoP.setInId(platAccount.getUniId());
            String comment = platFee.getTransPriority() == 0 ? "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5546\u54c1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143" : "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143";
            dtoP.setComment(comment);
            dtoP.setBusinessPartnerSeq(dtoP.getBusinessPartnerSeq() + "-P" + platFee.getTransPriority());
            dtoP.setTradeType(jsPayTrade.getTradeType());
            logger.info(">>>>>>>>> C\u7aef\u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1\u5904\u7406transferToPlatBody\uff1a\u8bf7\u6c42\u62a5\u6587\uff1a" + JSON.toJSONString((Object)dtoP));
            try {
                HuifuWalletService service = this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService());
                service.syncTransferToPlat(dtoP);
            }
            catch (CrmebWalletException e) {
                throw new RuntimeException(e);
            }
            logger.info(">>>>>>>>> C\u7aef\u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1\u5904\u7406transferToPlatBody\uff1a\u4efb\u52a1\u521b\u5efa\u6210\u529f");
        }
        logger.info(">>>>>>>>> C\u7aef\u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1\u5904\u7406transferToPlatBody\uff1a\u65e0\u5206\u8d26\u4e1a\u52a1\u9700\u6c42\uff0c\u4e1a\u52a1\u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuJspayRefundCallback(String messageBody) {
        Map<String, Object> response = this.pathToJson(messageBody);
        logger.info("C\u7aef\u9000\u6b3e\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u53c2\u6570\uff0cresponse={}", (Object)response.toString());
        this.transactionLogService.save("huifuJspayRefundCallback", "1", response.toString(), "ok", PaymentChannel.HUIFU.toString());
        if (!"00000000".equals(response.get("resp_code").toString())) {
            return "ok";
        }
        String sign = response.get("sign").toString();
        if (!RsaUtils.verify((String)response.get("resp_data").toString(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAj9mFzw0amiMHrM9B/V2l/RUqljsLwEAANZO4CiGVxeaZodOOFYT4Rve9zwHAqj37HCBcI/hs0lJeVZSO/EKjy+hmqKlHgXhv/mnyP7z4JgOHqQiR5Lr5xUdPjIRhuHzJOUsfdyBbGcfuaUNqh0Y64zKqCFylw0PSgRQ34IqebYW4K3fgNRSJ1ijWt9IsN4YaLVGnB7ISuiUx5OcMitcjsUK58JXecKFfQfxSx7btS+W+f8G70jnEPdAvJRP+2CrjJeiveJjy3K6h8SxPY5lcCfNYCzf9iytODoF7MDsGOmMjHVm8D84etI6MyP0zG1p/oSujf+2P9fxnZO30eev9BQIDAQAB", (String)sign)) {
            logger.info("C\u7aef\u9000\u6b3e\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        JSONObject dataObj = JSON.parseObject((String)response.get("resp_data").toString());
        String subRespCode = dataObj.getString("sub_resp_code");
        String reqSeqId = dataObj.getString("req_seq_id");
        String bankMessage = dataObj.getString("bank_message");
        String tradeStatus = Constants.tradeStatus((String)dataObj.get((Object)"trans_stat").toString());
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                JsPayTrade jsPayTrade = this.jsPayTradeDao.getJsPayTradeByHfSeqId(dataObj.get((Object)"hf_seq_id").toString());
                if ((!"00000000".equals(subRespCode) || "2".equals(tradeStatus)) && jsPayTrade == null) {
                    logger.info("C\u7aef\u652f\u4ed8\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=" + bankMessage);
                    String string = "ok";
                    return string;
                }
                if ("1".equals(jsPayTrade.getTradeStatus())) {
                    logger.info("C\u7aef\u9000\u6b3e\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc1={}", (Object)reqSeqId);
                    String string = "RECV_ORD_ID_" + reqSeqId;
                    return string;
                }
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    Date date;
                    String lTime = dataObj.getString("trans_finish_time");
                    try {
                        date = new SimpleDateFormat("yyyyMMddHHmmss").parse(lTime);
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                    jsPayTrade.setTransFinishTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
                    jsPayTrade.setErrorMsg(dataObj.getString("resp_desc"));
                    jsPayTrade.setTradeStatus(tradeStatus);
                    jsPayTrade.setUpdateTime(new Date());
                    this.jsPayTradeDao.updateJsPayTrade(jsPayTrade);
                    logger.info("C\u7aef\u9000\u6b3e\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)jsPayTrade.getErrorMsg());
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("C\u7aef\u9000\u6b3e\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    String string = "";
                    return string;
                }
                String string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String jsPayTrade = "";
            return jsPayTrade;
        }
        catch (InterruptedException e2) {
            logger.error("huifuJspayRefundCallback error", (Throwable)e2);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    private Map<String, Object> pathToJson(String urlData) {
        String data = null;
        try {
            data = URLDecoder.decode(urlData, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u89e3\u7801\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        Map collect = Arrays.stream(data.split("&")).map(str -> str.split("=")).collect(Collectors.toMap(x -> x[0], x -> ((String[])x).length == 2 ? x[1] : "", (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return collect;
    }

    @Override
    public String getMerchantIdentifyNoByOrderNo(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (order == null || order.getMerId() == null) {
            throw new CrmebException("\u6ca1\u6709\u8be5\u8ba2\u5355\uff1a" + orderNo);
        }
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        if (merchant == null || merchant.getIdentityNo() == null) {
            throw new CrmebException("\u6ca1\u6709\u8be5\u5546\u6237\u6216\u5546\u6237\u672a\u5f00\u901a\u6c47\u4ed8\u652f\u4ed8\uff1a" + order.getMerId());
        }
        return merchant.getIdentityNo();
    }

    @Override
    public void allOrder(String orderNo) {
        List<Order> list = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)orderNo)) {
            Order order = this.orderService.getByOrderNo(orderNo);
            list.add(order);
            System.out.println(">>>>>>>>> 100000 \u5355\u4e2a\u8ba2\u5355:" + order.getOrderNo() + ",amount:" + order.getPayPrice() + ",orders:" + order.getPayChannel());
        } else {
            list = this.orderService.testAllOrderNo();
            System.out.println(">>>>>>>>> 100000 \u5408\u5e76\u8ba2\u5355:" + list.size() + "\u4e2a");
        }
        HashMap map = Maps.newHashMap();
        for (Order order : list) {
            String key = order.getUid() + "ORDER" + order.getMerId() + "DATE" + DateUtil.format((Date)order.getPayTime(), (String)"yyyyMMdd");
            Order o = (Order)map.get(key);
            if (o != null) {
                o.setPayPrice(o.getPayPrice().add(order.getPayPrice()));
                o.setPayChannel(o.getPayChannel() + "," + order.getOrderNo());
            } else {
                o = order;
                o.setPayChannel(o.getOrderNo());
            }
            map.put(key, o);
        }
        for (Map.Entry entry : map.entrySet()) {
            Order order = (Order)entry.getValue();
            System.out.println(">>>>>>>>> 000000 \u5408\u5e76\u8ba2\u5355:" + order.getOrderNo() + ",amount:" + order.getPayPrice() + ",orders:" + order.getPayChannel());
            if (order.getPayPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
            this.paymentUtil(order);
        }
    }

    private Boolean paymentUtil(Order order) {
        User user = (User)this.userService.getById(order.getUid());
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        String[] orders = order.getPayChannel().split(",");
        List orderDetails = Lists.newArrayList();
        for (String orderNo : orders) {
            orderDetails.addAll(this.orderDetailService.getByOrderNo(orderNo));
        }
        return this.walletFreezeAndPayTest(order, orderDetails, order.getBizType(), user, merchant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean walletFreezeAndPayTest(Order order, List<OrderDetail> orderDetails, Integer bizType, User user, Merchant merchant) {
        if (orderDetails.isEmpty()) {
            throw new CrmebException("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a,\u65e0\u6cd5\u652f\u4ed8,\u8bf7\u8054\u7cfb\u7ba1\u7406\u9875");
        }
        String productDesc = orderDetails.stream().map(d -> d.getProductName() + "(" + d.getSku() + ") * " + d.getPayNum()).collect(Collectors.joining(";"));
        if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            String isPlatAcct = "0";
            if (order.getPlatFee() != null && order.getPlatFee().compareTo(BigDecimal.ZERO) > 0) {
                isPlatAcct = "1";
            }
            transferDto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo() + "B").setComment(productDesc).setGoodsName(orderDetails.get(0).getProductName()).setGoodsUnit(orderDetails.get(0).getSku()).setGoodsNumber(String.valueOf(orderDetails.get(0).getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(Integer.valueOf(1)).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(order.getPlatFee().toPlainString());
            try {
                System.out.println(">>>>>>>>> order:" + transferDto.getBusinessPartnerSeq() + ",amount:" + transferDto.getAmount() + ",pAmount:" + transferDto.getPlatAmount());
                if (bizType.equals(1)) return true;
                transferDto.setTradeType("04");
                this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountTransfer(transferDto);
                String sign = smap.get(transferDto.getBusinessPartnerSeq());
                if (!StringUtils.isEmpty((CharSequence)sign)) return true;
                System.out.println(">>>>>>>>> 000000 order:" + transferDto.getBusinessPartnerSeq() + ",amount:" + transferDto.getAmount() + ",pAmount:" + transferDto.getPlatAmount());
                this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).testLock(transferDto.getOutId(), "05", transferDto.getAmount());
                smap.put(transferDto.getBusinessPartnerSeq(), "1");
                return true;
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u51bb\u7ed3\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                return false;
            }
        } else {
            logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
        }
        return true;
    }

    @Override
    public boolean payOffline(BcxMerchantPayOfflineRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Order order = this.orderService.getByOrderNo(request.getOrderNo());
        Integer uid = order.getUid();
        User user = (User)this.userService.getById(uid);
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        if (order == null || !order.getMerId().equals(admin.getMerId())) {
            throw new CrmebException("\u65e0\u6743\u9650");
        }
        BcxPayOffline offline = this.bcxPayOfflineService.queryByOrderNo(request.getOrderNo());
        if (offline == null) {
            throw new CrmebException("\u7528\u6237\u672a\u786e\u8ba4\u7ebf\u4e0b\u652f\u4ed8");
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            order.setPayType("offline");
            order.setPaid(Boolean.valueOf(true));
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            this.orderService.updateById(order);
            offline.setMerMsg(request.getMerMsg());
            offline.setStatus(Integer.valueOf(2));
            this.bcxPayOfflineService.updateById(offline);
            if (CollUtil.isNotEmpty((Collection)request.getFileList())) {
                List files = request.getFileList().stream().map(file -> new BcxPayOfflineFile().setOrderNo(request.getOrderNo()).setFileUrl(file.getFileUrl()).setFileName(file.getFileName()).setPayOfflineId(offline.getId())).collect(Collectors.toList());
                this.bcxPayOfflineFileService.saveBatch(files);
            }
            List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(order.getOrderNo());
            List<Integer> productIds = orderDetails.stream().map(OrderDetail::getProductId).collect(Collectors.toList());
            Integer bizType = this.orderService.getBizTypeByProductsType(productIds);
            if (order.getBizType().equals(ProductConstants.BIZ_TYPE_RISK)) {
                this.syncReportOrder2RiskSystem(order, orderDetails.get(0));
                return true;
            }
            return this.walletFreezeAndPay(order, orderDetails.get(0), bizType, user, merchant);
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u7ebf\u4e0b\u652f\u4ed8\u63d0\u4ea4\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return true;
    }

    @Override
    public boolean payOfflineReceived(BcxMerchantPayOfflineRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        Order order = this.orderService.getByOrderNo(request.getOrderNo());
        Integer uid = order.getUid();
        User user = (User)this.userService.getById(uid);
        Merchant merchant = this.merchantService.getByIdException(order.getMerId());
        if (!order.getMerId().equals(admin.getMerId())) {
            throw new CrmebException("\u65e0\u6743\u9650");
        }
        BcxPayOffline offline = this.bcxPayOfflineService.queryByOrderNo(request.getOrderNo());
        if (offline == null) {
            throw new CrmebException("\u7528\u6237\u672a\u786e\u8ba4\u7ebf\u4e0b\u652f\u4ed8");
        }
        if (offline.getStatus() != 2) {
            throw new CrmebException("\u5546\u6237\u672a\u786e\u8ba4\u7ebf\u4e0b\u652f\u4ed8");
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            offline.setMerMsg(request.getMerMsg());
            offline.setStatus(Integer.valueOf(3));
            this.bcxPayOfflineService.updateById(offline);
            if (CollUtil.isNotEmpty((Collection)request.getFileList())) {
                List files = request.getFileList().stream().map(file -> new BcxPayOfflineFile().setOrderNo(request.getOrderNo()).setFileUrl(file.getFileUrl()).setFileName(file.getFileName()).setPayOfflineId(offline.getId())).collect(Collectors.toList());
                this.bcxPayOfflineFileService.saveBatch(files);
            }
            List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo(order.getOrderNo());
            List<Integer> productIds = orderDetails.stream().map(OrderDetail::getProductId).collect(Collectors.toList());
            Integer bizType = this.orderService.getBizTypeByProductsType(productIds);
            return this.walletFreezeAndPay(order, orderDetails.get(0), bizType, user, merchant);
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u786e\u8ba4\u5230\u6b3e\u63d0\u4ea4\u5931\u8d25");
        }
        return true;
    }

    private /* synthetic */ Boolean lambda$walletUnfreeze$25(Order order, Integer bizType, String productDesc, List orderDetails, Merchant merchant, BcxPlatformFee platFee, User user, TransactionStatus e) {
        boolean update;
        block6: {
            update = true;
            if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
                HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
                transferDto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(((OrderDetail)orderDetails.get(0)).getProductName()).setGoodsUnit(((OrderDetail)orderDetails.get(0)).getSku()).setGoodsNumber(String.valueOf(((OrderDetail)orderDetails.get(0)).getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee().toPlainString());
                try {
                    if (bizType.equals(2)) {
                        transferDto.setTradeType("05");
                        if (!"offline".equalsIgnoreCase(order.getPayType())) {
                            this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountRefund(transferDto);
                        }
                        break block6;
                    }
                    logger.error("\u53ea\u6709\u7279\u6b8a\u5546\u54c1\u624d\u8d70\u89e3\u51bb\u6d41\u7a0b-orderNo:" + order.getOrderNo() + ":orderDetailId:" + ((OrderDetail)orderDetails.get(0)).getId());
                    update = false;
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                    logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u89e3\u51bb\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                    e.setRollbackOnly();
                    update = false;
                }
            } else {
                logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
            }
        }
        return update;
    }

    private /* synthetic */ Boolean lambda$platWalletUnfreezeAndPay$23(Order order, Integer bizType, String productDesc, List orderDetails, Merchant merchant, BcxPlatformFee platFee, User user, TransactionStatus e) {
        boolean update = true;
        if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(((OrderDetail)orderDetails.get(0)).getProductName()).setGoodsUnit(((OrderDetail)orderDetails.get(0)).getSku()).setGoodsNumber(String.valueOf(((OrderDetail)orderDetails.get(0)).getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee().toPlainString());
            try {
                if (bizType.equals(ProductConstants.BIZ_TYPE_SPACIAL) || bizType.equals(ProductConstants.BIZ_TYPE_RISK)) {
                    transferDto.setTradeType("05");
                    this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).platHuifuWalletAccountLock(transferDto);
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u89e3\u51bb\u652f\u4ed8\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                update = false;
            }
        } else {
            logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
        }
        return update;
    }

    private /* synthetic */ Boolean lambda$walletUnfreezeAndPay$21(Order order, Integer bizType, String productDesc, List orderDetails, Merchant merchant, BcxPlatformFee platFee, User user, TransactionStatus e) {
        boolean update = true;
        if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(((OrderDetail)orderDetails.get(0)).getProductName()).setGoodsUnit(((OrderDetail)orderDetails.get(0)).getSku()).setGoodsNumber(String.valueOf(((OrderDetail)orderDetails.get(0)).getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee().toPlainString());
            try {
                if (bizType.equals(ProductConstants.BIZ_TYPE_SPACIAL) || bizType.equals(ProductConstants.BIZ_TYPE_RISK)) {
                    transferDto.setTradeType("05");
                    this.paymentFactory.getPaymentChannel(PaymentChannel.getByName(this.systemConfigService.getValueByKey("pay_channel")).getService()).huifuWalletAccountLock(transferDto);
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u89e3\u51bb\u652f\u4ed8\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                update = false;
            }
        } else {
            logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
        }
        return update;
    }
}

