/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.community.CommunityCategory;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommunityCategorySaveRequest;
import com.zbkj.common.request.CommunityCategorySearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.CommunityResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.service.dao.community.CommunityCategoryDao;
import com.zbkj.service.service.CommunityCategoryService;
import com.zbkj.service.service.CommunityNotesService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommunityCategoryServiceImpl
extends ServiceImpl<CommunityCategoryDao, CommunityCategory>
implements CommunityCategoryService {
    @Resource
    private CommunityCategoryDao dao;
    @Autowired
    private CommunityNotesService notesService;

    @Override
    public PageInfo<CommunityCategory> findPageList(CommunityCategorySearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityCategory::getId, CommunityCategory::getName, CommunityCategory::getSort, CommunityCategory::getIsShow, CommunityCategory::getCreateTime});
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            lqw.like(CommunityCategory::getName, (Object)URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            lqw.eq(CommunityCategory::getIsShow, (Object)request.getIsShow());
        }
        lqw.eq(CommunityCategory::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc((Object[])new SFunction[]{CommunityCategory::getSort, CommunityCategory::getId});
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public void add(CommunityCategorySaveRequest request) {
        if (this.isExistName(request.getName(), 0)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_CATEGORY_EXIST);
        }
        CommunityCategory category = new CommunityCategory();
        BeanUtils.copyProperties((Object)request, (Object)category, (String[])new String[]{"id"});
        boolean save = this.save(category);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u6dfb\u52a0\u793e\u533a\u5206\u7c7b\u5931\u8d25"));
        }
    }

    @Override
    public void edit(CommunityCategorySaveRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_CATEGORY_ID_NULL);
        }
        CommunityCategory category = this.getByIdExpetion(request.getId());
        if (!category.getName().equals(request.getName()) && this.isExistName(request.getName(), request.getId())) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_CATEGORY_EXIST);
        }
        BeanUtils.copyProperties((Object)request, (Object)category);
        boolean update = this.updateById(category);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7f16\u8f91\u793e\u533a\u5206\u7c7b\u5931\u8d25"));
        }
    }

    @Override
    public void deleteById(Integer id) {
        CommunityCategory category = this.getByIdExpetion(id);
        if (this.notesService.isUseCategory(id).booleanValue()) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_CATEGORY_USING);
        }
        category.setIsDel(Constants.COMMON_IS_FILED_ONE);
        boolean update = this.updateById(category);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5220\u9664\u793e\u533a\u5206\u7c7b\u5931\u8d25"));
        }
    }

    @Override
    public Map<Integer, String> getMapInIdList(List<Integer> cateIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityCategory::getId, CommunityCategory::getName});
        lqw.in(CommunityCategory::getId, cateIdList);
        lqw.eq(CommunityCategory::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        List list = this.dao.selectList((Wrapper)lqw);
        HashMap map = CollUtil.newHashMap();
        list.forEach(e -> map.put(e.getId(), e.getName()));
        return map;
    }

    @Override
    public void showSwitch(Integer id) {
        CommunityCategory category;
        category.setIsShow((category = this.getByIdExpetion(id)).getIsShow().equals(Constants.COMMON_IS_FILED_ONE) ? Constants.COMMON_IS_FILED_ZERO : Constants.COMMON_IS_FILED_ONE);
        boolean update = this.updateById(category);
        if (!update) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7f16\u8f91\u793e\u533a\u5206\u7c7b\u663e\u793a\u72b6\u6001\u5931\u8d25"));
        }
    }

    @Override
    public List<CommunityCategory> findListByShow(Integer isShow) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityCategory::getId, CommunityCategory::getName});
        if (ObjectUtil.isNotNull((Object)isShow)) {
            lqw.eq(CommunityCategory::getIsShow, (Object)isShow);
        }
        lqw.eq(CommunityCategory::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        lqw.orderByDesc((Object[])new SFunction[]{CommunityCategory::getSort, CommunityCategory::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    private boolean isExistName(String name, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityCategory::getId});
        lqw.eq(CommunityCategory::getName, (Object)name);
        lqw.eq(CommunityCategory::getIsDel, (Object)Constants.COMMON_IS_FILED_ZERO);
        if (ObjectUtil.isNotNull((Object)id) && id > 0) {
            lqw.ne(CommunityCategory::getId, (Object)id);
        }
        lqw.last("limit 1");
        CommunityCategory communityCategory = (CommunityCategory)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)communityCategory);
    }

    private CommunityCategory getByIdExpetion(Integer id) {
        CommunityCategory category = (CommunityCategory)this.getById(id);
        if (ObjectUtil.isNull((Object)category) || category.getIsDel().equals(Constants.COMMON_IS_FILED_ONE)) {
            throw new CrmebException((IResultEnum)CommunityResultCode.COMMUNITY_CATEGORY_NOT_EXIST);
        }
        return category;
    }
}

