/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.enums.BcxBillSettleStatusEnum;
import com.zbkj.common.enums.BcxPerformanceReportBelongTypeEnum;
import com.zbkj.common.enums.BcxReportSettleStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxDepartment;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxBillGenerateSettleRequest;
import com.zbkj.common.request.BcxSettleBillSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleBillDetailResponse;
import com.zbkj.common.response.BcxSettleBillInfoResponse;
import com.zbkj.common.response.BcxSettleBillResponse;
import com.zbkj.common.response.BcxSettleBillStatisticsResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.service.dao.BcxSettleBillDao;
import com.zbkj.service.service.BcxDepartmentMemberService;
import com.zbkj.service.service.BcxDepartmentService;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BcxSettleBillService;
import com.zbkj.service.service.BcxSettleService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxSettleBillServiceImpl
extends ServiceImpl<BcxSettleBillDao, BcxSettleBill>
implements BcxSettleBillService {
    private static final Logger log = LoggerFactory.getLogger(BcxSettleBillServiceImpl.class);
    @Resource
    private BcxSettleBillDao dao;
    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Autowired
    private BcxDepartmentService bcxDepartmentService;
    @Autowired
    private BcxDepartmentMemberService bcxDepartmentMemberService;
    @Autowired
    private UserService userService;
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RedissonClient redissonClient;

    @Override
    @Transactional
    public void generateSettleBill(Date endTime) {
        log.info("==================\u751f\u6210\u4e1a\u7ee9\u8d26\u5355==================");
        log.info("\u8d26\u5355\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)endTime);
        String billPeriod = DateUtils.formatDate((Date)endTime, (Object[])new Object[]{"yyyy-MM"});
        log.info("\u8d26\u671f\uff1a{}", (Object)billPeriod);
        String lockKey = "GENERATE_SETTLE_BILL";
        log.info("\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(30L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            List<BcxPerformanceReport> performanceReportList = this.bcxPerformanceReportService.listWaitSettledByEndTime(endTime);
            if (CollectionUtil.isNotEmpty(performanceReportList)) {
                Date now = new Date();
                ArrayList<BcxSettleBill> bcxSettleBillList = new ArrayList<BcxSettleBill>();
                log.info("\u8d26\u671f\uff1a{}\uff0c\u4e1a\u7ee9\u62a5\u8868\u6761\u6570\u4e3a\uff1a{}", (Object)billPeriod, (Object)performanceReportList.size());
                Map<String, List<BcxPerformanceReport>> belongReportListMap = performanceReportList.stream().collect(Collectors.groupingBy(bcxPerformanceReport -> bcxPerformanceReport.getBelongId().toString().concat("_").concat(bcxPerformanceReport.getBelongType().toString())));
                for (Map.Entry<String, List<BcxPerformanceReport>> belongReportListEntry : belongReportListMap.entrySet()) {
                    String[] key = belongReportListEntry.getKey().split("_");
                    long belongId = Long.parseLong(key[0]);
                    int belongType = Integer.parseInt(key[1]);
                    BcxSettleBill exist = this.findByBelongIdAndBillPeriod(belongId, belongType, billPeriod);
                    if (exist != null) {
                        log.info("belongId\uff1a{}\uff0cbelongType\uff1a{}\uff0c\u8d26\u671f\uff1a{}\uff0c\u7684\u8d26\u5355\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210", new Object[]{belongId, belongType, billPeriod});
                        continue;
                    }
                    List<BcxPerformanceReport> reportList = belongReportListEntry.getValue();
                    log.info("\u751f\u6210belongId\uff1a{}\uff0cbelongType\uff1a{}\uff0c\u7684\u8d26\u5355\uff0c\u8d26\u671f\uff1a{}\uff0c\u4e1a\u7ee9\u62a5\u8868\u6761\u6570\u4e3a\uff1a{}", new Object[]{belongId, belongType, billPeriod, reportList.size()});
                    Long billId = this.snowflake.snowflakeId();
                    HashSet<Integer> orderIdSet = new HashSet<Integer>();
                    BigDecimal orderTotalPrice = BigDecimal.ZERO;
                    BigDecimal brokerageTotalPrice = BigDecimal.ZERO;
                    for (BcxPerformanceReport report : reportList) {
                        orderIdSet.add(report.getOrderId());
                        orderTotalPrice = orderTotalPrice.add(report.getPayPrice());
                        if (report.getSeparateAccountStatus() == null || report.getSeparateAccountStatus() == 0) {
                            brokerageTotalPrice = brokerageTotalPrice.add(report.getBrokeragePrice());
                        }
                        report.setSettleBillId(billId);
                    }
                    bcxSettleBillList.add(this.createBcxSettleBill(billId, belongId, belongType, billPeriod, orderIdSet.size(), orderTotalPrice, brokerageTotalPrice, now));
                }
                log.info("\u4fdd\u5b58\u6570\u636e");
                this.bcxPerformanceReportService.updateBatchById(performanceReportList);
                this.saveBatch(bcxSettleBillList);
            } else {
                log.info("\u8d26\u671f\uff1a{}\uff0c\u4e1a\u7ee9\u62a5\u8868\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u751f\u6210\u4e1a\u7ee9\u8d26\u5355", (Object)billPeriod);
            }
            log.info("\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\u5b8c\u6210\uff0c\u8d26\u5355\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("==================\u751f\u6210\u4e1a\u7ee9\u8d26\u5355\u5b8c\u6210==================");
    }

    private BcxSettleBill createBcxSettleBill(Long id, Long belongId, Integer belongType, String billPeriod, int orderCount, BigDecimal orderTotalPrice, BigDecimal brokerageTotalPrice, Date now) {
        BcxSettleBill bill = new BcxSettleBill();
        bill.setId(id);
        bill.setBelongId(belongId);
        bill.setBelongType(belongType);
        bill.setBillPeriod(billPeriod);
        bill.setOrderCount(Integer.valueOf(orderCount));
        bill.setOrderTotalPrice(orderTotalPrice);
        bill.setBrokerageTotalPrice(brokerageTotalPrice);
        bill.setBrokerageSettleTotalPrice(BigDecimal.ZERO);
        bill.setSettleStatus(BcxBillSettleStatusEnum.WAIT_SETTLED.getValue());
        bill.setCreateTime(now);
        bill.setUpdateTime(now);
        return bill;
    }

    private BcxSettleBill findByBelongIdAndBillPeriod(Long belongId, Integer belongType, String billPeriod) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"belong_id", (Object)belongId);
        queryWrapper.eq((Object)"belong_type", (Object)belongType);
        queryWrapper.eq((Object)"bill_period", (Object)billPeriod);
        return (BcxSettleBill)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public BcxSettleBillDetailResponse findId(Long id) {
        BcxDepartmentMember departmentMember;
        BcxSettleBillDetailResponse result = new BcxSettleBillDetailResponse();
        BcxSettleBill bcxSettleBill = (BcxSettleBill)this.getById(id);
        BeanUtil.copyProperties((Object)bcxSettleBill, (Object)result);
        int belongType = bcxSettleBill.getBelongType();
        Long belongId = bcxSettleBill.getBelongId();
        if (belongType == BcxPerformanceReportBelongTypeEnum.CHANNEL.getValue() || belongType == BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue() || belongType == BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue()) {
            User user = (User)this.userService.getById(belongId);
            if (user != null) {
                result.setSettleName(user.getRealName());
            }
        } else if (belongType == BcxPerformanceReportBelongTypeEnum.DEPARTMENT.getValue()) {
            BcxDepartment department = (BcxDepartment)this.bcxDepartmentService.getById(belongId);
            if (department != null) {
                result.setSettleName(department.getName());
            }
        } else if (belongType == BcxPerformanceReportBelongTypeEnum.DEPARTMENT_MEMBER.getValue() && (departmentMember = (BcxDepartmentMember)this.bcxDepartmentMemberService.getById(belongId)) != null) {
            result.setSettleName(departmentMember.getName());
        }
        return result;
    }

    @Override
    public PageInfo<BcxSettleBillResponse> getPage(BcxSettleBillSearchRequest request, PageParamRequest pageParamRequest) throws ParseException {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Object> list = new ArrayList();
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                list = this.dao.selectChannelList(map);
            } else if (request.getSearchType() == 2) {
                list = this.dao.selectDepartmentList(map);
            } else if (request.getSearchType() == 3) {
                list = this.dao.selectDepartmentMemberList(map);
            } else if (request.getSearchType() == 4) {
                list = this.dao.selectFxsList(map);
            } else if (request.getSearchType() == 5) {
                list = this.dao.selectFxyList(map);
            } else if (request.getSearchType() == 6) {
                list = this.dao.selectUserList(map);
            }
        }
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public BcxSettleBillStatisticsResponse statistics(BcxSettleBillSearchRequest request) throws ParseException {
        BcxSettleBillStatisticsResponse response = new BcxSettleBillStatisticsResponse();
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                response = this.dao.selectChannelCount(map);
            } else if (request.getSearchType() == 2) {
                response = this.dao.selectDepartmentCount(map);
            } else if (request.getSearchType() == 3) {
                response = this.dao.selectDepartmentMemberCount(map);
            } else if (request.getSearchType() == 4) {
                response = this.dao.selectFxsCount(map);
            } else if (request.getSearchType() == 5) {
                response = this.dao.selectFxyCount(map);
            } else if (request.getSearchType() == 6) {
                response = this.dao.selectUserCount(map);
            }
        }
        return response;
    }

    private HashMap<String, Object> getSearchParamMap(BcxSettleBillSearchRequest request) throws ParseException {
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)request.getBillPeriodStart())) {
            map.put("billPeriodStart", DateUtils.parseDate((String)request.getBillPeriodStart().concat("-01 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        }
        if (ObjectUtil.isNotNull((Object)request.getBillPeriodEnd())) {
            map.put("billPeriodEnd", DateUtils.parseDate((String)request.getBillPeriodEnd().concat("-01 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        }
        if (ObjectUtil.isNotNull((Object)request.getUserId())) {
            map.put("userId", request.getUserId());
        }
        if (ObjectUtil.isNotNull((Object)request.getSpreadUid())) {
            map.put("spreadUid", request.getSpreadUid());
        }
        if (ObjectUtil.isNotNull((Object)request.getSettleStatus())) {
            map.put("settleStatus", request.getSettleStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", request.getName());
        }
        if (request.getSearchType() == 2) {
            if (StringUtils.isNotBlank((CharSequence)request.getBcxId())) {
                BcxDepartment department = this.bcxDepartmentService.findByBcxId(request.getBcxId());
                if (department != null) {
                    map.put("departmentId", department.getId());
                } else {
                    map.put("departmentId", -1);
                }
            }
        } else if (request.getSearchType() == 3 && StringUtils.isNotBlank((CharSequence)request.getBcxId())) {
            BcxDepartment department = this.bcxDepartmentService.findByBcxId(request.getBcxId());
            if (department != null) {
                map.put("departmentId", department.getId());
            } else {
                BcxDepartmentMember departmentMember = this.bcxDepartmentMemberService.findByBcxId(request.getBcxId());
                if (departmentMember != null) {
                    map.put("departmentMemberId", departmentMember.getId());
                } else {
                    map.put("departmentMemberId", -1);
                }
            }
        }
        return map;
    }

    @Override
    public BcxSettleBillInfoResponse getSettleInfo(BcxBillGenerateSettleRequest request) {
        if (CollectionUtil.isEmpty((Collection)request.getSettleBillIdList()) && request.getSettleBillId() == null && CollectionUtil.isEmpty((Collection)request.getPerformanceReportIdList())) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8bf7\u9009\u62e9\u8981\u7ed3\u7b97\u7684\u8d26\u5355\u6216\u4e1a\u7ee9\u62a5\u8868"));
        }
        List<BcxPerformanceReport> performanceReportList = this.getSettleReportList(request);
        BcxSettleBillInfoResponse response = this.getBcxBillSettleInfoResponse(performanceReportList);
        return response;
    }

    @Override
    @Transactional
    public Boolean generateSettle(BcxBillGenerateSettleRequest request) {
        log.info("==================\u751f\u6210\u7ed3\u7b97\u5355==================");
        log.info("\u751f\u6210\u7ed3\u7b97\u5355,\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String lockKey = "BCX_SETTLE_BILL_GENERATE_SETTLE";
        log.info("\u751f\u6210\u7ed3\u7b97\u5355\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(30L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            if (CollectionUtil.isEmpty((Collection)request.getSettleBillIdList()) && request.getSettleBillId() == null && CollectionUtil.isEmpty((Collection)request.getPerformanceReportIdList())) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8bf7\u9009\u62e9\u8981\u751f\u6210\u7ed3\u7b97\u5355\u7684\u8d26\u5355\u6216\u4e1a\u7ee9\u62a5\u8868"));
            }
            Date now = new Date();
            List<BcxPerformanceReport> performanceReportList = this.getSettleReportList(request);
            if (CollectionUtil.isNotEmpty(performanceReportList)) {
                log.info("\u8981\u751f\u6210\u7ed3\u7b97\u5355\u7684\u4e1a\u7ee9\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)performanceReportList.size());
                Map<Long, List<BcxPerformanceReport>> reportListMap = performanceReportList.stream().collect(Collectors.groupingBy(BcxPerformanceReport::getSettleBillId));
                log.info("\u8981\u751f\u6210\u7ed3\u7b97\u5355\u7684\u8d26\u5355\u6570\u91cf\uff1a{}", (Object)reportListMap.size());
                BcxSettle lastNoSettle = this.bcxSettleService.getLastNoSettle();
                int settleNoNum = 1;
                if (lastNoSettle != null) {
                    int length = lastNoSettle.getSettleNo().length();
                    settleNoNum = Integer.parseInt(lastNoSettle.getSettleNo().substring(length - 5, length)) + 1;
                }
                DecimalFormat settleNoFormat = new DecimalFormat("00000");
                for (Map.Entry<Long, List<BcxPerformanceReport>> reportListEntry : reportListMap.entrySet()) {
                    String settleNo = this.bcxSettleService.getSettleNoPrefix().concat(settleNoFormat.format(settleNoNum));
                    Long settleId = this.snowflake.snowflakeId();
                    Long settleBillId = reportListEntry.getKey();
                    List<BcxPerformanceReport> reportList = reportListEntry.getValue();
                    log.info("========================");
                    log.info("\u8981\u751f\u6210\u7ed3\u7b97\u5355\u7684\u8d26\u5355id\uff1a{}\uff0c\u4e1a\u7ee9\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)settleBillId, (Object)reportList.size());
                    for (BcxPerformanceReport report : reportList) {
                        report.setSettleStatus(BcxReportSettleStatusEnum.SETTLING.getValue());
                        report.setSettleId(settleId);
                        report.setUpdateTime(now);
                        log.info("\u4fee\u6539\u4e1a\u7ee9\u62a5\u8868id\uff1a{}\uff0c\u7ed3\u7b97\u72b6\u6001\uff1a{}", (Object)report.getId().toString(), (Object)BcxReportSettleStatusEnum.SETTLING.getName());
                    }
                    BcxSettleBillInfoResponse response = this.getBcxBillSettleInfoResponse(reportList);
                    if (response.getSettleTotalPrice().compareTo(BigDecimal.ZERO) < 0) {
                        throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
                    }
                    BcxSettleBill settleBill = (BcxSettleBill)this.getById(settleBillId);
                    this.bcxSettleService.generateSettle(settleBill, settleId, settleNo, response, now);
                    this.bcxPerformanceReportService.updateBatchById(reportList);
                    ++settleNoNum;
                    log.info("========================");
                }
            } else {
                log.info("\u65e0\u7ed3\u7b97\u7684\u4e1a\u7ee9\u62a5\u8868");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u751f\u6210\u7ed3\u7b97\u5355\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u751f\u6210\u7ed3\u7b97\u5355\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u751f\u6210\u7ed3\u7b97\u5355\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("==================\u751f\u6210\u7ed3\u7b97\u5355\u5b8c\u6210==================");
        return true;
    }

    private List<BcxPerformanceReport> getSettleReportList(BcxBillGenerateSettleRequest request) {
        ArrayList<BcxPerformanceReport> performanceReportList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)request.getSettleBillIdList())) {
            QueryWrapper queryWrapper = Wrappers.query();
            queryWrapper.in((Object)"settle_bill_id", (Collection)request.getSettleBillIdList());
            queryWrapper.eq((Object)"settle_status", (Object)BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
            performanceReportList = this.bcxPerformanceReportService.list((Wrapper)queryWrapper);
        } else {
            QueryWrapper queryWrapper = Wrappers.query();
            if (CollectionUtil.isNotEmpty((Collection)request.getPerformanceReportIdList())) {
                queryWrapper.in((Object)"id", (Collection)request.getPerformanceReportIdList());
            }
            if (request.getSettleBillId() != null) {
                queryWrapper.eq((Object)"settle_bill_id", (Object)request.getSettleBillId());
            }
            queryWrapper.eq((Object)"settle_status", (Object)BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
            performanceReportList = this.bcxPerformanceReportService.list((Wrapper)queryWrapper);
        }
        return performanceReportList;
    }

    private BcxSettleBillInfoResponse getBcxBillSettleInfoResponse(List<BcxPerformanceReport> performanceReportList) {
        BcxSettleBillInfoResponse response = new BcxSettleBillInfoResponse();
        if (CollectionUtil.isNotEmpty(performanceReportList)) {
            HashSet<Long> settleBillIdSet = new HashSet<Long>();
            int settleReportCount = 0;
            HashSet<Integer> settleOrderIdSet = new HashSet<Integer>();
            BigDecimal payTotalPrice = BigDecimal.ZERO;
            BigDecimal settleTotalPrice = BigDecimal.ZERO;
            BigDecimal settledPrice = BigDecimal.ZERO;
            for (BcxPerformanceReport report : performanceReportList) {
                settleBillIdSet.add(report.getSettleBillId());
                ++settleReportCount;
                settleOrderIdSet.add(report.getOrderId());
                payTotalPrice = payTotalPrice.add(report.getPayPrice());
                settleTotalPrice = settleTotalPrice.add(report.getBrokeragePrice());
                if (report.getSeparateAccountStatus() == null || report.getSeparateAccountStatus() != 1) continue;
                settledPrice = settledPrice.add(report.getBrokeragePrice());
            }
            response.setSettleCount(Integer.valueOf(settleBillIdSet.size()));
            response.setSettleReportCount(Integer.valueOf(settleReportCount));
            response.setSettleOrderCount(Integer.valueOf(settleOrderIdSet.size()));
            response.setPayTotalPrice(payTotalPrice);
            response.setSettleTotalPrice(settleTotalPrice);
            response.setSettledPrice(settledPrice);
            response.setNotSettledPrice(settleTotalPrice.subtract(settledPrice));
        } else {
            response.setSettleCount(Integer.valueOf(0));
            response.setSettleReportCount(Integer.valueOf(0));
            response.setSettleOrderCount(Integer.valueOf(0));
            response.setPayTotalPrice(BigDecimal.ZERO);
            response.setSettleTotalPrice(BigDecimal.ZERO);
            response.setSettledPrice(BigDecimal.ZERO);
            response.setNotSettledPrice(BigDecimal.ZERO);
        }
        return response;
    }
}

