/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDetailDto;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsProtocolWithholdResultNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsProtocolWithholdResultNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsProtocolWithholdResultNotifyService")
public class BkcloudfundsProtocolWithholdResultNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        System.out.println("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify");
        System.out.println("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        logger.info("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        BkcloudfundsProtocolWithholdResultNotifyRequest protocolWithholdResultNotifyRequest = XmlConverter.getInstance().toResponse(context, BkcloudfundsProtocolWithholdResultNotifyRequest.class);
        RequestHead head = protocolWithholdResultNotifyRequest.getBkcloudfundsProtocolWithholdResultNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(protocolWithholdResultNotifyRequest.getBkcloudfundsProtocolWithholdResultNotify().getBkcloudfundsProtocolWithholdResultNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsProtocolWithholdResultNotifyModel model) {
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOperateNo());
        int cf = this.huifuWalletAccountDetailDao.checkFlowNo(trade.getReqSeqId(), trade.getUniId());
        if (cf > 0) {
            return true;
        }
        if ("SUCCESS".equals(model.getStatus())) {
            trade.setTradeStatus(Constants.tradeStatus((String)"S"));
            trade.setOrderNo(model.getOrderNo());
        } else {
            trade.setTradeStatus(Constants.tradeStatus((String)"F"));
            trade.setErrorMsg(model.getErrorDesc());
        }
        if (StringUtil.isNotEmpty((String)model.getFinishDate())) {
            trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getFinishDate(), (String)"yyyyMMddHHmmss")));
        }
        trade.setUpdateTime(new Date());
        this.huifuWalletTradeDao.updateById(trade);
        ArrayList detailList = Lists.newArrayList();
        HuifuWalletAccountDetailDto detail = new HuifuWalletAccountDetailDto();
        detail.setUniId(trade.getUniId());
        detail.setWalletAccountNo(trade.getExpendAccountNo());
        detail.setTradeDate(DateUtils.formatDate((Date)trade.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
        detail.setTradeFlowNo(model.getOperateNo());
        detail.setFlowNo(model.getOutTradeNo());
        detail.setAccountsDealType("\u5185\u90e8\u6237\u5904\u7406");
        detail.setAccountsDealDate(model.getFinishDate());
        detail.setAmount(new BigDecimal(model.getTotalAmount()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP).toString());
        detail.setDirection("\u51fa\u8d26");
        String transStat = trade.getTradeStatus();
        transStat = transStat.equals("1") ? "\u6210\u529f" : (transStat.equals("2") ? "\u5931\u8d25" : "\u5904\u7406\u4e2d");
        detail.setHandStatus(transStat);
        String tradeType = StringUtils.isNotEmpty((CharSequence)trade.getRemark()) && trade.getRemark().contains("\u9000\u6b3e") ? "\u53cd\u5411\u4ea4\u6613" : "\u6b63\u5411\u4ea4\u6613";
        detail.setTradeType(tradeType);
        detail.setCreateDate(DateUtils.formatDate((Date)trade.getCreateTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        detail.setServiceType("\u5b9e\u65f6");
        detail.setAccountIn(trade.getIncomeAccountNo());
        detail.setAccountOut(trade.getExpendAccountNo());
        detail.setMemo(trade.getRemark());
        detail.setPayChannel(PaymentChannel.WANGSHANG.toString());
        HuifuWalletAccountDto accountIn = null;
        HuifuWalletAccountDto accountOut = null;
        if (StringUtil.isEmpty((String)detail.getAccountIn())) {
            detail.setAccountInName("\u65e0");
        } else {
            accountIn = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountIn());
            detail.setAccountInName(StringUtils.isEmpty((CharSequence)accountIn.getComName()) ? "\u65e0" : accountIn.getComName());
        }
        if (StringUtil.isEmpty((String)detail.getAccountOut())) {
            detail.setAccountOutName("\u65e0");
        } else {
            accountOut = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountOut());
            detail.setAccountOutName(StringUtils.isEmpty((CharSequence)accountOut.getComName()) ? "\u65e0" : accountOut.getComName());
        }
        if (accountOut != null && accountIn != null) {
            int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
            if (count == 0) {
                detailList.add(detail);
            }
            HuifuWalletAccountDetailDto detail2 = new HuifuWalletAccountDetailDto();
            BeanUtils.copyProperties((Object)detail, (Object)detail2);
            detail2.setUniId(accountIn.getUniId());
            detail2.setWalletAccountNo(accountIn.getWalletAccountNo());
            detail2.setDirection("\u5165\u8d26");
            count = this.huifuWalletAccountDetailDao.checkFlowNo(detail2.getTradeFlowNo(), detail2.getUniId());
            if (count == 0) {
                detailList.add(detail2);
            }
        } else if (accountOut != null && accountIn == null) {
            int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
            if (count == 0) {
                detailList.add(detail);
            }
        } else if (accountIn != null && accountOut == null) {
            detail.setDirection("\u5165\u8d26");
            int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
            if (count == 0) {
                detailList.add(detail);
            }
        }
        if (detailList.size() > 0) {
            this.huifuWalletAccountDetailDao.insertBatch(detailList);
        }
        return true;
    }
}

