/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.WxUtil;
import com.zbkj.common.vo.wxvedioshop.ShopOrderCommonVo;
import com.zbkj.common.vo.wxvedioshop.delivery.DeliveryCompanyVo;
import com.zbkj.common.vo.wxvedioshop.delivery.DeliverySendVo;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoDeliveryService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatVideoDeliveryServiceImpl
implements WechatVideoDeliveryService {
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public List<DeliveryCompanyVo> shopDeliveryGetCompanyList() {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_DELIVERY_GET_COMPANY_LIST_URL, (Object[])new Object[]{miniAccessToken});
        String stringData = this.restTemplateUtil.postStringData(url, "{}");
        JSONObject jsonObject = JSONObject.parseObject((String)stringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        List voList = JSONArray.parseArray((String)jsonObject.getJSONArray("company_list").toJSONString(), DeliveryCompanyVo.class);
        return voList;
    }

    @Override
    public Boolean shopDeliverySend(DeliverySendVo deliverySendVo) {
        Map<String, Object> sendMap = this.assembleSendMap(deliverySendVo);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_DELIVERY_SEND_URL, (Object[])new Object[]{miniAccessToken});
        String stringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(sendMap));
        JSONObject jsonObject = JSONObject.parseObject((String)stringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    private Map<String, Object> assembleSendMap(DeliverySendVo deliverySendVo) {
        HashMap map = CollUtil.newHashMap();
        map.put("out_order_id", deliverySendVo.getOutOrderId());
        map.put("openid", deliverySendVo.getOpenid());
        map.put("finish_all_delivery", deliverySendVo.getFinishSllDelivery());
        List deliveryList = deliverySendVo.getDeliveryList();
        List infoMapList = deliveryList.stream().map(e -> {
            HashMap infoMap = CollUtil.newHashMap();
            infoMap.put("delivery_id", e.getDeliveryId());
            infoMap.put("waybill_id", e.getWaybillId());
            return infoMap;
        }).collect(Collectors.toList());
        map.put("delivery_list", infoMapList);
        return map;
    }

    @Override
    public Boolean shopDeliveryRecieve(ShopOrderCommonVo shopOrderCommonVo) {
        if (ObjectUtil.isNull((Object)shopOrderCommonVo.getOrderId()) && StrUtil.isBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            throw new CrmebException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_DELIVERY_RECIEVE_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopOrderCommonVo.getOrderId())) {
            map.put("order_id", shopOrderCommonVo.getOrderId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            map.put("out_order_id", shopOrderCommonVo.getOutOrderId());
        }
        map.put("openid", shopOrderCommonVo.getOpenid());
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }
}

