/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.enums.BcxBrokerageConfigBelongTypeEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxBrokerageConfig;
import com.zbkj.common.model.bcx.BcxBrokerageConfigRegion;
import com.zbkj.common.model.bcx.BcxRegion;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.request.BcxBrokerageConfigDetailRequest;
import com.zbkj.common.request.BcxBrokerageConfigRequest;
import com.zbkj.common.request.BcxBrokerageConfigSearchRequest;
import com.zbkj.common.request.BcxBrokerageLoadSearchRequest;
import com.zbkj.common.request.BcxSetProductBrokerageRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductSearchRequest;
import com.zbkj.common.response.BcxBrokerageConfigResponse;
import com.zbkj.common.response.BcxBrokerageLoadResponse;
import com.zbkj.common.response.PlatformProductListResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.service.dao.BcxBrokerageConfigDao;
import com.zbkj.service.service.BcxBrokerageConfigRegionService;
import com.zbkj.service.service.BcxBrokerageConfigService;
import com.zbkj.service.service.BcxRegionService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemConfigService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxBrokerageConfigServiceImpl
extends ServiceImpl<BcxBrokerageConfigDao, BcxBrokerageConfig>
implements BcxBrokerageConfigService {
    @Resource
    private BcxBrokerageConfigDao dao;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private BcxBrokerageConfigRegionService bcxBrokerageConfigRegionService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private BcxRegionService bcxRegionService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Override
    public BcxBrokerageLoadResponse load(BcxBrokerageLoadSearchRequest searchRequest) {
        BcxBrokerageLoadResponse response = new BcxBrokerageLoadResponse();
        if (searchRequest.getProductId() == null) {
            response.setMaxBrokerage(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_product_max_brokerage"))));
            response.setRetailStoreBrokerageFirstRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio"))));
            response.setRetailStoreBrokerageSecondRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio"))));
        } else {
            Product product = (Product)this.productService.getById(searchRequest.getProductId());
            if (product.getIsSub().booleanValue()) {
                response.setIsSub(Integer.valueOf(1));
                response.setMaxBrokerage(product.getMaxBrokerage() != null ? Integer.valueOf(product.getMaxBrokerage().intValue()) : null);
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(searchRequest.getProductId(), 0);
                if (CollectionUtil.isNotEmpty(skuList)) {
                    response.setRetailStoreBrokerageFirstRatio(skuList.get(0).getBrokerage());
                    response.setRetailStoreBrokerageSecondRatio(skuList.get(0).getBrokerageTwo());
                }
            } else {
                response.setIsSub(Integer.valueOf(0));
                response.setMaxBrokerage(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_product_max_brokerage"))));
                response.setRetailStoreBrokerageFirstRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio"))));
                response.setRetailStoreBrokerageSecondRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio"))));
            }
        }
        response.setConfigChannelList(this.getList(new BcxBrokerageConfigSearchRequest(searchRequest.getProductId(), BcxBrokerageConfigBelongTypeEnum.CHANNEL.getValue(), null)));
        response.setConfigDepartmentList(this.getList(new BcxBrokerageConfigSearchRequest(searchRequest.getProductId(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT.getValue(), null)));
        response.setConfigDepartmentMemberList(this.getList(new BcxBrokerageConfigSearchRequest(searchRequest.getProductId(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT_MEMBER.getValue(), null)));
        return response;
    }

    @Override
    public List<BcxBrokerageConfigResponse> getList(BcxBrokerageConfigSearchRequest searchRequest) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("productId", searchRequest.getProductId());
        paramMap.put("regionCode", searchRequest.getRegionCode());
        if (searchRequest.getBelongType().intValue() == BcxBrokerageConfigBelongTypeEnum.CHANNEL.getValue().intValue()) {
            return this.dao.selectChannelConfigList(paramMap);
        }
        if (searchRequest.getBelongType().intValue() == BcxBrokerageConfigBelongTypeEnum.DEPARTMENT.getValue().intValue()) {
            return this.dao.selectDepartmentConfigList(paramMap);
        }
        if (searchRequest.getBelongType().intValue() == BcxBrokerageConfigBelongTypeEnum.DEPARTMENT_MEMBER.getValue().intValue()) {
            return this.dao.selectDepartmentMemberConfigList(paramMap);
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean saveBcxBrokerageConfig(BcxBrokerageConfigRequest request) {
        this.validRetailStoreBrokerageRatio(request);
        this.validConfigDetail(request.getConfigChannelList());
        this.validConfigDetail(request.getConfigDepartmentList());
        this.validConfigDetail(request.getConfigDepartmentMemberList());
        if (CollectionUtil.isEmpty((Collection)request.getProductIdList())) {
            this.systemConfigService.updateOrSaveValueByName("retail_store_product_max_brokerage", request.getMaxBrokerage().toString());
            this.systemConfigService.updateOrSaveValueByName("retail_store_brokerage_first_ratio", request.getRetailStoreBrokerageFirstRatio().toString());
            this.systemConfigService.updateOrSaveValueByName("retail_store_brokerage_second_ratio", request.getRetailStoreBrokerageSecondRatio().toString());
        } else {
            if (request.getIsSub() == null) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u4f63\u91d1\u8ba1\u7b97\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            for (Integer productId : request.getProductIdList()) {
                Product product = (Product)this.productService.getById(productId);
                if (product == null) {
                    throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u8bbe\u7f6e\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
                }
                if (product.getIsBrokerage() == null || product.getIsBrokerage() == 0) {
                    throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u8bbe\u7f6e\u7684\u5546\u54c1\u4e0d\u662f\u5206\u9500\u5546\u54c1\uff0c\u8bf7\u5148\u5f00\u542f\u6210\u4e3a\u5206\u9500\u5546\u54c1\u518d\u8bbe\u7f6e\u4f63\u91d1\u914d\u7f6e"));
                }
                product.setMaxBrokerage(new BigDecimal(request.getMaxBrokerage()));
                product.setIsSub(Boolean.valueOf(request.getIsSub() == 1));
                this.productService.updateById(product);
                if (!product.getIsSub().booleanValue()) continue;
                this.validRetailStoreBrokerageRatio(request);
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product.getId(), 0);
                if (CollectionUtil.isEmpty(skuList)) {
                    throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u8bbe\u7f6e\u7684\u5546\u54c1sku\u4e0d\u5b58\u5728"));
                }
                for (ProductAttrValue productAttrValue : skuList) {
                    productAttrValue.setBrokerage(request.getRetailStoreBrokerageFirstRatio());
                    productAttrValue.setBrokerageTwo(request.getRetailStoreBrokerageSecondRatio());
                }
                this.productAttrValueService.updateBatchById(skuList);
            }
        }
        UpdateWrapper wrapper = Wrappers.update();
        if (CollectionUtil.isEmpty((Collection)request.getProductIdList())) {
            wrapper.isNull((Object)"product_id");
        } else {
            wrapper.in((Object)"product_id", (Collection)request.getProductIdList());
        }
        this.dao.delete((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)request.getProductIdList()) && request.getIsSub() != null && request.getIsSub() == 0) {
            return true;
        }
        ArrayList<BcxBrokerageConfig> list = new ArrayList<BcxBrokerageConfig>();
        ArrayList<BcxBrokerageConfigRegion> regionList = new ArrayList<BcxBrokerageConfigRegion>();
        Date now = new Date();
        if (CollectionUtil.isEmpty((Collection)request.getProductIdList())) {
            this.setConfigList(null, request.getConfigChannelList(), BcxBrokerageConfigBelongTypeEnum.CHANNEL, list, regionList, now);
            this.setConfigList(null, request.getConfigDepartmentList(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT, list, regionList, now);
            this.setConfigList(null, request.getConfigDepartmentMemberList(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT_MEMBER, list, regionList, now);
        } else {
            for (Integer productId : request.getProductIdList()) {
                this.setConfigList(productId, request.getConfigChannelList(), BcxBrokerageConfigBelongTypeEnum.CHANNEL, list, regionList, now);
                this.setConfigList(productId, request.getConfigDepartmentList(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT, list, regionList, now);
                this.setConfigList(productId, request.getConfigDepartmentMemberList(), BcxBrokerageConfigBelongTypeEnum.DEPARTMENT_MEMBER, list, regionList, now);
            }
        }
        this.saveBatch(list);
        this.bcxBrokerageConfigRegionService.saveBatch(regionList);
        return true;
    }

    private void validRetailStoreBrokerageRatio(BcxBrokerageConfigRequest request) {
        if (request.getMaxBrokerage() == null) {
            throw new CrmebException("\u5546\u54c1\u6700\u5927\u5206\u4f63\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMaxBrokerage() < 0 || request.getMaxBrokerage() > 100) {
            throw new CrmebException("\u5546\u54c1\u6700\u5927\u5206\u4f63\u6bd4\u4f8b\u8bf7\u57280-100\u4e2d\u9009\u62e9");
        }
        if (request.getRetailStoreBrokerageFirstRatio() == null) {
            throw new CrmebException("\u5206\u9500\u4e00\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getRetailStoreBrokerageSecondRatio() == null) {
            throw new CrmebException("\u5206\u9500\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int ration = request.getRetailStoreBrokerageFirstRatio() + request.getRetailStoreBrokerageSecondRatio();
        if (ration > this.crmebConfig.getRetailStoreBrokerageRatio() || ration < 0) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u4e00\u7ea7\u3001\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0 ~ {}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
        }
        if (ration > request.getMaxBrokerage()) {
            throw new CrmebException("\u4e00\u7ea7\u3001\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u5927\u4e8e\u5546\u54c1\u6700\u5927\u5206\u4f63\u6bd4\u4f8b");
        }
    }

    private void validConfigDetail(List<BcxBrokerageConfigDetailRequest> configDetailList) {
        if (CollectionUtil.isNotEmpty(configDetailList)) {
            HashSet regionSet = new HashSet();
            HashMap<Long, ArrayList<String>> belongRegionListMap = new HashMap<Long, ArrayList<String>>();
            for (BcxBrokerageConfigDetailRequest configDetail : configDetailList) {
                List regionList = belongRegionListMap.get(configDetail.getBelongId()) == null ? new ArrayList() : (List)belongRegionListMap.get(configDetail.getBelongId());
                this.validDetailRegionAndAdd(configDetail, regionList);
                belongRegionListMap.put(configDetail.getBelongId(), (ArrayList<String>)regionList);
                List regionConfigList = (List)belongRegionListMap.get(configDetail.getBelongId());
                if (!CollectionUtil.isNotEmpty((Collection)regionConfigList) || !regionConfigList.contains("all") || regionConfigList.size() <= 1) continue;
                throw new CrmebException(String.format("\u3010%s\u3011\u914d\u7f6e\u4e2d\uff0c\u5df2\u7ecf\u914d\u7f6e\u4e86\u3010\u5168\u56fd\u3011\uff0c\u5c31\u4e0d\u80fd\u914d\u7f6e\u5176\u4ed6\u533a\u57df\u4e86\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u540e\u63d0\u4ea4", configDetail.getBelongName()));
            }
        }
    }

    private void validDetailRegionAndAdd(BcxBrokerageConfigDetailRequest configDetail, List<String> regionList) {
        for (String region : configDetail.getRegionCodeList()) {
            if (regionList.contains(region)) {
                BcxRegion bcxRegion = this.bcxRegionService.findByCode(region);
                throw new CrmebException(String.format("\u3010%s\u3011\u914d\u7f6e\u4e2d\uff0c\u533a\u57df\uff1a\u3010%s\u3011\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u540e\u63d0\u4ea4", configDetail.getBelongName(), bcxRegion == null ? "\u5168\u56fd" : bcxRegion.getRegionName()));
            }
            regionList.add(region);
        }
    }

    private void setConfigList(Integer productId, List<BcxBrokerageConfigDetailRequest> configList, BcxBrokerageConfigBelongTypeEnum belongTypeEnum, List<BcxBrokerageConfig> list, List<BcxBrokerageConfigRegion> regionList, Date now) {
        if (CollectionUtil.isNotEmpty(configList)) {
            for (BcxBrokerageConfigDetailRequest detailRequest : configList) {
                BcxBrokerageConfig config = new BcxBrokerageConfig();
                config.setId(Long.valueOf(this.snowflake.snowflakeId()));
                config.setProductId(productId);
                config.setBelongId(detailRequest.getBelongId());
                config.setBelongType(belongTypeEnum.getValue());
                config.setChannelType(detailRequest.getChannelType());
                config.setType(detailRequest.getType());
                config.setRatio(detailRequest.getRatio());
                config.setServiceRatio(detailRequest.getServiceRatio());
                config.setCalculateRatio(detailRequest.getCalculateRatio());
                config.setStatus(Integer.valueOf(1));
                config.setCreateTime(now);
                config.setUpdateTime(now);
                list.add(config);
                if (!CollectionUtil.isNotEmpty((Collection)detailRequest.getRegionCodeList())) continue;
                Optional<String> all = detailRequest.getRegionCodeList().stream().filter(regionCode -> regionCode.equals("all")).findFirst();
                if (all.isPresent()) {
                    BcxBrokerageConfigRegion region = new BcxBrokerageConfigRegion();
                    region.setId(Long.valueOf(this.snowflake.snowflakeId()));
                    region.setBrokerageConfigId(config.getId());
                    region.setRegionCode(all.get());
                    region.setCreateTime(now);
                    region.setUpdateTime(now);
                    regionList.add(region);
                    continue;
                }
                for (String regionCode2 : detailRequest.getRegionCodeList()) {
                    BcxBrokerageConfigRegion region = new BcxBrokerageConfigRegion();
                    region.setId(Long.valueOf(this.snowflake.snowflakeId()));
                    region.setBrokerageConfigId(config.getId());
                    region.setRegionCode(regionCode2);
                    region.setCreateTime(now);
                    region.setUpdateTime(now);
                    regionList.add(region);
                }
            }
        }
    }

    @Override
    @Transactional
    public boolean setProductBrokerage(BcxSetProductBrokerageRequest request) {
        for (Integer productId : request.getProductIdList()) {
            Product product = (Product)this.productService.getById(productId);
            if (product == null) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u8bbe\u7f6e\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
            }
            if (request.getIsBrokerage() == 0) {
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product.getId(), 0);
                if (CollectionUtil.isNotEmpty(skuList)) {
                    for (ProductAttrValue productAttrValue : skuList) {
                        productAttrValue.setBrokerage(Integer.valueOf(0));
                        productAttrValue.setBrokerageTwo(Integer.valueOf(0));
                    }
                    this.productAttrValueService.updateBatchById(skuList);
                }
                product.setIsSub(Boolean.valueOf(true));
            }
            product.setIsBrokerage(request.getIsBrokerage());
            this.productService.updateById(product);
        }
        return true;
    }

    @Override
    public PageInfo<PlatformProductListResponse> getProductList(ProductSearchRequest searchRequest, PageParamRequest pageParamRequest) {
        PageInfo<PlatformProductListResponse> productPage = this.productService.getPlatformPageList(searchRequest, pageParamRequest);
        if (CollectionUtil.isNotEmpty((Collection)productPage.getList())) {
            for (PlatformProductListResponse response : productPage.getList()) {
                BcxBrokerageLoadSearchRequest request = new BcxBrokerageLoadSearchRequest();
                request.setProductId(response.getId());
                BcxBrokerageLoadResponse loadResponse = this.load(request);
                response.setBrokerageConfig("\u4e00\u7ea7\u8fd4\u4f63\uff1a".concat(loadResponse.getRetailStoreBrokerageFirstRatio().toString()).concat("\r\n\u4e8c\u7ea7\u8fd4\u4f63").concat(loadResponse.getRetailStoreBrokerageSecondRatio().toString()));
            }
        }
        return productPage;
    }
}

